
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/*$Id: write_ctrl_values.c 1377 2008-09-09 21:29:56Z  $*/
/* AUTOGENERATED write structure routine */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "machine.h"
#include "blocks.h"
/* start of structure ctrl_opt */
void write_ctrl_opt_values (FILE * fp, struct ctrl_opt *sp)
{
  int i;

  fprintf (fp, "\n# ctrl_opt STRUCTURE VALUES *****\n");
  fprintf (fp, "jflg %i \n", sp->jflg);
  fprintf (fp, "restart %i \n", sp->restart);
  fprintf (fp, "restart_pore_on %i \n", sp->restart_pore_on);
  fprintf (fp, "restart_gas_on %i \n", sp->restart_gas_on);
  fprintf (fp, "mould_nuc %i \n", sp->mould_nuc);
  fprintf (fp, "mould_src %i \n", sp->mould_src);
  fprintf (fp, "mould_src_pert %i \n", sp->mould_src_pert);
  fprintf (fp, "mould_source_value %g \n", sp->mould_source_value);
  fprintf (fp, "mould_source_pert %g \n", sp->mould_source_pert);
  fprintf (fp, "mould_source_freq %g \n", sp->mould_source_freq);
  fprintf (fp, "solo %i \n", sp->solo);
  fprintf (fp, "cap %i \n", sp->cap);
  fprintf (fp, "post %i \n", sp->post);
  fprintf (fp, "input %i \n", sp->input);
  fprintf (fp, "t_input %i \n", sp->t_input);
  fprintf (fp, "fgrid_input %i \n", sp->fgrid_input);
  fprintf (fp, "fg_tr %i \n", sp->fg_tr);
  fprintf (fp, "con_cast %i \n", sp->con_cast);
  fprintf (fp, "particle %i \n", sp->particle);
  fprintf (fp, "diffuse %i \n", sp->diffuse);
  fprintf (fp, "pore %i \n", sp->pore);
  fprintf (fp, "temp_lookup %i \n", sp->temp_lookup);
  fprintf (fp, "pr_lookup %i \n", sp->pr_lookup);
  fprintf (fp, "swap_axes %i \n", sp->swap_axes);
  fprintf (fp, "diffuse_alloy %i \n", sp->diffuse_alloy);
  fprintf (fp, "diffuse_alloy_multi %i \n", sp->diffuse_alloy_multi);
  fprintf (fp, "thermocalc %i \n", sp->thermocalc);
  fprintf (fp, "temp_dep_diff %i \n", sp->temp_dep_diff);
  fprintf (fp, "interpolate %i \n", sp->interpolate);
  fprintf (fp, "show_eut %i \n", sp->show_eut);
  fprintf (fp, "phase_diag_on %i \n", sp->phase_diag_on);
  fprintf (fp, "das_limrad %i \n", sp->das_limrad);
  fprintf (fp, "global_undercooling %i \n", sp->global_undercooling);
  fprintf (fp, "diffuse_step %i \n", sp->diffuse_step);
  fprintf (fp, "window_moving %i \n", sp->window_moving);
  fprintf (fp, "init_cont %i \n", sp->init_cont);
  fprintf (fp, "decentred_octahedron %i \n", sp->decentred_octahedron);
  fprintf (fp, "external %i \n", sp->external);
  fprintf (fp, "umat_feedback %i \n", sp->umat_feedback);
  fprintf (fp, "flow_on %i \n", sp->flow_on);
  fprintf (fp, "umat_method %i \n", sp->umat_method);
  fprintf (fp, "scheil %i \n", sp->scheil);
  fprintf (fp, "n_neigh %i \n", sp->n_neigh);
  fprintf (fp, "seed %li \n", sp->seed);
  fprintf (fp, "nsbslice %i \n", sp->nsbslice);
  fprintf (fp, "nbbslice %i \n", sp->nbbslice);
  fprintf (fp, "pore_dump_sb %i \n", sp->pore_dump_sb);
  fprintf (fp, "write_block %i \n", sp->write_block);
  fprintf (fp, "grainslice %i \n", sp->grainslice);
  fprintf (fp, "nfsprint %i \n", sp->nfsprint);
  fprintf (fp, "do_conc_prof %i \n", sp->do_conc_prof);
  fprintf (fp, "conc_prof ");
  for (i = 0; i < 3; i++) {
    fprintf (fp, " %i ", sp->conc_prof[i]);
  }
  fprintf (fp, " \n");
  fprintf (fp, "slice_dmp_freq %i \n", sp->slice_dmp_freq);
  fprintf (fp, "tempslice %i \n", sp->tempslice);
  fprintf (fp, "floatdump %i \n", sp->floatdump);
  fprintf (fp, "excel %i \n", sp->excel);
  fprintf (fp, "scr_dmp_freq %i \n", sp->scr_dmp_freq);
  fprintf (fp, "nscrdumps %i \n", sp->nscrdumps);
  fprintf (fp, "rgbmode %i \n", sp->rgbmode);
  fprintf (fp, "rgbgrey %i \n", sp->rgbgrey);
  fprintf (fp, "diff_rgbmode %i \n", sp->diff_rgbmode);
  fprintf (fp, "diff_log_disp %i \n", sp->diff_log_disp);
  fprintf (fp, "diff_ratio_disp %i \n", sp->diff_ratio_disp);
  fprintf (fp, "alloy_disp_max %g \n", sp->alloy_disp_max);
  fprintf (fp, "gas_disp_max %g \n", sp->gas_disp_max);
  fprintf (fp, "diff_disp_cap %i \n", sp->diff_disp_cap);
  fprintf (fp, "fixed_Pore %i \n", sp->fixed_Pore);
  fprintf (fp, "nfPore %i \n", sp->nfPore);
  fprintf (fp, "fixed_nuc %i \n", sp->fixed_nuc);
  fprintf (fp, "block_nuc %i \n", sp->block_nuc);
  fprintf (fp, "nfnuc %i \n", sp->nfnuc);
  fprintf (fp, "coolrate %i \n", sp->coolrate);
  fprintf (fp, "fs_finish %g \n", sp->fs_finish);
  fprintf (fp, "ref_pres %g \n", sp->ref_pres);
  fprintf (fp, "delT %g \n", sp->delT);
  fprintf (fp, "NUM_COMP %i \n", sp->NUM_COMP);
  fprintf (fp, "use_global_undercooling %i \n", sp->use_global_undercooling);
  fprintf (fp, "use_csol_alloy %i \n", sp->use_csol_alloy);
  fprintf (fp, "use_cell_nuc %i \n", sp->use_cell_nuc);
  fprintf (fp, "use_cell_temp %i \n", sp->use_cell_temp);
  fprintf (fp, "eut_nuc_option %i \n", sp->eut_nuc_option);
  fprintf (fp, "strontium %i \n", sp->strontium);
}

/* End of structure Ctrl_str */
/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *write_ctrl_values_c ()
{
  static char const rcsid[] = "$Id: write_ctrl_values.c 1377 2008-09-09 21:29:56Z  $";

  return (rcsid);
}
