
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/*$Id: write_fidap_struct.c 1339 2008-07-23 13:58:29Z  $*/
/* AUTOGENERATED write structure routine */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "machine.h"
#include "blocks.h"
#include "fidap.h"
/* start of structure treering */
void write_treering_values (FILE * fp, struct treering *sp)
{
  int i;

  fprintf (fp, "\ntreering STRUCTURE VALUES *****\n");
}

/* End of structure Tring_str */
/* start of structure fidap_geo */
void write_fidap_geo_values (FILE * fp, struct fidap_geo *sp)
{
  int i;

  fprintf (fp, "\nfidap_geo STRUCTURE VALUES *****\n");
  fprintf (fp, "nnodes: %i\n", sp->nnodes);
  fprintf (fp, "nr: %i\n", sp->nr);
  fprintf (fp, "nz: %i\n", sp->nz);
  fprintf (fp, "tstart: %g\n", sp->tstart);
  fprintf (fp, "s_start: %i\n", sp->s_start);
  fprintf (fp, "tnext: %g\n", sp->tnext);
  fprintf (fp, "s_next: %i\n", sp->s_next);
  fprintf (fp, "v: %g\n", sp->v);
  fprintf (fp, "Tmax: %g\n", sp->Tmax);
  fprintf (fp, "Tmin: %g\n", sp->Tmin);
  fprintf (fp, "state: %i\n", sp->state);
  fprintf (fp, "tring_on: %i\n", sp->tring_on);
  fprintf (fp, "ntring: %i\n", sp->ntring);
  fprintf (fp, "oldtime: %g\n", sp->oldtime);
  fprintf (fp, "trans_on: %i\n", sp->trans_on);
  fprintf (fp, "time_trans: %g\n", sp->time_trans);
  fprintf (fp, "z_off: %g\n", sp->z_off);
  fprintf (fp, "r_off: %g\n", sp->r_off);
  fprintf (fp, "time_var: %g\n", sp->time_var);
  fprintf (fp, "time_ca: %g\n", sp->time_ca);
  fprintf (fp, "hs_ingot: %g\n", sp->hs_ingot);
  fprintf (fp, "h_ingot: %g\n", sp->h_ingot);
  fprintf (fp, "h_cur: %g\n", sp->h_cur);
  fprintf (fp, "h_ca: %g\n", sp->h_ca);
}

/* End of structure FGrid_str */
/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *write_fidap_struct_c ()
{
  static char const rcsid[] = "$Id: write_fidap_struct.c 1339 2008-07-23 13:58:29Z  $";

  return (rcsid);
}
