
/****************************************************************/
/*      Copyright (c) 1993 Peter D Lee                          */
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      continuing D Phil work from University of Oxford        */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @imperial.ac.uk for details   */
/****************************************************************/

/********************************************************************************/
/*  This version is distributed under a BSD style public license, as follows:   */
/*                                                                              */
/*  Copyright (c) 2007, Dept. of Materials, Imperial College London             */
/*  All rights reserved.                                                        */
/*  Redistribution and use in source and binary forms, with or without          */
/*  modification, are permitted provided that the following conditions          */
/*  are met:                                                                    */
/*                                                                              */
/*  * Redistributions of source code must retain the above copyright            */
/*  notice, this list of conditions and the following disclaimer.               */
/*                                                                              */
/*  * Redistributions in binary form must reproduce the above                   */
/*  copyright notice, this list of conditions and the following                 */
/*  disclaimer in the documentation and/or other materials provided             */
/*  with the distribution.                                                      */
/*                                                                              */
/*  * Neither the name of the Dept. of Materials, Imperial College London, nor  */
/*  the names of its contributors may be used to endorse or promote products    */
/*  derived from this software without specific prior written permission.       */
/*                                                                              */
/*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */
/*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR       */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT        */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */
/*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */
/*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR      */
/*  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      */
/*  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING        */
/*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */
/********************************************************************************/
/*END of LICENSE NOTICE*/

/* AUTOGENERATED write structure routine */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "machine.h"
#include "blocks.h"
/* start of structure matprop */
void write_matprop_values (FILE * fp, struct matprop *sp)
{
  int i;

  fprintf (fp, "\n# matprop STRUCTURE VALUES *****\n");
  fprintf (fp, "Tliq %g \n", sp->Tliq);
  fprintf (fp, "Tsol %g \n", sp->Tsol);
  fprintf (fp, "Tstart_Offset %g \n", sp->Tstart_Offset);
  fprintf (fp, "Tstart %g \n", sp->Tstart);
  fprintf (fp, "latentH %g \n", sp->latentH);
  fprintf (fp, "rho %g \n", sp->rho);
  fprintf (fp, "cp %g \n", sp->cp);
  fprintf (fp, "rhocp %g \n", sp->rhocp);
  fprintf (fp, "CA_Q %g \n", sp->CA_Q);
  fprintf (fp, "QSV %g \n", sp->QSV);
  fprintf (fp, "surf_tens %g \n", sp->surf_tens);
  fprintf (fp, "gg_const %g \n", sp->gg_const);
  fprintf (fp, "gg_cub %g \n", sp->gg_cub);
#ifdef OLDSOL
  fprintf (fp, "Dliq %g \n", sp->Dliq);
  fprintf (fp, "Dsol %g \n", sp->Dsol);
  fprintf (fp, "part_coef %g \n", sp->part_coef);
  fprintf (fp, "km %g \n", sp->km);
  fprintf (fp, "kminv %g \n", sp->kminv);
  fprintf (fp, "Dliq_alloy %g \n", sp->Dliq_alloy);
  fprintf (fp, "Dsol_alloy %g \n", sp->Dsol_alloy);
  fprintf (fp, "part_coef_alloy %g \n", sp->part_coef_alloy);
  fprintf (fp, "km_alloy %g \n", sp->km_alloy);
  fprintf (fp, "kminv_alloy %g \n", sp->kminv_alloy);
  fprintf (fp, "c_eut %g \n", sp->c_eut);
  fprintf (fp, "T_eut %g \n", sp->T_eut);
  fprintf (fp, "tp %g \n", sp->tp);
  fprintf (fp, "m_alloy %g \n", sp->m_alloy);
  fprintf (fp, "m_inv_alloy %g \n", sp->m_inv_alloy);
  fprintf (fp, "Fs_eut %g \n", sp->Fs_eut);
  fprintf (fp, "surf_tens_alloy %g \n", sp->surf_tens_alloy);
#endif
  fprintf (fp, "das_factor %g \n", sp->das_factor);
  fprintf (fp, "das %g \n", sp->das);
}

/* End of structure Mat_str */
/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *write_matprop_values_c ()
{
  static char const rcsid[] = "$Id: write_matprop_values.c 1339 2008-07-23 13:58:29Z  $";

  return (rcsid);
}
