#define BIGBLOCKREV "bigblock.h $Revision: 1491 $"
#ifndef BIGBLOCK_H
#define BIGBLOCK_H

typedef struct bigblock {
   char header[256];      /* header string                   */
   char *fileroot;      /* filename without extension   */

   CA_FLOAT CR;              /* cooling rate if sol o           */
   CA_FLOAT Cinit;           /* initial concentration for diff  */
   CA_FLOAT CinitB;          /* initial concentration for diff  */
   CA_FLOAT Tinit;         /* the initial temperature [K]  */
   CA_FLOAT Cbdy_alloy; /* used for FIX_BDY solute source term */
   CA_FLOAT Cbdy_gas;

   CA_FLOAT area_bb;         /* surface area of BB              */
   CA_FLOAT autofin_time;  /* time to stop simulation       */
   CA_FLOAT delt;          /* ca time step                     */
   CA_FLOAT fs_active;       /* average fs of active blocks     */
   CA_FLOAT fsgrow;
   CA_FLOAT grad_slope;     /* slope of deviation of fixed temp grad.   */
   CA_FLOAT gradient;       /* fixed temperature gradient */
   CA_FLOAT iso_coef1;       /*curved isotherm */
   CA_FLOAT iso_coef2;       /*curved isotherm */
   CA_FLOAT velo_coef;        /*Varying V*/
   CA_FLOAT grad_coef;       /*varying G*/ 
   CA_FLOAT slope_coef;      /*varying slope */
   CA_FLOAT time_curv;       /* options for transient isotherm curvature*/
   CA_FLOAT time_tran;
   CA_FLOAT cell_no;
   CA_FLOAT therm_coef;  /* coef. for the transient isothermals, e.g. coef=2 from -2 to +2, coef =1.5 from -2 to 1 */

                         /* variables for melt-back xly 20041018 */
   CA_FLOAT time_velo1;  /* the time held for initial velocity before decreasing */
   CA_FLOAT time_velo2;  /* the time stop decreasing velocity */
   CA_FLOAT time_velo3;  /* the time stop decreasing velocity */
   CA_FLOAT time_velo4;  /* the time stop increasing velocity */ 
   CA_FLOAT time_hold;   /* the time held for zero velocity for melting back */
   CA_FLOAT velo_coef1;  /* velocity decrease per second, negative value */
   CA_FLOAT velo_coef2;  /* velocity increase per second, positive value */ 
   CA_FLOAT velo_coef3;
   CA_FLOAT velo_coef4;

   CA_FLOAT t_velo;       /* time to change velocity for melt_back only */
   CA_FLOAT oct_factor;     /* oct. factor for ngbhd flippn*/
   CA_FLOAT orig_bb[3];      /* lower left front origin of bb   */
   CA_FLOAT finish_time;   /* time to stop simulation       */
   CA_FLOAT sim_time;      /* current time in simulation       */
   CA_FLOAT this_temp, this_pr;
   CA_FLOAT size_bb[3];      /* size of big-block               */
   CA_FLOAT size_c[3];       /* size of cell                    */
   CA_FLOAT velocity;       /* non-FIdap directional velocity*/
   CA_FLOAT vol_bb;          /* volume of BB                    */
   CA_FLOAT vol_c;           /* volume of a cell                */
   CA_FLOAT vol_sb;          /* volume of a sb                  */
   CA_FLOAT window_disp;     /* window displacement */ /*by Wei WANG on 11-07-02*/
   CA_FLOAT window_disp2;        /* window displacement *//*by THUINET on 03-05 */
   CA_FLOAT window_velo;     /* window moving velocity */ /*by Wei WANG on 11-07-02*/
   int window_steps;   /* fix the temperature problem for moving window .. LY*/
   CA_FLOAT coef_iso2; /* time dependent T curve... LY*/
   CA_FLOAT yinv;              /* to speed up sb_temp_calc_cc     */

   int auto_fin;        /* automatically calc. fin time */
   int bb_npores;         /* # of active pores in BB         */
   int cell_option; /* user option for total or local ca_procast */
   int dfs_cap;          /* grow too fast or            */
   int dfs_err;          /* grow more than one cell     */
   int dfs_warn;         /* counters for how many cells */
   int dim;               /* # of dimensions: 2 or 3         */
   int extrafs_cap;     /* extra solid exceeds limit   */
   int first_micro; /* indicates the beginning of each macro time step */
   int last_micro; /* flag used to tell PRocast to stop running */
   int micro_step;
   int header_size;       /* size of total file header       */
   int nbeut;             /* # of binary eutectic cells      */
   int n_a_sb;            /* # active sb                     */
   int nc[3];             /* # cells/sub-blocks in x,y,z     */
   int ncsb;              /* # cells/sb                      */
   int nsb[3];            /* # sub-blocks in x,y,z           */
   int nzones[3];         /* # of grain-size zones per sb    */
   int nsteps;
   int nteut;             /* # of ternary eutectic cells    */
   int ntsb;              /* total # subblocks               */
   int pore_err;
   int realtime;     /* the clock time */
   int scr_dump_num;
   int slice_dump_num;
   int blk_dump_num;
   int step;            /* ca step #                     */
   int tnc[3];            /* total # cells in x,y,z          */
   int total_cell_number;

   Value_struct * c_fd_values;
   Value_struct * c_fs_corrected_values;
   Value_struct * c_fs_values;
   Value_struct * c_sol_alloy_values;
   Value_struct * c_sol_values;
   Value_struct * cell_dfs_eutectic_values;
   Value_struct * cell_dfs_primary_values;
   Value_struct * fs_b_eut_old_values;
   Value_struct * fs_b_eut_values;
   Value_struct * fs_n_eut_old_values;
   Value_struct * fs_n_eut_values;
   Value_struct * fs_t_eut_values;
   Value_struct * sch_fs_values;
  /* needed for poly component THUINET version (added by ATWOOD) */
  Value_struct *poly_c_eqv_values[NSOLMAX];
  Value_struct *poly_c_sol_values[NSOLMAX];
  Value_struct *poly_c_fs_values[NPHAMAX];
  /*end */
#ifdef CHIRAZI_MULTI
   Value_struct **multi_conc; /*liquid conc*/
   Value_struct **multi_conc_n_eut; /*non eutectic solid conc*/
   Value_struct **multi_conc_n_eut_old; /*non eutectic solid conc*/
   Value_struct **multi_conc_tot; /*total conc*/
   Value_struct **multi_conc_tot_old; /* old total conc*/
#endif                          /* CHIRAZI_MULTI */
   int * intclosed;
   int ** c_elm_array;
   int ** gr_array;
   int *bin_flag, *ter_flag;
   int *bin_grain_index, *ter_grain_index;
  int *cell_element_array;

                             /*****************the maper array of CAFE********/
  int *cell_node_array;

                             /*****************the mapper array for nodes*****/
   int *itmp_one;           /* int array size (nc[i]+2)^3   */
  int *itmp_nat_cell;
  int *itmp_nat_grain;

/*THUINET 04/05*/
  CA_FLOAT a[NPHAMAX][NPHAMAX]; /* table of coefficients to invert for linear system */
  CA_FLOAT slope[NPHAMAX][NSOLMAX];
  CA_FLOAT part[NPHAMAX][NSOLMAX];
  int dim_tab;
  int iphs_eff;
  int ipheq_eff;

/*END THUINET 04/05*/
   int *itmp_two;           /* int array size (nc[i]+2)^3   */ /*by Wei WANG on 11-07-02*/
   int *sb_mask;            /* array of flag for status of each subblock */
  float *cell_cord_x, *cell_cord_y, *cell_cord_z;

                                                   /*******cell coordinates in x y and z directions******/
  float *cell_temp_change_procast, *cell_pres_grad_procast;

                                                             /*****cell temperature and pressure gradients from procast***/
  float *cell_temp_procast, *cell_pres_procast;

                                                   /****cell  and pressure from procast******/
  float *current_cell_temp, *current_cell_pres;

                                                  /*******micro step values for temp and pres at each cell********
						   */

  
  /*****************************************************/
  /*****************************************************/ 
  /*----------- CA-PHYSICA VAR variables ---------------*/ 
  int phy_option;
  CA_FLOAT *Phy_newcord_x, *Phy_newcord_y, *Phy_newcord_z;   /* reformed Physica imported mesh coordinates in Marco*/
  CA_FLOAT *Phy_newcell_T;                                   /* the corresponding Temperature in Macro */
  int phytncx, phytncy, phytncz;                             /* total nodes number in x y z of Phy  in Marco */
  CA_FLOAT *Phy_newcell_u;
  CA_FLOAT *Phy_newcell_v;
  CA_FLOAT *Phy_newcell_w;                                   /*u,v,w in macromodel*/

  int phy_total_cell; 					     /* total nodes number of Phy  in Marco */
  
  CA_FLOAT *ca_cord_x, *ca_cord_y, *ca_cord_z;               /* CA coordinates of each cell in Micro*/
  CA_FLOAT *ca_cell_Tar;                                       /* Temperature array for each cell in Micro*/
  CA_FLOAT *ca_cell_uar, *ca_cell_var, *ca_cell_war;		     /*Velocities at x, y, z direction in Micro*/	
//  CA_FLOAT *ca_cell_par;                                       /*Pressure in Microcell*/  
  int tncx,tncy,tncz;                                        /* =nc[] for single block */
  int total_ca_number;                                       /* tncx*tncy*tncz total nodes number for CA in Micro*/
  CA_FLOAT phy_growvelocity;                                 /* Marco growth speed for steady VAR process */

  int phy223d;						     /* option for 2D T mirror to 3D */
  int phy_convection;					     /* option for calculating convection*/	
  CA_FLOAT phy_velofactor;
  CA_FLOAT *ftmp_u;                                          /* CA_FLOAT array size (nc[i]+2)^3 */
  CA_FLOAT *ftmp_v;                                          /* CA_FLOAT array size (nc[i]+2)^3 */
  CA_FLOAT *ftmp_w;                                          /* CA_FLOAT array size (nc[i]+2)^3 */
  int phy_tran;
  /*-----------  For fluid flow --------------*/
  
  CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w;    /*velocity components*/
//  CA_FLOAT ***ca_cell_uold, ***ca_cell_vold, ***ca_cell_wold;
  CA_FLOAT ***ca_cell_p;       /*pressure*/
  CA_FLOAT ***ca_cell_delp;    /*pressure gradient*/
  CA_FLOAT ***ca_cell_t;       /*cell temperature*/ 
  CA_FLOAT ***ca_cell_h;       /*enthalpy*/
//  CA_FLOAT ***ca_cell_Told;

//  CA_FLOAT ***ca_cell_fl;      /*liquid fraction ---- not used now*/
//  CA_FLOAT ***ca_cell_flold;
  CA_FLOAT ***ca_cell_ftry;    /*liquid fraction -- updated by growth*/
  CA_FLOAT ***ca_cell_dfs;     /*solid fraction increase at each time step*/
  CA_FLOAT ***ca_cell_ce;      /*eqv solute concentration for buoyancy force in the fluid flow*/
  CA_FLOAT ***cell_f, ***cell_g, ***cell_h;  /*temporary velocities*/
  CA_FLOAT ***ppe_rhs;
  CA_FLOAT ***conv_x_old, ***conv_z_old, ***conv_y_old;
  int ***cflag;
  int totalffcnum;
  CA_FLOAT inithighT;
  CA_FLOAT initcoldT;
  CA_FLOAT max_res;
  int inneriter;
  CA_FLOAT initvelo[3];
  CA_FLOAT H_L;    /*enthalpy when T=T_liquid*/
  CA_FLOAT H_S;    /*enthalpy when T=T_solid*/
  CA_FLOAT heatflux;  
  CA_FLOAT tonecyc; /* for cycling velocity BC.. total time for one cycle*/
  int ffstartflag;
  CA_FLOAT rev_fsgrow; /* 1/bp->fsgrow  for capture*/
  /*------------ for curvature -------------*/
  CA_FLOAT ***theta;
  CA_FLOAT ***curvature;
  CA_FLOAT ***Tcurv;
  CA_FLOAT ***fl_temp;
 
  /*--------for transient Marcomodel of VAR coupling to Micromodel--------*/
  CA_FLOAT ***phy_r, ***phy_a, ***phy_z;
  CA_FLOAT ***phy_fl,***phy_T;
  CA_FLOAT ***phy_u,***phy_v,***phy_w;
  CA_FLOAT ***phy_flold,***phy_Told;
  CA_FLOAT ***phy_uold,***phy_vold,***phy_wold;

  CA_FLOAT phy_sim_time, phy_sim_told;
  CA_FLOAT ***ca_r, ***ca_z, ***ca_a;
  CA_FLOAT ***ca_T, ***ca_Told, ***ca_Tnow;
  int fcount;
  int fcountin;
  CA_FLOAT macro_dt;
  CA_FLOAT dtimenow;

 /*--------------for Procast EXT coupling ------------------*/
  CA_FLOAT ext_xyz_min[3];
  CA_FLOAT ext_xyz_max[3];
  CA_FLOAT ext_cellsize;
  int ext_nc[3];
  int ext_num_steps, ext_num_fields;
  int ext_num_comp;
  int ext_num_nodes, ext_nodes_values;
  int cur_pos_start, cur_pos_end;  // start, the pointer position when T starts (in bytes)
  int ext_temp_length;   //total number cells of T

  
  CA_FLOAT ***ext_temp_new, ***ext_temp_old, ***ext_temp; 
  int ***ext_status;
  CA_FLOAT ***ca_ext_temp;
  CA_FLOAT *ext_times;

  int ext_count;  
  
  
  
  
  /**--------------- End ------------  LYUAN**/
  /*-----------------------------------------*/

  int outflag;
  
/**  \todo  make temporary arrays in the subblock instead -- multiblock */
   CA_FLOAT * floatclosed;
   CA_FLOAT *ftmp_dc_d;        /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *ftmp_dc_x;        /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *ftmp_dc_y;        /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *ftmp_dc_z;        /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *ftmp_five;        /* CA_FLOAT array size (nc[i]+2)^3 */ /*by Wei WANG on 11-07-02*/
   CA_FLOAT *ftmp_four;        /* CA_FLOAT array size (nc[i]+2)^3 */ /*by Wei WANG on 11-07-02*/
  CA_FLOAT *ftmp_cl_poly[NSOLMAX];      /*by THUINET on 18-02-05 */

  CA_FLOAT *ftmp_ce_poly[NSOLMAX];      /*by THUINET on 18-02-05 */
  CA_FLOAT *ftmp_one_poly[NPHAMAX];     /*THUINET 04/05 */
   CA_FLOAT * c_sol_in_solid_values;
   CA_FLOAT *conc_anal;  /* analythic solution for 3 component system */
   CA_FLOAT *ftmp_one;         /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *ftmp_one_old;     /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *ftmp_three;         /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *ftmp_two;         /* CA_FLOAT array size (nc[i]+2)^3 */
   CA_FLOAT *old_Tunder;
   CA_FLOAT *ftmp_nx;     /* CA_FLOAT array size (nc[i]+2)^3 to hold normal_x and normal_y  for curv calculation only added by xly 2004/09/06 */
   CA_FLOAT *ftmp_ny;
   CA_FLOAT *ftmp_nz;

   Frame cubeptr;      /* the geometry lookup tables   */
  Ind_grain **gr;               /* array of grain stuctures        */
   Mat_str mprops;      /* defined in matprops.h        */
   MultiS_struct MultiSvals; /* multi solute values in bb see*/
   Nbhd_str nbhd;       /* defined in nbhd.h           */
   Nuc_str nprops;      /* defined in nucprops.h        */
   PR_str * prlookup; /*defined in pr_struct.h */
   P_str pprops;  /* defined in pore.h */
   SB_struct **sb;        /* ptr to array of subblock str.   */
   TC_str tc;
   TEMP_str * templookup; /*defined in temp_struct.h */
   time_t starttime;
   /* pointer to temperature calc function */
   CA_FLOAT (*cell_temp_func)(struct bigblock *bp,int sbnum, int i, int j, int k); 
   /*
   CA_FLOAT (*mould_src_func)(struct bigblock *bp, CA_FLOAT cell_temp, CA_FLOAT conc, int i, int j, int k);
   */
   BB_Fem_str fem;      /* str. to hold FEM info        */
   Ctrl_str *ctrl;       /* defined in read_ctrl.h       */
   FGrid_str *fg;        /* str. to hold FIDAP info      */
   FGrid_str *fg_next;        /* str. to hold FIDAP info      */
   char tailer[256];      /* tailer string (-;               */
} BB_struct;
#endif /*BIGBLOCK_H*/
