%{
#include <stdio.h>
#include <string.h>
#define YYDEBUG 1
#define YYERROR_VERBOSE

void yyerror(char *s){
   printf("ERROR: yyerror: %s\n",s);
}

void header(FILE *fp){
      fprintf(fp,"/* AUTOGENERATED write structure routine */\n");
      fprintf(fp,"#include <stdio.h>\n");
      fprintf(fp,"#include <stdlib.h>\n");
      fprintf(fp,"#include <time.h>\n");
      fprintf(fp,"#include \"machine.h\"\n");
      fprintf(fp,"#include \"blocks.h\"\n");
}
void h_header(FILE *fp){
      fprintf(fp,"/* AUTOGENERATED header file for write structure routines */\n");
}

void prog(char * s,const char * strname){
      sprintf(s,"void write_%s_values(FILE * fp,struct %s *sp){\n",strname,strname);
}

FILE * fp,*hfp;
char * line;
char  outstring[1000];
int cmtflag = 0;
int newflag = 0;
int nflag = 0;
int endflag = 0;
%}
%union{
int index;
double val;
char * name;
}
%token <val> NUMBER
%token <name> NAME KEY STRNAME OTHER STRSTART
%token <index> INDEX
%type <name> Name Key
%type <index> index Index
%%
input:  | input line ;

member: Key Name Other {fprintf(stderr,"/* %s Member name: %s */\n",$1,$2);
                  if (strcasecmp ($1,"int") == 0){
                     fprintf(fp,"   fprintf(fp,\"%s: %%i\\n\",sp->%s);\n",$2,$2);
                  }else if (strcasecmp ($1,"float") == 0){
                     fprintf(fp,"   fprintf(fp,\"%s: %%g\\n\",sp->%s);\n",$2,$2);
                  }

                 }
;
array: Key Name Index Other { if ($3 == 0){
                                fprintf(stderr,"/*Can't do multi arrays yet */\n");
                              }else{
                                fprintf(stderr,"/* Member %s array %s index %i*/\n",$1,$2,$3);
                                fprintf(fp,"   for(i=0;i<%i;i++){\n",$3);

                  if (strcasecmp ($1,"int") == 0)
                                fprintf(fp,"     fprintf(fp,\"%s[%%i]: %%i\\n\",i,sp->%s[i]);\n",$2,$2);
                  else if (strcasecmp ($1,"float") == 0)
                                fprintf(fp,"     fprintf(fp,\"%s[%%i]: %%g\\n\",i,sp->%s[i]);\n",$2,$2);

                                fprintf(fp,"   }\n");
                              }
                            }
;
Index: index {$$ = $1;}
       | Index index {$$=0;}
;

index: INDEX {printf("Parser: index %i\n",$1);}
;

endstr: STRNAME {fprintf(fp,"}\n/* End of structure %s */\n",$1);}
;
strstart: STRSTART STRNAME {printf("Parser: strname %s\n",$2);
                            fprintf(fp,"/* start of structure %s */\n",$2);
                            prog(outstring,$2);
                            fprintf(fp,"%s",outstring);
                            fprintf(fp,"   int i;\n\n");
                            fprintf(fp,"   fprintf(fp,\"\\n%s STRUCTURE VALUES *****\\n\");\n" ,$2);
                            outstring[strlen(outstring)-2] = ';';
                            fprintf(hfp,"extern %s",outstring);
                           }
;
info:  Name {;} | Key {;} | Other {;} | Number {;} ;
line: array | strstart | endstr | member | info | info line;

Name: NAME {printf("parser: Name: %s\n",$1)}
;

Number: NUMBER {printf("parser: Number %f\n",$1)}
;

Key: KEY {printf("parser: Key: %s\n",$1)}
;

Other: OTHER {printf("parser: Other: %s\n",$1)}
;

%%


/*
int yylex(void){
   char * token;
   int return_val;

   if (newflag == 0){
      newflag = 1;
      token = strtok(line," ,\t");
   }else{
      token = strtok(NULL," ,\t");
   }

   if (token == NULL){
      return 0;
   }


   if ( token[0] == '/' || token[0] == '#' || token[0] == '%'){
       return_val = CMT;
       yylval.name = strdup(token);
   }else if(isalpha(token[0])){
      yylval.name = strdup(token);
      return_val = NAME;
   }else{
      yylval.val = atof(token);
      return_val= NUMBER;
   }
   return (return_val);
}
*/

void main(int argc, char * argv[]){
    fp = fopen("P_out.c","w");
    hfp = fopen("P_out.h","w");
    header (fp);
    h_header(hfp);
    while (endflag == 0){
       printf("Parsing .. \n");
       yyparse();
       printf("Enflag %i\n",endflag);
    }
    fclose (fp);
    fclose (hfp);
}





  


