/*$Id: checkgas.c 887 2006-03-01 18:21:01Z rcatwood $*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <signal.h>
#include "machine.h"
#include "blocks.h"
#include "pore.h"
#include "pore_routines.h"
#include "props.h"
#include "rand_step.h"
#include "gaussdev.h"
#include "ca_histo.h"
#include "find_max.h"
#define STARTSTEP 11750
#define ENDSTEP 11760
CA_FLOAT checkgas (BB_struct * bp, int callflag)
{
  static int callnum = 1;
  CA_FLOAT pore_nmols = 0, diff_gas, ctot = 0, tot_gas = 0, dumb, change;
  CA_FLOAT init_gas = (bp->ncsb * bp->ntsb * bp->vol_c * bp->mprops.gasprops.Cinit);
  PORE_str *pl;
  int sbnum, i;

  if (bp->step < STARTSTEP)
    return (0);
  for (sbnum = 0; sbnum < bp->ntsb; sbnum++) {
    pl = bp->sb[sbnum]->porelist;

    find_max_conc (bp, bp->c_sol_values, sbnum);
    /* add up the n-mols in the pores */
    for (i = 0; i < bp->sb[sbnum]->Npores; i++) {
      switch (pl[i].State) {
      case PORE_OFF:           /*fallthrough */
      case PORE_NONE:          /*fallthrough */
      case PORE_LATENT:
      case NOT_CASTING:
        /* do nothing */
        break;

      case PORE_SPHERE:        /*fallthrough */
      case PORE_TUBE:
      case PORE_FROZEN:
      case PORE_MULTI:
        pore_nmols += pl[i].NmolsH;
        break;

      default:
        fprintf (stderr, "Output_ex: Pore state in hyperspace %i\n", pl[i].State);
        break;
      }                         /* end of pore switch */
    }                           /* end of looping through pores */
    ctot += bp->c_sol_values->Ctot;
  }                             /* end of sb loop */
  tot_gas = (bp->vol_c) * (ctot) + (pore_nmols * 2);
  diff_gas = ABS ((tot_gas - init_gas) / init_gas);
  if (bp->step >= STARTSTEP)
    fprintf (stderr, "CHECKGAS:bstep, callflag,callnum,tot_gas,%i,%i,%i,%.10g\n", bp->step, callflag, callnum, tot_gas);
  if (callnum == 199) {
    int dumb;

    dumb = 0;
  }
  callnum++;
  if (bp->step == ENDSTEP)
    raise (SIGUSR1);
  return (diff_gas);
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *checkgas_c ()
{
  static char const rcsid[] = "$Id: checkgas.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
