/*RCS ID: $Id: checks.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "machine.h"
#include "blocks.h"

int find_ngrow (BB_struct * bp, int curr)
{
  SB_struct *sp;
  CA_FLOAT *fs, *fsend;
  int ngrow = 0;

  sp = bp->sb[curr];
  fsend = sp->c_fs + bp->ncsb;
  for (fs = sp->c_fs; fs < fsend; fs++) {
    ngrow += ((*fs > 0) && (*fs < 1));
  }
  return (ngrow);
}

CA_FLOAT find_fs_av (BB_struct * bp, int curr)
{
  SB_struct *sp;
  CA_FLOAT *fs, *fsend, sumfs = 0, fsav;

  sp = bp->sb[curr];
  fsend = sp->c_fs + bp->ncsb;
  for (fs = sp->c_fs; fs < fsend; fs++) {
    sumfs += *fs;
  }
  fsav = sumfs / (bp->ncsb - sp->nmould);
  return (fsav);
}

/* find the av. number of grwoing/solid cells in a grain */
CA_FLOAT grain_ncells (BB_struct * bp)
{
  int i;
  int ncells = 0;
  CA_FLOAT ncav = 0;

  if (bp->nprops.ngr == 0)
    return (0);
  for (i = 1; i < bp->nprops.ngr; i++) {
    ncells += bp->gr[i]->ncells;
  }
  ncav = (CA_FLOAT) ncells / bp->nprops.ngr;
  return (ncav);
}                               /*end of grain_ncells */

CA_FLOAT grain_ngrow (BB_struct * bp)
{
  int i;
  int ncells = 0;
  CA_FLOAT ncav = 0;

  if (bp->nprops.ngr == 0)
    return (0);
  for (i = 1; i < bp->nprops.ngr; i++) {
    ncells += bp->gr[i]->ngrow;
  }
  ncav = (CA_FLOAT) ncells / bp->nprops.ngr;
  return (ncav);
}                               /*end of grain_ngrow */

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *checks_c ()
{
  static char const rcsid[] = "$Id: checks.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
