/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/
/****************************************************************/
/* constants.h                                                  */
/* Header file defining numerical constants and similar things  */
/*                                                              */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Tue Nov 23 16:53:55 gmt  1999                                */
/****************************************************************/

/*RCS Id:$Id: constants.h 1407 2008-12-11 19:04:04Z rcatwood $*/

#ifndef CONSTANTS_H
#define CONSTANTS_H
/* line data */
#define N_DATA 100
#define ADD_DATA 100

/* fields per line */
#define N_FIELDS 10
#define ADD_FIELDS 5

/* z and r data*/
#define INIT_ARRAY 10
#define ADD_ARRAY 10

/*Version multicomponent multiphase THUINET 11/05*/

/*Max number of solutes in the system*/
#define NSOLMAX 10
/*Max number of phases or equilibrium between phases in the system*/
#define NPHAMAX 5 

/*End THUINET*/

#define CONSTREV "constants.h $Revision: 1407 $"

#define PROCAST_MIN_STEPS 10
#define FIRST_CALL -1
#define STEP_CALL   0
#define LAST_CALL   1
#define RESTART_CALL (3)

#define JFLG_END 0    /* default behaviour if a signal received */
#define JFLG_WRITEXIT 1
#define JFLG_WRITEBIN 2

/* used for debugging around a known timestep */
#define MANY_DUMP_START 775000 
#define MANY_DUMP_STOP  775500 
#define MANY_FREQ 1
/**/

/* cell state definitions */
#define LIQUID 0.0
#define SOLID 1.0
#define NOT_CASTING -1

#define EMBRYO 0.000001
#define RAD_EMBRYO 0.000001
#define COURANT_LIMIT 0.16
#define SOLID 1.0
#define NOT_CASTING -1
#define DFS_WARNING 0.4
#define EUT_WARNING 0  
#define MAX_WARN_MSG 5
#define MAX_ERR_MSG 5
#define WARN_EXIT_LIMIT 1000
#define DFS_CAP 0.8
#define MAX_CAP_MSG 5
#define MAX_NUC_MSG 5
#define CAP_GROWTH 0.5
#define START_TEMP_OFFSET 2000
#define CAP_TEMP_OFFSET 20
#define LIQUIDUS 1
#define CONC_MULTI 2
#define CONC_MULTI_MONO 3
#define LINEAR1 1
#define LINEAR2 2
#define REGRESSION 3
#define FROZEN 20.0 /* failsafe temperature to stop at */
#define MAX_CTRL 300 /* maximum number of fixed nuclei or slices */
/***********************************************************/
/* Some numerical constants etc...                         */
/***********************************************************/
#define SQRT2 1.4142136
#define THREE_BY_4PI    0.2387324146378    /* 3/4pi */
#define FOURPI_BY_THREE    4.1887902       /* 4/3 * pi */
#define PI    3.14159265       /*  pi */
#define PI_BY_FOUR      0.7853981633974    /* pi/4 */
#define LARGE 1.0e+21
#define P_AP_PA	101000.0                 /* applied pressure default value in Pa*/
#define P_AP_ATM 1.0                       /* applied pressure default value in Atm*/
#define GAS_CONST_ATM	82.056875	       /* R in $cm^3 x Atm \over (g.mol x K)$ */
#define GAS_CONST_SI	8.31441  	          /* R in $J\over K mol$*/
#define GAS_CONST_CM	8.31441e6  	          /* R in $J\over K mol$*/
#define STD_TEMP        273.16             /* Std temp in K */
#define CBRT2		1.2599210499         	 /* cbrt(2,0): 1.259921 */
#define POW_3_TO_1PT5	5.1961524227	    /* pow(3,3.0/2.0): 5.196152 */

#define MPMMCB 1.174812e-9                 /*conv ml/100g stp to mol/mm cub*/
#define MPLITRE 1.174812e-3                /*conv ml/100g stp to mol/l*/
#define MPMETERCUB 1.174812                /*conv ml/100g stp to mol/m cub*/
#define CONV_ATM_CM 9.8716683e-4           /* conv pa.m to atm.cm */


#define SB_NEW 0
#define SB_OPEN 1
#define SB_CLOSED 2
#define SURF_NUC_ALLOC_START (10000)
#define SURF_NUC_ALLOC_STEP (1000)

/***********************************************************/
/* properties of the alloy solute    (SCHEIL)              */
/*  also used in phase diagram mode for pores              */
/***********************************************************/
/* default to SILICON */
#if  !defined MAGNESIUM && !defined SILICON && !defined A356 && !defined INCONEL && !defined MULTICOMP
  #define SILICON
#endif

#ifdef MAGNESIUM
   #define DOUTRE_F 0.0170
   /* the following values from NLM - Hiromi Nagaumi */
      #define DAS_PRE 48.837e-6
      #define DAS_EXP -0.3085
   /*end NLM values*/

#elif defined INCONEL
   #define DOUTRE_F 0
   #define TRAD_END 500
   #define DAS_PRE 50.0e-6
   #define DAS_EXP -0.3333

   #ifndef ALLOY_EXPONENT
      #define ALLOY_EXPONENT 0.33
   #endif
   #ifndef DAS_COS_THETA
      #define DAS_COS_THETA 0.9848 /* about 10 degrees */
   #endif /*DAS_COS_THETA*/

#elif defined MULTICOMP
   #define MAX_B_CONC_1  12
   #define MAX_B_CONC_2  27.0
   #define T_EUT_1 570.0
   #define T_EUT_2 540.0
   #define TP_1    650.0
   #define TP_2    650.0
   #define DOUTRE_F -0.0119
   #define FS_EUT 0.65
   #define T_EUT 570.0 /*C*/
   #define T_LIQ 616.7 /*C*/
   #define T_SOL 500.0
   #define TP 650.0
   #define M -7.1212
   #define PD_SLOPE -7.1212
   #define KB 0.13
   #define CINITB 7.0 /*w%*/
   #define MAX_B_CONC 12.6 /*w%*/
   #define TRAD_END 545

   #ifndef ALLOY_EXPONENT
      #define ALLOY_EXPONENT 0.33
   #endif
   #ifndef DAS_COS_THETA
      #define DAS_COS_THETA 0.9848 /* about 10 degrees */
   #endif /*DAS_COS_THETA*/
   #define TRAD_END 449 
#elif defined SILICON
   #define DOUTRE_F -0.0119
   #define TRAD_END 545
   #define DAS_PRE 50.0e-6
   #define DAS_EXP -0.3333

   #ifndef ALLOY_EXPONENT
      #define ALLOY_EXPONENT 0.33
   #endif
   #ifndef DAS_COS_THETA
      #define DAS_COS_THETA 0.9848 /* about 10 degrees */
   #endif /*DAS_COS_THETA*/
#elif defined A356
   #define DOUTRE_F -0.0119
   #define TRAD_END 545
   #define DAS_PRE 50.0e-6
   #define DAS_EXP -0.3333

   #ifndef ALLOY_EXPONENT
      #define ALLOY_EXPONENT 0.33
   #endif
   #ifndef DAS_COS_THETA
      #define DAS_COS_THETA 0.9848 /* about 10 degrees */
   #endif /*DAS_COS_THETA*/
#elif defined VAR

#endif /*MAGNESIUM or SILICON*/

   #ifdef BUG_OCT_02
      #undef TRAD_END
      #define TRAD_END 610
      #define TRAD_START 615
   #endif
/***********************************************************/
/* end of SCHEIL parameters section  (SCHEIL)              */
/***********************************************************/
/*******************************************/
/* Nuc distribution parameters             */
/*******************************************/
   #define N_NUC_MODELS 7
      /* the names of the models */
      #define N_RAPPAZ 1	/*  rappaz model                        */
      #define N_HETERO 2	/*  heterogenous model                  */
      #define N_DIST 3   	/*  distribution heterogenous model                 */
      #define N_RAP_DEL 4  /*use delta Undercooling and Rappaz                 */ 
      #define N_OLDF_DEL 5  /*use delta Undercooling and Oldfiled              */ 
      #define N_BLOCK 6     /* use method with threshold per cell in the block */

   #define D_GD_MAX_TOTAL 100000	/* Max number of grains in total*/
   #define N_NUC_FUNCS 6
   #define N_TUND_BINS 10000
   #define TUND_MAX 50
   #define U_MAX 10
   #define N_U_BINS 100
   #define K_ONE 1e19

/*******************************************/
/* end of Nuc distribution parameters      */
/*******************************************/
#define FLAT_GROWTH 7e-5
/* test gas diff. coeff. for constant Dl and Ds*/
#define TEST_DL 3.3e-7
#define TEST_DS 6.1e-8
/* constants used in pore routines */
   #define PORE_T_EUT_OFFSET 1.0 /* print pores with tnuc > TEUT + offset */
   #define PORE_NONE 0
   #define PORE_SPHERE 1
   #define PORE_OFF 2 
   #define PORE_TUBE 3
   #define PORE_LATENT 4
   #define PORE_MULTI 5
   #define PORE_FROZEN 6
   #define PORE_NTRAD 100 /* number of temperature benchmarks for pore data */
   #define PORE_EXTRA 25  /* if PORE_REALLOC defined, how many array elements to increase */
   #define TAU 0.1 /* dwell time constant */
   #define PORE_MIN_TUBE_FS 1e-4
   #define PORE_MAX_FS 0.9
#ifndef MIN_LIMRAD             /*minimum pore limrad */
#define MIN_LIMRAD 1e-7
#endif

/* the minimum number of allowed pores */
#define PNUC_MIN (1)
/* the different pore nuc function choices */
#define PNUC_GAUSS (0)
#define PNUC_STEP (1)
#define PNUC_TRUESTEP (2)
#define PNUC_FUNCTION (3)
#define PNUC_INPUT (4)
#define PNUC_GAUSSDEV (5)
#define PNUC_SQUARE (6)

#define P_NUC_MIN_SS 1.2
#define P_NUC_SIG_MULT 3.0
/* used for preparing nuclaetion  histogram for pores*/
#define P_MINBIN 1.0
#define P_NBINS 100
#define P_BINSIZE 0.05

/* random generator function for grains */
#define G_NUC_STEP 0
#define G_NUC_SQUARE 1
#define G_NUC_GAUSSDEV 2
#define G_NUC_TWOSTEP 3

#define G_NUC_MIN_UND 1.0e-5
#define G_NUC_SIG_MULT 6.0
/* used for preparing nuclaetion  histogram for grains*/
#define G_MINBIN 0.0
#define G_NBINS  50
#define G_BINSIZE 0.2
/* used for preparing size histogram for grains*/
#define G_SIZE_MINBIN  0.0
#define G_SIZE_NBINS  50
#define G_SIZE_BINSIZE 0.5 

#endif /*CONSTANTS_H*/
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2.2.2  2006/01/18 12:01:17  lthuinet
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 10.2.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1.2.1  2005/11/07 17:47:56  rcatwood
RCS Log:Branch uisng Xiao Li Yang final version
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 9.5.4.1.6.1  2004/08/02 12:13:53  xly
RCS Log:changed undercooling calculation for block cell nucleation.
RCS Log:Revision 8.6.8.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.5.4.1  2004/05/24 18:36:04  rcatwood
RCS Log:Added individual surface nucleation parameters
RCS Log:
RCS Log:Revision 9.5  2003/11/18 13:22:40  rcatwood
RCS Log:Added routines to find and store the interface cells between the casting and the mould.
RCS Log:Added the surface cell storage structure to the subblock.
RCS Log:Improved mould source and nucleation  routines to use the surface cell structure
RCS Log:
RCS Log:Revision 9.4  2003/10/27 20:01:11  rcatwood
RCS Log:Harmonized header file cpp protection
RCS Log:Fixed filename bug for restart
RCS Log:
RCS Log:Revision 9.3  2003/10/23 16:32:39  rcatwood
RCS Log:chagned signal result to allow writing of the final files on USR1
RCS Log:
RCS Log:Revision 9.2  2003/09/16 11:59:14  rcatwood
RCS Log:Improved micro/macro interpolation
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.6.2.6  2003/08/14 14:17:57  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.6.2.5  2003/05/06 15:48:07  rcatwood
RCS Log:Altered linear binary phase diagram usage to consistently use the values input from the control files rather than the header files.
RCS Log:
RCS Log:Revision 8.6.2.4  2003/05/02 14:09:52  rcatwood
RCS Log:fix double DEFINE
RCS Log:
RCS Log:Revision 8.6.2.3  2003/01/22 16:53:43  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.6.2.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.4.2.1  2002/11/06 17:27:45  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 8.4  2002/10/31 18:02:57  rcatwood
RCS Log:Moved clock tick macro to machine.h where it belongs
RCS Log:
RCS Log:Revision 8.3  2002/10/31 17:52:02  rcatwood
RCS Log:improved clock use for calculation time reporting
RCS Log:
RCS Log:Revision 8.2  2002/10/18 15:48:02  rcatwood
RCS Log:WITHOUT cell_dif_coeff
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:01  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.15  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.14.8.7  2002/10/10 12:06:05  rcatwood
RCS Log:Merge pore and decentered square -- but restart needs work
RCS Log:
RCS Log:Revision 7.14.8.6  2002/09/27 14:38:45  rcatwood
RCS Log:Added write block structure values routines
RCS Log:Modified matprops to allow T and C for eutectic to b read in
RCS Log:Modified props to use these values
RCS Log:Modified Makefile to make the obj files in a subdirectory
RCS Log:
RCS Log:Revision 7.14.8.5  2002/09/19 18:34:57  rcatwood
RCS Log:First working restart version using bin-block file
RCS Log:
RCS Log:Revision 7.14.8.4  2002/09/19 11:25:42  rcatwood
RCS Log:added control to print out at a specified fraction-solid
RCS Log:
RCS Log:Revision 7.14.8.3  2002/09/17 20:51:07  rcatwood
RCS Log:Rearranged so that read/write leave the memory clean
RCS Log:Added signal 16 (SIGUSR1) catching for trapping after finishing the current timestep.
RCS Log:
RCS Log:Revision 7.14.8.2  2002/08/30 19:18:24  rcatwood
RCS Log:split bigblock and subblock allocation into seperate subroutines
RCS Log:from bigblock.c and open_sb.c: added alloc_bb.c and alloc_sb.c
RCS Log:
RCS Log:Revision 7.13.2.1  2002/07/09 14:30:27  rcatwood
RCS Log:Changed subblock open flag to 3 values: new, open,and closed. This is to aviod re-opening blocks that are already processed.
RCS Log:COmpiles and runs without seg fault.
RCS Log:Revision 7.14.8.1  2002/08/22 15:13:43  ww1
RCS Log:Merge of Wei Wang's decentered octahedron/square method
RCS Log:
RCS Log:Revision 7.14  2002/06/18 18:16:50  rcatwood
RCS Log:changed pore output: just pore P_ONLY file and .por list file
RCS Log:
RCS Log:Revision 7.13  2002/05/23 17:28:01  rcatwood
RCS Log:Used dbmalloc to eliminate all memory leaks!
RCS Log:Started close-sb routine to improve multiblock
RCS Log:
RCS Log:Revision 7.12  2001/08/28 19:08:51  rcatwood
RCS Log:thesis version
RCS Log:
RCS Log:Revision 7.11  2001/06/25 16:55:46  rcatwood
RCS Log:changed size for grain histo to proper units instead of cell number
RCS Log:
RCS Log:Revision 7.10  2001/05/31 16:24:45  rcatwood
RCS Log:changed M macro to PD_SLOPE (Easier to find!)
RCS Log:
RCS Log:Revision 7.9  2001/03/27 11:31:49  rcatwood
RCS Log:Protected error messages from excessive numbers
RCS Log:
RCS Log:Revision 7.8  2001/03/20 11:10:56  rcatwood
RCS Log:filter pores near eutectic out of image
RCS Log:
RCS Log:Revision 7.7  2001/03/13 11:39:19  rcatwood
RCS Log:Merged Anchou version - which only updates constants.h with A356 values.
RCS Log:
RCS Log:Revision 7.6  2001/03/13 10:36:46  rcatwood
RCS Log:Ready to Merge with anchou version
RCS Log:Fixed not-casting problems,
RCS Log:seperate pore stats file.
RCS Log:Revision 7.4  2001/03/05 19:37:18  rcatwood
RCS Log:Beginning of An Chou merge. Used to continue AT runs
RCS Log:Added extra stat-only output
RCS Log:
RCS Log:Revision 7.3  2001/03/02 18:02:44  rcatwood
RCS Log:Merged Anchou's branch into main
RCS Log:Eliminated some old files
RCS Log:Revision 7.5  2001/02/22 13:00:24  rcatwood
RCS Log:Included pore reallocation and stop temp (as cpp macro)
RCS Log:fixed x-y bug in line intercept routine
RCS Log:
RCS Log:Revision 7.2.2.2  2001/03/02 17:36:24  acy97
RCS Log:Updated with Anchou's constants file
RCS Log:Revision 7.4  2001/02/19 21:35:25  rcatwood
RCS Log:fixed more histo,
RCS Log:also found memory allocation bug, not sur eif it is fixed.
RCS Log:
RCS Log:Revision 7.2.2.1  2001/02/20 18:40:27  acy97
RCS Log:Revision 7.3  2001/02/19 19:28:46  rcatwood
RCS Log:fixed histo
RCS Log:for grains
RCS Log:
RCS Log:Pore bug that causes pores to nucleate below expected liquidus temp.
RCS Log:and also make TcTrace mode override const. cooling rate
RCS Log:
RCS Log:Revision 7.2  2000/11/08 12:10:54  rcatwood
RCS Log: changed PORE_MIN_TUBE_FS
RCS Log:
RCS Log:Revision 7.1  2000/11/07 18:57:14  rcatwood
RCS Log:Altered T_lists and pore_max_fs
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.4  2000/10/24 14:55:52  rcatwood
RCS Log:before changing pore
RCS Log:
RCS Log:Revision 6.3  2000/10/17 13:59:36  rcatwood
RCS Log:added some stuff eg courant stability limit.
RCS Log:
RCS Log:Revision 6.1.1.1  2000/10/16 17:29:57  rcatwood
RCS Log:non-casting cells
RCS Log:
RCS Log:Revision 6.2  2000/10/16 10:37:22  rcatwood
RCS Log:Changed grain nuc to include block_nuc method
RCS Log:
RCS Log:Revision 6.1  2000/10/09 16:57:04  rcatwood
RCS Log:Before changing nucleation
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:37  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.1  2000/09/25 17:35:30  rcatwood
RCS Log:Before synch with common version, Used for PORE_00 paper
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.6  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.5  2000/06/29 14:31:02  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.4  2000/06/27 11:41:19  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.3  2000/06/12 16:23:30  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.2  2000/06/06 18:43:04  rcatwood
RCS Log:Changed r start and growth of pores -- pore radius equilibrium
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.7  2000/05/04 18:36:45  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.6  2000/04/11 14:44:05  rcatwood
RCS Log:Seperated castats routines. Fixed sreenprint bug and error overruns
RCS Log:
RCS Log:Revision 5.5  2000/03/27 17:06:27  rcatwood
RCS Log:Particle dependant growth - neg. phi
RCS Log:
RCS Log:Revision 5.5  2000/03/27 11:21:22  rcatwood
RCS Log:Checkin prior to modifications for particle version
RCS Log:
RCS Log:Revision 5.4  2000/03/27 11:21:18  rcatwood
RCS Log:Particle dependant growth - neg. phi
RCS Log:
RCS Log:Revision 5.4  2000/03/24 19:33:30  rcatwood
RCS Log:Checkin prior to modifications for particle version
RCS Log:
RCS Log:Revision 5.3  2000/03/24 19:19:48  rcatwood
RCS Log:Particle dependant growth fixed
RCS Log:
RCS Log:Revision 5.3  2000/03/23 19:00:16  rcatwood
RCS Log:Checkin prior to modifications for particle version
RCS Log:
RCS Log:Revision 5.2  2000/03/23 18:57:37  rcatwood
RCS Log:Particle dependant growth added
RCS Log:
RCS Log:Revision 5.2  2000/03/23 17:19:56  rcatwood
RCS Log:Checkin prior to modifications for particle version
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.2  2000/02/29 18:00:25  rcatwood
RCS Log:Bug fixed when growing into new block
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.7  2000/02/15 15:29:11  rcatwood
RCS Log:Version after McWasp submitted
RCS Log:
RCS Log:Revision 4.6  2000/01/27 12:18:48  rcatwood
RCS Log:Overgrowth addressed. Bindump of t, fs
RCS Log:
RCS Log:Revision 4.5  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.4  1999/12/23 18:09:21  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.3  1999/12/21 10:26:15  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.2  1999/12/20 13:11:23  rcatwood
RCS Log:Alloy and Gas outputs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
