/************************************************************************/
/*             Fluid Flow Code   by LY   01/2008   
                          set boundary conditions
						  no-slip wall bc 
*/
/************************************************************************/

#include "ff_mpflow.h"

void boundary (BB_struct *bp)
{

	int i,j,k;
	
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w, ***ca_cell_p;
	CA_FLOAT ***ca_cell_t, ***ca_cell_ftry; 
//        CA_FLOAT ***ca_cell_fl;
	CA_FLOAT ***ca_cell_h;
	int ***cflag;
	int IMAX, JMAX, KMAX;
	CA_FLOAT sizex, sizey, sizez;
//	CA_FLOAT INITVELO;
	CA_FLOAT INITTEMPCOLD, INITTEMPHIGH;
	CA_FLOAT heatflux, thermcond;
	CA_FLOAT latent;
	CA_FLOAT cp;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	INITTEMPHIGH = bp->inithighT;
	INITTEMPCOLD = bp->initcoldT;
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
        sizez = bp->size_c[2];	
	heatflux = bp->heatflux;
	thermcond = bp->mprops.thermcond;
//	INITVELO = bp->initvelo;
	latent = bp->mprops.latentH;
	cp = bp->mprops.cp;
	
	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	ca_cell_p = bp->ca_cell_p;
	ca_cell_t = bp->ca_cell_t;
//	ca_cell_fl = bp->ca_cell_fl;
	ca_cell_ftry = bp->ca_cell_ftry;
	ca_cell_h = bp->ca_cell_h;

	cflag = bp->cflag;

	if(bp->ctrl->ffheattran == 2){
	  for (i=1; i<=IMAX; i++){
	    for (j=1; j<=JMAX; j++){
	      for (k=1; k<=KMAX; k++){
	         ca_cell_t[i][j][k] = ca_cell_t[i][j][k]+(bp->ctrl->delT)*(bp->delt);
		 ca_cell_h[i][j][k] = cp*ca_cell_t[i][j][k] + ca_cell_ftry[i][j][k]*latent;
	      }
	    }
	  }
	}
		

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      	if (cflag[i][j][k] == FFCELL){
	      		
/*		  if (cflag[i-1][j][k] == BCCELL){  
	            ca_cell_u[i-1][j][k] = 0.0;
		    ca_cell_v[i-1][j][k] = (-1.0) * ca_cell_v[i][j][k];
		    ca_cell_w[i-1][j][k] = (-1.0) * ca_cell_w[i][j][k];

//		    ca_cell_t[i-1][j][k] = 2*INITTEMPCOLD - ca_cell_t[i][j][k];
		    ca_cell_t[i-1][j][k] = ca_cell_t[i][j][k];
//		    ca_cell_fl[i-1][j][k] = ca_cell_fl[i][j][k];
		    ca_cell_p[i-1][j][k] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i-1][j][k] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i-1][j][k] = ca_cell_h[i][j][k];

		  } 
		  if (cflag[i+1][j][k] == BCCELL ){  
		    ca_cell_u[i][j][k] = 0.0;
		    ca_cell_v[i+1][j][k] = (-1.0) * ca_cell_v[i][j][k];
		    ca_cell_w[i+1][j][k] = (-1.0) * ca_cell_w[i][j][k]; 

//		    ca_cell_t[i+1][j][k] = 2*INITTEMPHIGH - ca_cell_t[i][j][k];
		    ca_cell_t[i+1][j][k] =  ca_cell_t[i][j][k];
//		    ca_cell_fl[i+1][j][k] = ca_cell_fl[i][j][k];
		    ca_cell_p[i+1][j][k] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i+1][j][k] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i+1][j][k] = ca_cell_h[i][j][k];
		  }

*/		  if (cflag[i][j-1][k] == BCCELL){  
		    ca_cell_u[i][j-1][k] = (-1.0) * ca_cell_u[i][j][k];
		    ca_cell_v[i][j-1][k] = 0.0;
		    ca_cell_w[i][j-1][k] = (-1.0) * ca_cell_w[i][j][k]; 
		    
//		    ca_cell_t[i][j-1][k] = 2*INITTEMPCOLD - ca_cell_t[i][j][k];
		    ca_cell_t[i][j-1][k] = heatflux*sizey/thermcond + ca_cell_t[i][j][k];
//		    ca_cell_fl[i][j-1][k] = ca_cell_fl[i][j][k];
		    ca_cell_p[i][j-1][k] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i][j-1][k] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i][j-1][k] = ca_cell_h[i][j][k];
		  }
		  if (cflag[i][j+1][k] == BCCELL){  // || ca_cell_ftry[i][j+1][k]<=0.1){
	            ca_cell_u[i][j+1][k] = (-1.0) * ca_cell_u[i][j][k];
		    ca_cell_v[i][j][k] = 0.0;
		    ca_cell_w[i][j+1][k] = (-1.0) * ca_cell_w[i][j][k]; 

//		    ca_cell_t[i][j+1][k] = 2*INITTEMPHIGH - ca_cell_t[i][j][k];
//		    ca_cell_t[i][j+1][k] = -heatflux*sizey/thermcond/2 + ca_cell_t[i][j][k];
		    ca_cell_t[i][j+1][k] =  ca_cell_t[i][j][k];
//		    ca_cell_fl[i][j+1][k] = ca_cell_fl[i][j][k];
		    ca_cell_p[i][j+1][k] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i][j+1][k] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i][j+1][k] = ca_cell_h[i][j][k];
		  }
		  if (cflag[i][j][k-1] == BCCELL){  // || ca_cell_ftry[i][j][k-1]<=0.1){
/*		    ca_cell_u[i][j][k-1] = (-1.0) * ca_cell_u[i][j][k];
		    ca_cell_v[i][j][k-1] = (-1.0) * ca_cell_v[i][j][k]; 
		    ca_cell_w[i][j][k-1] = 0.0;
*/			
		    ca_cell_u[i][j][k-1] = ca_cell_u[i][j][k];
		    ca_cell_v[i][j][k-1] = ca_cell_v[i][j][k];
		    ca_cell_w[i][j][k-1] = 0.0;   //ca_cell_w[i][j][k];
		    
		    ca_cell_t[i][j][k-1] = ca_cell_t[i][j][k];
//		    ca_cell_fl[i][j][k-1] = ca_cell_fl[i][j][k];
		    ca_cell_p[i][j][k-1] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i][j][k-1] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i][j][k-1] = ca_cell_h[i][j][k];
		  }
		  if (cflag[i][j][k+1] == BCCELL){  // || ca_cell_ftry[i][j][k+1]<=0.1){
/*   		    ca_cell_u[i][j][k+1] = (-1.0) * ca_cell_u[i][j][k];
		    ca_cell_v[i][j][k+1] = (-1.0) * ca_cell_v[i][j][k]; 
		    ca_cell_w[i][j][k] = 0.0;
*/			
		    ca_cell_u[i][j][k+1] = ca_cell_u[i][j][k];
		    ca_cell_v[i][j][k+1] = ca_cell_v[i][j][k]; 
		    ca_cell_w[i][j][k] = 0.0;   //ca_cell_w[i][j][k-1];
		    
		    ca_cell_t[i][j][k+1] = ca_cell_t[i][j][k];
//		    ca_cell_fl[i][j][k+1] = ca_cell_fl[i][j][k];
		    ca_cell_p[i][j][k+1] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i][j][k+1] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i][j][k+1] = ca_cell_h[i][j][k];
		  }
/*		  
//#define LYUAN_DOWNIN
#ifdef LYUAN_DOWNIN
                  if (cflag[i][j-1][k] == INLETCELL){
		    ca_cell_u[i][j-1][k] = 2*bp->initvelo[0]-ca_cell_u[i][j][k];
		    ca_cell_v[i][j-1][k] = bp->initvelo[1] ;
		    ca_cell_w[i][j-1][k] = 2*bp->initvelo[2]-ca_cell_w[i][j][k];
		    
//		    ca_cell_t[i][j-1][k] = 2*INITTEMPHIGH - ca_cell_t[i][j][k];
		    ca_cell_t[i][j-1][k] = ca_cell_t[i][j][k];
//		    ca_cell_fl[i][j-1][k] = ca_cell_fl[i][j][k];
		    ca_cell_p[i][j-1][k] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i][j-1][k] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i][j-1][k] = ca_cell_h[i][j][k];
		  }

		  if (cflag[i][j+1][k] == OUTLETCELL){
		    ca_cell_u[i][j+1][k] = ca_cell_u[i][j][k];
		    ca_cell_v[i][j][k] = ca_cell_v[i][j-1][k] ;
		    ca_cell_w[i][j+1][k] = ca_cell_w[i][j][k];
		    
 //                 ca_cell_t[i][j-1][k] = 2*INITTEMPHIGH - ca_cell_t[i][j][k];
                    ca_cell_t[i][j+1][k] = ca_cell_t[i][j][k];
 //                 ca_cell_fl[i][j+1][k] = ca_cell_fl[i][j][k];
                    ca_cell_p[i][j+1][k] = ca_cell_p[i][j][k];
                    ca_cell_ftry[i][j+1][k] = ca_cell_ftry[i][j][k];
                    ca_cell_h[i][j+1][k] = ca_cell_h[i][j][k];                          
		   }
#endif
		  
*/
//#define LYUAN_LEFTIN
#ifdef LYUAN_LEFTIN
		  if(cflag[i-1][j][k] == INLETCELL){
		    ca_cell_u[i-1][j][k] = bp->initvelo[0];
		    ca_cell_v[i-1][j][k] = 2*bp->initvelo[1]-ca_cell_v[i][j][k];
		    ca_cell_w[i-1][j][k] = 2*bp->initvelo[2]-ca_cell_w[i][j][k];
		    ca_cell_t[i-1][j][k] = ca_cell_t[i][j][k];
//		    ca_cell_fl[i-1][j][k] = ca_cell_fl[i][j][k];
	 	    ca_cell_p[i-1][j][k] = ca_cell_p[i][j][k];
		    ca_cell_ftry[i-1][j][k] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i-1][j][k] = ca_cell_h[i][j][k];
		  }

		  if(cflag[i+1][j][k] == OUTLETCELL){
		    ca_cell_u[i][j][k] =  ca_cell_u[i-1][j][k];
		    ca_cell_v[i+1][j][k] = ca_cell_v[i][j][k];
		    ca_cell_w[i+1][j][k] = ca_cell_w[i][j][k];
		    ca_cell_t[i+1][j][k] = ca_cell_t[i][j][k];
//		    ca_cell_fl[i+1][j][k] = ca_cell_fl[i][j][k];
		    ca_cell_p[i+1][j][k] = ca_cell_p[i][j][k];   
		    ca_cell_ftry[i+1][j][k] = ca_cell_ftry[i][j][k];
		    ca_cell_h[i+1][j][k] = ca_cell_h[i][j][k];	
		  }

#endif
		} 
				
			

	    } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/

		  
#ifdef LYUAN_DOWNIN
	for (j=0; j<=JMAX+1; j++){
	  for (k=0; k<=KMAX+1; k++){
	  	
		/* Periodic for the left and right walls*/	  	
            ca_cell_u[0][j][k] = ca_cell_u[IMAX-1][j][k];
	    ca_cell_v[0][j][k] = ca_cell_v[IMAX-1][j][k];
	    ca_cell_w[0][j][k] = ca_cell_w[IMAX-1][j][k];
	    
	    ca_cell_v[1][j][k] = ca_cell_v[IMAX][j][k];
	    ca_cell_w[1][j][k] = ca_cell_w[IMAX][j][k];
	    ca_cell_u[IMAX][j][k] = ca_cell_u[1][j][k];
	    ca_cell_v[IMAX+1][j][k] = ca_cell_v[2][j][k];
	    ca_cell_w[IMAX+1][j][k] = ca_cell_w[2][j][k];
	    
	    ca_cell_p[1][j][k] = ca_cell_p[IMAX][j][k];
	    ca_cell_ftry[1][j][k] = ca_cell_ftry[IMAX][j][k];
	    
	  /* Symmetry for the left and right walls*/

/*	    ca_cell_u[0][j][k] = 0.0 ;   //ca_cell_u[1][j][k];    
	    ca_cell_v[0][j][k] = ca_cell_v[1][j][k];
	    ca_cell_w[0][j][k] = ca_cell_w[1][j][k];
	    
	    ca_cell_u[IMAX][j][k] = 0.0;  // ca_cell_u[IMAX-1][j][k]; 
	    ca_cell_v[IMAX+1][j][k] = ca_cell_v[IMAX][j][k];
	    ca_cell_w[IMAX+1][j][k] = ca_cell_w[IMAX][j][k];
*/	  
	  /*Symmtry for T and P*/
	
	    ca_cell_t[0][j][k] = ca_cell_t[1][j][k];
	    ca_cell_t[IMAX+1][j][k] = ca_cell_t[IMAX][j][k];
	    ca_cell_h[0][j][k] = ca_cell_h[1][j][k];
	    ca_cell_h[IMAX+1][j][k] = ca_cell_h[IMAX][j][k];
	  }
	}
#endif	

	
#ifdef LYUAN_LEFTIN
        for (i=0; i<=IMAX+1; i++){
          for (k=0; k<=KMAX+1; k++){
          /* Symmetry for the up and down walls*/

            ca_cell_u[i][0][k] = ca_cell_u[i][1][k];
            ca_cell_v[i][0][k] = 0.0;
            ca_cell_w[i][0][k] = ca_cell_w[i][1][k];

            ca_cell_u[i][JMAX+1][k] = ca_cell_u[i][JMAX][k];
            ca_cell_v[i][JMAX][k] = 0.0;
            ca_cell_w[i][JMAX+1][k] = ca_cell_w[i][JMAX][k];

														            /*Symmtry for T and P*/

            ca_cell_t[i][0][k] = heatflux*sizey/thermcond + ca_cell_t[i][1][k];
            ca_cell_t[i][JMAX+1][k] = ca_cell_t[i][JMAX][k];
 	    ca_cell_h[i][0][k] = ca_cell_h[i][1][k];
            ca_cell_h[i][JMAX+1][k] = ca_cell_h[i][JMAX][k];
          }
        }
#endif

		  
}

