/*---------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008     
			allocate memory and free memory
*/
/*---------------------------------------------------------------------*/

#include "ff_mpflow.h"
#include "datatrans.h"

void calc_temp(BB_struct *bp){

	int i,j,k;
	
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w, ***ca_cell_t;
	int ***cflag;
	CA_FLOAT ***ca_cell_dfs;
	CA_FLOAT ***tempt;
//	CA_FLOAT ***ca_cell_fl, ***ca_cell_flold;
	CA_FLOAT ***ca_cell_ftry;
	CA_FLOAT laplt, dutfdx, dvtfdy, dwtfdz;
	CA_FLOAT sizex, sizey, sizez, rev_dx2, rev_dy2, rev_dz2;
	CA_FLOAT delttime;
	CA_FLOAT therm_dif, therm_coe,latentsrc;
	CA_FLOAT dtl, dtr, dtf, dtb, dtu, dtd;
	CA_FLOAT sgu, sgv, sgw;
	CA_FLOAT dtdx, dtdy, dtdz;
        int IMAX, JMAX, KMAX;

        IMAX = bp->tnc[0];
        JMAX = bp->tnc[1];
        KMAX = bp->tnc[2];

	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	ca_cell_t = bp->ca_cell_t;
	cflag = bp->cflag;

//	ca_cell_fl = bp->ca_cell_fl;
//	ca_cell_flold = bp->ca_cell_flold;
	ca_cell_ftry = bp->ca_cell_ftry;
	ca_cell_dfs = bp->ca_cell_dfs;

	tempt = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	delttime = bp->delt;
	therm_dif = bp->mprops.thermcond/(bp->mprops.rhocp);
//	therm_dif = 2.13e-5;
	therm_coe = bp->mprops.latentH/bp->mprops.cp/bp->ncsb;
	latentsrc = 0;

	rev_dx2 = 1.0/sizex/sizex;
	rev_dy2 = 1.0/sizey/sizey;
	rev_dz2 = 1.0/sizez/sizez;

	dutfdx = dvtfdy = dwtfdz = 0.0;

	vectorin(ca_cell_dfs, bp->sb[0]->c_dfs, 1, IMAX, 1, JMAX, 1, KMAX );
	

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL)
	      {
										
		laplt = rev_dx2*(ca_cell_t[i+1][j][k]+ca_cell_t[i-1][j][k]-2.0*ca_cell_t[i][j][k]) +
		rev_dy2*(ca_cell_t[i][j+1][k]+ca_cell_t[i][j-1][k]-2.0*ca_cell_t[i][j][k]) +
		rev_dz2*(ca_cell_t[i][j][k+1]+ca_cell_t[i][j][k-1]-2.0*ca_cell_t[i][j][k]);

		
/*		dutfdx = ((ca_cell_u[i][j][k]*(ca_cell_t[i][j][k]+ca_cell_t[i+1][j][k])*(ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k]) - ca_cell_u[i-1][j][k]*(ca_cell_t[i-1][j][k]+ca_cell_t[i][j][k])*(ca_cell_ftry[i-1][j][k]+ca_cell_ftry[i][j][k])) + GAMMA*(fabs(ca_cell_u[i][j][k])*(ca_cell_t[i][j][k]-ca_cell_t[i+1][j][k])*(ca_cell_ftry[i][j][k]-ca_cell_ftry[i+1][j][k]) - fabs(ca_cell_u[i-1][j][k])*(ca_cell_t[i-1][j][k]-ca_cell_t[i][j][k])*(ca_cell_ftry[i-1][j][k]-ca_cell_ftry[i][j][k])))/sizex/4;
		dvtfdy = ((ca_cell_v[i][j][k]*(ca_cell_t[i][j][k]+ca_cell_t[i][j+1][k])*(ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k]) - ca_cell_v[i][j-1][k]*(ca_cell_t[i][j-1][k]+ca_cell_t[i][j][k])*(ca_cell_ftry[i][j-1][k]+ca_cell_ftry[i][j][k])) + GAMMA*(fabs(ca_cell_v[i][j][k])*(ca_cell_t[i][j][k]-ca_cell_t[i][j+1][k])*(ca_cell_ftry[i][j][k]-ca_cell_ftry[i][j+1][k]) - fabs(ca_cell_v[i][j-1][k])*(ca_cell_t[i][j-1][k]-ca_cell_t[i][j][k])*(ca_cell_ftry[i][j-1][k]-ca_cell_ftry[i][j][k])))/sizey/4;
		dwtfdz = ((ca_cell_w[i][j][k]*(ca_cell_t[i][j][k]+ca_cell_t[i][j][k+1]) *(ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])- ca_cell_w[i][j][k-1]*(ca_cell_t[i][j][k-1]+ca_cell_t[i][j][k])*(ca_cell_ftry[i][j][k-1]+ca_cell_ftry[i][j][k])) + GAMMA*(fabs(ca_cell_w[i][j][k])*(ca_cell_t[i][j][k]-ca_cell_t[i][j][k+1]) *(ca_cell_ftry[i][j][k]-ca_cell_ftry[i][j][k+1])- fabs(ca_cell_w[i][j][k-1])*(ca_cell_t[i][j][k-1]-ca_cell_t[i][j][k])*(ca_cell_ftry[i][j][k-1]-ca_cell_ftry[i][j][k])))/sizez/4;
		
		dutfdx = ((ca_cell_u[i][j][k]*(ca_cell_t[i][j][k]+ca_cell_t[i+1][j][k])- ca_cell_u[i-1][j][k]*(ca_cell_t[i-1][j][k]+ca_cell_t[i][j][k])) + GAMMA*(fabs(ca_cell_u[i][j][k])*(ca_cell_t[i][j][k]-ca_cell_t[i+1][j][k]) - fabs(ca_cell_u[i-1][j][k])*(ca_cell_t[i-1][j][k]-ca_cell_t[i][j][k])))/sizex/2;
		dvtfdy = ((ca_cell_v[i][j][k]*(ca_cell_t[i][j][k]+ca_cell_t[i][j+1][k]) - ca_cell_v[i][j-1][k]*(ca_cell_t[i][j-1][k]+ca_cell_t[i][j][k])) + GAMMA*(fabs(ca_cell_v[i][j][k])*(ca_cell_t[i][j][k]-ca_cell_t[i][j+1][k]) - fabs(ca_cell_v[i][j-1][k])*(ca_cell_t[i][j-1][k]-ca_cell_t[i][j][k])))/sizey/2;
		dwtfdz = ((ca_cell_w[i][j][k]*(ca_cell_t[i][j][k]+ca_cell_t[i][j][k+1]) - ca_cell_w[i][j][k-1]*(ca_cell_t[i][j][k-1]+ca_cell_t[i][j][k])) + GAMMA*(fabs(ca_cell_w[i][j][k])*(ca_cell_t[i][j][k]-ca_cell_t[i][j][k+1]) - fabs(ca_cell_w[i][j][k-1])*(ca_cell_t[i][j][k-1]-ca_cell_t[i][j][k])))/sizez/2;
		
*/
		dtl = (ca_cell_t[i][j][k]-ca_cell_t[i-1][j][k])/sizex;
		dtr = (ca_cell_t[i+1][j][k]-ca_cell_t[i][j][k])/sizex;
		sgu = (ca_cell_u[i][j][k] >=0 ? 1.0 : -1.0);
		dtdx = (dtl+dtr+GAMMA*sgu*(dtl-dtr))/2;

		dtf = (ca_cell_t[i][j+1][k]-ca_cell_t[i][j][k])/sizey;
		dtb = (ca_cell_t[i][j][k]-ca_cell_t[i][j-1][k])/sizey;
		sgv = (ca_cell_v[i][j][k]>=0 ? 1.0 : -1.0);
		dtdy = (dtf+dtb+GAMMA*sgv*(dtb-dtf))/2;

		dtu = (ca_cell_t[i][j][k+1]-ca_cell_t[i][j][k])/sizez;
		dtd = (ca_cell_t[i][j][k]-ca_cell_t[i][j][k-1])/sizez;
		sgw = (ca_cell_w[i][j][k] >= 0 ? 1.0 :-1.0);
		dtdz = (dtu+dtd+GAMMA*sgw*(dtd-dtu))/2;
/*
		dutfdx = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])*ca_cell_u[i][j][k]*dtdx/2;
		dvtfdy = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])*ca_cell_v[i][j][k]*dtdy/2;
		dwtfdz = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])*ca_cell_w[i][j][k]*dtdz/2;
*/		
		dutfdx = ca_cell_u[i][j][k]*dtdx/2;
		dvtfdy = ca_cell_v[i][j][k]*dtdy/2;
		dwtfdz = ca_cell_w[i][j][k]*dtdz/2;
						
		latentsrc = therm_coe * ca_cell_dfs[i][j][k];
//		latentsrc = 0;
				
//		tempt[i][j][k] = ca_cell_t[i][j][k]+delttime*(therm_dif*laplt-dutfdx-dvtfdy-dwtfdz)-therm_coe*(ca_cell_fl[i][j][k]-ca_cell_flold[i][j][k]);
		tempt[i][j][k] = ca_cell_t[i][j][k]+delttime*(therm_dif*laplt-dutfdx-dvtfdy-dwtfdz) + latentsrc;
		
		if(latentsrc > 0 && tempt[i][j][k] > bp->mprops.Tliq) tempt[i][j][k] = bp->mprops.Tliq;
	      }
	    }
	  }
	}

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
		if (cflag[i][j][k] == FFCELL){
		  ca_cell_t[i][j][k] = tempt[i][j][k];
				
		}
	    }
	  }
	}
	

	freerealmem(tempt, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	
}

CA_FLOAT HtoT(BB_struct *bp, CA_FLOAT enthalpy, CA_FLOAT liq_f){
				
  if (enthalpy < bp->H_S) return enthalpy/bp->mprops.cp;
  if (enthalpy > bp->H_L) return (enthalpy - bp->mprops.latentH)/bp->mprops.cp;
  return (enthalpy - liq_f*bp->mprops.latentH)/bp->mprops.cp;

}

void calc_temp_enthalpy(BB_struct *bp){

	int i,j,k;
			
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w, ***ca_cell_t;
	CA_FLOAT ***ca_cell_h;
	int ***cflag;
	CA_FLOAT ***temph;
	CA_FLOAT ***ca_cell_ftry;
	CA_FLOAT laplt, duhfdx, dvhfdy, dwhfdz;
	CA_FLOAT sizex, sizey, sizez, rev_dx2, rev_dy2, rev_dz2;
	CA_FLOAT delttime;
											CA_FLOAT therm_dif;
	CA_FLOAT dhl, dhr, dhf, dhb, dhu, dhd;
	CA_FLOAT sgu, sgv, sgw;
	CA_FLOAT dhdx, dhdy, dhdz;
	int IMAX, JMAX, KMAX;
	
	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	
	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	ca_cell_t = bp->ca_cell_t;
	ca_cell_h = bp->ca_cell_h;
	cflag = bp->cflag;
	ca_cell_ftry = bp->ca_cell_ftry;
	
	temph = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	delttime = bp->delt;
			
	therm_dif = bp->mprops.thermcond/bp->mprops.rho;

	rev_dx2 = 1.0/sizex/sizex;
	rev_dy2 = 1.0/sizey/sizey;
	rev_dz2 = 1.0/sizez/sizez;
	duhfdx = dvhfdy = dwhfdz = 0.0;
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL)
	      {
		laplt = rev_dx2*(ca_cell_t[i+1][j][k]+ca_cell_t[i-1][j][k]-2.0*ca_cell_t[i][j][k]) + rev_dy2*(ca_cell_t[i][j+1][k]+ca_cell_t[i][j-1][k]-2.0*ca_cell_t[i][j][k]) + rev_dz2*(ca_cell_t[i][j][k+1]+ca_cell_t[i][j][k-1]-2.0*ca_cell_t[i][j][k]);

		dhl = (ca_cell_h[i][j][k]-ca_cell_h[i-1][j][k])/sizex;
		dhr = (ca_cell_h[i+1][j][k]-ca_cell_h[i][j][k])/sizex;
		sgu = (ca_cell_u[i][j][k] >=0 ? 1.0 : -1.0);
		dhdx = (dhl+dhr+GAMMA*sgu*(dhl-dhr))/2;
		
		dhf = (ca_cell_h[i][j+1][k]-ca_cell_h[i][j][k])/sizey;
		dhb = (ca_cell_h[i][j][k]-ca_cell_h[i][j-1][k])/sizey;
		sgv = (ca_cell_v[i][j][k]>=0 ? 1.0 : -1.0);
		dhdy = (dhf+dhb+GAMMA*sgv*(dhb-dhf))/2;

		dhu = (ca_cell_h[i][j][k+1]-ca_cell_h[i][j][k])/sizez;
		dhd = (ca_cell_h[i][j][k]-ca_cell_h[i][j][k-1])/sizez;
		sgw = (ca_cell_w[i][j][k] >= 0 ? 1.0 :-1.0);
		dhdz = (dhu+dhd+GAMMA*sgw*(dhd-dhu))/2;
		
		duhfdx = ca_cell_u[i][j][k]*dhdx;
		dvhfdy = ca_cell_v[i][j][k]*dhdy;
		dwhfdz = ca_cell_w[i][j][k]*dhdz;
		
		temph[i][j][k] = ca_cell_h[i][j][k]+delttime*(therm_dif*laplt-duhfdx-dvhfdy-dwhfdz);
	        }		
	      }
	    }
	  }

								
											
	  for (i=1; i<=IMAX; i++){
	    for (j=1; j<=JMAX; j++){
	      for (k=1; k<=KMAX; k++){
		if (cflag[i][j][k] == FFCELL)	 ca_cell_h[i][j][k] = temph[i][j][k];
		ca_cell_t[i][j][k] = (ca_cell_h[i][j][k] - ca_cell_ftry[i][j][k]*bp->mprops.latentH)/bp->mprops.cp;
		//HtoT(bp, ca_cell_h[i][j][k],ca_cell_ftry[i][j][k]);
	      }
	    }
	  }

         freerealmem(temph, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

}


