/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008      
			Computation of tentative velocity field (F,G,H)
*/
/*----------------------------------------------------------------------*/

#include "ff_mpflow.h"



void calc_fgh(BB_struct *bp){

	int i,j,k;
	
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w, ***ca_cell_p;
	int ***cflag;
//	CA_FLOAT ***ca_cell_fl;
	CA_FLOAT ***ca_cell_t;
	CA_FLOAT ***cell_f, ***cell_g, ***cell_h;
	CA_FLOAT ***ca_cell_ftry, ***ca_cell_ce;
	CA_FLOAT tempftry;

	CA_FLOAT sizex,sizey,sizez;
	CA_FLOAT delttime;
	CA_FLOAT m_density, m_viscosity, dy_visc;

//	CA_FLOAT ***dfdx, ***dfdy, ***dfdz, ***laplf;

	CA_FLOAT laplu, laplv, laplw;
	CA_FLOAT dul, dur, duf, dub, duu, dud;
	CA_FLOAT dudx, dudy, dudz;
	CA_FLOAT du2dx, duvdy, duwdz;	
	CA_FLOAT dvl, dvr, dvf, dvb, dvu, dvd;
	CA_FLOAT dvdx, dvdy, dvdz;
	CA_FLOAT duvdx, dv2dy, dvwdz;
	CA_FLOAT dwl, dwr, dwf, dwb, dwu, dwd;
	CA_FLOAT dwdx, dwdy, dwdz;
	CA_FLOAT duwdx, dvwdy, dw2dz;
	CA_FLOAT uvx,uwx,vuy,vwy,wuz,wvz;

	CA_FLOAT dfl, dfr, dff, dfb, dfu, dfd;

	CA_FLOAT sgu, sgv, sgw;

	CA_FLOAT conv_term_x, diff_term_x, source_term_x;
	CA_FLOAT conv_term_y, diff_term_y, source_term_y;
	CA_FLOAT conv_term_z, diff_term_z, source_term_z;
	CA_FLOAT carcoz_x, carcoz_y, carcoz_z;   //Carman-Cozeny 
	CA_FLOAT delpx, delpy, delpz;
	int IMAX, JMAX, KMAX;
	CA_FLOAT TEMP_REF, ref_c;
	CA_FLOAT GX,GY,GZ;	
	CA_FLOAT CCCONST;
	CA_FLOAT BETA, BETA_C;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	GX = bp->mprops.gravity_x;
	GY = bp->mprops.gravity_y;
	GZ = bp->mprops.gravity_z;
	CCCONST = bp->mprops.CCconst;
	TEMP_REF = bp->mprops.ref_T;
	BETA = bp->mprops.beta_T;
	BETA_C = bp->mprops.beta_c;
	ref_c = bp->mprops.ref_c;
	
	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	ca_cell_p = bp->ca_cell_p;
	cflag = bp->cflag;

//	ca_cell_fl = bp->ca_cell_fl;
	ca_cell_t = bp->ca_cell_t;
	ca_cell_ftry = bp->ca_cell_ftry;
	ca_cell_ce = bp->ca_cell_ce;
		
	cell_f = bp->cell_f;
	cell_g = bp->cell_g;
	cell_h = bp->cell_h;

	/* constant values */
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	delttime = bp->delt;
	m_density = bp->mprops.rho;
	m_viscosity = bp->mprops.viscosity;

	carcoz_x = carcoz_y = carcoz_z = 0.0;
	tempftry = 1.0;

	dy_visc = m_viscosity/m_density;

/*-----  derivatives of liquid fraction ---allocation --- temporary use ---- */
/*
	dfdx = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	dfdy = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	dfdz = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	laplf = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
   	      if (cflag[i][j][k] == FFCELL){
 		dfl = (ca_cell_fl[i][j][k]-ca_cell_fl[i-1][j][k])/sizex;
		dfr = (ca_cell_fl[i+1][j][k]-ca_cell_fl[i][j][k])/sizex;
		sgu = (ca_cell_u[i][j][k] >=0 ? 1.0 : -1.0);
		dfdx[i][j][k] = (dfl+dfr+GAMMA*sgu*(dfl-dfr))/2;
				
		dff = (ca_cell_fl[i][j+1][k]-ca_cell_fl[i][j][k])/sizey;
		dfb = (ca_cell_fl[i][j][k]-ca_cell_fl[i][j-1][k])/sizey;
		sgv = (ca_cell_v[i][j][k]>=0 ? 1.0 : -1.0);
		dfdy[i][j][k] = (dff+dfb+GAMMA*sgv*(dfb-dff))/2;
				
		dfu = (ca_cell_fl[i][j][k+1]-ca_cell_fl[i][j][k])/sizez;
		dfd = (ca_cell_fl[i][j][k]-ca_cell_fl[i][j][k-1])/sizez;
		sgw = (ca_cell_w[i][j][k] >= 0 ? 1.0 :-1.0);
		dfdz[i][j][k] = (dfu+dfd+GAMMA*sgw*(dfd-dfu))/2;

	//	dfdx[i][j][k] = (ca_cell_fl[i+1][j][k] - ca_cell_fl[i][j][k])/sizex;
	//	dfdy[i][j][k] = (ca_cell_fl[i][j+1][k] - ca_cell_fl[i][j][k])/sizey;
	//	dfdz[i][j][k] = (ca_cell_fl[i][j][k+1] - ca_cell_fl[i][j][k])/sizez;
				
		laplf[i][j][k] = (ca_cell_fl[i+1][j][k] - 2.0 * ca_cell_fl[i][j][k] + ca_cell_fl[i-1][j][k])/sizex/sizex + (ca_cell_fl[i][j+1][k] - 2.0 * ca_cell_fl[i][j][k] + ca_cell_fl[i][j-1][k])/sizey/sizey +(ca_cell_fl[i][j][k+1] - 2.0 * ca_cell_fl[i][j][k] + ca_cell_fl[i][j][k-1])/sizez/sizez;
  	      }
	    } // end of k loop
	  } // end of j loop
	} // end of i loop
*/
/*--------------------------------------------------------------------------*/

/*-------------  F -------------*/

	for (i=1; i<=IMAX-1; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i+1][j][k] == FFCELL ){
/*		dul = (ca_cell_u[i][j][k]-ca_cell_u[i-1][j][k])/sizex;
		dur = (ca_cell_u[i+1][j][k]-ca_cell_u[i][j][k])/sizex;
		sgu = (ca_cell_u[i][j][k] >=0 ? 1.0 : -1.0);
		dudx = (dul+dur+GAMMA*sgu*(dul-dur))/2;
		
		duf = (ca_cell_u[i][j+1][k]-ca_cell_u[i][j][k])/sizey;
		dub = (ca_cell_u[i][j][k]-ca_cell_u[i][j-1][k])/sizey;
		uvx = (ca_cell_v[i][j][k]+ca_cell_v[i+1][j][k]+ca_cell_v[i+1][j-1][k]+ca_cell_v[i][j-1][k])/4;
		sgv = (uvx>=0 ? 1.0 : -1.0);
		dudy = (duf+dub+GAMMA*sgv*(dub-duf))/2;

		duu = (ca_cell_u[i][j][k+1]-ca_cell_u[i][j][k])/sizez;
		dud = (ca_cell_u[i][j][k]-ca_cell_u[i][j][k-1])/sizez;
		uwx = (ca_cell_w[i][j][k-1]+ca_cell_w[i+1][j][k-1]+ca_cell_w[i][j][k]+ca_cell_w[i+1][j][k])/4;
		sgw = (uwx>=0? 1.0 :-1.0);
		dudz = (duu+dud+GAMMA*sgw*(dud-duu))/2;
*/
		laplu = (ca_cell_u[i+1][j][k] - 2.0 * ca_cell_u[i][j][k] + ca_cell_u[i-1][j][k])/sizex/sizex + 
			(ca_cell_u[i][j+1][k] - 2.0 * ca_cell_u[i][j][k] + ca_cell_u[i][j-1][k])/sizey/sizey +
			(ca_cell_u[i][j][k+1] - 2.0 * ca_cell_u[i][j][k] + ca_cell_u[i][j][k-1])/sizez/sizez;

		du2dx = (((ca_cell_u[i][j][k] + ca_cell_u[i+1][j][k])*(ca_cell_u[i][j][k] + ca_cell_u[i+1][j][k])-(ca_cell_u[i-1][j][k] + ca_cell_u[i][j][k])*(ca_cell_u[i-1][j][k] + ca_cell_u[i][j][k])) + GAMMA*(fabs((ca_cell_u[i][j][k] + ca_cell_u[i+1][j][k])) * (ca_cell_u[i][j][k] - ca_cell_u[i+1][j][k]) - fabs((ca_cell_u[i-1][j][k] + ca_cell_u[i][j][k])) * (ca_cell_u[i-1][j][k] - ca_cell_u[i][j][k])))/sizex/4;
				
		duvdy = (((ca_cell_v[i][j][k] + ca_cell_v[i+1][j][k])*(ca_cell_u[i][j][k] + ca_cell_u[i][j+1][k]) - (ca_cell_v[i][j-1][k] + ca_cell_v[i+1][j-1][k])*(ca_cell_u[i][j][k] + ca_cell_u[i][j-1][k])) +GAMMA*(fabs((ca_cell_v[i][j][k] + ca_cell_v[i+1][j][k])) * (ca_cell_u[i][j][k] - ca_cell_u[i][j+1][k]) - fabs((ca_cell_v[i][j-1][k] + ca_cell_v[i+1][j-1][k])) * (ca_cell_u[i][j-1][k] - ca_cell_u[i][j][k])))/sizey/4;

		duwdz = (((ca_cell_w[i][j][k] + ca_cell_w[i+1][j][k])*(ca_cell_u[i][j][k] + ca_cell_u[i][j][k+1]) - (ca_cell_w[i][j][k-1] + ca_cell_w[i+1][j][k-1])*(ca_cell_u[i][j][k] + ca_cell_u[i][j][k-1])) +GAMMA*(fabs((ca_cell_w[i][j][k] + ca_cell_w[i+1][j][k])) * (ca_cell_u[i][j][k] - ca_cell_u[i][j][k+1]) - fabs((ca_cell_w[i][j][k-1] + ca_cell_w[i+1][j][k-1])) * (ca_cell_u[i][j][k-1] - ca_cell_u[i][j][k])))/sizez/4;
				
/*		diff_term_x = ca_cell_fl[i][j][k]*laplu+ca_cell_u[i][j][k]*laplf[i][j][k]+2*(dfdx[i][j][k]*dudx+dfdy[i][j][k]*dudy+dfdz[i][j][k]*dudz);
		conv_term_x = ca_cell_fl[i][j][k]*(du2dx+duvdy+duwdz) + ca_cell_u[i][j][k]*ca_cell_u[i][j][k]*dfdx[i][j][k] + 	ca_cell_u[i][j][k]*ca_cell_v[i][j][k]*dfdy[i][j][k] + ca_cell_u[i][j][k]*ca_cell_w[i][j][k]*dfdz[i][j][k];
*/		
		diff_term_x = laplu;
		conv_term_x = du2dx+duvdy+duwdz;
		source_term_x = 0.0;
		if(ca_cell_ftry[i][j][k] > 0.9) 
		  source_term_x = (BETA*((ca_cell_t[i][j][k]+ca_cell_t[i+1][j][k])/2-TEMP_REF)+BETA_C*((ca_cell_ce[i][j][k]+ca_cell_ce[i+1][j][k])/2-ref_c))*GX;  //Buoyancy force

//		source_term_x = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i+1][j][k])/2-TEMP_REF))*GX;
				
		tempftry = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])/2;
	//	tempftry = ca_cell_ftry[i][j][k];
		
//		carcoz_x = CCCONST * (1- tempftry) * (1- tempftry) / (tempftry*tempftry*tempftry+0.001)/m_density ;

		delpx = 0.0;
//		delpx = (ca_cell_p[i+1][j][k]-ca_cell_p[i][j][k])/sizex;

/*		conv_term_x = ca_cell_fl[i][j][k]*(du2dx+duvdy+duwdz) + ca_cell_u[i][j][k]*ca_cell_u[i][j][k]*dfdx[i][j][k] + 
			ca_cell_u[i][j][k]*uvx*dfdy[i][j][k] + ca_cell_u[i][j][k]*uwx*dfdz[i][j][k];
*/			  // different way of trying u v and w

//		cell_f[i][j][k] = ca_cell_fl[i][j][k] * ca_cell_u[i][j][k] + delttime * (dy_visc*diff_term_x - conv_term_x + source_term_x - carcoz_x * ca_cell_u[i][j][k] - delpx);
//		cell_f[i][j][k] = (ca_cell_fl[i][j][k] * ca_cell_u[i][j][k] + delttime * (dy_visc*diff_term_x - conv_term_x + source_term_x - delpx - carcoz_x*ca_cell_u[i][j][k]/2))/(1+carcoz_x*delttime/2);  //- carcoz_x*ca_cell_u[i][j][k]/2
		cell_f[i][j][k] =  (ca_cell_u[i][j][k] + delttime * (dy_visc*diff_term_x - conv_term_x + source_term_x - delpx - carcoz_x*ca_cell_u[i][j][k]/2))/(1+carcoz_x*delttime/2);
		cell_f[i][j][k] = cell_f[i][j][k]*tempftry;
	      }
	      else {
//		cell_f[i][j][k] = ca_cell_fl[i][j][k] * ca_cell_u[i][j][k];
		cell_f[i][j][k] = ca_cell_u[i][j][k] * (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])/2;
  	      }

	    } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/


/*-------------  G -------------*/

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX-1; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j+1][k] == FFCELL ){
/*		dvl = (ca_cell_v[i][j][k]-ca_cell_v[i-1][j][k])/sizex;
		dvr = (ca_cell_v[i+1][j][k]-ca_cell_v[i][j][k])/sizex;
		vuy = (ca_cell_u[i][j][k]+ca_cell_u[i-1][j][k]+ca_cell_u[i-1][j+1][k]+ca_cell_u[i][j+1][k])/4;
		sgu = (vuy >=0 ? 1.0 : -1.0);
		dvdx = (dvl+dvr+GAMMA*sgu*(dvl-dvr))/2;

		dvf = (ca_cell_v[i][j+1][k]-ca_cell_v[i][j][k])/sizey;
		dvb = (ca_cell_v[i][j][k]-ca_cell_v[i][j-1][k])/sizey;
		sgv = (ca_cell_v[i][j][k]>=0 ? 1.0 : -1.0);
		dvdy = (dvf+dvb+GAMMA*sgv*(dvb-dvf))/2;

		dvu = (ca_cell_v[i][j][k+1]-ca_cell_v[i][j][k])/sizez;
		dvd = (ca_cell_v[i][j][k]-ca_cell_v[i][j][k-1])/sizez;
		vwy = (ca_cell_w[i][j][k-1]+ca_cell_w[i][j+1][k-1]+ca_cell_w[i][j][k]+ca_cell_w[i][j+1][k])/4;
		sgw = (vwy >=0 ? 1.0 :-1.0);
		dvdz = (dvu+dvd+GAMMA*sgw*(dvd-dvu))/2;
*/
		laplv = (ca_cell_v[i+1][j][k] - 2.0 * ca_cell_v[i][j][k] + ca_cell_v[i-1][j][k])/sizex/sizex + 
			(ca_cell_v[i][j+1][k] - 2.0 * ca_cell_v[i][j][k] + ca_cell_v[i][j-1][k])/sizey/sizey +
			(ca_cell_v[i][j][k+1] - 2.0 * ca_cell_v[i][j][k] + ca_cell_v[i][j][k-1])/sizez/sizez;

		duvdx = (((ca_cell_u[i][j][k] + ca_cell_u[i][j+1][k])*(ca_cell_v[i][j][k] + ca_cell_v[i+1][j][k]) - (ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j+1][k])*(ca_cell_v[i-1][j][k] + ca_cell_v[i][j][k])) + GAMMA*(fabs((ca_cell_u[i][j][k] + ca_cell_u[i][j+1][k])) * (ca_cell_v[i][j][k] - ca_cell_v[i+1][j][k]) - fabs((ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j+1][k])) * (ca_cell_v[i-1][j][k] - ca_cell_v[i][j][k])))/sizex/4;
				
		dv2dy = (((ca_cell_v[i][j][k] + ca_cell_v[i][j+1][k])*(ca_cell_v[i][j][k] + ca_cell_v[i][j+1][k]) - (ca_cell_v[i][j-1][k] + ca_cell_v[i][j][k])*(ca_cell_v[i][j][k] + ca_cell_v[i][j-1][k])) +	GAMMA*(fabs((ca_cell_v[i][j][k] + ca_cell_v[i][j+1][k])) * (ca_cell_v[i][j][k] - ca_cell_v[i][j+1][k]) -fabs((ca_cell_v[i][j-1][k] + ca_cell_v[i][j][k])) * (ca_cell_v[i][j-1][k] - ca_cell_v[i][j][k])))/sizey/4;

		dvwdz = (((ca_cell_w[i][j][k] + ca_cell_w[i][j+1][k])*(ca_cell_v[i][j][k] + ca_cell_v[i][j][k+1]) - (ca_cell_w[i][j][k-1] + ca_cell_w[i][j+1][k-1])*(ca_cell_v[i][j][k] + ca_cell_v[i][j][k-1])) +GAMMA*(fabs((ca_cell_w[i][j][k] + ca_cell_w[i][j+1][k])) * (ca_cell_v[i][j][k] - ca_cell_v[i][j][k+1]) - fabs((ca_cell_w[i][j][k-1] + ca_cell_w[i][j+1][k-1])) * (ca_cell_v[i][j][k-1] - ca_cell_v[i][j][k])))/sizez/4;
				
/*		diff_term_y = ca_cell_fl[i][j][k]*laplv+ca_cell_v[i][j][k]*laplf[i][j][k]+2*(dfdx[i][j][k]*dvdx+dfdy[i][j][k]*dvdy+dfdz[i][j][k]*dvdz);
		conv_term_y = ca_cell_fl[i][j][k]*(duvdx+dv2dy+dvwdz) + ca_cell_u[i][j][k]*ca_cell_v[i][j][k]*dfdx[i][j][k] + ca_cell_v[i][j][k]*ca_cell_v[i][j][k]*dfdy[i][j][k] + ca_cell_v[i][j][k]*ca_cell_w[i][j][k]*dfdz[i][j][k];
*/		
		diff_term_y = laplv;
		conv_term_y = duvdx+dv2dy+dvwdz;
		source_term_y = 0.0;
		if(ca_cell_ftry[i][j][k] > 0.9) 
		  source_term_y = (BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j+1][k])/2-TEMP_REF)+BETA_C*((ca_cell_ce[i][j][k]+ca_cell_ce[i][j+1][k])/2-ref_c))*GY;   //Buoyancy force
			
//		source_term_y = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j+1][k])/2-TEMP_REF))*GY;
	    	tempftry = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2;
//		tempftry = ca_cell_ftry[i][j][k];
	
//		carcoz_y = CCCONST * (1- tempftry) * (1- tempftry) / (tempftry*tempftry*tempftry+0.001)/m_density ;
		
		delpy = 0.0;
//		delpy = (ca_cell_p[i][j+1][k]-ca_cell_p[i][j][k])/sizey;
				
/*		conv_term_y = ca_cell_fl[i][j][k]*(duvdx+dv2dy+dvwdz) + vuy*ca_cell_v[i][j][k]*dfdx[i][j][k] + 
			ca_cell_v[i][j][k]*ca_cell_v[i][j][k]*dfdy[i][j][k] + ca_cell_v[i][j][k]*vwy*dfdz[i][j][k];
*/		  // different way of trying u v and w

//		cell_g[i][j][k] = ca_cell_fl[i][j][k] * ca_cell_v[i][j][k] + delttime * (dy_visc*diff_term_y - conv_term_y + source_term_y - carcoz_y * ca_cell_v[i][j][k]- delpy);
//		cell_g[i][j][k] = (ca_cell_fl[i][j][k] * ca_cell_v[i][j][k] + delttime * (dy_visc*diff_term_y - conv_term_y + source_term_y - delpy - carcoz_y*ca_cell_v[i][j][k]/2))/(1+carcoz_y*delttime/2);	//- carcoz_y*ca_cell_v[i][j][k]/2		  
		cell_g[i][j][k] = ( ca_cell_v[i][j][k] + delttime * (dy_visc*diff_term_y - conv_term_y + source_term_y - delpy - carcoz_y*ca_cell_v[i][j][k]/2))/(1+carcoz_y*delttime/2);
		cell_g[i][j][k] = cell_g[i][j][k] * tempftry ; 
	      }
	      else{
//		cell_g[i][j][k] = ca_cell_fl[i][j][k] * ca_cell_v[i][j][k];
		cell_g[i][j][k] = ca_cell_v[i][j][k] * (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2;
	      }
				
	    } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/


/*-------------  H -------------*/

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX-1; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j][k+1] == FFCELL){
/*
		dwl = (ca_cell_w[i][j][k]-ca_cell_w[i-1][j][k])/sizex;
		dwr = (ca_cell_w[i+1][j][k]-ca_cell_w[i][j][k])/sizex;
		wuz = (ca_cell_u[i][j][k]+ca_cell_u[i-1][j][k]+ca_cell_u[i-1][j][k+1]+ca_cell_u[i][j][k+1])/4;
		sgu = (wuz >=0 ? 1.0 : -1.0);
		dwdx = (dwl+dwr+GAMMA*sgu*(dwl-dwr))/2;

		dwf = (ca_cell_w[i][j+1][k]-ca_cell_w[i][j][k])/sizey;
		dwb = (ca_cell_w[i][j][k]-ca_cell_w[i][j-1][k])/sizey;
		wvz = (ca_cell_v[i][j][k]+ca_cell_v[i][j-1][k]+ca_cell_v[i][j-1][k+1]+ca_cell_v[i][j-1][k+1])/4;
		sgv = (wvz>=0 ? 1.0 : -1.0);
		dwdy = (dwf+dwb+GAMMA*sgv*(dwb-dwf))/2;

		dwu = (ca_cell_w[i][j][k+1]-ca_cell_w[i][j][k])/sizez;
		dwd = (ca_cell_w[i][j][k]-ca_cell_w[i][j][k-1])/sizez;
		sgw = (ca_cell_w[i][j][k] >= 0 ? 1.0 :-1.0);
		dwdz = (dwu+dwd+GAMMA*sgw*(dwd-dwu))/2;
*/
		laplw = (ca_cell_w[i+1][j][k] - 2.0 * ca_cell_w[i][j][k] + ca_cell_w[i-1][j][k])/sizex/sizex + 
			(ca_cell_w[i][j+1][k] - 2.0 * ca_cell_w[i][j][k] + ca_cell_w[i][j-1][k])/sizey/sizey +
			(ca_cell_w[i][j][k+1] - 2.0 * ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])/sizez/sizez;

		duwdx = (((ca_cell_u[i][j][k] + ca_cell_u[i][j][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i+1][j][k]) - (ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j][k+1])*(ca_cell_w[i-1][j][k] + ca_cell_w[i][j][k])) +GAMMA*(fabs((ca_cell_u[i][j][k] + ca_cell_u[i][j][k+1])) * (ca_cell_w[i][j][k] - ca_cell_w[i+1][j][k]) -fabs((ca_cell_u[i-1][j][k] + ca_cell_u[i-1][j][k+1])) * (ca_cell_w[i-1][j][k] - ca_cell_w[i][j][k])))/sizex/4;
				
		dvwdy = (((ca_cell_v[i][j][k] + ca_cell_v[i][j][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j+1][k]) - (ca_cell_v[i][j-1][k] + ca_cell_v[i][j-1][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j-1][k])) +GAMMA*(fabs((ca_cell_v[i][j][k] + ca_cell_v[i][j][k+1])) * (ca_cell_w[i][j][k] - ca_cell_w[i][j+1][k]) -fabs((ca_cell_v[i][j-1][k] + ca_cell_v[i][j-1][k+1])) * (ca_cell_w[i][j-1][k] - ca_cell_w[i][j][k])))/sizey/4;

		dw2dz = (((ca_cell_w[i][j][k] + ca_cell_w[i][j][k+1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j][k+1]) - (ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])*(ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])) +GAMMA*(fabs((ca_cell_w[i][j][k] + ca_cell_w[i][j][k+1])) * (ca_cell_w[i][j][k] - ca_cell_w[i][j][k+1]) -fabs((ca_cell_w[i][j][k] + ca_cell_w[i][j][k-1])) * (ca_cell_w[i][j][k-1] - ca_cell_w[i][j][k])))/sizez/4;
				
//		diff_term_z = ca_cell_fl[i][j][k]*laplw+ca_cell_w[i][j][k]*laplf[i][j][k]+2*(dfdx[i][j][k]*dwdx+dfdy[i][j][k]*dwdy+dfdz[i][j][k]*dwdz);
//		conv_term_z = ca_cell_fl[i][j][k]*(duwdx+dvwdy+dw2dz) + ca_cell_u[i][j][k]*ca_cell_w[i][j][k]*dfdx[i][j][k] + ca_cell_v[i][j][k]*ca_cell_w[i][j][k]*dfdy[i][j][k] + ca_cell_w[i][j][k]*ca_cell_w[i][j][k]*dfdz[i][j][k];
		diff_term_z = laplw;
		conv_term_z = duwdx+dvwdy+dw2dz ;
		source_term_z = 0.0;
		if(ca_cell_ftry[i][j][k] > 0.9) 
		  source_term_z = (BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j][k+1])/2-TEMP_REF)+BETA_C*((ca_cell_ce[i][j][k]+ca_cell_ce[i][j][k+1])/2-ref_c))*GZ;    //Buoyancy force
	
//		source_term_z = (1-BETA*((ca_cell_t[i][j][k]+ca_cell_t[i][j][k+1])/2-TEMP_REF))*GZ; 
				
		tempftry = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2;
//		tempftry = ca_cell_ftry[i][j][k];
//		carcoz_z = CCCONST * (1- tempftry) * (1- tempftry) / (tempftry*tempftry*tempftry+0.001)/m_density ;
		
		delpz = 0.0;
//		delpz = (ca_cell_p[i][j][k+1]-ca_cell_p[i][j][k])/sizez;
				
/*		conv_term_z = ca_cell_fl[i][j][k]*(duwdx+dvwdy+dw2dz) + wuz*ca_cell_w[i][j][k]*dfdx[i][j][k] + 
			wvz*ca_cell_w[i][j][k]*dfdy[i][j][k] + ca_cell_w[i][j][k]*ca_cell_w[i][j][k]*dfdz[i][j][k];
*/		  // different way of trying u v and w

//		cell_h[i][j][k] = ca_cell_fl[i][j][k] * ca_cell_w[i][j][k] + delttime * (dy_visc*diff_term_z - conv_term_z + source_term_z - carcoz_z* ca_cell_w[i][j][k] - delpz);
//		cell_h[i][j][k] = (ca_cell_fl[i][j][k] * ca_cell_w[i][j][k] + delttime * (dy_visc*diff_term_z - conv_term_z + source_term_z - delpz - carcoz_z*ca_cell_w[i][j][k]/2))/(1 + carcoz_z*delttime/2 );  //- carcoz_z*ca_cell_w[i][j][k]/2 
		cell_h[i][j][k] = ( ca_cell_w[i][j][k] + delttime * (dy_visc*diff_term_z - conv_term_z + source_term_z - delpz - carcoz_z*ca_cell_w[i][j][k]/2))/(1 + carcoz_z*delttime/2 );
		cell_h[i][j][k] = cell_h[i][j][k] * tempftry;
	      }
	      else{
//		cell_h[i][j][k] = ca_cell_fl[i][j][k] * ca_cell_w[i][j][k];
		cell_h[i][j][k] = ca_cell_w[i][j][k] * (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2;
	      }
				
	    } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/


	
/*-------------  F G H at the boundaries -------------*/
/*

	for (j=1; j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){
	    cell_f[0][j][k] = ca_cell_fl[0][j][k] * ca_cell_u[0][j][k];
	    cell_f[IMAX][j][k] = ca_cell_fl[IMAX][j][k] * ca_cell_u[IMAX][j][k];
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (k=1; k<=KMAX; k++){
	    cell_g[i][0][k] = ca_cell_fl[i][0][k] * ca_cell_v[i][0][k];
	    cell_g[i][JMAX][k] = ca_cell_fl[i][JMAX][k] * ca_cell_v[i][JMAX][k];
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    cell_h[i][j][0] = ca_cell_fl[i][j][0] * ca_cell_w[i][j][0];
	    cell_h[i][j][KMAX] = ca_cell_fl[i][j][KMAX] * ca_cell_w[i][j][KMAX];
	  }
	}
*/
/*---------------------------------------------------*/

/*-------------  F G H at the boundaries -------------*/
	
	
	for (j=1; j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){
	    cell_f[0][j][k] = (ca_cell_ftry[0][j][k] + ca_cell_ftry[1][j][k] ) * ca_cell_u[0][j][k] /2;
	    cell_f[IMAX][j][k] = (ca_cell_ftry[IMAX][j][k]+ca_cell_ftry[IMAX+1][j][k]) * ca_cell_u[IMAX][j][k] /2;
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (k=1; k<=KMAX; k++){
	    cell_g[i][0][k] = (ca_cell_ftry[i][0][k]+ca_cell_ftry[i][1][k]) * ca_cell_v[i][0][k] /2;
	    cell_g[i][JMAX][k] = (ca_cell_ftry[i][JMAX][k]+ca_cell_ftry[i][JMAX+1][k]) * ca_cell_v[i][JMAX][k] /2;
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    cell_h[i][j][0] = (ca_cell_ftry[i][j][0]+ca_cell_ftry[i][j][1]) * ca_cell_w[i][j][0] /2;
	    cell_h[i][j][KMAX] = (ca_cell_ftry[i][j][KMAX]+ca_cell_ftry[i][j][KMAX+1]) * ca_cell_w[i][j][KMAX] /2;
	  }
	}
	
/*---------------------------------------------------*/
/*
	freerealmem(laplf, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(dfdx, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(dfdy, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	freerealmem(dfdz, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

*/
}


void poisson_rhs(BB_struct *bp){
	
	int i,j,k;
	
	CA_FLOAT delttime,sizex,sizey,sizez;
//	CA_FLOAT ***ca_cell_fl; 
	CA_FLOAT ***ppe_rhs, ***ca_cell_ftry;
	int ***cflag;
	CA_FLOAT ***cell_f, ***cell_g, ***cell_h;
	int IMAX, JMAX, KMAX;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	
//	ca_cell_fl = bp->ca_cell_fl;
	ca_cell_ftry = bp->ca_cell_ftry;
	ppe_rhs = bp->ppe_rhs;
	cflag = bp->cflag;
	cell_f = bp->cell_f;
	cell_g = bp->cell_g;
	cell_h = bp->cell_h;
	delttime = bp->delt;
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL){
		      /*Liq_f * u to dump velocity in the mushy zone*/
//		ppe_rhs[i][j][k] = ((cell_f[i][j][k]-cell_f[i-1][j][k])/sizex + (cell_g[i][j][k]-cell_g[i][j-1][k])/sizey+(cell_h[i][j][k]-cell_h[i][j][k-1])/sizez)/ca_cell_ftry[i][j][k]/delttime;

		/*force velcotiy to be ZERO when solid*/
	      ppe_rhs[i][j][k] = ((cell_f[i][j][k]-cell_f[i-1][j][k])/sizex + (cell_g[i][j][k]-cell_g[i][j-1][k])/sizey+(cell_h[i][j][k]-cell_h[i][j][k-1])/sizez)/delttime;
	      } 
//	      else if (cflag[i][j][k] == FFCELL && ca_cell_fl[i][j][k] == 0.0){
//		ppe_rhs[i][j][k] = 0.0;
//	      }
				
	    }
	  }
	}
}







