/*---------------------------------------------------------------------*/
/*             Vector transfer module 
  Transfer data between one dimensional array and three dimensional array
  coded by LY   03/2008
*/
/*---------------------------------------------------------------------*/

#include "datatrans.h"
#include "ff_mpflow.h"

int vectorin(CA_FLOAT ***data3din, CA_FLOAT *data1dout, int io, int ie, int jo, int je, int ko, int ke){
  
  int *ijkindex;
  int i, j, k, ic, jc, kc;
  int indexnum, totalnum;

  indexnum = 0;
  totalnum = (ie-io+1) * (je-jo+1) * (ke-ko+1);
  
  ijkindex = (int *)calloc(3*totalnum, sizeof(int));

  for (k = ko; k <= ke; k ++){
	for (j = jo; j <= je; j ++){
	  for (i = io; i<= ie; i ++){

		ijkindex[indexnum*3] = i;
		ijkindex[indexnum*3+1] = j;
		ijkindex[indexnum*3+2] = k;
			  
		indexnum ++;
			  
	  }
	}
  }

  for (i=0; i<totalnum; i++) {
	
	ic=ijkindex[i*3];
	jc=ijkindex[i*3+1];
	kc=ijkindex[i*3+2];
	  
	data3din[ic][jc][kc] = data1dout[i]; 
	  
  }

  free(ijkindex);

  return 1;
};

int intvectorin(int ***data3din, int *data1dout, int io, int ie, int jo, int je, int ko, int ke){

  int *ijkindex;
  int i, j, k, ic, jc, kc;
  int indexnum, totalnum;
  
  indexnum = 0;
  totalnum = (ie-io+1) * (je-jo+1) * (ke-ko+1);
  
  ijkindex = (int *)calloc(3*totalnum, sizeof(int));
  
  for (k = ko; k <= ke; k ++){
	  for (j = jo; j <= je; j ++){
		  for (i = io; i<= ie; i ++){
			  
			  ijkindex[indexnum*3] = i;
			  ijkindex[indexnum*3+1] = j;
			  ijkindex[indexnum*3+2] = k;
			  
			  indexnum ++;
			  
		  }
	  }
  }
  
  for (i=0; i<totalnum; i++) {
	  
	  ic=ijkindex[i*3];
	  jc=ijkindex[i*3+1];
	  kc=ijkindex[i*3+2];
	  
	  data3din[ic][jc][kc] = data1dout[i];
	  
  }
  
  free(ijkindex);
  
  return 1;
};


int vectorout(CA_FLOAT ***data3dout, CA_FLOAT *data1din, int io, int ie, int jo, int je, int ko, int ke){
  
  int i, j, k;
  int indexnum;
	
  indexnum = 0;
	
  for (k = ko; k <= ke; k ++){
    for (j = jo; j <= je; j ++){
      for (i = io; i<= ie; i ++){

		data1din[indexnum] = data3dout[i][j][k];
		indexnum ++;
	  }
	}
  }

  return 1;
};


