/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*   email p.d.lee or r.atwood or x.xu @ic.ac.uk for details    */
/****************************************************************/

/****************************************************************/
/* fidap.h                                                      */
/* head file for temp. in macro (FIDAP, CV)                     */
/****************************************************************/
/* Written by X. Xu, P.D. Lee & R.C. Atwood, Imperial College   */
/* Nov 10, 1998                                                 */
/****************************************************************/
/*      MODIFIED by:                                            */
/* see RCS Log at end of file                                   */
/****************************************************************/
/*$Id: fidap.h 887 2006-03-01 18:21:01Z rcatwood $*/

/*RCS Id:$Id: fidap.h 887 2006-03-01 18:21:01Z rcatwood $*/
#ifndef FIDAP_INTERP_H
#define FIDAP_INTERP_H

#define FG_REV "fidap.h $Revision: 887 $"
#define STEADY 0
#define TRANSIENT 1

#define MAX_TRING 20
#define TRING_I 2
#define TRING_F 5
 
#define R_OFF 0.0       /* set an offset (0.138) from central of ingot when interpolation for saving time */  
#define Z_OFF 1.60      /* set an offset from the bottom of ingot in macro temperature field for CA */
#define TIME_TR 0.0

typedef struct treering {
   int v_int[TRING_I];   /* 0: cell number to start perturb. on  */
            /* 1: cell number to finish perturb. on */
   CA_FLOAT v_f[TRING_F];   /* 0: magnitude of perturbation         */
         /* 1: time perturb starts               */
         /* 2: time perturbation lasts           */
         /* 3: z to start perturbation           */
         /* 4: z to finish perturbation          */
} Tring_str;

typedef struct fidap_geo {
   int nnodes;     /* total # of nodes                     */
   int nr;         /* # of nodes in r direction            */
   int nz;         /* # of nodes in z direction            */
   CA_FLOAT tstart;   /* beginning time for this data */
   int s_start;  /* CA step for beginning time */
   CA_FLOAT tnext;    /* beginning time for the next data */
   int s_next;   /* CA step for next data time */
   double wfact; /* precalculated weight factor for time interpolation */
   double wf_add; /* precalculated weight factor step*/
   int stepdif;
                   /* updated every step */

   CA_FLOAT *r;       /* ptr to array of r node locations     */
   CA_FLOAT *z;       /* ptr to array of z node locations     */
   CA_FLOAT *Fidap_T;       /* ptr to array of node Temperatures    */
   CA_FLOAT v;        /* velocity of growth [mm]              */
   CA_FLOAT Tmax;     /* Max. Temperature to set CA cells     */
   CA_FLOAT Tmin;     /* Min. Temperature to set CA cells     */
   int state;      /* steady/transient state of temp. field. */
  /*******************  Stuff for tree ring creation   ***********/
   int tring_on;    /* Using Tree Rings? True/False    */
   int ntring;      /* no. oc tree rings                      */
   Tring_str tring[MAX_TRING];   /* structure to add perturbations */
   CA_FLOAT *zoffset;   /* ptr to array of z offsets (one per r)  */
   CA_FLOAT oldtime;    /* time at last step                      */
  
  /******************** Stuff for transient calculation ************/
   int trans_on;        /* Using Transient state thermal solution  */
   CA_FLOAT time_trans;    /* time to start using transient state solution  */   
   CA_FLOAT z_off;         /* offset of Z of CV mesh with CA's     */
   CA_FLOAT r_off;         /* offset of R of CV mesh with CA's     */
   CA_FLOAT time_var;      /* time in a macro model                */
   CA_FLOAT time_ca;       /* time of CA                           */
   CA_FLOAT hs_ingot;      /* steady state height of the ingot     */
   CA_FLOAT h_ingot;       /* Transient state heigh of the ingot   */
   CA_FLOAT h_cur;         /* Height of ingot at current step      */ 
   CA_FLOAT h_ca;          /* total height of ingot in CA domain   */
  
} FGrid_str;

#endif /* FIDAP_INTERP_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.3.8.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.3.2.4  2003/01/22 16:53:43  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.3.2.3  2003/01/17 13:57:36  rcatwood
RCS Log:merged fidap.h versions
RCS Log:
RCS Log:Revision 8.3  2002/12/16 15:12:25  rcatwood
RCS Log:Improved Gmakefile, and started work on fg - macromodel version
RCS Log:But this needs merging with procast version first
RCS Log:
RCS Log:Revision 8.2  2002/12/13 18:06:06  rcatwood
RCS Log:Started rewriting input section for VAR input
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:01  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.1  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.0.14.1  2002/09/05 12:24:59  rcatwood
RCS Log:added FG_REV tag for data checking
RCS Log:
RCS Log:Revision 1.1  2002/09/04 18:40:54  rcatwood
RCS Log:
RCS Log:header files needed for converting and finding number of nodes, and fgrid structure
RCS Log:
RCS Log:Revision 7.0.16.1  2002/09/04 16:46:07  rcatwood
RCS Log:The last known version used by X Xu (March 2001)
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.3  1999/12/16 12:21:13  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
RCS Log:Revision 4.0.1.1  1999/12/15 13:29:12  rcatwood
RCS Log:XXu Changes to FIDAP files
RCS Log:for using W.Zhang output
RCS Log:
*/
