/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/
/*RCS Id:$Id: find_max.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include "machine.h"
#include "blocks.h"
#include "props.h"
int find_max_conc (BB_struct * bp, Value_struct * vp, int sbnum)
{

  CA_FLOAT max, min, amt, tot = 0;
  int i, j, k, errors = 0;      /*counters */
  CA_FLOAT *sp, *fsp, partcoef, *concp;
  CA_FLOAT Temp, TempK, ss, conc, fl;
  CA_FLOAT sat = 0, maxsat, maxss, minss, maxcl, mincl;
  int index_ca;

  partcoef = vp->part_coef;
  sp = vp->block_array[sbnum];
  Temp = bp->sb[sbnum]->Tvals.Tavg;
  TempK = Temp + STD_TEMP;
  if (bp->ctrl->scheil == TRUE) {
    fsp = bp->sb[sbnum]->sch_fs;
  } else {
    fsp = bp->sb[sbnum]->c_fs;
  }
  concp = bp->sb[sbnum]->c_sol_alloy;
  max = 0;
  min = 100;
  maxcl = 0;
  mincl = 100;
  minss = 100;
  maxsat = maxss = 0;
   /*******************************************/
  /* Loop through the value array and find   */
  /* the min, max and solute amount corrected */
  /* according to the partition coefficient. */
  /*                                         */
   /*******************************************/
  for (k = 0, index_ca = 0; (k < bp->nc[2] && index_ca < bp->nc[0] * bp->nc[1] * bp->nc[2]); k++) {
    for (j = 0; j < bp->nc[1]; j++) {
      for (i = 0; i < bp->nc[0]; i++) {
         /***********NOT_CASTING TEST*************************/
        if (*fsp == NOT_CASTING) {
        } else {
          amt = *sp * (1 - (1 - partcoef) * *fsp);
          tot += amt;
          if (*fsp < 1.0) {
            if (*sp > maxcl)
              maxcl = *sp;
            if (*sp < mincl)
              mincl = *sp;
          }
          if (amt > max)
            max = amt;
          if (amt < min)
            min = amt;
          if (amt < 0)
            errors++;
          if (bp->ctrl->scheil == TRUE) {
            fl = 1 - *fsp;
            conc = find_sch_conc (TempK, fl);
          } else if ((bp->ctrl->diffuse_alloy) && (bp->ctrl->diffuse_alloy_multi == FALSE)) {
            conc = *concp;
          } else {
            conc = (bp->sb[sbnum]->Svals[ALLOY]).Cinit;
          }
  
          if (bp->ctrl->diffuse_alloy_poly == FALSE){
            sat = find_sat (&(bp->mprops), TempK, conc, *fsp);
          }else{
            sat = find_sat_poly(bp, sbnum, TempK);
          }

          ss = *sp / sat;
          if (sat > maxsat)
            maxsat = sat;
          if (ss < minss)
            minss = ss;
          if (ss > maxss)
            maxss = ss;
        }   /*********end of NOT_CASTING test*************/
        index_ca++;
        sp++;
        fsp++;
        concp++;
      }
    }
  }

  vp->CLmin = mincl;
  vp->CLmax = maxcl;
  vp->Cmin = min;
  vp->Cmax = max;
  vp->Ctot = tot;
  vp->SSmax = maxss;
  vp->SSmin = minss;
  vp->SATmax = maxsat;

  return (errors);
}                               /*end of find max conc */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_find_max_c ()
{
  static char const rcsid[] = "$Id: find_max.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_find_max_c subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3.2.1  2006/02/01 14:16:25  lthuinet
RCS Log:#update change of the calculation of supersaturation for gas in multicomponent
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1.4.1  2004/03/04 11:29:24  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.5  2003/08/14 14:17:57  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.1.8.4  2003/05/06 15:48:07  rcatwood
RCS Log:Altered linear binary phase diagram usage to consistently use the values input from the control files rather than the header files.
RCS Log:
RCS Log:Revision 8.1.8.3  2003/01/22 16:53:43  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:46  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 7.0.8.1  2002/08/27 14:18:17  chirazi
RCS Log:adding files for multi-component-Procast version of CA
RCS Log:Revision 8.1  2002/10/17 17:01:01  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.1  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.0.14.1  2002/10/17 16:03:44  rcatwood
RCS Log:Fixed a subtle problem concerning the amount of gas in the pores
RCS Log:This required adding a lot of debugging #ifdef CHECK_GAS lines
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:53:28  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.1  2000/10/24 14:53:57  rcatwood
RCS Log:Changed grain nuc to include block_nuc method
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:35  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.2  2000/06/06 18:43:04  rcatwood
RCS Log:Changed r start and growth of pores -- pore radius equilibrium
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.2  2000/02/29 18:30:36  rcatwood
RCS Log:Fixed bug in find_max if no schiel
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.5  2000/02/15 15:29:11  rcatwood
RCS Log:Version after McWasp submitted
RCS Log:
RCS Log:Revision 4.4  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.3  1999/12/21 10:26:15  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.2  1999/12/16 19:15:49  rcatwood
RCS Log:Alloy and gas diffusion working, pores working. Changed file name for conc. output A for alloy C for gas conc.
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.3  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
