#include <stdlib.h>
#include <stdio.h>
#include "machine.h"
#include "blocks.h"
#include "pore.h"
#include "SurCellRoutines.h"
#include "phy_ca_tran.h"
#include "ff_mpflow.h"

/* in pore_routines.c */
extern void free_porelist (p_c_list * list);
extern void free_ms (MultiS_struct * ms, int ele_1);

int free_pore (PORE_str * porelist, int npores);
int free_sb (BB_struct * bp, int i);

/* free all the structures .. hopefully .. */
void free_sb_arrays (BB_struct * bp, int sbnum);

/*******************************************/
/* Free the pointers in the ctrl struct    */
/*******************************************/
int free_ctrl (Ctrl_str * cp)
{
  int i;
  fprintf (stderr, "    free(cp->fn_cap);\n");
  free (cp->fn_cap);
  fprintf (stderr, "    free(cp->fn_geo);\n");
  free (cp->fn_geo);
  fprintf (stderr, "    free(cp->fn_mat);\n");
  free (cp->fn_mat);
  fprintf (stderr, "    free(cp->fn_inp);\n");
  free (cp->fn_inp);
  fprintf (stderr, "    free(cp->fn_base);\n");
  free (cp->fn_base);
  fprintf (stderr, "    free(cp->cflags);\n");
  free (cp->cflags);
  fprintf (stderr, "    free(cp->rgbp->r);\n");
  free (cp->rgbp->r);
  fprintf (stderr, "    free(cp->rgbp->g);\n");
  fprintf (stderr, " %x\n", (cp->rgbp->g));
  free (cp->rgbp->g);
  fprintf (stderr, "    free(cp->rgbp->b);\n");

  free (cp->rgbp->b);

  fprintf (stderr, "    free(cp-> rgbp);\n");
  free (cp->rgbp);
  fprintf (stderr, "    free(cp->fn_ca_phy);\n");
  free (cp->fn_ca_phy);

  for (i=0; i<7; i++) free(cp->lntrack[i]);
  free (cp->lntrack);

  return (0);
}

/*******************************************/
/* Free the pointers in the blig block     */
/*******************************************/
int free_bb (BB_struct * bp)
{

  int i, j, ele_num, ele_1;
  MultiS_struct *ms;
  Ctrl_str *cp;

  cp = bp->ctrl;
  ms = &(bp->MultiSvals);
  ele_num = cp->NUM_COMP;
  ele_1 = ele_num - 1;
  for (i = 0; i < bp->ntsb; i++) {
    fprintf (stderr, "Freeing subblock %i\n", i);
    free_sb (bp, i);
    free (bp->sb[i]);
  }

  free (bp->sb);
  free (bp->intclosed);
  free (bp->floatclosed);
  free (bp->c_fs_values->block_array);
  free (bp->c_fs_values);

  /*free the structures for finite element input */
  if (bp->ctrl->fgrid_input) {
    free (bp->fg);
    free (bp->fg_next);
  }


  if (bp->ctrl->diffuse_alloy_multi == 1) {
    free (bp->fs_n_eut_values->block_array);
    free (bp->fs_n_eut_old_values->block_array);
    free (bp->cell_dfs_primary_values);
    free (bp->cell_dfs_eutectic_values);
    free (bp->fs_b_eut_values->block_array);
    free (bp->fs_b_eut_old_values->block_array);
    free (bp->fs_t_eut_values->block_array);
    free (bp->c_fs_corrected_values->block_array);
    free (bp->fs_n_eut_values);
    free (bp->fs_n_eut_old_values);
    free (bp->fs_b_eut_values);
    free (bp->fs_b_eut_old_values);
    free (bp->fs_t_eut_values);
    free (bp->c_fs_corrected_values);
  }
  /* end of multi diff test */
  free (bp->sch_fs_values->block_array);
  free (bp->sch_fs_values);
  free (bp->c_sol_values->block_array);
  free (bp->c_sol_values);
  free (bp->c_sol_alloy_values->block_array);
  free (bp->c_sol_alloy_values);
  /*
     if (bp->ctrl->diffuse_alloy_multi==FALSE){
     free (bp->c_sol_in_solid_values);
     }
   */

  #ifdef CHIRAZI_MULTI
  /*  free the multi-component arrays */
  if (bp->ctrl->diffuse_alloy_multi == 1) {
    for (j = 0; j < ele_1; j++) {
      free (bp->multi_conc[j]);
      free (bp->multi_conc_tot_old[j]);
      free (bp->multi_conc_tot[j]);
      free (bp->multi_conc_n_eut[j]);
      free (bp->multi_conc_n_eut_old[j]);
      free (ms->temp_multi[j]);
    }
    free (bp->multi_conc);
    free (bp->multi_conc_tot_old);
    free (bp->multi_conc_tot);
    free (bp->multi_conc_n_eut);
    free (bp->multi_conc_n_eut_old);
    free (ms->temp_multi);
    free (bp->bin_flag);
    free (bp->ter_flag);
    free (bp->bin_grain_index);
    free (bp->ter_grain_index);

    /* free the MultiS values structue */

    free_ms (ms, bp->ctrl->NUM_COMP - 1);

  }
  /* end of multi diff test */
  #endif
  free (bp->gr_array);

  free (bp->c_elm_array);

  /*free (bp->ftmp_one_old); */
  free (bp->ftmp_one);
  free (bp->ftmp_two);
  free (bp->ftmp_three);
  free (bp->ftmp_four);
  free (bp->ftmp_five);
  free (bp->ftmp_nx);
  free (bp->ftmp_ny);

  /* only used for decentered (Wei WANG) mode */
  if (bp->ctrl->decentred_octahedron) {
    free (bp->ftmp_dc_d);
    free (bp->ftmp_dc_x);
    free (bp->ftmp_dc_y);
    free (bp->ftmp_dc_z);
  }

  free (bp->sb_mask);
  if (bp->ctrl->procast == TRUE) {
    free (bp->cell_temp_procast);
    free (bp->cell_pres_procast);
    free (bp->current_cell_temp);
    free (bp->current_cell_pres);
    free (bp->cell_temp_change_procast);
    free (bp->cell_pres_grad_procast);
    free (bp->cell_element_array);
    free (bp->cell_node_array);
  }
#ifdef OLD_TUNDER
  free (bp->old_Tunder);
#endif /*OLD_TUNDER */

  free (bp->itmp_one);
  free (bp->itmp_two);

  /*free the grains */
  fprintf (stderr, "Freeing the grains\n");
  for (i = 0; i <= bp->nprops.ngr; i++) {
    if (bp->gr[i] != NULL) {
#ifdef DBM
      fprintf (stderr, "freegrain,num %i,mem %x\n", i, bp->gr[i]);
#endif /*DBM*/
        free (bp->gr[i]);
    }
  }

  /*and the array that holds them */
  fprintf (stderr, "... the grain ptr array\n");
  free (bp->gr);

  /* free the pressure lookup table */
  fprintf (stderr, "... the pressure lookup\n");
  if (bp->ctrl->pr_lookup)
    free (bp->prlookup->pr_points);
 
  if (bp->ctrl->physica || bp->ctrl->fluidflow) {
    fprintf (stderr, "\t free(bp->Phy_newcord_x, bp->Phy_newcord_y, bp->Phy_newcord_z);\n");
    free (bp->Phy_newcord_x);
    free (bp->Phy_newcord_y);
    free (bp->Phy_newcord_z);
    free (bp->Phy_newcell_u);
    free (bp->Phy_newcell_v);
    free (bp->Phy_newcell_w);

    fprintf (stderr, "\t free(bp->Phy_newcell_T);\n");
    free (bp->Phy_newcell_T);

    fprintf (stderr, "\t free(bp->ca_cord_x, bp->ca_cord_y, bp->ca_cord_z);\n");
    free (bp->ca_cord_x);
    free (bp->ca_cord_y);
    free (bp->ca_cord_z);
    free (bp->ca_cell_Tar);
    free (bp->ca_cell_uar);
    free (bp->ca_cell_var);
    free (bp->ca_cell_war);
//    free (bp->ca_cell_par);
   
    free (bp->ftmp_u);
    free (bp->ftmp_v);
    free (bp->ftmp_w);
  }
  if(bp->ctrl->ffheattran || bp->ctrl->fluidflow)
     ff_free_bb(bp);
  if(bp->ctrl->curvature_3D ==2 || bp->ctrl->curvature_2D == 3)
     curv_free(bp);
  if(bp->ctrl->physica && bp->phy_tran ==1)
     phy_free_bb(bp);
  if(bp->ctrl->extinput == 1)
     ext_free_bb(bp);


      /*****************************/
  /*free the control structure */
      /*****************************/
  fprintf (stderr, "... the ctrl pointers \n");
  free_ctrl (bp->ctrl);
  fprintf (stderr, "... done \n");
  fprintf (stderr, "... the ctrl struct \n");
  free (bp->ctrl);
  fprintf (stderr, "... done \n");
      /*****************************/
  /* control structure is gone! */
      /*****************************/

  fprintf (stderr, "... done free_bb \n");
  return (0);
}                               /* end of free_bb */

void free_interp (NODENB_str * nnd)
{
  free (nnd->nl);
  free (nnd->wl);
  free (nnd->wr);
  free (nnd->nd);
  free (nnd->wd);
  free (nnd->wu);
}

/*******************************************/
/* free the subblock substructures */
/*******************************************/
int free_sb (BB_struct * bp, int sbnum)
{

  SB_struct *sb;

  sb = bp->sb[sbnum];

  if (sb->open == SB_OPEN) {
    /* free the data arrays inside the subblock */
    free_sb_arrays (bp, sbnum);

    /* free the interpolation information */
    if (bp->ctrl->fgrid_input) {
      free_interp (sb->nnd);
      free_interp (sb->nnd_next);
      free (sb->nnd);
      free (sb->nnd_next);
    }
    /* free the surface structure */

    free_SurCell (&(sb->surface));

    /*free all the pores */
    if (bp->ctrl->pore) {
      free_pore (sb->porelist, sb->Npores);
      free (sb->porelist);
    }
  }

  return (0);
}

/* free each pore structure */
int free_pore (PORE_str * porelist, int npores)
{
  int i, j;

  fprintf (stderr, "Freeing the pores ...");
  for (i = 0; i < npores; i++) {
    if ((porelist[i].State != NOT_CASTING)) {
      for (j = 0; j < N_T_LISTS; j++) {
        free (porelist[i].t_lists[j]);
      }
      /*traverse the list deleting it all */
#ifdef VERBOSE
      fprintf (stderr, "%i ", i);
#endif
      free_porelist (porelist[i].boundary);
    }
    free (porelist[i].boundary);
    free (porelist[i].body);
    free (porelist[i].t_lists);
  }
  fprintf (stderr, "Done\n");
  return (0);
}

/*******************************************/
/*                                         */
/* free all the arrays contained in the sb */
/*                                         */
/*******************************************/
void free_sb_arrays (BB_struct * bp, int sbnum)
{
  SB_struct *sp;

  sp = bp->sb[sbnum];
#ifdef USE_ELM
  free (sp->c_elm);
  sp->c_elm = NULL;
  bp->c_elm_array[sbnum] = bp->intclosed;
#endif /*USE_ELM */

  /* fraction solid array */
  free (sp->c_fs);
  sp->c_fs = NULL;
  bp->c_fs_values->block_array[sbnum] = bp->floatclosed;

  /* scheil fraction solid array */
  if (bp->ctrl->scheil == TRUE) {
    free (sp->sch_fs);
    sp->sch_fs = NULL;
    bp->sch_fs_values->block_array[sbnum] = bp->floatclosed;
  }

  /* cell index for Wei WANG */
  free (sp->index);

  /*
  free (sp->interface_index);
  REMOVED rcatwood 23/11/05 */

  /* grain array */
  free (sp->gr);
  sp->gr = NULL;
  bp->gr_array[sbnum] = bp->intclosed;

  /* cell temperature for Wei WANG */
  free (sp->c_temp);

  /* curvature xly 2004/08/09 */
  /* modified for curvature 3D and protected by the options */
  /**todo: simplify the curvature options */
      if ((bp->ctrl->curvature_3D == 1 ) || (bp->ctrl->curvature_2D == 1)|| (bp->ctrl->curvature_2D == 2)) {
	    free (sp->curv);
	    free (sp->norm_x);
	    free (sp->norm_y);
	    free (sp->norm_z);
     }
  /* undercooling map... ly*/ 
  if ( bp->ctrl->maxucmap == 1) {
    free (sp->ucmax);
    free (sp->ucmax_t);
  }
  /* gas solute array */
  if (bp->ctrl->diffuse == TRUE) {
    free (sp->c_sol);
    sp->c_sol = NULL;
    bp->c_sol_values->block_array[sbnum] = bp->floatclosed;
  }
  /*ALLOY solute array */
  if ((bp->ctrl->diffuse_alloy == TRUE) || (bp->ctrl->particle == TRUE)) {
    free (sp->c_sol_alloy);
    sp->c_sol_alloy = NULL;
    bp->c_sol_alloy_values->block_array[sbnum] = bp->floatclosed;

    /* C_E array for Wei WANG */
    if (bp->ctrl->decentred_octahedron == TRUE) {
      free (sp->c_eqv_alloy);
    }
  }

  if (bp->ctrl->decentred_octahedron == TRUE) {
    free (sp->dc_d);
    free (sp->dc_x);
    free (sp->dc_y);
    free (sp->dc_z);
  }

  /*block nuc array */
  if ((bp->ctrl->block_nuc == TRUE)) {
    free (sp->c_nuc_thresh);
    sp->c_nuc_thresh = NULL;
    free(sp->nat_sol_site);
    sp->nat_sol_site=NULL;

  }

}                               /* end free_sb_arrays */

/********************************************************/
/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program         */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_freeblock_c ()
{
  static char const rcsid[] = "$Id: freeblock.c 1490 2010-07-29 22:56:53Z  $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:39  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.4.2.4  2006/02/20 14:51:23  rcatwood
RCS Log:Correced evil log message
RCS Log:
RCS Log:Revision 10.4.2.3  2006/02/20 12:00:13  lthuinet
RCS Log: A lot of modifications : add an option to treat correctly diffusion in the case the secondary eutectic phase is stoechiometric AND add a pointer to distinguish the nature of the cell and the nature of the grain
RCS Log:
RCS Log:Revision 10.4.2.2  2006/02/01 14:16:25  lthuinet
RCS Log:#update change of the calculation of supersaturation for gas in multicomponent
RCS Log:
RCS Log:Revision 10.4.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.4  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1.2.1  2005/11/07 17:47:56  rcatwood
RCS Log:Branch uisng Xiao Li Yang final version
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 9.4.12.1  2004/09/09 17:49:42  xly
RCS Log:add curvature undercooling by estimating interface normal of growing cells.
RCS Log:Revision 8.2.8.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.4  2003/11/18 13:22:40  rcatwood
RCS Log:Added routines to find and store the interface cells between the casting and the mould.
RCS Log:Added the surface cell storage structure to the subblock.
RCS Log:Improved mould source and nucleation  routines to use the surface cell structure
RCS Log:
RCS Log:Revision 9.3  2003/10/23 16:32:39  rcatwood
RCS Log:chagned signal result to allow writing of the final files on USR1
RCS Log:
RCS Log:Revision 9.2  2003/09/16 11:59:14  rcatwood
RCS Log:Improved micro/macro interpolation
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:35  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.2.2.7  2003/02/03 12:52:03  rcatwood
RCS Log:Fixed some memory allocation bugs (seg fault if no fgrid input)
RCS Log:
RCS Log:Revision 8.2.2.6  2003/01/28 18:11:47  rcatwood
RCS Log:ALL_SIG flag to disable signal blocking
RCS Log:Fixed double free of node structure
RCS Log:
RCS Log:Revision 8.2.2.5  2003/01/23 17:47:27  rcatwood
RCS Log:finite grid applied to decentered square,
RCS Log:works, but not checked for correct results.
RCS Log:
RCS Log:Revision 8.2.2.4  2003/01/22 16:53:43  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.2.2.3  2003/01/17 16:09:29  rcatwood
RCS Log:Before changing all CA_FLOAT to CA_CA_FLOAT
RCS Log:
RCS Log:Revision 8.2.2.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.2  2003/01/14 19:32:04  rcatwood
RCS Log:working checkin - not for multicomponent however
RCS Log:Temeprature routine still not harmonised
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:46  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:01  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.7  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.6.10.5  2002/10/07 13:24:28  ww1
RCS Log:fixed total fraction solid at each time step and remove curv from ctrl
RCS Log:
RCS Log:Revision 7.6.10.4  2002/09/17 20:51:07  rcatwood
RCS Log:Rearranged so that read/write leave the memory clean
RCS Log:Added signal 16 (SIGUSR1) catching for trapping after finishing the current timestep.
RCS Log:
RCS Log:Revision 7.6.10.3  2002/09/13 09:10:18  rcatwood
RCS Log:only alloc C_E if decentered mode is on
RCS Log:started write_block for pore data - just a stub!
RCS Log:
RCS Log:Revision 7.6.10.2  2002/09/12 13:53:19  rcatwood
RCS Log:Added decentered mode arrays to freeblocks
RCS Log:Tested with efence and dbmalloc
RCS Log: fix curvature access bug in fs_change_diffuse (Wei)
RCS Log:
*/
