/*$Id: handlers.c 953 2006-11-09 13:39:43Z rcatwood $*/
#include <stdlib.h>
#include <stdio.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <setjmp.h>
#include "machine.h"
#include "constants.h"
#ifdef GNU_TRAP_FPE
#define _GNU_SOURCE
#   include <fenv.h>
extern int feenableexcept (int excepts);
#endif
extern int jflg;
extern int the_signo;
extern jmp_buf env;
extern int errno;
extern int signal_change_freq;

void float_error (int signo)
{                               /* signal handler for sigfpe */
  static int count = 0;

  printf ("\nSignal handler: float_error: ERROR: fpe detected (signal %i) !!!!\n",signo);
  if (count == 0)
    printf ("\nRaising USR2 to obtain output step.\n");
    raise (SIGUSR2);
  count++;
  if (count >= 10)
    printf ("\n%s: More than %i fpe errors detected. Exiting...\n",__func__);
    exit (6);
  signal (SIGFPE, float_error);
  return;
}

void catchit (int signo)
{                               /* signal handler -- jump to finish_bb */
  printf ("\nCA_WRAPPER: catchit: Signal %d received \n", signo);
  the_signo = signo;
  fflush (NULL);
  FILE * fp;
  struct stat  status;
  
  if (signo == SIGUSR1) {
    jflg = JFLG_WRITEXIT;
  } else if (signo == SIGUSR2) {
    jflg = JFLG_WRITEBIN;
    signal (SIGUSR2, catchit);

    /********************************************************/
    /* mechanism for changing output timestep while runnign */
    /* if the file is there, then it gets read when the signal */
    /* is caught */

    if ( stat("ca_newstep.in",&status) == 0 ){
       char * line, *sep,*token;
       line = (char * ) calloc(MAX_STRING_LEN,sizeof(char));
       sep = (char *) calloc (MAX_STRING_LEN, sizeof (char));
       sprintf (sep, " ,;\t\n\r");
       fprintf(stderr,"%s: Changing the output step as requested.\n",__func__);

       /* change the time step */
       fp = fopen("ca_newstep.in","r");

         while (fgets (line, MAX_STRING_LEN, fp) != NULL) {
       /* ignore comment and blank lines */
       if (line[0] == '%' || line[0] == '#' || (token = strtok (line, sep)) == NULL) {
         continue;
       } else if (strcasecmp (token, "NewStep") == 0) {
         if ((token = strtok (NULL, sep)) != NULL)
           signal_change_freq = atoi (token);
           if (signal_change_freq <= 0 ) {
              signal_change_freq = 0 ;
           }
         }else{
           signal_change_freq = 0 ;
         }
      }
    }else{
      /* no change */
        signal_change_freq = 0 ;
        fprintf(stderr,"%s:Returning with output flag set.\n",__func__);
    }
    return;
  }
  longjmp (env, 1);
  return;
}

#ifdef GNU_TRAP_FPE
void enable_fpe_traps ()
{
  /*
   * This installs the SIGFPE signal handler and enables traps for
   *
   * debugging purposes.
   */

  fenv_t env;
  int excepts;

  /* Enable exception trapping. */

  excepts = FE_DIVBYZERO | FE_INVALID | FE_OVERFLOW;
  feholdexcept (&env);          /* start clean */
  if (feenableexcept (excepts) == -1)
    exit (1);                   /* set traps */
}
#endif

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *handlers_c ()
{
  static char const rcsid[] = "$Id: handlers.c 953 2006-11-09 13:39:43Z rcatwood $";

  return (rcsid);
}
