/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* multi_diff_props.h                                                   */
/* Header file defining concentrationsolution related structures*/
/* for multi-component diffusion                                */
/****************************************************************/
/****************************************************************/
/* Written by A. Chirazi Imperial College */
/* October 4, 2000                                                 */
/*RCS Id:$Id: multi_diff_props.h 887 2006-03-01 18:21:01Z rcatwood $*/
/****************************************************************/

#ifndef MULTIPROPS_H
#define MULTIPROPS_H

/****************************************************************/
/*  the solute MultiS_struct structure, which holds                */
/*  information about solute phases and pahse diagram              */
/****************************************************************/
typedef struct multisolprops {
                        /***********T AND FL VARIABLES***********/
   CA_FLOAT *Cinit_multi;  /* the initial concentration array [mol/m^3] */
   CA_FLOAT *Cmax_multi;   /* max concentration array of whole sb     */
   CA_FLOAT *Cmin_multi;   /* min concentration aaray of whole sb     */
   CA_FLOAT *Cavg_multi;   /* Avg. concentration array of whole sb     */
   CA_FLOAT *Ctot_multi;   /* tot. concentration array of whole sb     */
   CA_FLOAT *slope_multi;  /* the slope for each solute phase */
   CA_FLOAT **Clim_multi;   /* limiting concentration for each phase and cell*/

   CA_FLOAT *part_coef_multi; /* partition coefficeint for different elements */
   CA_FLOAT **part_coef_matrix; /*variation of Ki for each cell*/
   CA_FLOAT *LDiff_multi;   /* liquid diffusion array */
   CA_FLOAT *SDiff_multi;  /* solid diffusion array */
   CA_FLOAT **Diff_matrix_liq; /* diffusion parameters matrix, liquid phase */
   CA_FLOAT **Diff_matrix_sol; /* diffusion parameters matrix, solid phase */
   CA_FLOAT **temp_multi;   /* a range of temparory arrays for the*/
                        /* storage of the solute values */
                        /* old values are stored at each time step*/
   CA_FLOAT **begin_buffer; /* the begin pointer of the conc buffer */
   CA_FLOAT phaval[30000][4];     /*phase diagram values for liqidus and al si cu conc*/
   CA_FLOAT **ya1, **ya2, **ya3, **xxa; /**interpolation matrices for phase dia**/
   int counter[5];           /* counter array for phase dia ***/
   int numtietri;      /*number of tie triangles produced by thermocalc*/

   /***********phase diagram critical points (bin and ter eut points) **/
   CA_FLOAT bin_eut_max[3];
   CA_FLOAT bin_eut_temp[3];
   CA_FLOAT ter_eut_max[3];
   CA_FLOAT ter_eut_temp[3];
} MultiS_struct;
#endif /* MULTIPROPS_H */
