#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "machine.h"
#include "blocks.h"
#include "bigblock.h"
#include "props.h"



void tecplotop(CA_FLOAT *x, CA_FLOAT *y, CA_FLOAT *z, int nx, int ny, int nz, CA_FLOAT *data, CA_FLOAT *data1, CA_FLOAT *data2, CA_FLOAT *data3, int totalnum, char filename[100]){

     int tecflag, i;
     FILE *inf;

     tecflag=0;

     if(tecflag==0){
        inf=fopen(filename,"w+");
        fprintf(inf,"VARIABLES = \"X\"\n\"Y\"\n\"Z\"\n\"T\"\n\"U\"\n\"V\"\n\"W\"\n");
        tecflag=1;
     }else inf=fopen(filename,"a+");

     fprintf(inf,"ZONE T=\"G1\" I=%d, J=%d, K=%d \n DT=(SINGLE SINGLE SINGLE DOUBLE SINGLE SINGLE SINGLE)\n",nx,ny,nz);
     for(i = 0;i < totalnum; i++) {
         fprintf(inf,"%f\t %f\t %f\t %f\t %f\t %f\t %f\n",x[i],y[i],z[i],data[i],data1[i],data2[i],data3[i]);
     }
         fclose(inf);

     fprintf (stderr,"Tecplotop: write the Phy data file: %s ! \n", filename);
}


void plt_op_fsv (BB_struct * bp, int sbnum){

      char fname[MAX_STRING_LEN];
      int tecflag, i;
      FILE *inf;
      int l, m, n, indexnum;
      CA_FLOAT tempvalue;

      l=m=n=0;
      tempvalue = 0.0;
	      
      sprintf (fname, "PLT_%s_t%08d.plt", bp->ctrl->fn_base, bp->step);
	  
//      tecplotop(bp->ca_cord_x, bp->ca_cord_y, bp->ca_cord_z, bp->tncx, bp->tncy, bp->tncz, bp->sb[sbnum-1]->c_temp, bp->ca_cell_uar, bp->ca_cell_var, bp->ca_cell_war, bp->total_ca_number, fname);
  

       tecflag=0;

//       if(tecflag == 0){
          if((inf=fopen(fname,"w+"))== NULL)
	     fprintf(stderr, "ERROR: plt_output: cannot open file: %s \n", fname);

       if(bp->ctrl->physica || bp->ctrl->fluidflow || bp->ctrl->ffheattran){
         fprintf(inf,"VARIABLES = \"X\"\n\"Y\"\n\"Z\"\n\"T\"\n\"Fs\"\n\"Cl\"\n\"Ce\"\n\"U\"\n\"V\"\n\"W\"\n");
         fprintf(inf,"ZONE T=\"G1\" I=%d, J=%d, K=%d \nDT=(SHORTINT SHORTINT SHORTINT DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE DOUBLE)\n",bp->tnc[0], bp->tnc[1], bp->tnc[2]);       /*Write file head for tecplot outouts*/
       }else {
         fprintf(inf,"VARIABLES = \"X\"\n\"Y\"\n\"Z\"\n\"T\"\n\"Fs\"\n\"Cl\"\n\"Ce\"\n\"Gr\"\n");
         fprintf(inf,"ZONE T=\"G1\" I=%d, J=%d, K=%d \nDT=(SHORTINT SHORTINT SHORTINT DOUBLE DOUBLE DOUBLE DOUBLE LONGINT)\n",bp->tnc[0], bp->tnc[1], bp->tnc[2]); 
       }
	       
       
       
       indexnum=0;
       
       if(bp->ctrl->physica || bp->ctrl->fluidflow || bp->ctrl->ffheattran){
         for( n = 0; n < bp->tnc[2]; n++) {
	   for ( m = 0; m < bp->tnc[1]; m++){
             for ( l = 0; l < bp->tnc[0]; l++){
	       if (bp->ctrl->decentred_octahedron == TRUE) {      
	         fprintf(inf,"%d\t %d\t %d\t %lf\t %f\t %f\t %f\t %f\t %f\t %f\n", l, m, n, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_eqv_alloy[indexnum], bp->ca_cell_uar[indexnum], bp->ca_cell_var[indexnum], bp->ca_cell_war[indexnum]);
	       } else{
	         fprintf(inf,"%d\t %d\t %d\t %lf\t %f\t %f\t %f\t %f\t %f\t %f\n", l, m, n, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->ca_cell_uar[indexnum], bp->ca_cell_var[indexnum], bp->ca_cell_war[indexnum]);
	       }
	       indexnum++; 
	     }
	   }
	 }
       } else{
         for( n = 0; n < bp->tnc[2]; n++) {
           for ( m = 0; m < bp->tnc[1]; m++){
             for ( l = 0; l < bp->tnc[0]; l++){
               if (bp->ctrl->decentred_octahedron == TRUE) {
		 if(bp->ctrl->diffuse_alloy == TRUE){
                 fprintf(inf,"%d\t %d\t %d\t %lf\t %f\t %f\t %f\t %d\t \n", l, m, n, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_eqv_alloy[indexnum], bp->sb[sbnum-1]->gr[indexnum]);
		 } else if(bp->ctrl->diffuse_alloy == FALSE){
		 fprintf(inf,"%d\t %d\t %d\t %lf\t %f\t %f\t %f\t %f \n", l, m, n, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], tempvalue, tempvalue, tempvalue);
		 } 
               } else{
		 fprintf(inf,"%d\t %d\t %d\t %lf\t %f\t %f\t %f\t %f\t %f\t %f\n", l, m, n, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], tempvalue, tempvalue, tempvalue);
	       }
	       indexnum++;
             }
	   }
         }
       }
             /*Write data to fname!!!*/

       fclose(inf);

       fprintf (stderr,"Tecplotop: write the Phy data file: %s ! \n", fname);
						  
}



void plt_op_pointinfo (BB_struct * bp, int sbnum, int i, int j, int k){

       char fname[MAX_STRING_LEN];
       FILE *inf;
       int indexnum;
       CA_FLOAT tempt, const_uc, total_uc;
       tempt = 0.0;
       const_uc = 0.0;
       total_uc = 0.0;
       indexnum = i + j * bp->tncx + k * bp->tncx * bp->tncy;

       sprintf (fname, "PT_%s_ijk_%d_%d_%d.csv", bp->ctrl->fn_base, i, j, k);


       if(bp->outflag == 0){

	      inf=fopen(fname,"w+");
              fprintf(inf, "Time step is %f, \n", bp->delt);
	      fprintf(inf, "Point: %d, %d, %d, \n", i, j ,k );
	      fprintf(inf,"Steps,Temperature,fs,Cl,Ce,Total_UC,Const_UC, Max_UC,\n");
              bp->outflag = 1;
	      
       }else inf = fopen(fname,"a+");
       
       if (bp->ctrl->decentred_octahedron == TRUE) {
  //     fprintf(inf,"%d, %f, %f, %f, %f, %f, %f, %f, \n",bp->step, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_eqv_alloy[indexnum], bp->ca_cell_uar[indexnum], bp->ca_cell_var[indexnum], bp->ca_cell_war[indexnum]);
    
	  if (bp->sb[sbnum-1]->c_fs[indexnum] < 0.01) {
	       tempt = cell_liq_calc (bp->sb[sbnum-1]->c_eqv_alloy[indexnum], &(bp->mprops));    
	       const_uc = bp->mprops.Tliq - tempt;
	       total_uc = bp->sb[sbnum-1]->c_temp[indexnum]- tempt;
	  } else {
	       const_uc = 0.0;
	       total_uc = 0.0;
	  }
	
       fprintf(inf,"%d, %f, %f, %f, %f, %f, %f, %f, \n",bp->step, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_eqv_alloy[indexnum], total_uc, const_uc, bp->sb[sbnum-1]->ucmax[indexnum]);
       }  else {
       fprintf(inf,"%d, %f, %f, %f, %f, %f, %f, %f, \n",bp->step, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum] , bp->ca_cell_uar[indexnum], bp->ca_cell_var[indexnum], bp->ca_cell_war[indexnum]);
       }
       fclose(inf);
       fprintf (stderr,"OUTPUT:pointinfo: write the Phy data file: %s ! \n", fname);
}

void plt_op_lineinfo (BB_struct * bp, int sbnum, int **lineinfo, int lnum){

     /*only output a line alined with X direction, need to be redone by interpolation*/  
	
       char fname[MAX_STRING_LEN];
       FILE *inf;
       int indexnum;
       int i;
       CA_FLOAT tempt, const_uc, total_uc;
       int nopoint;  // number of points to be outputed/interpolated
       tempt = 0.0;
       const_uc = 0.0;
       total_uc = 0.0;
       indexnum = lineinfo[lnum][0] + lineinfo[lnum][1] * bp->tncx + lineinfo[lnum][2] * bp->tncx * bp->tncy;

    //   nopoint = lineinfo[lnum][6];

       nopoint = lineinfo[lnum][3]- lineinfo[lnum][0] +1 ;
       
       sprintf (fname, "LN_%s_t%05d_%02d.csv", bp->ctrl->fn_base, bp->step, lnum);


	      inf=fopen(fname,"w+");
              fprintf(inf, "Time step is %f, \n", bp->delt);
	      fprintf(inf, "Start Point: %d, %d, %d, \n", lineinfo[lnum][0],lineinfo[lnum][1],lineinfo[lnum][2]);
	      fprintf(inf, "End Point: %d, %d, %d, \n", lineinfo[lnum][3],lineinfo[lnum][4],lineinfo[lnum][5]);
	      
	      fprintf(inf,"Number, Temperature,fs,Cl,Ce,Total_UC,Const_UC, Max_UC,\n");
      for (i = indexnum; i < (indexnum + nopoint); i ++ ){
       
       if (bp->ctrl->decentred_octahedron == TRUE) {
  //     fprintf(inf,"%d, %f, %f, %f, %f, %f, %f, %f, \n",bp->step, bp->sb[sbnum-1]->c_temp[indexnum], bp->sb[sbnum-1]->c_fs[indexnum], bp->sb[sbnum-1]->c_sol_alloy[indexnum], bp->sb[sbnum-1]->c_eqv_alloy[indexnum], bp->ca_cell_uar[indexnum], bp->ca_cell_var[indexnum], bp->ca_cell_war[indexnum]);
    
	  if (bp->sb[sbnum-1]->c_fs[i] < 0.01) {
	       tempt = cell_liq_calc (bp->sb[sbnum-1]->c_eqv_alloy[i], &(bp->mprops));    
	       const_uc = bp->mprops.Tliq - tempt;
	       total_uc = bp->sb[sbnum-1]->c_temp[i]- tempt;
	  } else {
	       const_uc = 0.0;
	       total_uc = 0.0;
	  }
	
       fprintf(inf,"%d, %f, %f, %f, %f, %f, %f, %f, \n",bp->step, bp->sb[sbnum-1]->c_temp[i], bp->sb[sbnum-1]->c_fs[i], bp->sb[sbnum-1]->c_sol_alloy[i], bp->sb[sbnum-1]->c_eqv_alloy[i], total_uc, const_uc, bp->sb[sbnum-1]->ucmax[i]);
       }  else {
       fprintf(inf,"%d, %f, %f, %f, %f, %f, %f, %f, \n",bp->step, bp->sb[sbnum-1]->c_temp[i], bp->sb[sbnum-1]->c_fs[i], bp->sb[sbnum-1]->c_sol_alloy[i], bp->sb[sbnum-1]->c_sol_alloy[i] , bp->ca_cell_uar[i], bp->ca_cell_var[i], bp->ca_cell_war[i]);
       }
      }
      
       fclose(inf);
       fprintf (stderr,"OUTPUT:Lineinfo: write the Phy data file: %s ! \n", fname);
}
