#include <math.h>
#include "machine.h"

int pnuc_function (CA_FLOAT v, CA_FLOAT binsize, int npores, CA_FLOAT p_tsig, CA_FLOAT p_tn, CA_FLOAT par1, CA_FLOAT par2)
{
/* two step function */
/* par 1 is ratio of smaller step to larger */
/* par 2 is tn of smaller step */
  int numnew;
  CA_FLOAT inc = v + binsize;

  if (v > p_tn && inc < (p_tn + p_tsig)) {
    numnew = (int) ((CA_FLOAT) (npores) * binsize / p_tsig);
  } else if (v > par2 && inc < (par2 + p_tsig)) {
    numnew = (int) ((CA_FLOAT) (npores * par1) * binsize / p_tsig);
  } else {

    numnew = 0;
  }

  return (numnew);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_pnuc_function_c ()
{
  static char const rcsid[] = "$Id: pnuc_function.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
