/* $Id: pore_routines.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "machine.h"
#include "blocks.h"
#include "pore.h"
#include "pore_routines.h"
extern int getxyz (int cellnum, int *nc, int *Cell);

/*****************************************************/
/* add all appropriate cells at the boundary of a pore */

void add_all_cells (BB_struct * bp, CA_FLOAT * fs, PORE_str * c_p)
{
  int *nni, *nnip, *nniend, min_cell, cellnum;
  int check_flag, check_cell;

  CA_FLOAT *fsp, min_fs, this_fs;
  p_c_list *bdy;
  p_c_node *node, *checknode, *newnode;

  nni = nnip = bp->nbhd.nnq;
  nniend = nni + 6;
  bdy = c_p->boundary;
  node = bdy->first;

  while (node != NULL) {

    cellnum = node->cellnum;
    fsp = fs + cellnum;

    for (nnip = nni; nnip < nniend; nnip++) {
      this_fs = *(fsp + *nnip);
      if ((this_fs >= LIQUID) && (this_fs < SOLID)) {
        check_cell = cellnum + *nnip;
        check_flag = 1;
        /* check if it is already in the pore */
        for (checknode = bdy->first; checknode != NULL; checknode = checknode->next) {
          if (check_cell == checknode->cellnum) {
            check_flag = 0;
            break;
          }
        }                       /* end loop to check if already in pore */
        /* add to the list if not already in pore */
        if (check_flag) {
          add_to_list (bdy, new_node (check_cell));
          c_p->ncells++;
        }
      }                         /* end check if liquid/ partly solid cell */
    }                           /* end of neigbour chek loop */
    node = node->next;
  }                             /* end traverse bdy list */
  return;
}                               /* end of add_all_cells */

/*****************************************************/
/* Find the gradient of the hydrogen solute field */
/* this is used in the next subroutine find_new_cell */
/* THIS ROUTINE is specific for 6 Neigbour central FD scheme */
/*************************************************************/
/* still needs to handle NOT_CASTING somehow */
CA_FLOAT get_grad (CA_FLOAT * solp, int *nni, int ncsb, int cellnum)
{
  CA_FLOAT gradx, grady, gradz;
  CA_FLOAT gradsq;

/**there is a BUG here  \todo  Fix this bug rewrite so as to use PADDED sol array!  -- general -- hard -- maybe obsolete by xly curvature?*/
#ifdef GRAD
  gradx = *(solp + nni[0]) - *(solp + nni[1]);
  grady = *(solp + nni[2]) - *(solp + nni[3]);
#ifdef PROCAST_3D
  if ((cellnum + nni[4]) < 0) {
    gradz = 2 * (*(solp + nni[5]) - *solp);
  } else if ((cellnum + nni[5]) > ncsb) {
    gradz = 2 * (*solp - *(solp + nni[4]));
  } else {
    gradz = *(solp + nni[4]) - *(solp + nni[5]);
  }
#else
  gradz = 0.0;
#endif /* PROCAST_3D */
  gradsq = gradx * gradx + grady * grady + gradz * gradz;
#else
  gradsq = 1;
#endif /* GRAD */
  return gradsq;
}

/*****************************************************/
/* find one cell which has minimum of fraction solid */
/* neighbouring the boundary of the pore */
/* also from these fine the one with minium grad H   */
/* and choose randombly from among multiple choices   */
/*****************************************************/
int find_new_cell (BB_struct * bp, CA_FLOAT * fs, CA_FLOAT * sol, PORE_str * c_p)
{

  int *nni, *nnip, *nniend, min_cell, cellnum;
  int check_flag = 0, check_cell;
  int *choose_list, nchoose = 0, choice;

  CA_FLOAT *fsp, *solp, min_grad, min_fs, this_fs, this_grad, gradsq;
  p_c_list *bdy;
  p_c_node *node, *checknode;

  min_grad = LARGEGRAD;
  choose_list = (int *) calloc (6 * c_p->ncells, sizeof (int));

  nni = nnip = bp->nbhd.nnq;
  nniend = nni + 6;
  bdy = c_p->boundary;

  node = bdy->first;
  nchoose = 1;
  min_fs = 1.0;
  min_cell = -1;

  /* check the boundary cells */
  for (node = bdy->first; node != NULL; node = node->next) {
    cellnum = node->cellnum;
    fsp = fs + cellnum;
    solp = sol + cellnum;

    for (nnip = nni; nnip < nniend; nnip++) {
      check_cell = cellnum + *nnip;
      /* restart loop if  out of bounds */
      if (check_cell < 0 || check_cell >= bp->ncsb) {
        continue;
      }

      this_fs = *(fsp + *nnip);

      /* or not in casting */
      if (this_fs == NOT_CASTING)
        continue;
      /* or greater than previous miniumum */
      if (this_fs > min_fs)
        continue;

      check_flag = 1;

      /* check if it is already in the pore */
      for (checknode = bdy->first; checknode != NULL; checknode = checknode->next) {
        if (check_cell == checknode->cellnum) {
          check_flag = 0;
          break;
        }
      }

      if (check_flag) {

        /*randomize if equal fraction solid and gradient */
        /* don't need to calculate the gradient if fs is greater */
        if (this_fs == min_fs) {
          /* find the gradient of hydrogen in the target cell */
          this_grad = get_grad (solp, nni, bp->ncsb, cellnum);
          if (this_grad == min_grad) {
            /*equal fs and grad, so add to choice list */
            choose_list[nchoose++] = check_cell;
          } else if (this_grad < min_grad) {
            /* new miniumum grad so reset choice list */
            min_cell = check_cell;
            min_grad = this_grad;
            nchoose = 1;
            choose_list[0] = check_cell;
          }
          /* otherwise, this_grad > min_grad so do nothing */
        } else {
          /* new miniumum fs so reset choice list */
          min_cell = check_cell;
          min_fs = this_fs;
          min_grad = this_grad;
          nchoose = 1;
          choose_list[0] = check_cell;
        }                       /*end add/reset choice list (choose_list) */
      }                         /*end if check_flag */
    }                           /* end of neighbour chek loop */
  }                             /* end traverse bdy list */
  /* select a random cell if there is more than one candidate */
  if (nchoose > 1) {
    choice = (int) (floor (((double) (nchoose)) * drand48 ()));
    min_cell = choose_list[choice];
  }
  free (choose_list);
  return (min_cell);
}                               /* end of find_new_cell */

/*****************************************************/
/* remove a node from the list -- does not destroy it */
/*****************************************************/
void remove_from_list (p_c_list * list, p_c_node * node)
{
  if (list->first == node) {
    /* the cell is first on the list */
    list->first = node->next;
    if (list->first == NULL) {
      /* the cell is the only one in the list */
      list->last = NULL;
      node->next = node->previous = NULL;
      return;
    }
    list->first->previous = NULL;
    node->next = node->previous = NULL;
    return;
  }

  if (list->last == node) {
    /* the cell is last on the list */
    list->last = node->previous;
    if (list->last == NULL) {
      /* the cell is the only one in the list */
      list->first = NULL;
      return;
    }
    list->last->next = NULL;
    return;
  }

  /* ordinary deletion */
  node->previous->next = node->next;
  node->next->previous = node->previous;
  return;
}                               /* end of remove_from_list */

/* add a node to the list */
void add_to_list (p_c_list * list, p_c_node * node)
{

  if (list->last == NULL) {
    /* the list is empty */
    list->first = node;
    node->previous = node->next = NULL;
    list->last = node;
    return;
  }

  /* add to the end */

  node->previous = list->last;
  list->last->next = node;
  list->last = node;
  node->next = NULL;
  return;
}                               /* end of add_to_list */

/* create a new node and initialise the cellnumber */
p_c_node *new_node (int cellnum)
{
  p_c_node *node;

  node = calloc (1, sizeof (p_c_node));
#ifdef DBM_VERBOSE
  fprintf (stderr, "new_node:, cell, %i, mem, %x \n", cellnum, node);
#endif /*DBM_VERBOSE */
  node->cellnum = cellnum;
  return (node);
}

/* find a node by cellnum */
p_c_node *find_node (p_c_list * list, int cellnum)
{
  p_c_node *node;

  node = list->first;
  while (node != NULL) {
    if (node->cellnum == cellnum)
      return (node);
    node = node->next;
  };
  return (NULL);
}

/* free a node -- should be removed first! */
void delete_node (p_c_node * node)
{
  if ((node->next != NULL) || (node->previous != NULL)) {
    fprintf (stderr, "ERROR:delete_node: cannot remove node, as it is attatched to something!\n");
    return;
  }
#ifdef DBM
  fprintf (stderr, "delete_node:, cell, %i, mem, %x \n", node->cellnum, node);
#endif /*DBM*/
    free (node);
}

/* move a node from boundary to body */
void move_to_body (PORE_str * this_pore, p_c_node * node)
{
  remove_from_list (this_pore->boundary, node);
  add_to_list (this_pore->body, node);
}                               /* end of move_to_body */

/* traverse the list and print out cellnum */
void print_list (p_c_list * list, FILE * outfile)
{
  p_c_node *node;

  node = list->first;
  fprintf (outfile, "Cellnum list:");
  while (node != NULL) {
    fprintf (outfile, ",%i", node->cellnum);
    node = node->next;
  }
  fprintf (outfile, "\n");
}

/*************************************************/
/* traverse the list and find extent of the pore */
/*************************************************/
void find_minmax (p_c_list * list, int cellminmax[])
{
  /* 0 - min x */
  /* 1 - min y */
  /* 2 - min z */
  /* 3 - max x */
  /* 4 - max y */
  /* 5 - max z */
  int i;
  p_c_node *node;

  for (i = 0; i < 3; i++) {
    cellminmax[i] = 100000;
    cellminmax[i + 3] = -100000;
  }

  node = list->first;
  while (node != NULL) {
    for (i = 0; i < 3; i++) {
      if (node->Cell[i] < cellminmax[i]) {
        cellminmax[i] = node->Cell[i];
      }
      if (node->Cell[i] > cellminmax[i + 3]) {
        cellminmax[i + 3] = node->Cell[i];
      }
    }
    node = node->next;
  }
}

/*************************************************/
/* traverse the list and find extent of the pore */
/*************************************************/
void free_porelist (p_c_list * list)
{
  int i;
  p_c_node *node;

  node = list->first;
  while (node != NULL) {
    remove_from_list (list, node);
    delete_node (node);
    node = list->first;
  }
}                               /* end free_porelist */

#ifdef TEST_PORE_LIST
void main ()
{
  PORE_str pore;
  p_c_node *newnode;
  int i;

  pore.body = calloc (1, sizeof (p_c_list));
  pore.boundary = calloc (1, sizeof (p_c_list));

  for (i = 0; i < 20; i++) {
    newnode = new_node (i);
    add_to_list (pore.boundary, newnode);
  }
  print_list (pore.boundary, stdout);

  newnode = find_node (pore.boundary, 12);
  remove_from_list (pore.boundary, newnode);
  print_list (pore.boundary, stdout);
  delete_node (newnode);

  newnode = pore.boundary->first;
  while (newnode != NULL) {
    remove_from_list (pore.boundary, newnode);
    delete_node (newnode);
    print_list (pore.boundary, stdout);
    newnode = pore.boundary->first;
  }

}
#endif /*TEST_PORE_LIST */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_pore_routines_c ()
{
  static char const rcsid[] = "$Id: pore_routines.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */

/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.5  2005/12/06 13:09:54  rcatwood
RCS Log:Changed todo lists to Doxygen syntax
RCS Log:
RCS Log:Revision 10.4  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:38  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.3  2003/01/22 16:53:45  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:01  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.2  2003/01/14 16:22:25  rcatwood
RCS Log:Removed many lint warnings from sb_decentered_step
RCS Log:Added signal function to ca_procast
RCS Log:Removed some unused files
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:47  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:02  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.10  2002/10/17 16:52:37  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.9.10.2  2002/09/16 18:11:54  rcatwood
RCS Log:Added read/write pores to read-blocks routines
RCS Log:
RCS Log:Revision 7.9.10.1  2002/09/12 13:53:19  rcatwood
RCS Log:Added decentered mode arrays to freeblocks
RCS Log:Tested with efence and dbmalloc
RCS Log:TODO: fix curvature access bug in fs_change_diffuse (Wei)
RCS Log:
RCS Log:Revision 7.9  2002/05/23 17:28:01  rcatwood
RCS Log:Used dbmalloc to eliminate all memory leaks!
RCS Log:Started close-sb routine to improve multiblock
RCS Log:
RCS Log:Revision 7.8  2001/03/27 11:31:50  rcatwood
RCS Log:Protected error messages from excessive numbers
RCS Log:
RCS Log:Revision 7.7  2001/03/26 17:15:30  rcatwood
RCS Log:Included minimum gradient check for multicell pores
RCS Log:Still need to fix diffusion of alloy and growth of solid, so
RCS Log:that there is not diffusion and growth within a pore.
RCS Log:
*/
