/*RCS Id:$Id: freecsv.c 892 2006-03-10 15:24:59Z rcatwood $*/
#include <stdio.h>
#include <string.h>
#include "../machine.h"
#include "../constants.h"
#include "csv.h"

void free_line(LineData * lp){
   int i;
   #ifdef PC
   fprintf(stderr,"Freeing %i \n",lp->ct);
   #endif
   if (lp->nfields > 0){
      for (i=0;i<lp->nfields;i++){
         free(lp->fields[i]);
   #ifdef PC
         fprintf(stderr,"%i... ",i);
   #endif
      }
   }
   #ifdef PC
   fprintf(stderr,"\n");
   #endif
   lp->nfields = 0;
   free (lp->fields);
   free(lp);
}

void free_csv_data (CsvData * cp){
   int i;
   for (i=0;i<cp->line_count;i++){
      free_line((cp->lines[i]));
   }
   for (i=0;i<cp->nheaders;i++){
      free_line((cp->headers[i]));
   }
   free(cp->lines);
   free(cp->headers);
   cp->nheaders=cp->nlines=cp->line_count=0;
}

void free_float_data(CsvFloat * cp){
   int i;
   for (i=0;i<cp->nheaders;i++){
      free_line((cp->headers[i]));
   }
   for (i=0;i<cp->line_count;i++){
      free(cp->data[i]);
   }
   free (cp->data);
   free (cp->headers);
   cp->nheaders = 0;
   cp->nlines=0;
   cp->line_count=0;
   cp->nfields=0;
}
/*
RCS Log:$Log$
RCS Log:Revision 1.1  2006/03/10 15:24:59  rcatwood
RCS Log:Added read_phase_diag for phasediagram lookup table
RCS Log:
RCS Log:Revision 1.1.2.1  2004/07/28 10:39:06  rcatwood
RCS Log:Added copies of read-list files suitably modified
RCS Log:
RCS Log:Revision 9.2  2003/12/10 17:36:23  kerman
RCS Log:added unit conversions & fixed for counting number of fields from the header
RCS Log:
RCS Log:Revision 1.1.2.3  2003/02/25 19:43:58  kerman
RCS Log:change the unit system from BS to SI as it's necessary for decentred square
RCS Log:
RCS Log:Revision 2.2.4.2  2003/01/15 20:05:41  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 2.2.2.1  2003/01/09 16:26:29  rcatwood
RCS Log:Sorted out several memory prblems.
RCS Log:Modified to handle allvac's data as well as fluent data
RCS Log:
RCS Log:Revision 2.2  2002/12/13 17:04:25  rcatwood
RCS Log:Changed to a part of ca source treeh
RCS Log:
RCS Log:Revision 2.1  2002/10/17 16:56:01  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 1.2  2002/09/06 16:10:55  rcatwood
RCS Log:Changed line structure to double-dereferencet to improve reallocation efficiency
RCS Log:
RCS Log:Revision 1.1  2002/09/06 12:52:36  rcatwood
RCS Log:Cured all memory allocation problems .. I hope.
RCS Log:
*/
