/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* readgeoplus.h                                                */
/* Header file defining default values via cpp operatives       */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Aug 16, 1998                                                 */
/****************************************************************/
/*RCS Id:$Id: readgeoplus.h 887 2006-03-01 18:21:01Z rcatwood $*/
/****************************/
/*                          */
/*  ADDING OPTIONS          */
/*                          */
/**************************************************/
/*                                                */
/* 1. add member to the structure                 */
/* 2. add default value                           */
/* 3. add lines to set_geo_defaults               */
/* 4. add parsing lines to read_geo_values        */
/* 5. modify read_bin_blocks and write_bin_blocks */
/*    as necessary (if pointer members are added) */
/* 6. guard the option functions with a flag      */
/*    as necessary                                */
/*                                                */
/**************************************************/


#ifndef READGEOPLUS_H
#define READGEOPLUS_H

/****************************************************************/
/* Define all of the default geometry values below to be used   */
/* if the user does not specify them.                           */
/****************************************************************/
#define D_FS_GROW 1.0
#define D_NSB 1                 /* # sub-blocks in x,y,z        */
#define D_SIZE_CELL 1e-4                 /* # sub-blocks in x,y,z        */
#define D_NC_SB 50              /* total # cells in x,y,z       */
#define D_SIZE_BB 7.0           /* size of big-block            */
#define D_FINISH_TIME 200.0     /* time to stop simulation      */
#define D_DELT 0.1              /* ca time step                 */
#define D_TINIT 1190            /* initial temperature          */
#define D_PINIT 1.0           /* initial pressure atm          */
#define D_DEL_TEMP 1.0          /* fixed T drop for testing     */

#define D_WINDOW_VELO 0.0       /* window velocity */ /*by Wei WANG 11-07-02*/
#define D_NZONES 1              /* dnumber of zones in subblock */
#define D_WINDOW_DISP 0.0       /* window displacement */ /*by Wei WANG 11-07-02*/
#define D_ISO_COEF1 0.0 	/* curved isotherm dong*/
#define D_ISO_COEF2 0.0		/*curved isotherm dong*/
#define D_VELO_COEF 0.0          /*varying V*/
#define D_GRAD_COEF 0.0         /*varying G */
#define D_FIDAP_VEL 0.1         /* vel. of VAR filling          */
#define D_FIDAP_TMIN 500.0      /* min. T if no FIDAP result    */
#define D_FIDAP_TMAX 2000.0     /* max. T if no FIDAP result    */
#define D_FIDAP_STATE 1    /* steady - 0/transient -1 state of temp. */
#define D_TCTRACE_FILE "trace.dat"
#define D_FIDAP_FILE "trace.dat"

#endif /* READGEOPLUS_H */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.2.8.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.3  2003/11/17 18:33:14  hdong
RCS Log:
RCS Log:for varying the pulling velocity and thermal gradient
RCS Log:
RCS Log:Revision 9.2  2003/11/03 19:14:26  hdong
RCS Log:
RCS Log:log message
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:39  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.2.2.4  2003/03/14 16:41:47  hdong
RCS Log:Fixed temperature option selection for re-start.
RCS Log:Fixed output_excel for restart case
RCS Log:
RCS Log:Revision 8.2.2.3  2003/03/13 15:32:10  rcatwood
RCS Log:Added histogram zone input in geoplus file
RCS Log:
RCS Log:Revision 8.2.2.2  2003/01/15 19:02:01  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:03  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.1  2002/10/17 16:52:38  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 7.0.14.1  2002/08/22 15:13:43  ww1
RCS Log:Merge of Wei Wang's decentered octahedron/square method
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:55:38  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:36  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.3  2000/05/04 18:36:45  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.2  2000/03/06 14:11:59  rcatwood
RCS Log:removed Cinit from readgeoplus, in matprops now!
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 1.2  2000/02/23 15:54:07  xxu
RCS Log:weighting fact of z direction
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.1  1999/12/16 12:37:36  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
