/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/* readmat.h                                                    */
/* Header file defining default values via cpp operatives       */
/****************************************************************/
/****************************************************************/
/* Written by Peter D. Lee & Robert C. Atwood, Imperial College */
/* Aug 16, 1998                                                 */
/*RCS ID$Id: readmat.h 887 2006-03-01 18:21:01Z rcatwood $*/
/****************************************************************/
#ifndef READMAT_H
#define READMAT_H

/****************************************************************/
/* Define all of the default values below to be used            */
/* if the user does not specify them.                           */
/****************************************************************/
#define D_TSTART_OFFSET 5         /* the offset value added by default to the liquidus temp */
#define D_TLIQ 1180.0             /* liquidus temperature [C]     */
#define D_TSOL 1120.0             /* solidus temperature [C]     */
#define D_TEUT 1000.0           /* eutectic temperature [C]      */ 
#define D_LATENTH 1.44          /* latent heat [J/mm^3]         */
#define D_RHO 7700.0              /* density [g/mm^3]             */
#define D_CP 0.83               /* Cp [J/g/K]                   */
#define D_Q 0.05                /* Heat flux [W/mm^2]           */
#define D_SURF_TENS 0.9e-7      /* Surface tension [mK]         */
#define D_GG_CONST 1e-5       /* rain growht const M/s/K     */
#define D_GG_CUB 0.0
#define D_CINIT 1.0            /* initial concentration gas   */
#define D_DLIQ 1.0e-8           /*     */
#define D_DSOL 1.0e-9       /*      */
#define D_PART_COEF 0.1       /*      */
#define D_CINIT_ALLOY 1.0;
#define D_DLIQ_ALLOY 1.0e-9;
#define D_DSOL_ALLOY 1.0e-13;
#define D_PART_COEF_ALLOY 0.13;
#define D_M_ALLOY -7.1212;
#define D_GIBBS_THOMSON 1e-7   /*by Wei WANG 11-07-02*/
/* porpsity defautls*/
#define D_PTSIG 0.1       /*      */
#define D_PLIMRAD 2e-5 /* */
#define D_PTN  2      /*      */
#define D_PNPHAMAX 5.0e+9       /*      */
#define D_BINSIZE 0.01       /*      */

/****************************************************************/
/* Define all of the default values below to be used            */
/* if the user does not specify them.                           */
/****************************************************************/
#define D_NUC_MODEL 1           /* Use Rappaz model by default  */
#define D_GD_MAX 60.0           /* max. grain density per [mm^3]*/
#define D_GD_MAX_BEUT 60.0           /* max. grain density per [mm^3]*/
#define D_GD_MAX_TEUT 60.0           /* max. grain density per [mm^3]*/
#define D_TN 20.0               /* centre of gaussian [K]       */
#define D_TSIGMA 5.0            /* variation in gaussian [K]    */
                                /* Variables for HETEROGENIOUS  */
#define D_N_HET  20             /* number of het. nuclei        */

#endif /* READMAT_H */

/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.2.2.2  2006/02/01 14:16:25  lthuinet
RCS Log:#update change of the calculation of supersaturation for gas in multicomponent
RCS Log:
RCS Log:Revision 10.2.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.2  2005/12/01 14:38:02  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.14.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2.4.1  2004/03/09 11:30:53  rcatwood
RCS Log:Changed to read materials properties from separate files for alloy and gas
RCS Log:
RCS Log:Revision 9.2  2003/10/23 17:33:27  rcatwood
RCS Log:added default eutectic temp. Updated example ctrl.in file
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:39  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.8.2  2003/01/15 19:02:01  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:48  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log: Trimmed the in-file log.
*/
