/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/
/*New function for the multi-component diffusion*/
/*           2000/09/28          achirazi        */

/*RCS Id:$Id: sb_diffuse_alloy_multi.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "blocks.h"
#include "matprops.h"
#include "multi_diff_props.h"
#include "machine.h"
#include "ca_matrix.h"
#include "sb_diffuse.h"

extern CA_FLOAT get_dl (CA_FLOAT temp);
extern CA_FLOAT get_ds (CA_FLOAT temp);
extern CA_FLOAT getav_d (CA_FLOAT dl, CA_FLOAT ds, CA_FLOAT fs);
extern int analythic (BB_struct * bp, int kk, int jj, int ii);
extern int interpolate (Ctrl_str * cp, BB_struct * bp, int cell_index, CA_FLOAT * cell_temp_in, int sbnum, int inter_flag,
                        CA_FLOAT cell_temperature);
extern int fcopy_surf (CA_FLOAT * big, CA_FLOAT * lit, Frame * cubeptr_local, int fcode, int type_local, int dir);

int sb_diffuse_alloy_multi (BB_struct * bp, int sbnum)
{

#ifdef CHIRAZI
  int type;
  Frame *cubeptr;
  int errflg = 0, fileflag = 0, errors = 0, cell_temp_on;
  int nx, ny, nz, tsteps, neut, nbeut, nteut;
  int anal_call, part_count;
  int g;
  int dump, not_casting_counter = 0;
  CA_FLOAT **buffer;            /* local temp storage area for concentration values */
  CA_FLOAT **local_diff_matrix_liq;     /* local diffusion matrix in liquid */
  CA_FLOAT **local_diff_matrix_sol;     /* local diffusion matrix in solid */
  CA_FLOAT term1, term2, term3, term4, term5, term6;
  CA_FLOAT fs_corrected_primary, fs_corrected_eutectic;
  Value_struct **multi_conc_ptr;        /* concentrations of different solutes in each cell */
  Value_struct *local_v_struct;
  CA_FLOAT *Cinit_multi_ptr;    /* initial concentration for each solute phase */
  CA_FLOAT **Clim_multi_ptr;
  CA_FLOAT *liq_diff_ptr;
  CA_FLOAT *sol_diff_ptr;
  CA_FLOAT *part_multi_ptr;
  CA_FLOAT *slope_multi_ptr, *conc_anal;
  CA_FLOAT *local_liq, *local_sol, **local_buffer;
  CA_FLOAT **old, *new, *fixed;
  CA_FLOAT *big_fs, *lit_fs, *big_fs_old, *lit_fs_old;
  CA_FLOAT extra_fs;
  int inter_flag;
  int loop_counter;

  static int wmess = 0, emess = 0, courant_messg = 0;
  int *oni, *onip, *onip_2, *onend;
  int step_counter, ele_num, inter_count;
  int itter_done = TRUE;
  int itter_control;
  SB_struct *sp;
  Ctrl_str *cp;
  MultiS_struct *ms;
  Nuc_str *np;
  int t, i, j, k, l, m, n, ele_1, total_cell_num, index, index_pad;
  CA_FLOAT total_concentration[3];
  CA_FLOAT new_sol, OldS, NewS, partcoef, fs_av, r_eff, Cinit, cell_c, cell_avr, SUM, SUM_LIQ;
  CA_FLOAT sum1, sum2, constant_1;
  CA_FLOAT **sol_alloy_values, **newfs_corrected_values, **oldfs_updated_values;
  CA_FLOAT old_alpha, new_alpha, alpha_ratio, conc, f_ratio, f_l;       /*readability variables */
  CA_FLOAT **osolm, **nsolm;
  CA_FLOAT *op, *npm, *npn, *opm, *opn, flux, nbconc, *nsol, *osol, dxsq, dt, nbsum;
  CA_FLOAT *opm_local, *opn_local, *npm_local;
  CA_FLOAT *tot_m, *tot_n, *solid_n_eut_m, *solid_n_eut_n, *newfs_corrected;
  CA_FLOAT *tot_m_start, *tot_n_start, *tot_old_m_start, *tot_old_n_start, *solid_n_eut_m_start, *solid_n_eut_n_start;
  CA_FLOAT *local_dfs, *dfs_start;
  CA_FLOAT *tot_old_m, *tot_old_n;
  CA_FLOAT *oldfs, *oldfs_start, *newfs, *newfs_start, *temp_fs;
  CA_FLOAT *ofs, *nfs;
  CA_FLOAT rmax, rmin, fstot;
  CA_FLOAT r, rs, rl, ds, rsrl, dl, cell_temp, Tliq, cell_temp_2, cellds, celldl, dtx, dmax, dmin, d;   /*solid, liquid */
  CA_FLOAT Tunder, T_Nuc_Thres, T_Nuc_Thres_pri, T_Nuc_Thres_liq;
  CA_FLOAT minv, fixfs, fs_not_corrected;
  CA_FLOAT *fs_n_eut, *fs_b_eut, *fs_t_eut, *fs_b_eut_old, *fs_n_eut_old, *dfs_primary, *dfs_eutectic;
  CA_FLOAT kmInv, Clim, ClimInv, KInv;
  CA_FLOAT Climm, ClimInvm, kmClimInv, KInvm, beutvalm, teutvalm, beuttempm, km, Cinitm;
  CA_FLOAT knInv, Climn, ClimInvn, knClimInv, KInvn, beutvaln, beutvalnsol, teutvaln, beuttempn, kn, teuttemp, Cinitn;
  int *bin_grain_index, *ter_grain_index;
  int *bin_grain_index_start, *ter_grain_index_start;

/*defining local variables*/
  CA_FLOAT kmm2, kmn2, kmm, kmn, EXP_1, EXP_2, EXP_3, FUN_1m_old, FUN_1m_new, FUN_1n_old, FUN_1n_new, FUN_2;
  CA_FLOAT delta_mass[6];
  CA_FLOAT FUN_1n_nb;
  CA_FLOAT kmm_old, kmn_old;
  CA_FLOAT D_ratio, solid_f, nbsolid_f;
  CA_FLOAT nbconc_2, nbsolid_f_2;
  CA_FLOAT r_liq[10][10], r_sol[10][10], r_av[10][10], tot_sol[10], FUN_new[6];
  CA_FLOAT local_tp[10], local_te[10], local_max[10], Ctot[6], Ctot_old[6];     /* these are fusion, eutectic */

/*temperatures and concentrations for different solute phases */
  CA_FLOAT limit, test;
  CA_FLOAT part_1, part_2, part_3, part_4, part_5;
  int m4, m5, m6, bb, neighbour_count, neighbour_count_eut;
  CA_FLOAT **old_rart_coef;
  CA_FLOAT *current_conc;
  CA_FLOAT fs_corrected, sol_corrected;
  FILE *fptr1, *fptr2, *fptr3, *fptr4;
  FILE *debug_fptr;
  FILE *mytemp;
  int not_ter_eut_cell_counter, corrected_cell_counter, only_liquid_counter;
  int *binary_flag, *ternary_flag;
  int *bin_flag_start, *ter_flag_start;
  int nc, q, h, c_eut;
  int fr, m1, m2, m3, ternery_count;
  CA_FLOAT Clim_count, minv_new, conc_new;
  CA_FLOAT part_coef_corrected[6];
  CA_FLOAT **old_part_coef;
  CA_FLOAT sol_corrected_m, sol_corrected_n, residual[6], residual_new[6];
  int *cell_was_corrected;

/************************************************/
/* set up local neighbourhood */
/* use 6cell only for now     */
  anal_call = 0;
  fstot = 0;
  if (bp->ctrl->eut_nuc_option == FALSE) {
    T_Nuc_Thres_pri = 0.5;
    if (bp->ctrl->strontium == FALSE) {
      T_Nuc_Thres_liq = T_Nuc_Thres_pri * 2.0;
    } else {
      T_Nuc_Thres_liq = T_Nuc_Thres_pri / 2.0;
    }
  }
  oni = bp->nbhd.onq;           /*padded */
  onip = oni;
  onip_2 = oni;
  onend = oni + 6;
/* set up local values and pointers */
  cell_temp_on = FALSE;
  if (bp->ctrl->use_cell_temp == TRUE) {
    cell_temp_on = TRUE;
  }
  cubeptr = &(bp->cubeptr);
  sp = bp->sb[sbnum];
  cp = bp->ctrl;
  bp->cubeptr.curr = sbnum;
  nx = bp->nc[0];
  ny = bp->nc[1];
  nz = bp->nc[2];
  nc = total_cell_num = nx * ny * nz;
  ele_num = cp->NUM_COMP;       /* number of elements in the alloy */
  ele_1 = ele_num - 1;
/****************multi-component values****************/
  ms = &(bp->MultiSvals);       /*local properties structure */
  np = &(bp->nprops);
/****************************************************************/
  local_diff_matrix_liq = ms->Diff_matrix_liq;
  local_diff_matrix_sol = ms->Diff_matrix_sol;
  Cinit_multi_ptr = ms->Cinit_multi;
  Clim_multi_ptr = ms->Clim_multi;
  slope_multi_ptr = ms->slope_multi;
  liq_diff_ptr = ms->LDiff_multi;
  sol_diff_ptr = ms->SDiff_multi;
  part_multi_ptr = ms->part_coef_multi;
/*****************************************************/

  tot_m = tot_m_start = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
  tot_n = tot_n_start = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
  tot_old_m = tot_old_m_start = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
  tot_old_n = tot_old_n_start = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
  solid_n_eut_m = solid_n_eut_m_start = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
  solid_n_eut_n = solid_n_eut_n_start = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));

  old_part_coef = (CA_FLOAT **) calloc (ele_1, sizeof (CA_FLOAT *));

  for (i = 0; i < ele_1; i++) {
    old_part_coef[i] = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));
  }

  cell_was_corrected = (int *) calloc (nc, sizeof (int));
  local_dfs = dfs_start = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT));

  if (bp->ctrl->scheil == TRUE) {
    fprintf (stderr, "ERROR: sb_diffuse_alloy_multi: Sorry, you cannot use SCHIEL mode and PHASE DIAGRAM mode simultaneously.\n");
    exit (100);
  } else {
    newfs = nfs = newfs_start = bp->ftmp_one;
    oldfs = ofs = oldfs_start = sp->c_fs;
    /*oldfs=ofs=oldfs_start=bp->ftmp_one_old; */
    newfs_corrected = sp->c_fs_corrected;

  }                             /*end of schiel test */

  for (i = 0; i < ele_1; i++) {
    for (j = 0; j < nc; j++) {
      old_part_coef[i][j] = ms->part_coef_matrix[i][j];
    }
  }
/************************************************************/
/*set up parameter values*/
/*try to move to pre-calc*/
  if (bp->ctrl->procast == FALSE) {
    cell_temp = cell_temp_2 = bp->sb[sbnum]->Tvals.Tavg;
  }
  tsteps = bp->ctrl->diffuse_step;
  dt = bp->delt / tsteps;
  dxsq = bp->size_c[0] * bp->size_c[0];
  /*delta t over delta x squared */
  dtx = (bp->delt / (bp->size_c[0] * bp->size_c[0])) / tsteps;
/***************temperature dependent diffusion coefficient******/
/*****for Si****************/

  if (bp->ctrl->temp_dep_diff == TRUE) {
    ms->Diff_matrix_liq[0][0] = (0.08e-07) * exp (-2865 / (cell_temp + 273.15));
    ms->Diff_matrix_sol[0][0] = (2.02e-04) * exp (-16069 / (cell_temp + 273.15));
/*ms->Diff_matrix_liq[0][0]=(2.02e-04)*exp((-136e+03)/(8.314*(cell_temp+273.15))); */
/*ms->Diff_matrix_sol[0][0]=(2.02e-09)*exp((-136e+03)/(8.314*(cell_temp+273.15))); */

/*****for Cu****************/

    ms->Diff_matrix_liq[1][1] = (1.05e-07) * exp (-2856 / (cell_temp + 273.15));
    ms->Diff_matrix_sol[1][1] = (4.8e-05) * exp (-16069 / (cell_temp + 273.15));
/*ms->Diff_matrix_liq[1][1]=(1.05e-07)*exp(-2856/cell_temp); */
/*ms->Diff_matrix_sol[1][1]=(4.8e-05)*exp(-16069/cell_temp); */

/******cross diffusional values*******/

    ms->Diff_matrix_liq[0][1] = ms->Diff_matrix_liq[1][0] = (ms->Diff_matrix_liq[0][0] + ms->Diff_matrix_liq[1][1]) / 20.0;
    ms->Diff_matrix_sol[0][1] = ms->Diff_matrix_sol[1][0] = (ms->Diff_matrix_sol[0][0] + ms->Diff_matrix_sol[1][1]) / 20.0;

  }
/********************************end of calculations**********************/

  for (test = 0.0, i = 0; i < ele_1; i++) {
    for (j = 0; j < ele_1; j++) {
      r_liq[i][j] = dtx * (ms->Diff_matrix_liq[i][j]);
      r_sol[i][j] = dtx * (ms->Diff_matrix_sol[i][j]);
      test += r_liq[i][j];
    }
  }
/* check courant stability*/
  limit = 0.16;
  if (test > limit) {
    if (courant_messg < MAX_WARN_MSG)
      fprintf (stderr, "SB_DIFFUSE_ALLOY: WARNING: Possible instability by Courant criterion!\n limit: , %1.2e, test: %1.2e\n", limit,
               test);
    courant_messg++;
#ifdef ERROR_EXIT
    if (courant_messg > WARN_EXIT_LIMIT) {
      fprintf (stderr, "SB_DIFFUSE_ALLOY: ERROR_EXIT: Courant Stability warning limit exceeded. %i warnings.\n", courant_messg);
      exit (courant_messg);
    }
#endif /*ERROR_EXIT */
  }

 /*****************************************************/
  fptr1 = fopen ("total_conc.out", "a+");
  fptr4 = fopen ("bin_grain.out", "a+");
#ifdef ANALYTHIC
  mytemp = fopen ("analythic.out", "a+");
#endif

  binary_flag = bin_flag_start = bp->bin_flag;
  ternary_flag = ter_flag_start = bp->ter_flag;

  bin_grain_index = bin_grain_index_start = bp->bin_grain_index;
  ter_grain_index = ter_grain_index_start = bp->ter_grain_index;

  /* make a copy of the solute concentration matrix */
  old = ms->temp_multi;
  for (m = 0; m < ele_1; m++) {
    new = nsol = &(sp->c_sol_alloy_multi[m][0]);
    bp->cubeptr.ivalue = ms->Cinit_multi[m];
    sol_alloy_values = bp->multi_conc[m]->block_array;
    errflg += fcopy_matrix (PAD, &(old[m][0]), nsol, bp, sol_alloy_values, sbnum);      /* (flag, to, from, bp) */
    bp->cubeptr.ivalue = 0.0;
  }
     /***********************************************/

 /****************calculation of the limiting concentration for each solute****/

  if (bp->ctrl->thermocalc == FALSE) {

    for (m1 = 0; m1 < ele_1; m1++) {    /* loop over all solutes */
      minv = 1 / ms->slope_multi[m1];

      for (k = 0, index = 0, index_pad = 0; k < nz; k++) {      /* loop cells in z direction */
        for (j = 0; j < ny; j++) {      /* loop cells in y direction */
          for (i = 0; i < nx; i++) {    /* loop cells in x direction */

            cell_temp = bp->sb[sbnum]->c_temp[index];
             /********count for the liquidus hyper-surface**********/
              for (m2 = 0, Clim_count = 0; m2 < ele_1; m2++) {
              if (m2 != m1) {
                minv_new = 1 / ms->slope_multi[m2];
                conc_new = *(&old[m2][index_pad] + bp->cubeptr.flist[0][START]);
                Clim_count += minv_new * conc_new;
              }
            }                   /* end m2 loop */
            ms->Clim_multi[m1][index] = (cell_temp - bp->mprops.alloyprops.T_pure - Clim_count) * minv;
            fprintf (stderr, "SORRY:sb_diffuse_alloy_multi:this section has been mangled, needs rewriting!\n");
            exit (0);

            index++;
            index_pad++;
          }                     /* end x loop */
          index_pad += 2;
        }                       /* end y loop */
        index_pad += 2 * (nx + 2);
      }                         /*  end z loop */
    }                           /* end m1 loop */

  } else {

    for (k = 0, index = 0; k < nz; k++) {       /* loop cells in z direction */
      for (j = 0; j < ny; j++) {        /* loop cells in y direction */
        for (i = 0; i < nx; i++) {      /* loop cells in x direction */

          cell_temp = bp->sb[sbnum]->c_temp[index];
            if (*binary_flag == 1 && bp->ctrl->interpolate == 3 && *ternary_flag == 0) {
            inter_flag = CONC_MULTI_MONO;
            inter_count = interpolate (cp, bp, index, &cell_temp, sbnum, inter_flag, cell_temp_2);
          } else if (*binary_flag == 0 && *ternary_flag == 0) {
            inter_flag = CONC_MULTI;
            inter_count = interpolate (cp, bp, index, &cell_temp, sbnum, inter_flag, cell_temp_2);
          } else if (*ternary_flag == 1) {
            for (bb = 0; bb < ele_1; bb++) {
              ms->Clim_multi[bb][index] = ms->ter_eut_max[m];
            }
          }

          binary_flag++;
          ternary_flag++;
          index++;
        }                       /* end x loop */
        binary_flag += 2;
        ternary_flag += 2;
      }                         /* end y loop */
      binary_flag += 2 * (nx + 2);
      ternary_flag += 2 * (nx + 2);
    }                           /*  end z loop */

  }                             /* end of thermocalc test */

 /****************************************end of limiting values calculation********************/

/**********************************************************/
/*              start time stepping                       */
/**********************************************************/

  loop_counter = 1;             /* counter variable for the itteration loop on mass conservation */
  while (itter_done) {

    /* make a copy of the solute concentration matrix */
    old = ms->temp_multi;
    for (m = 0; m < ele_1; m++) {
      new = nsol = &(sp->c_sol_alloy_multi[m][0]);
      bp->cubeptr.ivalue = ms->Cinit_multi[m];
      sol_alloy_values = bp->multi_conc[m]->block_array;
      errflg += fcopy_matrix (PAD, &(old[m][0]), nsol, bp, sol_alloy_values, sbnum);    /* (flag, to, from, bp) */
      bp->cubeptr.ivalue = 0.0;
    }
    old = ms->temp_multi;
     /***********************************************/

    oldfs = oldfs_start = sp->c_fs;
    local_dfs = dfs_start;
    newfs_corrected = sp->c_fs_corrected;
    newfs = newfs_start + bp->cubeptr.flist[0][START];

    fs_b_eut = sp->fs_b_eut;
    fs_b_eut_old = sp->fs_b_eut_old;
    fs_t_eut = sp->fs_t_eut;
    fs_n_eut = sp->fs_n_eut;
    fs_n_eut_old = sp->fs_n_eut_old;
    dfs_primary = sp->cell_dfs_primary;
    dfs_eutectic = sp->cell_dfs_eutectic;

    tot_m = tot_m_start;
    tot_n = tot_n_start;
    tot_old_m = tot_old_m_start;
    tot_old_n = tot_old_n_start;
    solid_n_eut_m = solid_n_eut_m_start;
    solid_n_eut_n = solid_n_eut_n_start;

    binary_flag = bin_flag_start + bp->cubeptr.flist[0][START];
    ternary_flag = ter_flag_start + bp->cubeptr.flist[0][START];

    bin_grain_index = bin_grain_index_start + bp->cubeptr.flist[0][START];
    ter_grain_index = ter_grain_index_start + bp->cubeptr.flist[0][START];
    /************************************************************************/

    /* initialise all the pointers before each iteration */

    not_ter_eut_cell_counter = 0;
    corrected_cell_counter = 0;
    only_liquid_counter = 0;

    /* residual array for the convergence control */
    for (i = 0; i < ele_1; i++) {
      residual[i] = 0.0;
      residual_new[i] = 0.0;
    }

    /* residual array for the convergence control */
    for (i = 0; i < ele_1; i++) {
      delta_mass[i] = 0.0;
    }

    /* reset the array for the cell fraction solid correction flag */
    for (i = 0; i < nc; i++) {
      cell_was_corrected[i] = 0;
    }

    /* effective liquid con per cell and per solute */
    npm = &(sp->c_sol_alloy_multi[0][0]);
    npn = &(sp->c_sol_alloy_multi[1][0]);

    opm = &(old[0][0]) + bp->cubeptr.flist[0][START];
    opn = &(old[1][0]) + bp->cubeptr.flist[0][START];

    beutvalm = ms->bin_eut_max[0];
    beutvaln = ms->bin_eut_max[1];
    beutvalnsol = ms->bin_eut_max[2];

    teutvalm = ms->ter_eut_max[0];
    teutvaln = ms->ter_eut_max[1];

    beuttempm = ms->bin_eut_temp[0];
    beuttempn = ms->bin_eut_temp[1];
    teuttemp = ms->ter_eut_temp[0];

    Cinitm = ms->Cinit_multi[0];
    Cinitn = ms->Cinit_multi[1];

    not_casting_counter = 0;

    /* end of pointer initialisation */

      /************************************************/
    /* now calculate the finite difference */
      /************************************************/
    /* DIFFUSION LOOP                               */
      /************************************************/

    /* Run through all cells updating as needed.    */
      /************************************************/
    for (k = 0, index = 0, index_pad = 0; k < nz; k++) {        /* loop cells in z direction */
      for (j = 0; j < ny; j++) {        /* loop cells in y direction */
        for (i = 0; i < nx; i++) {      /* loop cells in x direction */

          /* set the local array value for fraction solid */
          *newfs_corrected = *newfs;

          cell_temp = bp->sb[sbnum]->c_temp[index];

          /* skip cells that are not in the casting */
          if (*newfs == NOT_CASTING) {
            dump = 0;
            not_casting_counter++;
          } else {

            /* consider all different solutal phases */
            for (m = 0; m < ele_1; m++) {

              opm_local = &(old[m][0]) + bp->cubeptr.flist[0][START];

              local_liq = &(ms->Diff_matrix_liq[m][0]);
              local_sol = &(ms->Diff_matrix_sol[m][0]);
              Cinit = ms->Cinit_multi[m];

              SUM_LIQ = 0.0;
              SUM = 0.0;

              KInv = 1.0 / ms->part_coef_matrix[m][index];
              kmm = 1.0 - ms->part_coef_matrix[m][index];
              kmInv = 1 / kmm;
              FUN_1m_new = (1.0 - (kmm * *newfs));
              FUN_1m_old = (1.0 - (kmm * *oldfs));
              Clim = ms->Clim_multi[m][index];
              ClimInv = 1 / Clim;
              kmClimInv = ClimInv * kmInv;

              /* unroll out of loop once stable!! */

               /***************************************************/
              /* for each cell and each solute phase, take into account */
              /* the variation in the concentration of all the other phases */
               /****************************************************/

              for (n = 0; n < ele_1; n++) {
                kmn = 1.0 - ms->part_coef_matrix[n][index];
                FUN_1n_old = 1.0 - (kmn * (*oldfs));
                FUN_1n_new = 1.0 - (kmn * (*newfs));
                opn_local = &(old[n][0]) + bp->cubeptr.flist[0][START];
                conc = *(opn_local + index_pad);

                for (nbsum = 0, onip = oni; onip < onend; onip++) {
                  fs_av = 0.5 * (*newfs + *(newfs + *onip));
                  r_av[m][n] = r_sol[m][n] * fs_av + r_liq[m][n] * (1.0 - fs_av);
                  nbconc = *(opn_local + index_pad + *onip);

               /******************************************************NEW**************/

                  EXP_1 = (nbconc - conc);
                  SUM += r_av[m][n] * EXP_1;

                }               /* end of neighbour sum loop */

              }                 /* end of the n loop */

             /******for each solute phase at each cell the new conc is calculated ***/

              if ((*binary_flag == 0) && (*ternary_flag == 0)) {
                sp->c_sol_alloy_multi[m][index] = (*(opm_local + index_pad) * FUN_1m_old + SUM) / FUN_1m_new;
                if (*newfs < 0.0)
                  *newfs = *oldfs;
                if (*newfs > 1.0)
                  *newfs = 1.0;
                *local_dfs = *newfs - *oldfs;
                *fs_n_eut = *newfs;
                *fs_b_eut = 0.0;
                if (m == 0) {
                  *solid_n_eut_m = sp->c_sol_alloy_multi[0][index] * ms->part_coef_matrix[0][index] * *newfs;
                  Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
                  Ctot[0] = *tot_m = sp->c_sol_alloy_multi[0][index] * (1.0 - (1.0 - ms->part_coef_matrix[0][index]) * *newfs);
                }
                if (m == 1) {
                  *solid_n_eut_n = sp->c_sol_alloy_multi[1][index] * ms->part_coef_matrix[1][index] * *newfs;
                  Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];
                  Ctot[1] = *tot_n = sp->c_sol_alloy_multi[1][index] * (1.0 - (1.0 - ms->part_coef_matrix[1][index]) * *newfs);
                }
              }

              else if (*binary_flag == 1 && *ternary_flag == 0) {

                sp->c_sol_alloy_multi[m][index] = (*(opm_local + index_pad) + SUM);
                if (*fs_n_eut_old > 0.0) {
                  *fs_n_eut = *fs_n_eut_old + *dfs_primary;
                } else {
                  *fs_n_eut = *fs_n_eut_old;
                }
                *fs_b_eut = *fs_b_eut_old + *dfs_eutectic;
                /* if (*fs_b_eut<0.0) *fs_b_eut=0.0; */
                if (*fs_b_eut < 0.0)
                  *fs_b_eut = *fs_b_eut_old;

                *newfs = *fs_n_eut + *fs_b_eut;

                if (*newfs > 1.0) {
                  extra_fs = *newfs - 1.0;
                  *newfs = 1.0;
                  *fs_b_eut -= extra_fs;
                  if (*fs_b_eut < 0.0) {
                    *fs_b_eut = *fs_b_eut_old;
                    *fs_n_eut = *oldfs - *fs_b_eut;
                  }
                }
                *local_dfs = *newfs - *oldfs;
                if (m == 0) {
                  Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
                  *solid_n_eut_m = *fs_n_eut * ms->part_coef_matrix[0][index] * sp->c_sol_alloy_multi[0][index];
                  /* *solid_n_eut_m= sp->c_sol_n_eut_multi[0][index]; */
                  Ctot[0] = *tot_m = *solid_n_eut_m + *fs_b_eut * beutvalm + (1.0 - *newfs) * sp->c_sol_alloy_multi[0][index];
                }
                if (m == 1) {
                  Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];
                  *solid_n_eut_n = *fs_n_eut * ms->part_coef_matrix[1][index] * sp->c_sol_alloy_multi[1][index];
                  /* *solid_n_eut_n= sp->c_sol_n_eut_multi[1][index]; */
                  Ctot[1] = *tot_n = *solid_n_eut_n + *fs_b_eut * beutvalnsol + (1.0 - *newfs) * sp->c_sol_alloy_multi[1][index];
                }
              }

              else if (*ternary_flag == 1) {
                *newfs = 1.0;
                /*    *fs_t_eut= *local_dfs= *newfs - *fs_b_eut- *fs_n_eut; */
                /*  sp->c_sol_alloy_multi[m][index]=ms->ter_eut_max[m]; */
                if (m == 0) {
                  Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
                  *solid_n_eut_m = sp->c_sol_n_eut_multi[0][index];
                  /*       Ctot[0]= *tot_m= sp->c_sol_n_eut_multi[0][index] + *fs_b_eut*beutvalm + *fs_t_eut*teutvalm; */
                  Ctot[0] = sp->c_sol_tot_multi[0][index];
                }
                if (m == 1) {
                  Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];
                  *solid_n_eut_n = sp->c_sol_n_eut_multi[1][index];
                  /*      Ctot[1]= *tot_n= sp->c_sol_n_eut_multi[1][index] + beutvalnsol * *fs_b_eut + *fs_t_eut * sp->c_sol_alloy_multi[1][index]; */
                  Ctot[1] = sp->c_sol_tot_multi[1][index];
                }
              }

              if (sp->c_sol_alloy_multi[m][index] < 0) {
                if (emess < MAX_ERR_MSG)
                  fprintf (stderr, "ERROR:sb_diffuse_alloy_multi: Possible instability *npm = %g\n", sp->c_sol_alloy_multi[m][index]);
                emess++;
              }
            }                   /* end of m loop */

           /*********************************************************/

           /********fraction solid solute correction and partition coefficient correction as well as binary and ******/
           /********ternary eutectic detection are calculated here for each cell and*/
           /********each solute phase************************************************/

            /* precalc values per cell */

            km = ms->part_coef_matrix[0][index];
            kn = ms->part_coef_matrix[1][index];

            KInvm = 1.0 / ms->part_coef_matrix[0][index];
            KInvn = 1.0 / ms->part_coef_matrix[1][index];

            kmm = 1.0 - ms->part_coef_matrix[0][index];
            kmn = 1.0 - ms->part_coef_matrix[1][index];

            kmInv = 1 / kmm;
            knInv = 1 / kmn;

            FUN_new[0] = FUN_1m_new = (1.0 - (kmm * *newfs));
            FUN_new[1] = FUN_1n_new = (1.0 - (kmn * *newfs));

            Climm = ms->Clim_multi[0][index];
            Climn = ms->Clim_multi[1][index];

            ClimInvm = 1 / Climm;
            ClimInvn = 1 / Climn;

            kmClimInv = ClimInvm * kmInv;
            knClimInv = ClimInvn * knInv;

            /* precalc finished */

   /** first case only one of the solutes is greater than the PD value **/

            if (*npm > Climm && *npn < Climn && Climn < teutvaln && *newfs < 1 && *newfs >= 0.0 && cell_temp > beuttempm
                && *binary_flag == 0 && *ternary_flag == 0) {

              /* set the flag for the further correction of the partition coefficient */
              cell_was_corrected[index] = 1;
    /***********************************************************************/

              /* correct the fraction solid */
              fs_corrected = kmInv * (1.0 - (Ctot[0] / Climm));
    /**********check for remelt or total solidification*******/
              if (fs_corrected < 0.0) {
                fs_corrected = *oldfs;
              } else if (fs_corrected > 1.0) {
                fs_corrected = 1.0;
              }
    /*********************************************************/

              sol_corrected_n = Ctot[1] / (1.0 - (kmn * fs_corrected));

              if (sol_corrected_n > *npn) {
                sol_corrected_n = *npn;
              }

              if (sol_corrected_n < 0.0) {
                sol_corrected_n = *opn;
              }

              /* save the value of current solute before allocating the new value for the current cell */
              *opn = *npn;
              *npn = sol_corrected_n;
              *opm = *npm;
              *npm = Climm;
      /******************************************************************************************/

              /* save the value of current fraction solid before allocating the new value for the current cell */
              *newfs = *newfs_corrected = fs_corrected;

              *local_dfs = *newfs - *oldfs;
              *fs_n_eut = *newfs;
              *solid_n_eut_m = *npm * km * *newfs;
              *solid_n_eut_n = *npn * kn * *newfs;

              /* copy the old total conc before over writing it by its new value */
              Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
              Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];

              Ctot[0] = *tot_m = *npm * (1.0 - kmm * *newfs);
              Ctot[1] = *tot_n = *npn * (1.0 - kmn * *newfs);
      /********************************************************************/

            }
            /*end of first case */
            else if (*npn > Climn && *npm <= Climm && *npn < teutvaln && *newfs < 1 && *newfs >= 0.0 && cell_temp > beuttempm
                     && *binary_flag == 0 && *ternary_flag == 0) {

              /* set the flag for the further correction of the partition coefficient */
              cell_was_corrected[index] = 1;
    /***********************************************************************/

              /* correct the fraction solid */
              fs_corrected = knInv * (1.0 - (Ctot[1] / Climn));
    /**********check for remelt or total solidification*******/
              if (fs_corrected < 0.0) {
                fs_corrected = *oldfs;
              } else if (fs_corrected > 1.0) {
                fs_corrected = 1.0;
              }
    /*********************************************************/

              sol_corrected_m = Ctot[0] / (1.0 - (kmm * fs_corrected));

              if (sol_corrected_m > *npm) {
                sol_corrected_m = *npm;
              }

              if (sol_corrected_m < 0.0) {
                sol_corrected_m = *opm;
              }

              /* save the value of current solute before allocating the new value for the current cell */
              *opm = *npm;
              *npm = sol_corrected_m;
              *opn = *npn;
              *npn = Climn;
      /******************************************************************************************/

              /* save the value of current fraction solid before allocating the new value for the current cell */
              *newfs = *newfs_corrected = fs_corrected;

              *local_dfs = *newfs - *oldfs;
              *fs_n_eut = *newfs;
              *solid_n_eut_m = *npm * km * *newfs;
              *solid_n_eut_n = *npn * kn * *newfs;

              /* copy the old total conc before over writing it by its new value */
              Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
              Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];

              Ctot[0] = *tot_m = *npm * (1.0 - kmm * *newfs);
              Ctot[1] = *tot_n = *npn * (1.0 - kmn * *newfs);
      /********************************************************************/

            }

            /*end of first case bis */
 /** second case both solutes are greater than PD values **/
            else if (*npm > Climm && *npn > Climn && *npn < teutvaln && *newfs < 1.0 && *newfs >= 0.0 && cell_temp > beuttempm
                     && *binary_flag == 0 && *ternary_flag == 0) {

              /* set the flag for the further correction of the partition coefficient */
              cell_was_corrected[index] = 1;
    /***********************************************************************/

              /* correct fraction solid */
              fs_corrected = (kmInv * (1.0 - (Ctot[0] / Climm)) + knInv * (1.0 - (Ctot[1] / Climn))) / 2.0;
    /**********check for remelt or total solidification*******/
              if (fs_corrected < 0.0) {
                fs_corrected = *oldfs;
              } else if (fs_corrected > 1.0) {
                fs_corrected = 1.0;
              }
    /*********************************************************/

              /* save the value of current fraction solid before allocating the new value for the current cell */

              *newfs = *newfs_corrected = fs_corrected;

              sol_corrected_m = Ctot[0] / (1.0 - (kmm * fs_corrected));
              sol_corrected_n = Ctot[1] / (1.0 - (kmn * fs_corrected));

              if (sol_corrected_m > *npm) {
                sol_corrected_m = *npm;
              }

              if (sol_corrected_m < 0.0) {
                sol_corrected_m = *opm;
              }

              if (sol_corrected_n > *npn) {
                sol_corrected_n = *npn;
              }

              if (sol_corrected_n < 0.0) {
                sol_corrected_n = *opn;
              }

              /* save the value of current solute before allocating the new value for the current cell */
              *opm = *npm;
              *npm = sol_corrected_m;
              *opn = *npn;
              *npn = sol_corrected_n;
      /****************************************************************************************/

              *local_dfs = *newfs - *oldfs;
              *fs_n_eut = *newfs;
              *solid_n_eut_m = *npm * km * *newfs;
              *solid_n_eut_n = *npn * kn * *newfs;

              /* copy the old total conc before over writing it by its new value */
              Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
              Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];

              Ctot[0] = *tot_m = *npm * (1.0 - kmm * *newfs);
              Ctot[1] = *tot_n = *npn * (1.0 - kmn * *newfs);
      /********************************************************************/

            }

            /*end of second case */
            /* third case the binary eutectic is reached */
            else if (*binary_flag == 1 && *newfs < 1.0 && *newfs >= 0.0 && cell_temp > teuttemp && *ternary_flag == 0) {

              /* set the flag for the further correction of the partition coefficient */
              cell_was_corrected[index] = 1;
    /*********************************************/

              if (beutvalm != Climm) {
                fs_corrected_eutectic = (Ctot[0] - Climm - *solid_n_eut_m + *fs_n_eut * Climm) / (beutvalm - Climm);
              } else {
                fs_corrected_eutectic = *fs_b_eut_old;
              }

              if (fs_corrected_eutectic < 0.0) {
                fs_corrected_eutectic = *fs_b_eut_old;
              }

              *fs_b_eut = fs_corrected_eutectic;

              fs_corrected = *fs_b_eut + *fs_n_eut;

              if (fs_corrected > 1.0) {
                extra_fs = fs_corrected - 1.0;
                *fs_b_eut -= extra_fs;
                fs_corrected = 1.0;
                if (*fs_b_eut < 0.0) {
                  *fs_b_eut = *fs_b_eut_old;
                  if (*fs_n_eut_old > 0.0) {
                    *fs_n_eut = fs_corrected - *fs_b_eut;
                  } else {
                    *fs_n_eut = *fs_n_eut_old;
                  }
                }
              }

    /*********************************************************/

              /* save the value of current fraction solid before allocating the new value for the current cell */

              *newfs_corrected = *newfs = fs_corrected;
              *local_dfs = *newfs - *oldfs;

              /* correct the non-eutectic concentration */

              sol_corrected_n = (Ctot[1] - (*fs_b_eut * beutvalnsol)) / (kn * *fs_n_eut + 1.0 - *newfs);
              if (sol_corrected_n > *npn)
                sol_corrected_n = *npn;
              if (sol_corrected_n < 0.0)
                sol_corrected_n = *opn;

    /*********************************************************/
              /* save the value of current solute before allocating the new value for the current cell */
              *opm = *npm;
              *npm = Climm;
              *opn = *npn;
              *npn = sol_corrected_n;
    /***********************************************************************/

              Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
              Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];

              /* *solid_n_eut_m= sp->c_sol_n_eut_multi[0][index]; */
              /* *solid_n_eut_n= sp->c_sol_n_eut_multi[1][index]; */
              *solid_n_eut_m = km * *npm * *fs_n_eut;
              *solid_n_eut_n = kn * *npn * *fs_n_eut;

              Ctot[0] = *tot_m = *solid_n_eut_m + *fs_b_eut * beutvalm + (1.0 - *newfs) * *npm;
              Ctot[1] = *tot_n = *solid_n_eut_n + *fs_b_eut * beutvalnsol + (1.0 - *newfs) * *npn;

            }

            /* end of third case */
            /* fourth case ternary eutectic is reached with or without binary eutectic */
            else if (cell_temp <= teuttemp && *ternary_flag == 0) {

              /* set the flag for the further correction of the partition coefficient */
              cell_was_corrected[index] = 1;
    /***********************************************************************/

              /* set the flag for ternary eutectic detection */
              if (*ternary_flag == 0) {
                *ternary_flag = 1;
                bp->nteut += 1;
              }
    /***********************************************/

              *newfs = *newfs_corrected = 1.0;

              *fs_t_eut = *newfs - *fs_b_eut - *fs_n_eut;
              *opm = *npm;
              *opn = *npn;

              /*  *npm= teutvalm;  */
              /*  *npn= teutvaln;  */
              *npm = sp->c_sol_alloy_multi[0][index];
              *npn = sp->c_sol_alloy_multi[1][index];

              /* copy the old total conc before over writing it by its new value */
              Ctot_old[0] = *tot_old_m = sp->c_sol_tot_old_multi[0][index];
              Ctot_old[1] = *tot_old_n = sp->c_sol_tot_old_multi[1][index];

              *solid_n_eut_m = sp->c_sol_n_eut_multi[0][index];
              *solid_n_eut_n = sp->c_sol_n_eut_multi[1][index];

              Ctot[0] = *tot_m = sp->c_sol_n_eut_multi[0][index] + *fs_b_eut * beutvalm + *fs_t_eut * *npm;
              Ctot[1] = *tot_n = sp->c_sol_n_eut_multi[1][index] + beutvalnsol * *fs_b_eut + *fs_t_eut * *npn;

            }
            /* end of ternary eutectic */
            if (*newfs < 0.0) {
              *newfs = *oldfs;
            }

            if (*newfs > 1.0) {
              *newfs = *newfs_corrected = 1.0;
              *fs_b_eut = *newfs - *fs_n_eut;
            }

            if (cell_was_corrected[index] == 1)
              corrected_cell_counter++;
            if (*newfs == 0)
              only_liquid_counter++;

            /* calculate the total mass of not_casting cells for residual evaluation */

            residual[0] += *tot_m;
            residual[1] += *tot_n;

            /* setting the flags for the nucleation and growth of binary_eutectic */

            if (*npm >= beutvalm && cell_temp <= beuttempm && *binary_flag == 0 && *newfs < 1.0 && *newfs >= 0.0
                && cell_temp > teuttemp && *ternary_flag == 0) {

              /* check for the nucleation threshold criterion and nucleate if satisfied */

              inter_flag = LIQUIDUS;
              inter_count = interpolate (cp, bp, index, &Tliq, sbnum, inter_flag, cell_temp_2);

              Tunder = Tliq - cell_temp;
              if (bp->ctrl->eut_nuc_option == TRUE) {
                T_Nuc_Thres_pri = np->beut_threshold[index];
                if (bp->ctrl->strontium == FALSE) {
                  T_Nuc_Thres_liq = T_Nuc_Thres_pri * 2.0;
                } else {
                  T_Nuc_Thres_liq = T_Nuc_Thres_pri / 2.0;
                }
              }

              if (*newfs > 0.0) {
                T_Nuc_Thres = T_Nuc_Thres_pri;
              }

              if (*newfs == 0.0) {
                T_Nuc_Thres = T_Nuc_Thres_liq;
              }

              /* at least one of the neigbours must be a liquid cell for the eutectic to form */
              /* and at least one of the neighbours of a fully liquid cell must be a eutectic cell for the eutectic growth */

              for (neighbour_count = 0, neighbour_count_eut = 0, onip = oni; onip < onend; onip++) {
                if (*newfs > 0 && *(newfs + *onip) == 0.0) {    /* check for the possible nucleation of the binary eutectic */
                  neighbour_count++;
                }
              }

     /***************************end of check for neighbouring liquid cell**************/

              /* set the binary eutectic flag based on cell nucleation */

              if (Tunder >= T_Nuc_Thres_pri && neighbour_count > 0 && *newfs > 0.0) {
                *binary_flag = 1;
                bp->nbeut += 1;
                /* set the index number for each eutectic cell */
                *bin_grain_index = bp->nbeut;
                fprintf (fptr4, "Binary Eutectic Nucleation: \t cell: %d, Nuc_Temp: %f, eutectic grain index: %d \n ", index,
                         T_Nuc_Thres_pri, *bin_grain_index);
              }

              if (Tunder >= T_Nuc_Thres_liq && *newfs == 0.0) {
                *binary_flag = 1;
                bp->nbeut += 1;
                /* set the index number for each eutectic cell */
                *bin_grain_index = bp->nbeut;
                fprintf (fptr4, "Binary Eutectic Nucleation: \t cell: %d, Nuc_Temp: %f, eutectic grain index: %d \n ", index,
                         T_Nuc_Thres_liq, *bin_grain_index);
              }

              /* end of set the binary eutectic flag for nucleation */

           /***************************** end nucleation check ********************************************/

              /* set the limiting values based on the mono-variant line */

              if (bp->ctrl->interpolate == 3) {
                inter_flag = CONC_MULTI_MONO;
                inter_count = interpolate (cp, bp, index, &cell_temp, sbnum, inter_flag, cell_temp_2);
              }

            }

            /* end the set of binary flag for nucleation */
            /* decide for the eutectic flag based on the growth of existing eutectic cells for the next growth step */
            if (*binary_flag == 1 && *newfs >= bp->fsgrow) {
              for (onip = oni; onip < onend; onip++) {
                if (*(opm + *onip) >= beutvalm && *(newfs + *onip) >= 0.0 && *(newfs + *onip) < 1.0 && *(binary_flag + *onip) == 0) {
                  *(binary_flag + *onip) = 1;
                  *(bin_grain_index + *onip) = *bin_grain_index;
                }
              }
            }

            /* end of the setting of the eutectic flag based on the possible growth of the existing eutectic grains */

            if (*binary_flag == 1) {
              fprintf (fptr4, "%d \t %d \n", index_pad, *bin_grain_index);
            }

            fstot += *newfs;

          }                     /* end of NOT_CASTING loop */

          local_dfs++;
          newfs++;
          newfs_corrected++;
          oldfs++;
          dfs_primary++;
          dfs_eutectic++;
          fs_n_eut++;
          fs_n_eut_old++;
          fs_b_eut_old++;
          fs_b_eut++;
          fs_t_eut++;
          index++;
          index_pad++;

          opm++;
          opn++;
          npm++;
          npn++;
          tot_n++;
          tot_m++;
          tot_old_m++;
          tot_old_n++;
          solid_n_eut_m++;
          solid_n_eut_n++;
          binary_flag++;
          ternary_flag++;
          bin_grain_index++;
          ter_grain_index++;
        }                       /* end of x loop */
        newfs += 2;
        opm += 2;
        opn += 2;
        index_pad += 2;
        binary_flag += 2;
        ternary_flag += 2;
        bin_grain_index += 2;
        ter_grain_index += 2;
      }                         /* end of y loop */
      newfs += 2 * (nx + 2);
      opm += 2 * (nx + 2);
      opn += 2 * (nx + 2);
      index_pad += 2 * (nx + 2);
      binary_flag += 2 * (nx + 2);
      ternary_flag += 2 * (nx + 2);
      bin_grain_index += 2 * (nx + 2);
      ter_grain_index += 2 * (nx + 2);
    }                           /* end of z loop */

/********************************************************************/

    /* check the mass conservation */
    for (m = 0, itter_control = 0; m < ele_1; m++) {
      residual[m] = (residual[m] - (nc - not_casting_counter) * ms->Cinit_multi[m]);
      delta_mass[m] = residual[m] / (nc - not_casting_counter);
      if (fabs (residual[m]) == 0.0) {
        itter_control++;
      }
    }                           /* end of control */

    /* control the convergence for mass conservation of all components */
    if (itter_control == ele_1) {
      itter_done = FALSE;
    } else {

      /* begin the correction of partition coefficient for the total mass conservation for each solute */

      /* re-initialise the pointers */

      newfs = newfs_start + bp->cubeptr.flist[0][START];
      fs_b_eut = sp->fs_b_eut;
      fs_t_eut = sp->fs_t_eut;
      fs_n_eut = sp->fs_n_eut;

      dfs_primary = sp->cell_dfs_primary;
      dfs_eutectic = sp->cell_dfs_eutectic;

      binary_flag = bin_flag_start + bp->cubeptr.flist[0][START];
      ternary_flag = ter_flag_start + bp->cubeptr.flist[0][START];

      tot_m = tot_m_start;
      tot_n = tot_n_start;

  /***********************************/

      for (k = 0, index = 0, index_pad = 0; k < nz; k++) {      /* loop cells in z direction */
        for (j = 0; j < ny; j++) {      /* loop cells in y direction */
          for (i = 0; i < nx; i++) {    /* loop cells in x direction */

            if (*newfs != NOT_CASTING) {

              if (delta_mass[0] < 0.0) {
                Ctot[0] = *tot_m -= delta_mass[0];
              }
              /* if (Ctot[0]<0.0) Ctot[0]= *tot_m=sp->c_sol_tot_old_multi[0][index];   */
              /* if (Ctot[0]<0.0) Ctot[0]= *tot_m=0.000001;  */
              residual_new[0] += *tot_m;

              Ctot[0] = *tot_m;

              if (delta_mass[1] < 0.0) {
                Ctot[1] = *tot_n -= delta_mass[1];
              }
              /* if (Ctot[1]<0.0) Ctot[1]= *tot_n=sp->c_sol_tot_old_multi[1][index];  */
              /* if (Ctot[1]<0.0) Ctot[1]= *tot_n=0.000001; */
              residual_new[1] += *tot_n;

              Ctot[1] = *tot_n;

              if (*newfs > 0.0 && *newfs < 1.0 && *binary_flag == 0 && *ternary_flag == 0) {
                for (m = 0; m < ele_1; m++) {
                  part_coef_corrected[m] = (Ctot[m] / sp->c_sol_alloy_multi[m][index] - 1.0) / (*newfs) + 1.0;
                  if (part_coef_corrected[m] <= 0 || part_coef_corrected[m] >= 0.4) {
                    part_coef_corrected[m] = old_part_coef[m][index];
                  }
                  ms->part_coef_matrix[m][index] = part_coef_corrected[m];
                }
              }

            }
            index++;
            tot_m++;
            tot_n++;
            newfs++;
            dfs_primary++;
            fs_n_eut++;
            fs_b_eut++;
            binary_flag++;
            ternary_flag++;
          }
          newfs += 2;
          binary_flag += 2;
          ternary_flag += 2;
        }
        newfs += (2 * (nx + 2));
        binary_flag += 2 * (nx + 2);
        ternary_flag += 2 * (nx + 2);
      }

      /* end of the correction for the partition coefficeint */

      itter_done = FALSE;
    }

/* renew fraction solid and concentration arrays */

    for (i = 0; i < nc; i++) {
      sp->fs_n_eut_old[i] = sp->fs_n_eut[i];
      sp->fs_b_eut_old[i] = sp->fs_b_eut[i];
      for (j = 0; j < ele_1; j++) {
        sp->c_sol_tot_old_multi[j][i] = sp->c_sol_tot_multi[j][i];
      }
      sp->c_sol_n_eut_multi[0][i] = solid_n_eut_m_start[i];
      sp->c_sol_n_eut_multi[1][i] = solid_n_eut_n_start[i];

      sp->c_sol_tot_multi[0][i] = tot_m_start[i];
      sp->c_sol_tot_multi[1][i] = tot_n_start[i];
    }

    /* generate the test output for mass conservation */
    for (g = 0; g < ele_1; g++) {
      fprintf (fptr1, " %f \t %d \t %d \t %f \t %f \t %f \t", bp->delt * bp->step, loop_counter, g, residual[g], delta_mass[g],
               residual_new[g]);
    }
    fprintf (fptr1, "\n");
    loop_counter++;

    /* update the buffer for corrected fraction solid using fcopy_matrix */
    big_fs = bp->ftmp_one;
    lit_fs = sp->c_fs_corrected;
    newfs_corrected_values = bp->c_fs_corrected_values->block_array;
    errors += fcopy_matrix (PAD, big_fs, lit_fs, bp, newfs_corrected_values, sbnum);
    /********************************************************/

/**********************************************************/
  }                             /* end of time steping */

  /*fix up fraction solid */

/*  for(i=0;i<nc;i++){
   if (sp->c_fs[i]==NOT_CASTING){
    continue;
   }else{
    fstot+= sp->c_fs_corrected[i];
   } 
  }  */
  sp->Tvals.fsavg = fstot / (nc - not_casting_counter);

#ifdef DEBUG_MULTI
  debug_fptr = fopen ("debug_multi.dat", "a+");
  if (bp->step == 0) {
    fprintf (debug_fptr,
             "time step \t time \t cell_number \t solute_number \t primary_phase \t liquid_phase \t total \t initial \t cell_number \t solute_number \t primary_phase \t liquid_phase \t total \t initial \t cell_number \t solute_number \t primary_phase \t liquid_phase \t total \t initial \t cell_number \t solute_number \t primary_phase \t liquid_phase \t total \t initial \t cell_number \t solute_number \t primary_phase \t liquid_phase \t total \t initial \t cell_number \t  solute_number \t primary_phase \t liquid_phase \t total \t initial \t cell_number \t solute_number \t primary_phase \t liquid_phase \t total \t initial \t \n \n ");
  }
  fprintf (debug_fptr, "%d \t %f \t", bp->step, bp->step * bp->delt);
  for (index = 0; index < nx * ny * nz; index++) {
    if ((index == ((int) (nz / 2.0) * nx * ny) + ((int) (ny / 2.0) * nx))
        || (index == ((int) (nz / 2.0) * nx * ny) + ((int) (ny / 2.0) * nx) + (int) (nx / 2.0))
        || (index == ((int) (nz / 2.0) * nx * ny) + ((int) (ny / 2.0) * nx) + nx - 1) || (index == ((int) (nz / 2.0) * nx * ny))
        || (index == (((int) (nz / 2.0) + 1) * nx * ny - 1)) || (index == ((int) (nz / 2.0) + (ny - 1) * nx))
        || (index == (int) (nz / 2.0) + ny * nx - 1)) {
      for (g = 0; g < ele_1; g++) {
        fprintf (debug_fptr, "%d \t %d \t %f \t %f \t %f \t %f \t", index, g, sp->c_sol_n_eut_multi[g][index],
                 sp->c_sol_alloy_multi[g][index], sp->c_sol_tot_multi[g][index], ms->Cinit_multi[g]);
      }
    }                           /* end of index if */
  }
  fprintf (debug_fptr, "\n \n");
  fclose (debug_fptr);
#endif
/***************the following part of the program is an analythical*******/
/***************solution to the multi-componenet diffusion****************/

#ifdef ANALYTHIC

  for (k = 0, index = 0; k < nz; k++) {
    for (j = 0; j < ny; j++) {
      for (i = 0; i < nx; i++) {
        index = i + (nx * j) + (nx * ny * k);
        if (index == 19) {
          anal_call += analythic (bp, k, j, i);
          for (q = 0; q < ele_1; q++) {
            fprintf (mytemp, "%f \t %f \t", bp->conc_anal[q], sp->c_sol_alloy_multi[q][index]);
          }
          fprintf (mytemp, "\n");
        }
      }
    }
  }
#endif

/*******************************************************************/

#ifdef VERBOSE
  if ((bp->step % bp->ctrl->scr_dmp_freq) == 0) {
    fprintf (stderr, "sb_diffuse_alloy_multi: emess: %d wmess: %d\n", emess, wmess);
    fprintf (stderr, "sb_diffuse_alloy_multi: nbeut: %d \n", bp->nbeut);
    fprintf (stderr, "sb_diffuse_alloy_multi: nteut: %d \n", bp->nteut);
    fprintf (stderr, "sb_diffuse_alloy_multi: neut: %d \n", bp->nbeut + bp->nteut);
  }
#endif /*VERBOSE*/
    /* free all local arrays for re-initialization */
    free (tot_m_start);
  free (tot_n_start);
  free (tot_old_m_start);
  free (tot_old_n_start);
  free (solid_n_eut_m_start);
  free (solid_n_eut_n_start);

  free (cell_was_corrected);
  free (dfs_start);

  for (i = 0; i < ele_1; i++) {
    free (old_part_coef[i]);
  }
  free (old_part_coef);

  fclose (fptr1);
  fclose (fptr4);
#ifdef ANALYTHIC
  fclose (mytemp);
#endif
  return (errflg);

#endif
}                               /* end of sb_diffuse */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_sb_diffuse_alloy_multi_c ()
{
  static char const rcsid[] = "$Id: sb_diffuse_alloy_multi.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_sb_diffuse_alloy_c subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.4.2.1  2006/01/18 12:01:17  lthuinet
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 10.4  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:02  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 1.1.8.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.2.4.1  2004/03/09 11:30:54  rcatwood
RCS Log:Changed to read materials properties from separate files for alloy and gas
RCS Log:
RCS Log:Revision 9.2  2003/10/16 11:29:24  rcatwood
RCS Log:Changed incorrect use of con_cast to use_cell_temp
RCS Log:Added icc support in Makefile
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:40  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 1.1.6.4  2003/05/06 15:48:08  rcatwood
RCS Log:Altered linear binary phase diagram usage to consistently use the values input from the control files rather than the header files.
RCS Log:
RCS Log:Revision 1.1.6.3  2003/02/27 23:04:39  rcatwood
RCS Log:Removed use of old temperature routines , all temperatures shoudl
RCS Log:be determined by checking the array c_temp in teh subblock, if the
RCS Log:subblock is open
RCS Log:
RCS Log:Revision 1.1.6.2  2003/01/22 16:53:46  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 1.1.6.1  2003/01/15 19:16:24  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 1.1.4.1  2002/11/06 17:27:48  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 1.1.2.8  2002/11/04 11:22:06  rcatwood
RCS Log:Check-in after Ali has gone
RCS Log:
RCS Log:Revision 1.1.2.7  2002/09/11 10:15:50  chirazi
RCS Log:Changing the total concentration for ternary eutectic cells
RCS Log:
RCS Log:Revision 1.1.2.6  2002/09/09 09:45:27  chirazi
RCS Log:correction for DS mode
RCS Log:
RCS Log:Revision 1.1.2.5  2002/09/03 10:34:46  chirazi
RCS Log:new modification rule for eutectic
RCS Log:
RCS Log:Revision 1.1.2.4  2002/09/03 08:46:36  chirazi
RCS Log:adding the strontium option for binary eutectic nucleation
RCS Log:
RCS Log:Revision 1.1.2.3  2002/08/30 14:57:46  chirazi
RCS Log:adding the strontium modefication flag
RCS Log:
RCS Log:Revision 1.1.2.2  2002/08/28 20:43:30  chirazi
RCS Log:No mass variation
RCS Log:
RCS Log:Revision 1.1.2.1  2002/08/27 14:18:18  chirazi
RCS Log:adding files for multi-component-Procast version of CA
RCS Log:
RCS Log:Revision 1.1  2000/11/30 16:58:12  chirazi
RCS Log:Initial revision
RCS Log:
RCS Log:Revision 1.1  2000/10/30 14:57:40  chirazi
RCS Log:Initial revision
RCS Log:
RCS Log:Revision 6.0.1.4  2000/10/19 17:21:10  chirazi
RCS Log:last updated multi diff
RCS Log:
RCS Log:Revision 6.0.1.1  2000/09/28 16:52:28  chirazi
RCS Log:New branch on revision 6.0 reserved for the multi-component diffusion
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:36  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.3  2000/04/28 14:14:33  rcatwood
RCS Log:fixed error message to include originating routine.
RCS Log:
RCS Log:Revision 5.2  2000/04/11 14:44:05  rcatwood
RCS Log:Seperated castats routines. Fixed sreenprint bug and error overruns
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.2  2000/02/29 18:00:25  rcatwood
RCS Log:Bug fixed when growing into new block
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.8  2000/02/15 15:29:11  rcatwood
RCS Log:Version after McWasp submitted
RCS Log:
RCS Log:Revision 4.7  2000/01/27 12:18:48  rcatwood
RCS Log:Overgrowth addressed. Bindump of t, fs
RCS Log:
RCS Log:Revision 4.6  2000/01/06 10:48:11  rcatwood
RCS Log:Fixed bug -- prototype in sb_diffuse_gas
RCS Log:
RCS Log:Revision 4.5  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.4  1999/12/21 10:26:15  rcatwood
RCS Log:Solute arrays migrated to structure.
RCS Log:
RCS Log:Revision 4.3  1999/12/20 13:11:23  rcatwood
RCS Log:Alloy and Gas outputs
RCS Log:
RCS Log:Revision 4.2  1999/12/16 19:15:49  rcatwood
RCS Log:Alloy and gas diffusion working, pores working. Changed file name for conc. output A for alloy C for gas conc.
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.2  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
