/*$Id: sb_get_surface_cells.c 887 2006-03-01 18:21:01Z rcatwood $*/

#include <stdio.h>
#include <stdlib.h>
#include "machine.h"
#include "blocks.h"
#include "ca_matrix.h"
#include "SurCell.h"
#include "SurCellRoutines.h"

void sb_get_surface_cells (BB_struct * bp, int sbnum)
{
  CA_FLOAT *padfs, *padfs_start, *fs, *fs_start;
  SB_struct *sp;
  int i, j, k;
  int ca_index = 0;
  int num_mould_nuc = 0, num_not_casting = 0;
  int errflg = 0;
  int *oni, *onip, *onend;

  /* stored in the subblock structure */
  SurCell *surface;

  fprintf (stderr, "sb_get_surface_cells: finding the cells at the surface between\n");
  fprintf (stderr, "         the casting and the mould for subblock %i.\n", sbnum);

  sp = bp->sb[sbnum];
  surface = &(sp->surface);

  /* set up local neighbourhood */
  /* use 6cell only for now     */
  oni = bp->nbhd.onq;           /*padded */
  onip = oni;
  onend = oni + 6;
  /* set up local values and pointers */
  padfs = padfs_start = bp->ftmp_one;
  fs = fs_start = sp->c_fs;

      /*****************************************/
  /* make a copy of the fs array           */
  /* this is needed to locate cells        */
  /* neighbouring on mould in the          */
  /* next subblock or in a periodic domain */
      /*****************************************/
  errflg += fcopy_matrix (PAD, padfs, fs, bp, bp->c_fs_values, sbnum);  /* (flag, :to, from, bp) */
  padfs = padfs_start + bp->cubeptr.flist[0][START];
  fs = fs_start;

  for (k = 0; k < bp->nc[2]; k++) {     /* loop cells in z direction */
    for (j = 0; j < bp->nc[1]; j++) {   /* loop cells in y direction */
      for (i = 0; i < bp->nc[0]; i++) { /* loop cells in x direction */
        /* find neighbour cells that are not in the casting */
        if (*fs == NOT_CASTING) {
          num_not_casting++;
        } else {
          for (onip = oni; onip < onend; onip++) {
            if ((*(padfs + *onip)) == NOT_CASTING) {
              /* Neigbour is not in casting so */
              /* set a threshold here */
              /* if all the allocated spaces are used up */
              if (surface->ns_cell >= surface->n_alloc) {
                /* expand the array */
                expand_SurCell (surface);
              }

              /* record the ca_index of the cell */
              surface->c_surfp[surface->ns_cell] = ca_index;
              /* record the grid location of the cell too! */
              (*(surface->surf_xyz + surface->ns_cell))[0] = i;
              (*(surface->surf_xyz + surface->ns_cell))[1] = j;
              (*(surface->surf_xyz + surface->ns_cell))[2] = k;

              surface->ns_cell++;
              /* then skip to the next cell */
              /* break out of the NEIGHBOUR loop */
              break;
            }                   /* end of Neighbour Not_casting test */
          }                     /* end of NEIGHBOUR loop */
        }                       /* end NOT_CASTING test */
        fs++;
        padfs++;
        ca_index++;
      }                         /*x */
      padfs += 2;
    }                           /*y */
    padfs += 2 * (bp->nc[0] + 2);
  }                             /*z */

  sp->nmould = num_not_casting;

  fprintf (stderr, "sb_get_surface_cells: %i has %i mould cells \n", sbnum, num_not_casting);
  fprintf (stderr, "sb_get_surface_cells: %i has %i interface cells \n", sbnum, surface->ns_cell);
  fprintf (stderr, "sb_get_surface_cells: finished subblock %i\n", sbnum);
  return;
}
