/*$Id: setup_temp_func.c 1490 2010-07-29 22:56:53Z  $*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* include header files required by subroutines */
#include "machine.h"
#include "read_ctrl.h"
#include "blocks.h"
#include "temp_calc.h"
void setup_temp_function (Ctrl_str * cp, BB_struct * bp)
{

       /*******************************************/
  /* set up the temperature function */
       /*******************************************/
  fprintf (stderr, "CA_SOLID: setting up the temperature function...\n");
  if ((cp->fgrid_input + cp->con_cast + cp->procast +cp->physica +  cp->remelt + cp->extinput> 1) || (cp->fgrid_input + cp->con_cast + cp->procast + cp->physica + cp->ffheattran + cp->remelt + cp-> extinput<0)) {
    fprintf (stderr, "ERROR: SETUP_TEMP_FUNCTION: Invalid option.\n");
    fprintf (stderr, "SETUP_TEMP_FUNCTION: cannot select multiple options.\n");
    fprintf (stderr, "                     fgrid:      %i\n", cp->fgrid_input);
    fprintf (stderr, "                     concast:    %i\n", cp->con_cast);
    fprintf (stderr, "                     procast:    %i\n", cp->procast);
    fprintf (stderr, "                     physica:    %i\n", cp->physica);
    fprintf (stderr, "                     ffheattran: %i\n", cp->ffheattran);
    fprintf (stderr, "                     remelt: %i\n", cp->remelt);
    fprintf (stderr, "                     external T: %i\n", cp->extinput);
    fprintf (stderr, "exiting...\n");
    exit (32);
  }

       /**********************************************************/
  /* Set up the appropriate temperature function            */
  /* by copying the pointer to the chosen function          */
  /* into the bigblock temperature function pointer variable */
       /**********************************************************/
  if (cp->fgrid_input) {
    /* finite element grid input */
    fprintf (stderr, "CA_SOLID: temperature function is FGRID_INPUT\n");
    bp->cell_temp_func = fg_temp_calc;
  } else if (cp->con_cast) {
    /* calculated directional gradient */
    fprintf (stderr, "CA_SOLID: temperature function is (concast) DIR_TEMP\n");
    bp->cell_temp_func = dir_temp_calc;
  } else if (cp->procast) {
    /* procast temperature already calculated */
    /**  \todo  check order of procast temperature update - procast - coupled */
    fprintf (stderr, "CA_SOLID: temperature function is PROCAST_TEMP\n");
    bp->cell_temp_func = procast_temp_calc;
  } else if (cp->physica) {
    /* just for identifying . the cell_temp_func is not true and T is calculated directly in sb_temp_calc*/
    fprintf (stderr, "CA_SOLID: temperature function is PHYSICA_TEMP\n");
  //  bp->cell_temp_func = const_temp_calc;
  } else if (cp->ffheattran){
    fprintf (stderr, "CA_SOLID: temperature function is FF_HEAT_TRANSFER_TEMP\n");
    /*  physica + ffheattran have seperate functions to calculate T.....   lyuan */
  } else if(cp->remelt){
    bp->cell_temp_func = dir_temp_remelt;
    fprintf (stderr, "CA_SOLID: temperature function is CON_REMELT_TEMP\n");
  } else if(cp->extinput){
    fprintf (stderr, "CA_SOLID: temperature function is EXTERNAL_TEMP\n");
  } else {
    /* isothermal (const. cooling, thermocouple input, */
    fprintf (stderr, "CA_SOLID: temperature function is CONST_TEMP\n");
    bp->cell_temp_func = const_temp_calc;
  }
       /*******************************************/
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *setup_temp_func_c ()
{
  static char const rcsid[] = "$Id: setup_temp_func.c 1490 2010-07-29 22:56:53Z  $";

  return (rcsid);
}
