/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   02/2008      
			Solving PPE using ICCG

	symmetric maxtrix: pe=pw pn=ps pt=pb pp>0
	Right hand side: rhs[][][]
	solution : sol[][][]
	
*/
/*----------------------------------------------------------------------*/

#include "ff_mpflow.h"


int PPE_ICCG(BB_struct *bp, CA_FLOAT ***pe, CA_FLOAT ***pw, CA_FLOAT ***pn, CA_FLOAT ***ps, CA_FLOAT ***pt, CA_FLOAT ***pb, CA_FLOAT ***pp, CA_FLOAT ***rhs, CA_FLOAT ***sol){

	int i,j,k;
	int iter;


	CA_FLOAT ab_residual, max_res, temp_res;
	CA_FLOAT s0, sk, bk, ak, pkapk, resl, rsm;
	CA_FLOAT max_res1;
	CA_FLOAT ***pk, ***zk, ***d, ***res;
	int IMAX, JMAX, KMAX;

        IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];

	pk = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	zk = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	d = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
	res = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);



	for (i=0; i<=IMAX+1; i++){
  	  for (j=0; j<=JMAX+1; j++){
	    for (k=0; k<=KMAX+1; k++){
 	      pk[i][j][k] = 0.0;
	      zk[i][j][k] = 0.0;
	      d[i][j][k] = 0.0;
	      res[i][j][k] = 0.0;
 	    }
	  }
	}

/*-------------Boundary conditions for pressure-------------*/
/*	
	for (i=1; i<=IMAX; i++){
	  for (k=1; k<=KMAX; k++){
	    sol[i][0][k] = sol[i][1][k];
	    sol[i][JMAX+1][k] = sol[i][JMAX][k];
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    sol[i][j][0] = sol[i][j][1];
	    sol[i][j][KMAX+1] = sol[i][j][KMAX];
	  }
	}
	
	for (j=1; j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){
	    sol[0][j][k] = sol[1][j][k];
	    sol[IMAX+1][j][k] = sol[IMAX][j][k];
	  }
	}

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      sol[i][j][k] = 0.0;
	    }
	  }
        }

*/
/*----------Initial Residual vector and the Norm -----------*/
	ab_residual = 0.0;

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){

	      res[i][j][k] = - rhs[i][j][k] - sol[i+1][j][k] * pe[i][j][k] - 
		sol[i-1][j][k] * pw[i][j][k] - sol[i][j+1][k] * pn[i][j][k] -
		sol[i][j-1][k] * ps[i][j][k] - sol[i][j][k+1] * pt[i][j][k] - 
		sol[i][j][k-1] * pb[i][j][k] - sol[i][j][k] * pp[i][j][k];
					
	      ab_residual = ab_residual + fabs(res[i][j][k]);
	    }
	  }
	}

//	fprintf(stderr, "res = %f \n", ab_residual) ;

/*----------Elements of diagonal preconditioning matrix -----------*/

	for (k=1; k<=KMAX; k++){
	  for (j=1; j<=JMAX; j++){
	    for (i=1; i<=IMAX; i++){
	      d[i][j][k] = 1.0 / (pp[i][j][k]- pw[i][j][k]*pw[i][j][k]*d[i-1][j][k] -
		ps[i][j][k]*ps[i][j][k]*d[i][j-1][k] - pb[i][j][k]*pb[i][j][k]*d[i][j][k-1]);
	    }
	  }
	}

	s0 = 1.0e20;		


/*---------------------Inner iterations------------------------*/

      for (iter=1; iter<=ITERMAX; iter++) {

/*-------------Solve for zk[i][j][k] forward substitution-------------*/
	for (k=1; k<=KMAX; k++){
 	  for (j=1; j<=JMAX; j++){
	    for (i=1; i<=IMAX; i++){
	      zk[i][j][k] = (res[i][j][k] - pw[i][j][k]*zk[i-1][j][k] -
		ps[i][j][k]*zk[i][j-1][k] - pb[i][j][k]*zk[i][j][k-1]) * d[i][j][k];
	    }
	  }
	}

	for (k=1; k<=KMAX; k++){
	  for (j=1; j<=JMAX; j++){
	    for (i=1; i<=IMAX; i++){
	      zk[i][j][k] = zk[i][j][k]/(d[i][j][k]+1.0e-30);
	    }
	  }
	}

/*-------------Solve for zk[i][j][k] backward substitution and sk[i][j][k]-------------*/
		
	sk=0.0;

	for (k=KMAX; k>=1; k--){
	  for (j=JMAX; j>=1; j--){
	    for (i=IMAX; i>=1; i--){
	      zk[i][j][k] = (zk[i][j][k]-pe[i][j][k]*zk[i+1][j][k] -
		pn[i][j][k]*zk[i][j+1][k] -pt[i][j][k]*zk[i][j][k+1])*d[i][j][k];
	      sk = sk+ res[i][j][k]*zk[i][j][k];
	    }
	  }
	}

/*-------------Solve for bk and  pk[i][j][k]-------------*/
		
	bk= sk/s0;

//	fprintf(stderr, "beta is : %e , sk is %f \n", bk, sk);
		
	for (k=1; k<=KMAX; k++){
	  for (j=1; j<=JMAX; j++){
	    for (i=1; i<=IMAX; i++){
	      pk[i][j][k] = zk[i][j][k] + bk * pk[i][j][k];
	    }
	  }
	}

/*-------------Calculate for scalar product (PK. A Pk) and a[i][j][k]-------------*/
		
	pkapk = 0.0;
		
	for (k=1; k<=KMAX; k++) {
	  for (j=1; j<=JMAX; j++){
	    for (i=1; i<=IMAX; i++){
	      zk[i][j][k] = pp[i][j][k]* pk[i][j][k] + pe[i][j][k]* pk[i+1][j][k] +
		pw[i][j][k]* pk[i-1][j][k] + pn[i][j][k]* pk[i][j+1][k] +
		ps[i][j][k]* pk[i][j-1][k] + pt[i][j][k]* pk[i][j][k+1] +
		pb[i][j][k]* pk[i][j][k-1];
	      pkapk = pkapk + pk[i][j][k]*zk[i][j][k];
	    }
	  }
	}

	ak = sk/(pkapk+1e-30) ;

//	fprintf(stderr, "ak is : %f , pkapk is %f \n", ak, pkapk);

/*-------------Calculate pressure correction, new residual vector and norm-------------*/
		
	resl = 0.0;
	max_res = 0.0;
		
	for (k=1; k<=KMAX; k++) {
	  for (j=1; j<=JMAX; j++){
	    for (i=1; i<=IMAX; i++){
	      sol[i][j][k] = sol[i][j][k] + ak * pk[i][j][k];
	      res[i][j][k] = res[i][j][k]-ak*zk[i][j][k];
	      resl = resl + fabs(res[i][j][k]);

	      if (max_res < fabs(res[i][j][k]))  max_res = fabs(res[i][j][k]);
	    }
	  }
	}

	s0 = sk;

	rsm = resl / (ab_residual+1.0e-30);

	if( max_res <= EPS) break;

      } 


      freerealmem(pk, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
      freerealmem(zk, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
      freerealmem(d, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
      freerealmem(res, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

//    fprintf(stderr, "Resl = %f , rsm = %f \n", resl, rsm);
//      fprintf(stderr, "inneriter = %d , Resl = %f , max_res = %f , rsm = %f\n", iter, resl, max_res, rsm);
      bp->max_res = max_res;	
	
      return iter;
            
}

