/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/*RCS Id:$Id: alloc_bb.c 1404 2008-11-26 17:41:29Z  $*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "machine.h"
#include "fem.h"
#include "read_ctrl.h"
#include "blocks.h"
#include "nuc_lookup.h"
#include "ff_mpflow.h"
#include "ff_memory.h"
#include "phy_ca_tran.h"

extern CA_FLOAT global_pressure;

extern int init_sb (BB_struct * bp, int sbnum);

/* functions used from initface.c */
extern int init_facecode (Frame * cubeptr, int *ins, int dim);

/* functions used from initcube.c */
extern int init_cube (BB_struct * bp);

/*function from nbhd_def.c*/
extern void nbhd_def (BB_struct * bp);

/**************************************************/
/*      Subroutine to alloc memory for bigblock   */
/**************************************************/
/* pass in a blank BB structure with control,     */
/*                       return allocated         */
/**************************************************/

int alloc_bb (BB_struct * bp)
{
  char command[MAX_STRING_LEN];
  int i, sbnum;
  extern void srand48 (long);
  int errors = 0;
  Ctrl_str *cp;

  cp = bp->ctrl;                /** aargh! \todo straghten this out!  --  general*/
  /*THUINET 18/02/05 */
  int isol, ele_num, ele_1;
  int iphs, iphs_tot;

  /*FIN THUINET 18/02/05 */

   /************************************************/
  /* malloc an array of pointers to SB structures */
   /************************************************/
  fprintf (stderr, "Entering alloc_bb ...\n");
  fprintf (stderr, "mallocing an array of pointers to SB str...\n");
  if (!(bp->sb = (SB_struct * *)malloc (bp->ntsb * sizeof (SB_struct *)))) {
    fprintf (stderr, "ERROR: SB_struct pointer array malloc failed\n");
    return (1);
  }
  for (sbnum = 0; sbnum < bp->ntsb; sbnum++) {
    if (init_sb (bp, sbnum) != 0) {
      fprintf (stderr, "exiting due to init_sb failure");
      exit (2);
    }
  }
  /* create the mask and set to zero */
  fprintf (stderr, "callocing SB mask ...\n");
  if (!(bp->sb_mask = (int *) calloc (bp->ntsb, sizeof (int)))) {
    fprintf (stderr, "ERROR: SB_mask array  malloc failed\n");
    return (1);
  }

  /*and the supplementary pointer value structures */

  /*fraction solid */
  if (!(bp->c_fs_values = (Value_struct *) calloc (1, sizeof (Value_struct)))) {
    fprintf (stderr, "ERROR: c_fs pointer values malloc failed\n");
    return (1);
  } else {
    if (!(bp->c_fs_values->block_array = (CA_FLOAT * *)calloc (bp->ntsb, sizeof (CA_FLOAT *)))) {
      fprintf (stderr, "ERROR: c_fs values malloc failed\n");
      return (1);
    }
    bp->c_fs_values->part_coef = 1;     /*correct conc. profile output if not C_LIQ */

    sprintf (bp->c_fs_values->id_string, "FS_");
  }

  /*schiel fraction solid */
  if (!(bp->sch_fs_values = (Value_struct *) calloc (bp->ntsb, sizeof (Value_struct)))) {
    fprintf (stderr, "ERROR: sch_fs pointer values malloc failed\n");
    return (1);
  } else {
    if (!(bp->sch_fs_values->block_array = (CA_FLOAT * *)calloc (bp->ntsb, sizeof (CA_FLOAT *)))) {
      fprintf (stderr, "ERROR: sch_fs values malloc failed\n");
      return (1);
    }
    sprintf (bp->sch_fs_values->id_string, "SCH_");
  }

  /*first solute (gas) */
  if (!(bp->c_sol_values = (Value_struct *) calloc (bp->ntsb, sizeof (Value_struct)))) {
    fprintf (stderr, "ERROR: c_sol pointer values malloc failed\n");
    return (1);
  } else {
    if (!(bp->c_sol_values->block_array = (CA_FLOAT * *)calloc (bp->ntsb, sizeof (CA_FLOAT *)))) {
      fprintf (stderr, "ERROR: c_sol values malloc failed\n");
      return (1);
    }
    sprintf (bp->c_sol_values->id_string, "G_");
    bp->c_sol_values->disp_max = cp->gas_disp_max;
  }

  /*second solute (alloy) */
  if (!(bp->c_sol_alloy_values = (Value_struct *) calloc (bp->ntsb, sizeof (Value_struct)))) {
    fprintf (stderr, "ERROR: c_sol_alloy pointer values malloc failed\n");
    exit (1);
  } else {
    if (!(bp->c_sol_alloy_values->block_array = (CA_FLOAT * *)calloc (bp->ntsb, sizeof (CA_FLOAT *)))) {
      fprintf (stderr, "ERROR: c_sol_alloy values malloc failed\n");
      return (1);
    }
    sprintf (bp->c_sol_alloy_values->id_string, "A_");
    bp->c_sol_alloy_values->disp_max = cp->alloy_disp_max;
  }

  /*and the supplementary int pointer arrays */

  /*grain number */
  if (!(bp->gr_array = (int **) calloc (bp->ntsb, sizeof (int *)))) {
    fprintf (stderr, "ERROR:  pointer values malloc failed\n");
    return (1);
  }

  /*finite element number */
  if (!(bp->c_elm_array = (int **) calloc (bp->ntsb, sizeof (int *)))) {
    fprintf (stderr, "ERROR:  pointer values malloc failed\n");
    return (1);
  }
  /* holder for closed block (int) */
  if (!(bp->intclosed = (int *) calloc (bp->ncsb, sizeof (int)))) {
    fprintf (stderr, "ERROR:  pointer values malloc failed\n");
    return (1);
  }
  /* holder for closed block (float) */
  if (!(bp->floatclosed = (CA_FLOAT *) calloc (bp->ncsb, sizeof (CA_FLOAT)))) {
    fprintf (stderr, "ERROR:  pointer values malloc failed\n");
    return (1);
  }

   /*******************************************/
  /* Init cubeptr structure for matrix copy  */
   /*******************************************/
  init_cube (bp);
  init_facecode (&(bp->cubeptr), bp->nc, bp->dim);

   /************************************************/
  /* Malloc temp CA_FLOAT and int arrays          */
   /************************************************/
  i = (bp->nc[0] + 2) * (bp->nc[1] + 2) * (bp->nc[2] + 2);
  fprintf (stderr, "%s: total, nx, ny, nz, %d, %d, %d, %d\n", __func__, i, bp->nc[0], bp->nc[1], bp->nc[2]);
/** \todo put temporary buffer arrays into the subblocks -- multiblock */
  if (!(bp->ftmp_one = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
    fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
    return (1);
  }

  if (!(bp->ftmp_two = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
    fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
    return (1);
  }

  if (!(bp->ftmp_three = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
    fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
    return (1);
  }

  /*by Wei WANG 11-07-02 */
  if (!(bp->ftmp_four = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
    fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
    return (1);
  }

  /*by Wei WANG 11-07-02 */
  if (!(bp->ftmp_five = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
    fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
    return (1);
  }

  /* modified to protect by options */
  /**todo: Fine tune the options so as to avoid unnecessary memory allcation */
  if ((bp->ctrl->curvature_3D ==1) || (bp->ctrl->curvature_2D == 1)|| (bp->ctrl->curvature_2D == 2)){
     /*xly 2004/09/06 */
     if (!(bp->ftmp_nx = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
       fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
       return (1);
     }
     /*xly 2004/09/06 */
     if (!(bp->ftmp_ny = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
       fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
       return (1);
     }
      /*dn00 2005/10/21*/
      if (!(bp->ftmp_nz = (CA_FLOAT * ) calloc(i, sizeof(CA_FLOAT)))) {
         fprintf(stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
         return(1);
      }
   }
  /*by THUINET 18-02-05 */

  /* L Thuinet polycomponent data arrays */
  if (bp->ctrl->diffuse_alloy_poly == 1) {

    ele_num = cp->NUM_COMP;     /* number of elements in the alloy */
    ele_1 = ele_num - 1;
    iphs_tot = cp->NUM_PHS;     /* number of solid phases */

    if (!(bp->itmp_nat_cell = (int *) calloc (i, sizeof (int)))) {
      fprintf (stderr, "ERROR: tmp int array malloc failed\n");
      return (1);
    }

    if (!(bp->itmp_nat_grain = (int *) calloc (i, sizeof (int)))) {
      fprintf (stderr, "ERROR: tmp int array malloc failed\n");
      return (1);
    }

  } else {
    ele_num = 2;
    ele_1 = 1;
    iphs_tot = 1;               /* number of solid phases */
  }

  /* loop through solutes */
  for (isol = 0; isol < ele_1; isol++) {
    if (!(bp->ftmp_cl_poly[isol] = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
      fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
      return (1);
    }
    if (!(bp->ftmp_ce_poly[isol] = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
      fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
      return (1);
    }
    /* Value structures for polycomponent */
    if (!(bp->poly_c_eqv_values[isol] = (Value_struct *) calloc (bp->ntsb, sizeof (Value_struct)))) {
      fprintf (stderr, "ERROR: calloc failed in %s at %s\n", __func__, __LINE__);
      return (1);
    } else {
      if (!(bp->poly_c_eqv_values[isol]->block_array = (CA_FLOAT * *)calloc (bp->ntsb, sizeof (CA_FLOAT *)))) {
        fprintf (stderr, "ERROR: calloc failed in %s at %s\n", __func__, __LINE__);
        return (1);
      }
      sprintf (bp->poly_c_eqv_values[isol]->id_string, "A_%i", isol);
      bp->poly_c_eqv_values[isol]->disp_max = cp->alloy_disp_max;
    }
    if (!(bp->poly_c_sol_values[isol] = (Value_struct *) calloc (bp->ntsb, sizeof (Value_struct)))) {
      fprintf (stderr, "ERROR: calloc failed in %s at %s\n", __func__, __LINE__);
      return (1);
    } else {
      if (!(bp->poly_c_sol_values[isol]->block_array = (CA_FLOAT * *)calloc (bp->ntsb, sizeof (CA_FLOAT *)))) {
        fprintf (stderr, "ERROR: calloc failed in %s at %s\n", __func__, __LINE__);
        return (1);
      }
      sprintf (bp->poly_c_sol_values[isol]->id_string, "A_%i", isol);
      bp->poly_c_sol_values[isol]->disp_max = cp->alloy_disp_max;
    }

  }                             /* end of isol loop through solutes */

  /* loop through phases */
  for (iphs = 0; iphs < iphs_tot; iphs++) {
    if (!(bp->ftmp_one_poly[iphs] = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
      fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
      return (1);
    }
    /* Value structures for polycomponent phases */
    if (!(bp->poly_c_fs_values[iphs] = (Value_struct *) calloc (bp->ntsb, sizeof (Value_struct)))) {
      fprintf (stderr, "ERROR: calloc failed in %s at %s\n", __func__, __LINE__);
      return (1);
    } else {
      if (!(bp->poly_c_fs_values[iphs]->block_array = (CA_FLOAT * *)calloc (bp->ntsb, sizeof (CA_FLOAT *)))) {
        fprintf (stderr, "ERROR: calloc failed in %s at %s\n", __func__, __LINE__);
        return (1);
      }
      sprintf (bp->poly_c_fs_values[iphs]->id_string, "FS_%i", iphs);
      bp->poly_c_fs_values[iphs]->disp_max = 1.0;
    }
  }                             /* end of iphs loop through phases */
  /*FIN THUINET 18-02-05 */

  /* malloc buffer for decented octahedron *//*by Wei WANG 11-07-02 */
  if (cp->decentred_octahedron) {       /*malloced only if decentred_ocathedron algorithm used */
    if (!(bp->ftmp_dc_d = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
      fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
      return (1);
    }

    if (!(bp->ftmp_dc_x = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
      fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
      return (1);
    }

    if (!(bp->ftmp_dc_y = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
      fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
      return (1);
    }

    if (!(bp->ftmp_dc_z = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
      fprintf (stderr, "ERROR: tmp CA_FLOAT array malloc failed\n");
      return (1);
    }
  }
#ifdef OLD_TUNDER
  if (!(bp->old_Tunder = (CA_FLOAT *) calloc (i, sizeof (CA_FLOAT)))) {
    fprintf (stderr, "ERROR: old_Tunder array malloc failed\n");
    return (1);
  }
#endif /*OLD_TUNDER */
  if (!(bp->itmp_one = (int *) calloc (i, sizeof (int)))) {
    fprintf (stderr, "ERROR: tmp int array malloc failed\n");
    return (1);
  }

  /*by Wei WANG 11-07-02 */
  if (!(bp->itmp_two = (int *) calloc (i, sizeof (int)))) {
    fprintf (stderr, "ERROR: tmp int array malloc failed\n");
    return (1);
  }

   /************************************************/
   /* malloc an array of grain structures          */
   /************************************************/
  if (!(bp->gr = (Ind_grain * *)calloc (bp->nprops.gd_max_total, sizeof (Ind_grain *)))) {
    fprintf (stderr, "ERROR: Ind_grain array malloc failed\n");
    return (1);
  }

  if (bp->ctrl->fgrid_input) {
    /* the finite element grid structure */
    if (!(bp->fg = (FGrid_str *) calloc (1, sizeof (FGrid_str)))) {
      fprintf (stderr, "ERROR: fg structure malloc failed\n");
      return (1);
    }
    /* the finite element grid structure */
    if (!(bp->fg_next = (FGrid_str *) calloc (1, sizeof (FGrid_str)))) {
      fprintf (stderr, "ERROR: fg structure malloc failed\n");
      return (1);
    }
  }

  if(bp->ctrl->physica || bp->ctrl->fluidflow || bp->ctrl->ffheattran ){

	   int total_ca_number=bp->tnc[0]*bp->tnc[1]*bp->tnc[2];
    
    if(bp->ctrl->physica){	   
	   if(!(bp->ca_cord_x = (CA_FLOAT *) calloc (total_ca_number, sizeof(CA_FLOAT)))) {
	      fprintf (stderr, "ERROR: Phy_Cord structure malloc failed\n");
	      return (1);
	   };
           bp->ca_cord_y = (CA_FLOAT *) calloc (total_ca_number, sizeof(CA_FLOAT));
           bp->ca_cord_z = (CA_FLOAT *) calloc (total_ca_number, sizeof(CA_FLOAT));
	   bp->ca_cell_Tar = (CA_FLOAT *) calloc (total_ca_number, sizeof(CA_FLOAT));
    }
	   if(!( bp->ca_cell_uar = (CA_FLOAT *) calloc (total_ca_number, sizeof(CA_FLOAT)))) {
	      fprintf (stderr, "ERROR: ca_cell_Veloctiy structure malloc failed\n");
	      return (1);
	   };
	   
	   bp->ca_cell_var = (CA_FLOAT *) calloc (total_ca_number, sizeof(CA_FLOAT));
	   bp->ca_cell_war = (CA_FLOAT *) calloc (total_ca_number, sizeof(CA_FLOAT));
	
	   if(!( bp->ftmp_u = (CA_FLOAT *) calloc (i, sizeof(CA_FLOAT)))) {
	      fprintf (stderr, "ERROR: Velocity tmp structure malloc failed\n");
	      return (1);
	   };
	   
	   bp->ftmp_v = (CA_FLOAT *) calloc (i, sizeof(CA_FLOAT));
	   bp->ftmp_w = (CA_FLOAT *) calloc (i, sizeof(CA_FLOAT));
	   
	   //	   bp->ca_cell_p = (CA_FLOAT *) calloc (total_ca_number+1, sizeof(CA_FLOAT));
  }

  /*allocate memory for fluidflow including heat transfer --by LYUAN*/
  if(bp->ctrl->ffheattran || bp->ctrl->fluidflow)
	  ff_alloc_bb(bp);
  if(bp->ctrl->curvature_3D ==2 || bp->ctrl->curvature_2D == 3)
	  curv_alloc(bp);
  if(bp->ctrl->physica && bp->phy_tran == 1)
	  phy_alloc_bb(bp);

   /*************************************/
  /* Print out checks on input data... */
   /*************************************/
  fprintf (stderr, "sb_mask nsb: %d, %d, %d\n", bp->nsb[0], bp->nsb[1], bp->nsb[2]);
  fprintf (stderr, "Exiting alloc_bb().\n");
  return (0);
}

  /* end of alloc_bb subroutine */
  /* Little subroutine to get rcs id into the object code */
  /* so you can use ident on the compiled program  */
  /* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_alloc_bb_c ()
{
  static char const rcsid[] = "$Id: alloc_bb.c 1404 2008-11-26 17:41:29Z  $";

  return (rcsid);
}

/*
RCS Log:$Log$
RCS Log:Revision 11.2  2006/11/09 13:39:40  rcatwood
RCS Log:Merged the update for ca_procast version for procast 2006.0_beta
RCS Log:
RCS Log:Revision 11.1.12.1  2006/11/06 20:18:17  rcatwood
RCS Log:Improvements for coupled version
RCS Log:Signal flag to reread output frequency from ca_newstep.in
RCS Log:
RCS Log:Revision 11.1  2006/03/01 18:20:38  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.4.2.3  2006/02/20 14:51:22  rcatwood
RCS Log:Correced evil log message
RCS Log:
RCS Log:Revision 10.4.2.2  2006/02/20 12:00:13  lthuinet
RCS Log: A lot of modifications : add an option to treat correctly diffusion in the case the secondary eutectic phase is stoechiometric AND add a pointer to distinguish the nature of the cell and the nature of the grain
RCS Log:
RCS Log:Revision 10.4.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.4  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.2  2005/11/24 13:10:54  rcatwood
RCS Log:Ran INDENT on all the files!
RCS Log:Revision 10.1.2.3  2005/12/01 13:09:37  rcatwood
RCS Log:Fixed some implicit function declarations
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:52  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1.2.1  2005/11/07 17:47:56  rcatwood
RCS Log:Branch uisng Xiao Li Yang final version
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 9.1.12.1  2004/09/09 17:49:42  xly
RCS Log:add curvature undercooling by estimating interface normal of growing cells.
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:33  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.2  2003/02/03 12:52:03  rcatwood
RCS Log:Fixed some memory allocation bugs (seg fault if no fgrid input)
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:42  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:00  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.1  2002/10/17 16:52:36  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 1.1.4.2  2002/09/17 20:51:07  rcatwood
RCS Log:Rearranged so that read/write leave the memory clean
RCS Log:Added signal 16 (SIGUSR1) catching for trapping after finishing the current timestep.
RCS Log:
RCS Log:Revision 1.1.4.1  2002/08/30 19:18:24  rcatwood
RCS Log:split bigblock and subblock allocation into seperate subroutines
RCS Log:from bigblock.c and open_sb.c: added alloc_bb.c and alloc_sb.c
RCS Log:
RCS Log:Revision 1.1.2.2  2002/07/09 14:30:27  rcatwood
RCS Log:Changed subblock open flag to 3 values: new, open,and closed. This is to aviod re-opening blocks that are already processed.
RCS Log:COmpiles and runs without seg fault.
RCS Log:
RCS Log:Revision 1.1.2.1  2002/07/09 11:46:37  rcatwood
RCS Log:Split big block memory allocation and value initialization into seperate files.
RCS Log:Use alloc_bb for reading the block file.
RCS Log:Test program read_binblocks.c working (almost) all strings in ctrl, pore lists
RCS Log:
*/
