#include <stdio.h>
#include <stdlib.h>
#include "machine.h"
#include "blocks.h"
#include "read_sb.h"
#include "SurCellRoutines.h"
extern int      sb_nuc(BB_struct *bp, int sbnum);

/* functions used from sb_temp_calc.c */
extern int      sb_temp_calc(BB_struct *bp, int sbnum);

/* subroutines later in the file ... */
extern int      init_c_elm(BB_struct *, int);
extern int      init_c_elm_solo(BB_struct *, int);
extern int      init_nuc_thresh(BB_struct *bp,int sbnum);

int alloc_sb (BB_struct * bp, int sbnum)
{
      int      errors = 0;
  int i, j, ele_1,npha, nc, nxny;
      int      oldstep;

/*THUINET 05/05*/
  int iphs, iphs_tot;

/*FIN THUINET 05/05*/
      SB_struct * sp;
   MultiS_struct *ms;

/*THUINET 05/05*/
  iphs_tot = (bp->ctrl->NUM_PHS);
/*FIN THUINET 05/05*/

      sp = bp->sb[sbnum];
      nc = bp->ncsb;
      nxny = bp->nc[0]*bp->nc[1];
      ms = &(bp->MultiSvals);

#  ifdef USE_ELM
      /* malloc array to hold the FE element that the cells belong to  */
      if (!(sp->c_elm = (int *) malloc(nc * sizeof(int)))) {
          fprintf(stderr, "ERROR: alloc_sb: SB cell element  array malloc failed\n");
          return(1);
      }
      bp->c_elm_array[sbnum] = sp->c_elm;
#  endif /*USE_ELM*/
      /* malloc array to hold fs of cells and set = 0 */
      if (!(sp->c_fs = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
          fprintf(stderr, "ERROR: alloc_sb: SB cell fs array malloc failed\n");
          return(1);
      }
      /* set value pointer array */
      bp->c_fs_values->block_array[sbnum] = sp->c_fs;

/********************only for multi component***************/
#ifdef CHIRAZI_MULTI
if (bp->ctrl->diffuse_alloy_multi==1){

   /* malloc array to hold non eutectic fs of cells and set = 0 */
   if (!(sp->cell_dfs_primary = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell dfs_primary array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->cell_dfs_primary_values->block_array[sbnum] = sp->cell_dfs_primary;

   /* malloc array to hold eutectic fs of cells and set = 0 */
   if (!(sp->cell_dfs_eutectic = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell dfs_eutectic array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->cell_dfs_eutectic_values->block_array[sbnum] = sp->cell_dfs_eutectic;

   /* malloc array to hold non eutectic fs of cells and set = 0 */
   if (!(sp->fs_n_eut = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell fs_n_eut array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->fs_n_eut_values->block_array[sbnum] = sp->fs_n_eut;

   /* malloc array to hold non eutectic fs of cells and set = 0 */
   if (!(sp->fs_n_eut_old = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell fs_n_eut_old array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->fs_n_eut_old_values->block_array[sbnum] = sp->fs_n_eut_old;

   /* malloc array to hold binary eutectic fs of cells and set = 0 */
   if (!(sp->fs_b_eut = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell fs_b_eut array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->fs_b_eut_values->block_array[sbnum] = sp->fs_b_eut;

   /* malloc array to hold binary eutectic fs of cells and set = 0 */
   if (!(sp->fs_b_eut_old = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell fs_b_eut_old array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->fs_b_eut_old_values->block_array[sbnum] = sp->fs_b_eut_old;

   /* malloc array to hold ternary eutectic fs of cells and set = 0 */
   if (!(sp->fs_t_eut = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell fs_t_eut array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->fs_t_eut_values->block_array[sbnum] = sp->fs_t_eut;
   /* malloc array to hold temp corrected fs of cells and set = 0 */
   if (!(sp->c_fs_corrected = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
      fprintf(stderr, "ERROR: alloc_sb: SB cell c_fs_corrected array malloc failed\n");
      return(1);
   }
   /* set value pointer array */
   bp->c_fs_corrected_values->block_array[sbnum] = sp->c_fs_corrected;

  }
  #endif /* CHIRAZI_MULTI */

  /* end of multi diff test */
/*******************************************************/
  if (bp->ctrl->diffuse_alloy_poly == TRUE) {
     ele_1 = (bp->ctrl->NUM_COMP - 1);
     npha = bp->ctrl->NUM_PHS;

      if (!(sp->nat_cell = (int *) calloc(nc, sizeof(int)))) {
          fprintf(stderr, "ERROR: alloc_sb: SB cell gr array malloc failed\n");
          return(1);
        }

    if (!(sp->nat_grain = (int *) calloc (nc, sizeof (int)))) {
      fprintf (stderr, "ERROR: alloc_sb: SB cell gr array malloc failed\n");
      return (1);
    }


  }else{
     ele_1 = 1;
     npha = 1;
  }




    for (iphs = 0; iphs < npha ; iphs++) {

      if (!(sp->c_fs_poly[iphs] = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT)))) {
        fprintf (stderr, "ERROR: %s: malloc failed at %s\n",__func__,__LINE__);
        return (1);
      }
    }

  /*allocation and initialisation for multi-component system (THUINET) */
  /* now used for pure binary by setting eel_1 to the appropriate value */
    for (j = 0; j < ele_1; j++) {

      if (!(sp->c_sol_poly[j] = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT)))) {
        fprintf (stderr, "ERROR: alloc_sb: SB cell alloysol array malloc failed for multi\n");
        return (1);
      }

      if (!(sp->c_eqv_poly[j] = (CA_FLOAT *) calloc (nc, sizeof (CA_FLOAT)))) {
        fprintf (stderr, "ERROR: alloc_sb: SB cell equiv. sol array malloc failed for multi\n");
        return (1);
      }

      /* set concentration to initial value */
      for (i = 0; i < nc; i++) {
        *(sp->c_sol_poly[j] + i) = bp->mprops.alloyprops[j].Cinit;
        *(sp->c_eqv_poly[j] + i) = bp->mprops.alloyprops[j].Cinit;
      }
      /* set value pointer array
         bp->c_sol_alloy_values->block_array[sbnum] = sp->c_sol_alloy; */
    }


  /* end of multi component test (THUINET) */

      /* malloc array to hold schiel_fs of cells and set = 0 */
      if (bp->ctrl->scheil == TRUE) {
          if (!(sp->sch_fs = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
              fprintf(stderr, "ERROR: alloc_sb: SB sch_fs array malloc failed\n");
              return(1);
          }
          /* set value pointer array */
          bp->sch_fs_values->block_array[sbnum] = sp->sch_fs;
      }

      /* malloc array for cell index & set = 0 */ /*by Wei WANG 11-07-02*/
      if (!(sp->index = (int *) calloc(nc, sizeof(int)))) {
         fprintf(stderr, "ERROR: alloc_sb: SB cell index array malloc failed\n");
        return(1);
      }
      /* malloc array to hold grain # of cells and set = 0 */
      if (!(sp->gr = (int *) calloc(nc, sizeof(int)))) {
          fprintf(stderr, "ERROR: alloc_sb: SB cell gr array malloc failed\n");
          return(1);
      }
      /* set value pointer array */
      bp->gr_array[sbnum] = sp->gr;

      /* malloc array for cell temperature */ /*by Wei Wang on 11-07-02*/
      if (!(sp->c_temp = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
         fprintf(stderr, "ERROR: alloc_sb: SB cell temperature array malloc failed\n");
         return(1);
      }

      /* malloc array for next cell temperarue, for 2d temp. dist. */ /*by Robert Atwood*/
      if(bp->ctrl->fgrid_input){
         if (!(sp->c_fg_temp = (CA_FLOAT *) calloc(nxny, sizeof(CA_FLOAT)))) {
            fprintf(stderr, "ERROR: alloc_sb: SB cell temp_next array malloc failed\n");
            return(1);
         }
         if (!(sp->c_fg_temp_next = (CA_FLOAT *) calloc(nxny, sizeof(CA_FLOAT)))) {
            fprintf(stderr, "ERROR: alloc_sb: SB cell temp_next array malloc failed\n");
            return(1);
         }
      }
       
      /* malloc array for curvature */ /*by xly 2004/08/09*/
      /* protected by options rca 2007 01 15 */
      /**todo: finetune the options to avoid excessive memory allocation when the options are not used*/
      if ((bp->ctrl->curvature_3D == 1 ) || (bp->ctrl->curvature_2D == 1)|| (bp->ctrl->curvature_2D == 2)) {
        if (!(sp->curv = (CA_FLOAT *) calloc(nc+2, sizeof(CA_FLOAT)))) {

           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to curv malloc failed\n");
           return (1);
        }   
         if (!(sp->norm_x = (CA_FLOAT *) calloc(nc+2, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to norm_x malloc failed\n");
           return (1);   
        }
         if (!(sp->norm_y = (CA_FLOAT *) calloc(nc+2, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to norm_y malloc failed\n");
           return (1);   
        } 
      	if (!(sp->norm_z = (CA_FLOAT *) calloc(nc+2, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to norm_z malloc failed\n");
           return (1);
        }
      }
      /* models by ly*/
      if( (bp->ctrl->curvature_2D == 2) ||(bp->ctrl->curvature_2D == 3)){
      if (!(sp->Tunder_curv = (CA_FLOAT *) calloc(nc+2, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to Tunder_curv malloc failed\n");
           return (1);
        }
      }
      
      if (bp->ctrl->maxucmap == 1) {
        if (!(sp->ucmax = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
	  fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to UCMAX malloc failed\n");
	  return (1);
	}
	if (!(sp->ucmax_t = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
	  fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to UCMAX_TIME malloc failed\n");
	  return (1);
	}
	
	
      }
      
      /* malloc array to hold solute conc of cells and initialise */
      if (bp->ctrl->diffuse == TRUE) {/* GAS solute array */
          sp->Svals[GAS].Cinit = bp->mprops.gasprops.Cinit;/*all the same for now!*/
          if (!(sp->c_sol = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
              fprintf(stderr, "ERROR: alloc_sb: SB cell sol array malloc failed\n");
              return(1);
          }
          /* set concentraion to initial value */
          for (i = 0; i < nc; i++)
/** \todo  compartmentalize the initialization seperate from allocaton -- merge-xly */
              *(sp->c_sol + i) = sp->Svals[GAS].Cinit;
          /* set value pointer array */
          bp->c_sol_values->block_array[sbnum] = sp->c_sol;
      }

  if (((bp->ctrl->diffuse_alloy == TRUE) || (bp->ctrl->particle == TRUE)) && (bp->ctrl->diffuse_alloy_multi == FALSE)&&(bp->ctrl->diffuse_alloy_poly == FALSE)) {        /*ALLOY solute array */
    sp->Svals[ALLOY].Cinit = bp->mprops.alloyprops[0].Cinit;       /*all the same for now! */
         if (!(sp->c_sol_alloy = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
            fprintf(stderr, "ERROR: alloc_sb: SB cell alloysol array malloc failed\n");
            return(1);
         }
         /* malloc array for C_E*/ /*by Wei WANG on 11-07-02*/
         if (bp->ctrl->decentred_octahedron == TRUE){
            if (!(sp->c_eqv_alloy = (CA_FLOAT * ) calloc(nc, sizeof(CA_FLOAT)))) {
               fprintf(stderr, "ERROR: alloc_sb: SB cell equiv. sol array malloc failed\n");
               return(1);
            }
         }

         /* set concentraion to initial value */
         for (i = 0; i < nc; i++) {
            *(sp->c_sol_alloy + i) = sp->Svals[ALLOY].Cinit;
            if (bp->ctrl->decentred_octahedron == TRUE)
               *(sp->c_eqv_alloy + i) = sp->Svals[ALLOY].Cinit; /*by Wei WANG 11-07-02*/
         }
         /* set value pointer array */
         bp->c_sol_alloy_values->block_array[sbnum] = sp->c_sol_alloy;
      }

      /* malloc array for decented octahedron */ /*by Wei Wang 11-07-02*/
      if (bp->ctrl->decentred_octahedron == TRUE) {        
        if (!(sp->dc_d = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to dc_d malloc failed\n");
        }
        if (!(sp->dc_x = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to dc_x malloc failed\n");
        }
        if (!(sp->dc_y = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to dc_y malloc failed\n");
        }
        if (!(sp->dc_z = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
           fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to dc_z malloc failed\n");
        }
      }
      
      /* solid fraction changes recored for Latent heat, by lyuan*/
      if (!(sp->c_dfs = (CA_FLOAT *) calloc(nc, sizeof(CA_FLOAT)))) {
         fprintf(stderr, "ERROR: alloc_sb: SB array of ptrs to dfs malloc failed\n");
      }
      

   /*allocate and initialise the multi component array*/

  #ifdef CHIRAZI_MULTI
   if (bp->ctrl->diffuse_alloy_multi == TRUE ) {

      sp->c_sol_alloy_multi=(CA_FLOAT **)calloc(ele_1,sizeof(CA_FLOAT *));
      sp->c_sol_tot_multi=(CA_FLOAT **)calloc(ele_1,sizeof(CA_FLOAT *));
      sp->c_sol_tot_old_multi=(CA_FLOAT **)calloc(ele_1,sizeof(CA_FLOAT *));
      sp->c_sol_n_eut_multi=(CA_FLOAT **)calloc(ele_1,sizeof(CA_FLOAT *));
      sp->c_sol_n_eut_old_multi=(CA_FLOAT **)calloc(ele_1,sizeof(CA_FLOAT *));

      for(j=0;j<ele_1;j++){

      sp->c_sol_alloy_multi[j]=(CA_FLOAT *)calloc(nc,sizeof(CA_FLOAT));
      sp->c_sol_tot_multi[j]=(CA_FLOAT *)calloc(nc,sizeof(CA_FLOAT));
      sp->c_sol_tot_old_multi[j]=(CA_FLOAT *)calloc(nc,sizeof(CA_FLOAT));
      sp->c_sol_n_eut_multi[j]=(CA_FLOAT *)calloc(nc,sizeof(CA_FLOAT));
      sp->c_sol_n_eut_old_multi[j]=(CA_FLOAT *)calloc(nc,sizeof(CA_FLOAT));

      /* set concentraion to initial value */
      for (i = 0; i < nc; i++){
         sp->c_sol_alloy_multi[j][i]=ms->Cinit_multi[j];
         sp->c_sol_tot_multi[j][i]=ms->Cinit_multi[j];
         sp->c_sol_tot_old_multi[j][i]=ms->Cinit_multi[j];
       }
      /* set value pointer array */
      bp->multi_conc[j]->block_array[sbnum] = sp->c_sol_alloy_multi[j];
      bp->multi_conc_tot[j]->block_array[sbnum] = sp->c_sol_tot_multi[j];
      bp->multi_conc_tot_old[j]->block_array[sbnum] = sp->c_sol_tot_old_multi[j];
      bp->multi_conc_n_eut[j]->block_array[sbnum] = sp->c_sol_n_eut_multi[j];
      bp->multi_conc_n_eut_old[j]->block_array[sbnum] = sp->c_sol_n_eut_old_multi[j];
    }
  }
  #endif /* CHIRAZI_MULTI */
  /* end of multi diff test */
   /************************************************/
      /*allocate nuc threshold array*/
      if ((bp->ctrl->block_nuc == TRUE )) { /*nuc threshold array*/
          if (!(sp->c_nuc_thresh = malloc(nc * sizeof(CA_FLOAT)))) {
              fprintf(stderr, "ERROR: alloc_sb: SB cell nuc thresh. array malloc failed, %i\n",nc*sizeof(CA_FLOAT));
              return(1);
          }
/*THUINET 05/05*/
      if (!(sp->nat_sol_site = malloc(nc * sizeof(CA_FLOAT)))) {
          fprintf(stderr, "ERROR: alloc_sb: SB cell nat_sol_site array malloc failed, %i\n",nc*sizeof(CA_FLOAT));
          return(1);
        }
/*END THUINET 05/05*/

        }
      /* allocate the initial structure to hold mould/casting interface cell location */
      alloc_SurCell(&(sp->surface));
      return(errors);
}/*end of alloc_sb subroutine*/

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_alloc_sb_c ()
{
  static char const rcsid[] = "$Id: alloc_sb.c 1482 2009-11-25 21:08:47Z  $";

   return(rcsid);
   }

/* end of rcs_id_subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:38  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.5.2.4  2006/02/20 14:51:22  rcatwood
RCS Log:Correced evil log message
RCS Log:
RCS Log:Revision 10.5.2.3  2006/02/20 12:00:13  lthuinet
RCS Log: A lot of modifications : add an option to treat correctly diffusion in the case the secondary eutectic phase is stoechiometric AND add a pointer to distinguish the nature of the cell and the nature of the grain
RCS Log:
RCS Log:Revision 10.5.2.2  2006/02/01 14:16:25  lthuinet
RCS Log:#update change of the calculation of supersaturation for gas in multicomponent
RCS Log:
RCS Log:Revision 10.5.2.1  2006/01/10 13:58:24  rcatwood
RCS Log:Temporary branch for merging lthuinet poly-component and main branch
RCS Log:
RCS Log:Revision 10.5  2005/12/06 13:09:54  rcatwood
RCS Log:Changed todo lists to Doxygen syntax
RCS Log:
RCS Log:Revision 10.4  2005/12/06 12:58:01  rcatwood
RCS Log:Improved the to-do list information
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.2  2005/11/24 13:10:54  rcatwood
RCS Log:Ran INDENT on all the files!
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:52  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1.2.1  2005/11/07 17:47:56  rcatwood
RCS Log:Branch uisng Xiao Li Yang final version
RCS Log:Revision 10.1  2005/11/03 11:56:46  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 9.3.4.1.6.1  2004/09/09 17:49:42  xly
RCS Log:add curvature undercooling by estimating interface normal of growing cells.
RCS Log:Revision 8.2.8.2  2005/11/02 11:55:05  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.3.4.1  2004/03/04 11:29:24  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 9.3  2003/11/18 13:22:40  rcatwood
RCS Log:Added routines to find and store the interface cells between the casting and the mould.
RCS Log:Added the surface cell storage structure to the subblock.
RCS Log:Improved mould source and nucleation  routines to use the surface cell structure
RCS Log:
RCS Log:Revision 9.2  2003/09/16 11:59:14  rcatwood
RCS Log:Improved micro/macro interpolation
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:33  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.2.2.6  2003/08/14 14:17:56  rcatwood
RCS Log:Working ca_procast new version, on linux
RCS Log:Added surface nucleation
RCS Log:Added mould source term
RCS Log:Changed printout headers
RCS Log:Temperature output image
RCS Log:
RCS Log:Revision 8.2.2.5  2003/06/16 17:19:26  rcatwood
RCS Log:Added restart with pores turned on
RCS Log:
RCS Log:Revision 8.2.2.4  2003/01/23 17:47:27  rcatwood
RCS Log:finite grid applied to decentered square,
RCS Log:works, but not checked for correct results.
RCS Log:
RCS Log:Revision 8.2.2.3  2003/01/22 16:53:42  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.2.2.2  2003/01/15 19:02:00  rcatwood
RCS Log:*** empty log message ***
RCS Log:
RCS Log:Revision 8.1.6.1  2002/11/06 17:27:45  rcatwood
RCS Log:NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:00  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.1  2002/10/17 16:52:36  rcatwood
RCS Log:Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log:Revision 1.1.4.5  2002/10/17 16:03:44  rcatwood
RCS Log:Fixed a subtle problem concerning the amount of gas in the pores
RCS Log:This required adding a lot of debugging #ifdef CHECK_GAS lines
RCS Log:
RCS Log:Revision 1.1.4.4  2002/10/07 13:24:28  ww1
RCS Log:fixed total fraction solid at each time step and remove curv from ctrl
RCS Log:
RCS Log:Revision 1.1.4.3  2002/09/13 11:02:17  rcatwood
RCS Log:added file position pointer for each subblock data location
RCS Log:de-linted the program a bit
RCS Log:
RCS Log:Revision 1.1.4.2  2002/09/13 09:10:17  rcatwood
RCS Log:only alloc C_E if decentered mode is on
RCS Log:started write_block for pore data - just a stub!
RCS Log:
RCS Log:Revision 1.1.4.1  2002/08/30 19:18:24  rcatwood
RCS Log:split bigblock and subblock allocation into seperate subroutines
RCS Log:from bigblock.c and open_sb.c: added alloc_bb.c and alloc_sb.c
RCS Log:
RCS Log:Revision 1.1.2.1  2002/07/09 09:39:50  rcatwood
RCS Log:split the initialization (open_sb) into two subroutines, one for allocating the
RCS Log:memory, one for seting up the values -- so that it may be used for reading in
RCS Log:or restarting (not resetting the nuclei and initial values)
RCS Log:
*/
