/****/
/******************************************************/
/*                 ca_phy_calc.c                      */
/*   Main subroutine for coupling CAFD with Physica   */
/*         Added by Lang YUAN on 15-05-2007           */
/******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "machine.h"
#include "blocks.h"
#include "ca_phy_calc.h"

/*

extern void CA_Phy_readin(Ctrl_str *cp, BB_struct *bp);
extern void tecplotop(CA_FLOAT *x, CA_FLOAT *y, CA_FLOAT *z, int nx, int ny, int nz, CA_FLOAT *data, CA_FLOAT *data1, CA_FLOAT *data2,CA_FLOAT *data3,int totalnum,char filename[100]);
extern int read_ca_phy (Ctrl_str *cp, BB_struct *bp);
extern void phy_cacell_generation(BB_struct *bp, CA_FLOAT *orig);
extern int ca_phy_interp(BB_struct *bp, CA_FLOAT *orig);
extern void phy_temp_calc(BB_struct * bp);
*/


void CA_Phy_readin(Ctrl_str * cp, BB_struct * bp)
{
	int i,j;
	int caindex,phy_step;
	int infoline, varnumb;
	CA_FLOAT datatemp;
	int phy_total_cell, phy_total_ele, phy_total_surface;
	CA_FLOAT *Phy_cord_x, *Phy_cord_y, *Phy_cord_z;
	CA_FLOAT *Phy_cell_T;
	CA_FLOAT *Phy_cell_u, *Phy_cell_v, *Phy_cell_w;
	CA_FLOAT *Phy_cell_p;

	char *Phyfn_T, *Phyfn_geo;

//	char Phyfn[MAX_STRING_LEN];
	char Geofilename[MAX_STRING_LEN];
	char Tfilename[MAX_STRING_LEN];
	char buf[MAX_STRING_LEN];
	FILE *fp, *fpgeo;


	sprintf(cp->Phyfn, D_PHYCASE_FILE);

	caindex=0;
	datatemp=0;
	phy_step=1;


	infoline=11;
	varnumb=1;   //Tn is the 7th

	/**** read in Phy_total_cell number from the geo file *****/
	
	sprintf(Geofilename, "%s_%d.geo", cp->Phyfn,phy_step);

	Phyfn_geo=Geofilename;


	if((fpgeo = fopen(Phyfn_geo, "r")) == NULL){
		fprintf (stderr,"ERROR: Phyfn_geo : can't open file %s\n", Phyfn_geo);
		return;
	}

	fprintf (stderr,"Phyfn_geo : open file %s\n", Phyfn_geo);

	fscanf(fpgeo, "%d", &i);
	fscanf(fpgeo, "%d", &phy_total_cell);
	fscanf(fpgeo, "%d", &phy_total_surface);
	fscanf(fpgeo, "%d", &phy_total_ele);

#ifdef TEST_PHY
	fprintf (stderr,"Phyfn_geo : the geo file contains %d nodes, %d surface, %d elements \n", phy_total_cell, phy_total_surface, phy_total_ele);
#endif

	fclose(fpgeo);

    /*****allocation of local arrays and variables******/
	if(!(Phy_cord_x = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT)))){
		fprintf (stderr,"ERROR: Phy_cord_x : can't allocation arrays\n");
		return;
	};
	Phy_cord_y = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT));
	Phy_cord_z = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT));
	Phy_cell_T = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT));
	Phy_cell_u = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT));
	Phy_cell_v = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT));
	Phy_cell_w = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT));
	Phy_cell_p = (CA_FLOAT *) calloc (phy_total_cell, sizeof(CA_FLOAT));
	
	/***********************************************/


	/**** read in T from the temperature profile *****/

	sprintf(Tfilename, "%s_%d.dat", cp->Phyfn, phy_step);

	Phyfn_T=Tfilename;
	
	if((fp = fopen(Phyfn_T, "r")) == NULL){
		fprintf (stderr,"ERROR: Phyfn_T : can't open file %s\n", Phyfn_T);
		return;
	}

	fprintf (stderr,"Phyfn_T : open file %s\n", Phyfn_T);

	for(i = 0; i < infoline ; i++) {
		fgets (buf, sizeof(buf), fp);
	}



	for(i = 0; i < phy_total_cell ; i++) {
		fscanf(fp, ""SCAN_F"", Phy_cord_x+i);
	}
	for(i = 0; i < phy_total_cell ; i++) {
		fscanf(fp, ""SCAN_F"", Phy_cord_y+i);
	}
	for(i = 0; i < phy_total_cell ; i++) {
		fscanf(fp, ""SCAN_F"", Phy_cord_z+i);
	}
	for(j = 0; j < varnumb; j++){
		for(i = 0; i < phy_total_cell ; i++) {
			fscanf(fp, ""SCAN_F"", &datatemp);
		}
	}
	for(i = 0; i < phy_total_cell ; i++) {
	        fscanf(fp, ""SCAN_F"", Phy_cell_u+i);
	}
	for(i = 0; i < phy_total_cell ; i++) {
                fscanf(fp, ""SCAN_F"", Phy_cell_v+i);
        }
	for(i = 0; i < phy_total_cell ; i++) {
                fscanf(fp, ""SCAN_F"", Phy_cell_w+i);
        }
	for(i = 0; i < phy_total_cell ; i++) {
		fscanf(fp, ""SCAN_F"", Phy_cell_T+i);
	}

	fclose(fp);



	/*************** calculate the cell numbers in xyz of 2D mesh from PHYSICA ************************/

	int phytnc[3];
	int xflag, yflag, zflag;
	
	xflag = yflag = zflag = 0;

	for(i = 0; i < phy_total_cell ; i++) {
		if(xflag == 0 && * Phy_cord_x == * (Phy_cord_x+i+1)) {
			xflag= i;
			if(xflag==0){
				fprintf (stderr,"Reorder : xflag = 0 ! Exiting...\n");
				exit (0);
			}
		
		}
	}

	if (VAR2D)	{
		phytnc[0]=xflag;
		phytnc[1]=1;
		phytnc[2]=phy_total_ele/xflag;
	}


#ifdef TEST_PHY
	fprintf (stderr,"Reorder : the cell numbers in x y z are:  %d  %d  %d \n", phytnc[0],phytnc[1],phytnc[2]);
#endif


#ifdef TEST_PHY
//	for (i = 0; i < phy_total_cell; i++){
	for (i = 0; i < 10; i++){
		fprintf (stderr,"index: %d	 x: %f y: %f z: %f T: %f \n", i, Phy_cord_x[i], Phy_cord_y[i], Phy_cord_z[i], Phy_cell_T[i]);
	}

	/* test the import coordinates and T data */
   // char filename[]="Phy_T.plt";
	tecplotop(Phy_cord_x, Phy_cord_y, Phy_cord_z, phytnc[0]+1, phytnc[1]+1, phytnc[2]+1, Phy_cell_T,0,0,0,0, phy_total_cell, "Phy_T.plt");
#endif


 	/*************** reorder the 2D mesh from PHYSICA ************************/

	CA_FLOAT *Phy_newcord_x, *Phy_newcord_y, *Phy_newcord_z;
	CA_FLOAT *Phy_newcell_T, *Phy_newcell_u, *Phy_newcell_v, *Phy_newcell_w;

	int phytncx, phytncy, phytncz;    //total nodes number in x y z of Phy

	phytncx=phytnc[0]+1;
	phytncy=phytnc[1]+1;
	phytncz=phytnc[2]+1;

	if(!(Phy_newcord_x = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT)))){
		fprintf (stderr,"ERROR: Phy_cord_x : can't allocation arrays\n");
		return;
	};
	Phy_newcord_y = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	Phy_newcord_z = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	Phy_newcell_T = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	Phy_newcell_u = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	Phy_newcell_v = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	Phy_newcell_w = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));

/*	bp->Phy_newcord_x = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	bp->Phy_newcord_y = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	bp->Phy_newcord_z = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
	bp->Phy_newcell_T = (CA_FLOAT *) calloc (phy_total_cell/2, sizeof(CA_FLOAT));
*/

    if (VAR2D){
	for(j = 0; j < phytncz; j++){
		for(i = 0; i < phytncx; i++){
			Phy_newcord_x[i+j*phytncx]=(Phy_cord_x[i+j*phytncx*phytncy]+Phy_cord_x[i+j*phytncx*phytncy+phytncx])/2;
			Phy_newcord_y[i+j*phytncx]=(Phy_cord_y[i+j*phytncx*phytncy]+Phy_cord_y[i+j*phytncx*phytncy+phytncx])/2;
			Phy_newcord_z[i+j*phytncx]=(Phy_cord_z[i+j*phytncx*phytncy]+Phy_cord_z[i+j*phytncx*phytncy+phytncx])/2;
			Phy_newcell_T[i+j*phytncx]=(Phy_cell_T[i+j*phytncx*phytncy]+Phy_cell_T[i+j*phytncx*phytncy+phytncx])/2;
			Phy_newcell_u[i+j*phytncx]=(Phy_cell_u[i+j*phytncx*phytncy]+Phy_cell_u[i+j*phytncx*phytncy+phytncx])/2;
			Phy_newcell_v[i+j*phytncx]=(Phy_cell_v[i+j*phytncx*phytncy]+Phy_cell_v[i+j*phytncx*phytncy+phytncx])/2;
			Phy_newcell_w[i+j*phytncx]=(Phy_cell_w[i+j*phytncx*phytncy]+Phy_cell_w[i+j*phytncx*phytncy+phytncx])/2;

		}
	}

		phy_total_cell=phy_total_cell/2;
		phytncy=1;

		for(i = 0; i < phy_total_cell; i++){
			Phy_newcord_y[i]=Phy_newcord_z[i];
			Phy_newcell_v[i]=Phy_newcell_w[i];
			Phy_newcord_z[i]=0;
			Phy_newcell_w[i]=0;
		}

	}

	bp->Phy_newcord_x = Phy_newcord_x;
	bp->Phy_newcord_y = Phy_newcord_y;
	bp->Phy_newcord_z = Phy_newcord_z;
	bp->Phy_newcell_T = Phy_newcell_T;
	bp->Phy_newcell_u = Phy_newcell_u;
	bp->Phy_newcell_v = Phy_newcell_v;
	bp->Phy_newcell_w = Phy_newcell_w;
	bp->phytncx = phytncx;
	bp->phytncy = phytncz;
	bp->phytncz = phytncy;
	bp->phy_total_cell = phy_total_cell;

        tecplotop(bp->Phy_newcord_x, bp->Phy_newcord_y, bp->Phy_newcord_z, bp->phytncx, bp->phytncy, bp->phytncz, bp->Phy_newcell_T,bp->Phy_newcell_u,bp->Phy_newcell_v,bp->Phy_newcell_w,bp->phy_total_cell, "Phy_new_T_main.plt");
 
	/***** free the local arrays and variables in read in******/
/*	free(Phy_newcell_u);
	free(Phy_newcell_v);
	free(Phy_newcell_w);
*/

	free(Phy_cord_x);
	free(Phy_cord_y);
	free(Phy_cord_z);
	free(Phy_cell_T);
	free(Phy_cell_u);
	free(Phy_cell_v);
	free(Phy_cell_w);
	free(Phy_cell_p);
	
}

/*
void tecplotop(CA_FLOAT *x, CA_FLOAT *y, CA_FLOAT *z, int nx, int ny, int nz, CA_FLOAT *data, CA_FLOAT *data1, CA_FLOAT *data2, CA_FLOAT *data3, int totalnum, char filename[20]){

     int tecflag, i;
     FILE *inf;

     tecflag=0;

     if(tecflag==0){
           inf=fopen(filename,"w+");
           fprintf(inf,"VARIABLES = \"X\"\n\"Y\"\n\"Z\"\n\"T\"\n\"U\"\n\"V\"\n\"W\"\n");
           tecflag=1;
     }else inf=fopen(filename,"a+");

     fprintf(inf,"ZONE T=\"G1\" I=%d, J=%d, K=%d \n DT=(SINGLE SINGLE SINGLE SINGLE SINGLE SINGLE SINGLE)\n",nx,ny,nz);
     for(i = 0;i < totalnum; i++) {
           fprintf(inf,"%f\t %f\t %f\t %f\t %f\t %f\t %f\n",x[i],y[i],z[i],data[i],data1[i],data2[i],data3[i]);
     }
     fclose(inf);

     fprintf (stderr,"Tecplotop: write the Phy data file: %s ! \n", filename);

}

*/

int read_ca_phy (Ctrl_str * cp, BB_struct * bp){
	
	char line[MAX_STRING_LEN];
	char *token;
	int i;
	int rflag = 0;


        /*****************    Default values    *************************/
	bp->phy_velofactor = 1;
	bp->phy_convection = 0;

	/****************     Start to read file  ***********************/
	
	fprintf (stderr, "Read_ca_phy : Reading the input file %s \n ", cp->fn_ca_phy);
 
	/********* Open the Physica control file **************************/


	if ((cp->fd_ca_phy = fopen (cp->fn_ca_phy, "r")) == NULL) {
	   fprintf (stderr, "Error: can't open input file: %s \n", cp->fn_ca_phy);
	   exit (0);
	}

	while (fgets (line, MAX_STRING_LEN, cp->fd_ca_phy) != NULL) {

        	if (line[0] == '%' || line[0] == '#' || (token = strtok (line, " ,;\t")) == NULL) {
    
			continue;
		}
		else if (strcasecmp (token, "Phy_tran") == 0) {
		        if ((token = strtok (NULL, " ,;\t\n")) != NULL) {
		               bp->phy_tran = (CA_FLOAT) atoi (token);
		               fprintf (stderr, "Phy_tran : %i \n", bp->phy_tran);
		        }
		        else {
		               bp->phy_tran = 0;
		               fprintf (stderr, "Error: physica transient, default value used: 0 \n");
		        }
		}else if (strcasecmp (token, "Tran_start_num") == 0) {
		         if ((token = strtok (NULL, " ,;\t\n")) != NULL) {
		                bp->fcountin = (CA_FLOAT) atoi (token);
		                fprintf (stderr, "File Starts from  : %i \n", bp->fcount);
		         }
		         else {
		                bp->fcountin = 1;
		         }
		}else if (strcasecmp (token, "CellOption") == 0) {
			if ((token = strtok (NULL, " ,;\t\n")) != NULL){
				bp->phy_option = atoi (token);
				fprintf (stderr, "CA_PHY celloption : %d \n", bp->phy_option);
			}
		        else {
				bp->phy_option = D_PHY_OPTION;
			rflag++;
				fprintf (stderr, "Error: CellOption, default value used: %d.\n", bp->phy_option);
			}
		} 
		else if (strcasecmp (token, "BigBlockOrigin") == 0 && bp->phy_option == 2) {
			for (i = 0; i < 3; i++) {
				if ((token = strtok (NULL, " ,;\t\n")) != NULL) {
					bp->orig_bb[i] = (CA_FLOAT) atof (token);
					fprintf (stderr, "BigBlockOrigin : %f \n", bp->orig_bb[i]);
				}
				else {
					bp->orig_bb[i] = 0.0;
					fprintf (stderr, "Error: BigBlockOrigin, default value used: %f.\n", 0.0);
				}
			}
		}
		else if (strcasecmp (token, "GrowVelocity") == 0) {
			if ((token = strtok (NULL, " ,;\t\n")) != NULL) {
				bp->phy_growvelocity = (CA_FLOAT) atof (token);
				fprintf (stderr, "GrowVelocity : %f \n", bp->phy_growvelocity);
			}
			else {
				bp->phy_growvelocity = D_PHY_GROWVELOCITY;
				fprintf (stderr, "Error: GrowVelocity, default value used: %f.\n", bp->phy_growvelocity);
			}
		}
		else if (strcasecmp (token, "Convection") == 0) {
		         if ((token = strtok (NULL, " ,;\t\n")) != NULL){
		                bp->phy_convection = atoi (token);
				if(!bp->ctrl->physica) bp->phy_convection = 0;
		                fprintf (stderr, "CA_PHY convection option : %d \n", bp->phy_convection);
		         }
		         else {
		                bp->phy_convection = D_PHY_CONVECTION;
			        rflag++;
			        fprintf (stderr, "Error: Convection Option, default value used: %d.\n", bp->phy_convection);
		         }
		}
		else if (strcasecmp (token, "Velofactor") == 0) {
		          if ((token = strtok (NULL, " ,;\t\n")) != NULL){
		                bp->phy_velofactor = (CA_FLOAT)atof (token);
		                fprintf (stderr, "CA_PHY velocity factor : %f \n", bp->phy_velofactor);
		          }
		          else {
		                bp->phy_velofactor = 1;
		                rflag++;
		                fprintf (stderr, "Error: CA_PHY velocity factor, default value used: %f.\n", bp->phy_velofactor);
		          }
		}
		 
		 
		else rflag++;	
  }                             /* end while */

/*	if (bp->phy_option == 1){
		bp->orig_bb[0]=bp->Phy_newcord_x[0];
		bp->orig_bb[1]=bp->Phy_newcord_y[0];
		bp->orig_bb[2]=bp->Phy_newcord_z[0];

		if(VAR2D) bp->orig_bb[2]=0.0;
	}
*/ //put this into cell generation

 return rflag;
}

/*
*/
   /************************************************************************/
   /*                        ca cell generation                            */
   /************************************************************************/

void phy_cacell_generation(BB_struct *bp, CA_FLOAT *orig){

  
//	CA_FLOAT *ca_cord_x, *ca_cord_y, *ca_cord_z;

	CA_FLOAT cellsize[3], maxsize;
	int total_ca_number;
	int counter;
	int i,j,k;
	int tncx,tncy,tncz;

    /****** known from the ca_geo input***********/

/*        bp->tnc[0]=20;   
	bp->tnc[1]=20;
	bp->tnc[2]=1;

	bp->size_c[0]=5e-4;
	bp->size_c[1]=5e-4;
	bp->size_c[2]=5e-4;
*/
	/*********************************************/
	
	if(VAR2D){
		tncx=bp->tnc[0];     //nodes number
		tncy=bp->tnc[1];
		tncz=1;
		if(bp->phy223d) tncz=bp->tnc[2];
	}else {
		tncx=bp->tnc[0];     
		tncy=bp->tnc[1];
		tncz=bp->tnc[2];
	}

	total_ca_number=1;

	if(bp->phy_option == 1){

	/***** generate cells for the whole ingot******/

		cellsize[0]=(CA_FLOAT)(fabs (bp->Phy_newcord_x[bp->phy_total_cell-1]-bp->Phy_newcord_x[0]))/bp->tnc[0];
		cellsize[1]=(CA_FLOAT)(fabs (bp->Phy_newcord_y[bp->phy_total_cell-1]-bp->Phy_newcord_y[0]))/bp->tnc[1];
		cellsize[2]=(CA_FLOAT)(fabs (bp->Phy_newcord_z[bp->phy_total_cell-1]-bp->Phy_newcord_z[0]))/bp->tnc[2];

		maxsize=MAX(MAX(cellsize[0],cellsize[1]),cellsize[2]);
	
		if (maxsize <= 0) {
			fprintf (stderr, "ERROR: ca cell generation: incorrect size generated %f \n Exiting... \n", maxsize);
			exit (0);
		} else	fprintf(stderr,"now the cellsize is %f\n", maxsize);

		for(i = 0; i < 3; i++) {
			bp->size_c[i]=maxsize;
		}

	        bp->orig_bb[0]=bp->Phy_newcord_x[0];
	        bp->orig_bb[1]=bp->Phy_newcord_y[0];
	        bp->orig_bb[2]=bp->Phy_newcord_z[0];

		if(VAR2D) bp->orig_bb[2]=0.0;

	}

//		if(VAR2D) bp->orig_bb[2]=0.0;
		
		
		total_ca_number=tncx*tncy*tncz;

//		fprintf (stderr, "ca cell generation: total ca node number : %d \n ", total_ca_number);

	/**************allocate ca cell coordinate arrays**********************/
	
/*		ca_cord_x = (CA_FLOAT *) calloc (total_ca_number+1, sizeof(CA_FLOAT));
		ca_cord_y = (CA_FLOAT *) calloc (total_ca_number+1, sizeof(CA_FLOAT));
		ca_cord_z = (CA_FLOAT *) calloc (total_ca_number+1, sizeof(CA_FLOAT));
*/
	/************************************************************************/


	/**************allocate ca cell coordinate arrays**********************/

	        counter=0;
		for(k = 0; k < tncz; k++){
			for (j = 0; j < tncy; j++){
				for(i = 0; i < tncx; i++){
					if (counter >= (total_ca_number+1)){
							fprintf(stderr, "ERROR: %s: Array overflow\n",__func__);
							exit(0);
				        }
					if (counter < 0){
							fprintf(stderr, "ERROR: %s: Array underflow\n",__func__);
							exit(0);
				        }
					bp->ca_cord_x[counter]=orig[0]+i*bp->size_c[0];
					bp->ca_cord_y[counter]=orig[1]+j*bp->size_c[1];
					bp->ca_cord_z[counter]=orig[2]+k*bp->size_c[2];

					if(VAR2D && !(bp->phy223d)) bp->ca_cord_z[counter]=0.0;

					counter++;
				}
			}
		}  /* end of i, j, k*/

	/*	bp->ca_cord_x=ca_cord_x;
		bp->ca_cord_y=ca_cord_y;
		bp->ca_cord_z=ca_cord_z;  */
		bp->tncx=tncx;
		bp->tncy=tncy;
		bp->tncz=tncz;
		bp->total_ca_number=total_ca_number;


		if(bp->ntsb == 1){
			bp->nc[0]=bp->tncx;
		        bp->nc[1]=bp->tncy;
			bp->nc[2]=bp->tncz;
		}
		

//		fprintf (stderr, "ca cell generation: total ca node number : %d \n ", counter);

	
}


int ca_phy_interp(BB_struct *bp, CA_FLOAT *orig){

	

	/************************************************************************/
	/*              ca_phy_interpolate                                      */
	/************************************************************************/

	int i, j, k;
	int phyindex, caindex;
//	CA_FLOAT *ca_cell_Tar;
	int tempx, tempy, tempz;
	int tempcube[8];
	CA_FLOAT dtx, dty, dtz;
	CA_FLOAT ttemp[6];
	CA_FLOAT tempv[6], tempu[6],tempw[6];
	int total_ca_number;

	
	/**************allocate ca cell temperature arrays**********************/

   /*	ca_cell_Tar = (CA_FLOAT *) calloc (bp->total_ca_number+1, sizeof(CA_FLOAT)); */


	
/*	if (orig[0] < bp->Phy_newcord_x [0] || orig[1] < bp->Phy_newcord_y [0] || orig[2] < bp->Phy_newcord_z [0] ) { 
		fprintf (stderr, "ERROR: ca_phy_interp: incorrect origin !! \nExiting... \n");
		exit (0);
	} 
*/	
//	else	fprintf(stderr, "the origin for T interpolate is %f   %f  %f \n", orig[0], orig[1], orig[2]);


	/********** get the interpolating point in the macro mesh **********/
	
	total_ca_number=bp->total_ca_number;

	/*slice cell numbers, if phy223d*/
	if(VAR2D && bp->phy223d) total_ca_number = (bp->tncx) * (bp->tncy);
	
	for (caindex = 0; caindex < total_ca_number; caindex++){

	for (i = 0; i < bp->phytncx; i++){
		if( bp->ca_cord_x[caindex] == bp->Phy_newcord_x[i]){
			tempx = i;
			break;
		} else if (bp->ca_cord_x[caindex] < bp->Phy_newcord_x[i]) {
			tempx = i-1;
			break;
		}  /*else if (bp->ca_cord_x[caindex] > bp->Phy_newcord_x[bp->total_ca_number-1]){
			tempx = bp->phytncx-2;
			break;
		}*/
	}

	for (j = 0; j < bp->phytncy; j++){
		if( bp->ca_cord_y[caindex] == bp->Phy_newcord_y[j*bp->phytncx]){
			tempy = j;
			break;
		} else	if( bp->ca_cord_y[caindex] < bp->Phy_newcord_y[j*bp->phytncx]){
			tempy =j-1;
			break;
		} /*else if (bp->ca_cord_y[caindex] > bp->Phy_newcord_y[bp->total_ca_number-1]){
		        tempy = bp->phytncy-1;
			break;
		}*/
	}	
	for (k = 0; k < bp->phytncz; k++){
		if( bp->ca_cord_z[caindex] == bp->Phy_newcord_z[k*bp->phytncx*bp->phytncz]){
			tempz = k;
			break;
		}else if(bp->ca_cord_z[caindex] < bp->Phy_newcord_z[k*bp->phytncx*bp->phytncz]){
			tempz = k-1;
			break;
		}

	}

	if(VAR2D) tempz = 0;


	if(tempx < 0 ||tempy < 0||tempz < 0 ){
	//	fprintf (stderr, "ERROR: ca_phy_interp: incorrect phy interpolating index !! \nShifting... \n");
	        tempx=tempy=0;
	//exit (0);
	}

	phyindex = tempx + tempy * bp->phytncx + tempz * bp->phytncx * bp->phytncy;


//#ifdef TEST_PHY
//	fprintf (stderr, "ca_phy_interpolate: tempx, tempy, tempz: %d  %d  %d \n", tempx, tempy, tempz);
//	fprintf (stderr, "ca_phy_interpolate: coordinate in Phy: %f  %f  %f \n", bp->Phy_newcord_x[phyindex], bp->Phy_newcord_y[phyindex], bp->Phy_newcord_z[phyindex]);
//#endif



	/***********************************************************************************/
	/* the ca cell is in the cube of phy cell with node index:
	   phyindex        phyindex+1			phyindex+nx			phyindex+nx+1
	   phyindex+nx*ny  phyindex+nx*ny+1		phyindex+nx*ny+nx   phyindex+nx*ny+nx+1 	*/
	/**********************************************************************************/

	tempcube[0]=phyindex;
	tempcube[1]=phyindex+1;
	tempcube[2]=phyindex+bp->phytncx;
	tempcube[3]=phyindex+bp->phytncx+1;
	tempcube[4]=phyindex+bp->phytncx*bp->phytncy;
	tempcube[5]=phyindex+bp->phytncx*bp->phytncy+1;
	tempcube[6]=phyindex+bp->phytncx*bp->phytncy+bp->phytncx;
	tempcube[7]=phyindex+bp->phytncx*bp->phytncy+bp->phytncx+1;

	if(VAR2D){
		for (i = 0; i < 4; i++){
			tempcube[i+4] = 0;
		}
	}

//#ifdef TEST_PHY
//	for(i = 0; i < 4; i++) {
//		printf( " tempcube[%d]  : %d \n ", i, tempcube[i] );
//	}
//#endif

	dtx=(bp->ca_cord_x[caindex]-bp->Phy_newcord_x[tempcube[0]])/(bp->Phy_newcord_x[tempcube[1]]-bp->Phy_newcord_x[tempcube[0]]);
	dty=(bp->ca_cord_y[caindex]-bp->Phy_newcord_y[tempcube[0]])/(bp->Phy_newcord_y[tempcube[2]]-bp->Phy_newcord_y[tempcube[0]]);
	if(VAR2D) dtz = 0;
	else	dtz=(bp->ca_cord_z[caindex]-bp->Phy_newcord_z[tempcube[0]])/(bp->Phy_newcord_z[tempcube[4]]-bp->Phy_newcord_z[tempcube[0]]);

	/*Interpolating Micro cell Temperature*/
	
	for(i = 0, j = 0; i < 7; i+=2){
		ttemp[j]=bp->Phy_newcell_T[tempcube[i]]+dtx*(bp->Phy_newcell_T[tempcube[i+1]]-bp->Phy_newcell_T[tempcube[i]]);
		j++;
	
	}
	for(i = 0; i < 3; i+=2){
		ttemp[j]=ttemp[i]+dty*(ttemp[i+1]-ttemp[i]);
		j++;
	}

	bp->ca_cell_Tar[caindex]=ttemp[4]+dtz*(ttemp[5]-ttemp[4]);

	/*Interpolating Micro cell Velocity*/
	
	if(bp->phy_convection){
	       for(i = 0, j = 0; i < 7; i+=2){
	            tempu[j]=bp->Phy_newcell_u[tempcube[i]]+dtx*(bp->Phy_newcell_u[tempcube[i+1]]-bp->Phy_newcell_u[tempcube[i]]);
		    tempv[j]=bp->Phy_newcell_v[tempcube[i]]+dtx*(bp->Phy_newcell_v[tempcube[i+1]]-bp->Phy_newcell_v[tempcube[i]]);
	            j++;
	        }
		for(i = 0; i < 3; i+=2){
		    tempu[j]=tempu[i]+dty*(tempu[i+1]-tempu[i]);
		    tempv[j]=tempv[i]+dty*(tempv[i+1]-tempv[i]);
		    j++;
		}
			
	bp->ca_cell_uar[caindex]=tempu[4]+dtz*(tempu[5]-tempu[4]);
	bp->ca_cell_var[caindex]=tempv[4]+dtz*(tempv[5]-tempv[4]);
		
	}
	
/*	ttemp[0]=bp->Phy_newcell_T[tempcube[0]]+dtx*(bp->Phy_newcell_T[tempcube[1]]-bp->Phy_newcell_T[tempcube[0]]);
	ttemp[1]=bp->Phy_newcell_T[tempcube[2]]+dtx*(bp->Phy_newcell_T[tempcube[3]]-bp->Phy_newcell_T[tempcube[2]]);

	bp->ca_cell_Tar[caindex]=ttemp[0]+dty*(ttemp[1]-ttemp[0]);

*/ //only for 2D interpolation


	}    /* end of loop caindex */ 


	/*Run 2d T in 3d, when tnz>1*/
	
	if(VAR2D && bp->phy223d){
		for(i=0; i < bp->tncz-1; i++){
			memcpy(bp->ca_cell_Tar+(i+1)*total_ca_number, bp->ca_cell_Tar+i*total_ca_number, total_ca_number*sizeof(CA_FLOAT));
		}

		if(bp->phy_convection){
		   for(i=0; i < bp->tncz-1; i++){
			memcpy(bp->ca_cell_uar+(i+1)*total_ca_number, bp->ca_cell_uar+i*total_ca_number, total_ca_number*sizeof(CA_FLOAT));
		   }
		   for(i=0; i < bp->tncz-1; i++){
			memcpy(bp->ca_cell_var+(i+1)*total_ca_number, bp->ca_cell_var+i*total_ca_number, total_ca_number*sizeof(CA_FLOAT));
		   }
		   for(i=0; i < bp->tncz-1; i++){
			memcpy(bp->ca_cell_war+(i+1)*total_ca_number, bp->ca_cell_war+i*total_ca_number, total_ca_number*sizeof(CA_FLOAT));
		   }
		}
	}
	return (0);

}



void phy_temp_calc(BB_struct * bp){
	
  CA_FLOAT orig[3];
	
  orig[0]=bp->orig_bb[0];
  orig[1]=bp->orig_bb[1]-bp->phy_growvelocity*bp->sim_time;
  orig[2]=bp->orig_bb[2];		

//  fprintf(stderr, "The new orig is %f %f %f \n", orig[0],orig[1],orig[2]);
  
  phy_cacell_generation(bp, orig);
  ca_phy_interp(bp, orig);


}



