#include <stdlib.h>
#include <stdio.h>
#include "machine.h"
#include "blocks.h"
#include "pore.h"

int check_pore (BB_struct * bp, PORE_str * porelist, int npores, int nt);
int check_sb (BB_struct * bp, int i);

/* realloc arrays to allow SSMALLOC_FASTCHK to catch heap corruption*/
/* use with caution since it could be very wasteful of memory! */
/* and cause everyone elses programs to grind to a halt, or crash */
int check_bb (BB_struct * bp)
{

  int i;
  int n, nco, nc;

  n = bp->ntsb;
  nc = bp->ncsb;
  nco = (bp->nc[0] + 2) * (bp->nc[1] + 2) * (bp->nc[2] + 2);

  for (i = 0; i < bp->ntsb; i++) {

    /*       fprintf(stderr,"Checking subblock %i\n",i); */
    check_sb (bp, i);
    if (realloc (bp->sb[i], sizeof (SB_struct)) == NULL)
      fprintf (stderr, "checkblock error 1");
  }

  realloc (bp->sb, n * sizeof (SB_struct *));
  realloc (bp->c_fs_values->block_array, n * sizeof (CA_FLOAT *));
  realloc (bp->c_fs_values, sizeof (Value_struct));

  realloc (bp->sch_fs_values->block_array, n * sizeof (CA_FLOAT *));
  realloc (bp->sch_fs_values, sizeof (Value_struct));
  realloc (bp->c_sol_values->block_array, n * sizeof (CA_FLOAT *));
  realloc (bp->c_sol_values, sizeof (Value_struct));
  realloc (bp->c_sol_alloy_values->block_array, n * sizeof (CA_FLOAT *));
  realloc (bp->c_sol_alloy_values, sizeof (Value_struct));

  realloc (bp->gr_array, n * sizeof (int *));

  realloc (bp->c_elm_array, n * sizeof (int *));

  realloc (bp->ftmp_one, nco * sizeof (CA_FLOAT));
  realloc (bp->ftmp_two, nco * sizeof (CA_FLOAT));
  realloc (bp->ftmp_three, nco * sizeof (CA_FLOAT));

#ifdef OLD_TUNDER
  realloc (bp->old_Tunder, nco * sizeof (CA_FLOAT));
#endif /*OLD_TUNDER */

  realloc (bp->itmp_one, nco * sizeof (int));

  /*check the grains */
  /*   fprintf(stderr,"Checking the grains\n"); */
  for (i = 0; i < bp->nprops.ngr; i++)
    realloc (bp->gr[i], sizeof (Ind_grain));

  realloc (bp->gr, bp->nprops.gd_max_total * sizeof (Ind_grain *));

  realloc (bp->ctrl->rgbp, sizeof (RGB_struct));

  return (0);
}
int check_sb (BB_struct * bp, int i)
{

  int nc, npores;
  SB_struct *sb;

  sb = bp->sb[i];
  nc = bp->ncsb;
  npores = sb->Npores;

  if (sb->open) {
    realloc (sb->gr, nc * sizeof (int));
    realloc (sb->c_elm, nc * sizeof (int));
    realloc (sb->c_fs, nc * sizeof (CA_FLOAT));
    realloc (sb->c_sol, nc * sizeof (CA_FLOAT));
    if (bp->ctrl->scheil)
      realloc (sb->sch_fs, nc * sizeof (CA_FLOAT));
    realloc (sb->c_sol_alloy, nc * sizeof (CA_FLOAT));

    /*check all the pores */
    check_pore (bp, sb->porelist, sb->Npores, bp->pprops.P_ntrad);

    realloc (sb->porelist, npores * sizeof (PORE_str));
  }

  return (0);

}
int check_pore (BB_struct * bp, PORE_str * porelist, int npores, int nt)
{
  int i, j;

  /*   fprintf(stderr,"Checking the pores\n"); */
  for (i = 0; i < npores; i++) {
    if ((porelist[i].State != PORE_NONE) && (porelist[i].State != PORE_LATENT)) {
      for (j = 0; j < N_T_LISTS; j++) {
        realloc (porelist[i].t_lists[j], nt * sizeof (CA_FLOAT));
      }
    }
    realloc (porelist[i].t_lists, N_T_LISTS * sizeof (CA_FLOAT *));
  }
  return (0);
}

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_checkblock_c ()
{
  static char const rcsid[] = "$Id: checkblock.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
