/*-----------------------------*/
/*
 *  External temperature input subroutine
    Data from GE, interplated from ProCast
 *
 *                           lyuan 07/10
 * */

#include "ext_inp.h"
#include "datatrans.h"

//#define EXT_TEST

#ifdef EXT_TEST
struct geometry{
  int nodex;
  int nodey;
  int nodez;
  double coordx;
  double coordy;
  double coordz;
  int status;
  int node;
};
#endif

int ext_ini_readin(Ctrl_str * cp, BB_struct *bp){
  int dim, mi, mj, mk, ni, nj, nk;
  int num_BBOX, id_BBOX, File_prefix_length, Num_steps, Num_fields;
  int num_components;
  int i, j, k;
  int fieldnamelen;
  char FILE_prefix[20]={'\0'};
  char field_name[20]={'\0'};
  char string[20]={'\0'};
  char buffer[20]={'\0'};
  

  int Num_nodes;
  int Num_nodes_with_values;
  int count;
  int count1;
  int count2;
  int cur_pos;

  int *status;
  double temp1;
  double Xmin,Ymin,Zmin,Xmax,Ymax,Zmax;
  double cellsize;
  double *times;

#ifdef EXT_TEST
  struct geometry *geo;
  FILE *out1;
  char *sptr;
  FILE *test3d;
  FILE *geom;
  double *tempo;
#endif
  FILE *fp;
  FILE *out;
  
  fp=fopen(cp->fn_extinp, "rb");
  out=fopen("EXT_Info.txt", "w");
  
  fread(&dim,sizeof(int),1,fp);
  fprintf(out,"dimensions\t%d\n",dim);
  
  fread(&Xmin,sizeof(double),1,fp);
  fread(&Ymin,sizeof(double),1,fp);
  fread(&Zmin,sizeof(double),1,fp);
  
  fprintf(out,"Xmin\t%lf\n",Xmin);
  fprintf(out,"Ymin\t%lf\n",Ymin);
  fprintf(out,"Zmin\t%lf\n",Zmin);
  
  bp->ext_xyz_min[0] = Xmin;
  bp->ext_xyz_min[1] = Ymin;
  bp->ext_xyz_min[2] = Zmin;
  
  fread(&Xmax,sizeof(double),1,fp);
  fread(&Ymax,sizeof(double),1,fp);
  fread(&Zmax,sizeof(double),1,fp);
  
  fprintf(out,"Xmax\t%lf\n",Xmax);
  fprintf(out,"Ymax\t%lf\n",Ymax);
  fprintf(out,"Zmax\t%lf\n",Zmax);

  bp->ext_xyz_max[0] = Xmax;
  bp->ext_xyz_max[1] = Ymax;
  bp->ext_xyz_max[2] = Zmax;
  
  fread(&cellsize,sizeof(double),1,fp); // in cm
  fprintf(out,"cellsize\t%lf\n",cellsize);

  bp->ext_cellsize = cellsize;
  
  fread(&mi,sizeof(int),1,fp);
  fread(&mj,sizeof(int),1,fp);
  fread(&mk,sizeof(int),1,fp);
  
  fprintf(out,"Mi\t%d\n",mi);
  fprintf(out,"Mj\t%d\n",mj);
  fprintf(out,"Mk\t%d\n",mk);
  
  fread(&ni,sizeof(int),1,fp);
  fread(&nj,sizeof(int),1,fp);
  fread(&nk,sizeof(int),1,fp);
  
  fprintf(out,"Ni\t%d\n",ni);
  fprintf(out,"Nj\t%d\n",nj);
  fprintf(out,"Nk\t%d\n",nk);

  bp->ext_nc[0] = ni+1;
  bp->ext_nc[1] = nj+1;
  bp->ext_nc[2] = nk+1;
   
  status=(int *)(malloc(sizeof(int)*(ni+1)*(nj+1)*(nk+1)));
  if(!status)exit(0);

#ifdef EXT_TEST
  geo=(struct geometry *)(malloc((ni+1)*(nj+1)*(nk+1)*sizeof(struct geometry )));
  if(!geo)exit(0);
#endif
  
  fread(&num_BBOX,sizeof(int),1,fp);
  fread(&id_BBOX,sizeof(int),1,fp);	
  
  fprintf(out,"num_BBOX\t%d\n",num_BBOX);
  fprintf(out,"id_BBOX\t%d\n",id_BBOX);
  
  fread(&File_prefix_length,sizeof(int),1,fp);
  fread(&FILE_prefix,sizeof(char),File_prefix_length,fp);
  
  fprintf(out,"File_prefix_length\t%d\n",File_prefix_length);
  fprintf(out,"File_prefix\t%s\n",FILE_prefix);
  
  fread(&Num_steps,sizeof(int),1,fp);	
  fread(&Num_fields,sizeof(int),1,fp);	
  
  fprintf(out,"Num_steps\t%d\n",Num_steps);
  fprintf(out,"Num_fields\t%d\n",Num_fields);
  
  bp->ext_num_steps = Num_steps;
  bp->ext_num_fields = Num_fields;
  

/*--- allocate mameory ----*/

  ext_alloc_bb(bp);
  
  times = bp->ext_times;
  
  fread(times,sizeof(double),Num_steps,fp);
  
  fprintf(out,"times\n");
  for(i=0;i<Num_steps;i++)
	  fprintf(out,"%lf\n",times[i]);
  
  for(i=0;i<Num_fields;i++){
	  fread(&num_components,sizeof(int),1,fp);
	  fread(&fieldnamelen,sizeof(int),1,fp);
	  fread(&field_name,sizeof(char),fieldnamelen,fp);
	  
	  //fprintf(out,"num fields %d\n",i);
	  fprintf(out,"Num_components\t%d\n",num_components);
	  fprintf(out,"fieldnamelen\t%d\n",fieldnamelen);
	  fprintf(out,"field_name\t%s\n",field_name);

	  bp->ext_num_comp = num_components;
   }
  
  
  fread(&Num_nodes,sizeof(int),1,fp);
  fread(&Num_nodes_with_values,sizeof(int),1,fp);
  
  fprintf(out,"Num_nodes\t%d\n",Num_nodes);
  fprintf(out,"Num_nodes_with_values\t%d\n",Num_nodes_with_values);

  bp->ext_num_nodes = Num_nodes;
  bp->ext_nodes_values = Num_nodes_with_values;
  bp->ext_temp_length = (bp->ext_nodes_values * bp->ext_num_fields * bp->ext_num_comp);
  
#ifdef EXT_TEST
  tempo=(double *)(malloc(sizeof(double )*(Num_nodes_with_values*Num_fields*num_components)));
  if(!tempo)exit(0);
#endif
  
  fread(status,sizeof(int),Num_nodes,fp);
  fprintf(out,"status\n");

  //transfer status to 3D array
  intvectorin(bp->ext_status, status, 0, ni, 0, nj, 0, nk);

#ifdef EXT_TEST

  test3d = fopen("3d_array.txt", "w");
  fprintf(test3d, "i \t j \t k \t status \n");
  for(k=0; k<=nk; k++){
    for(j=0; j<=nj; j++){
      for(i=0; i<=ni; i++){
	 fprintf(test3d, "%d \t %d \t %d \t %d \n", i, j, k, bp->ext_status[i][j][k]);
      }  
    }
  }
  fclose(test3d);
  
#endif
  
  cur_pos = ftell(fp);
  fprintf(out,"current position: %d \n", cur_pos);

  bp->cur_pos_start = cur_pos;

#ifdef EXT_TEST

  geom = fopen("geometry.txt","w");
  fprintf(geom,"nodeid \t nodei \t nodej \t nodek \t coordx \t coordy \t coordz\n\n");
  
  count1=0;
  count2=0;
  for(k=0;k<nk+1;k++){
    for(j=0;j<nj+1;j++){
      for(i=0;i<ni+1;i++){
        geo[count1].nodex=mi+i;
	geo[count1].nodey=mj+j;
	geo[count1].nodez=mk+k;
	
	geo[count1].coordx=(double)(mi+i)*cellsize;
	geo[count1].coordy=(double)(mj+j)*cellsize;
	geo[count1].coordz=(double)(mk+k)*cellsize;
	
	geo[count1].status=status[count1];
	
	if(geo[count1].status==1)
	  count2++;
	  geo[count1].node=count1;
	  fprintf(geom,"%d\t%d\t%d\t%d\t%lf\t%lf\t%lf\n",geo[count1].node,geo[count1].nodex,
	  geo[count1].nodey,geo[count1].nodez,geo[count1].coordx,
	  geo[count1].coordy,geo[count1].coordz);
	  
	  count1++;
      }
    }
  }
  
  fclose(geom);
  
  if(count1!=Num_nodes){
	  printf("error in Num_nodes \n");
	  exit(0);
  }
  
  if(count2!=Num_nodes_with_values){
	  printf("error in Num_nodes_with_values\n");
	  exit(0);
  }
  
/*  for(count=0;count<Num_steps;count++){
    strcpy( string, "Temp");
    sptr=it_oa(count,buffer);
    strcat(string,buffer);
    
    strcat(string,".txt");
    out1=fopen(string,"w");
    
    fread(tempo,sizeof(double),(Num_nodes_with_values*Num_fields*num_components),fp);
    
    printf("tempo[0] = %f \n", tempo[0]);
    
    cur_pos = ftell(fp);
    fprintf(out,"current position: %d \n", cur_pos);
    
    count2=0;
    for(i=0;i<count1;i++){
	    fprintf(out1,"node(i j k):\t%d\t%d\t%d\n",geo[i].nodex,geo[i].nodey,geo[i].nodez);
	    if(geo[i].status==1){
		    for(j=0;j<Num_fields;j++){
			    fprintf(out1,"field:\t%d\n",j);
			    for(k=0;k<num_components;k++){
				    temp1=tempo[count2];
				    fprintf(out1,"component\t%d\n value %lf\n",k,temp1);
				    count2++;
			    }
		    }
	    }
	    else{
		    for(j=0;j<Num_fields;j++){
			    fprintf(out1,"field:\t%d\n",j);
			    for(k=0;k<num_components;k++){
				    temp1=-274.0;
				    fprintf(out1,"component\t%d\n value %lf\n",k,temp1);
			    }
		    }
	    }
	    
    }
    fclose(out1);
  }
*/  
#endif 

  
  fseek(fp, 0, SEEK_END);
  bp->cur_pos_end = ftell(fp);
  fprintf(out,"current position: %d \n", bp->cur_pos_end);

  fclose(fp);
  fclose(out);
  free(status);

#ifdef EXT_TEST
  free(tempo);
  free(geo);
#endif  

  
}

int ext_readin(Ctrl_str * cp, BB_struct *bp, int fcount){

  FILE *fp;
  double *tempo;
  int cur_pos;
  int i, j, k;
  int index;
  

  /*--set current location of the pointer --*/
  if( fcount < 0) printf("ERROR: \tfcount is too small!! \n"), exit(0);
  if(fcount == 0) cur_pos = bp->cur_pos_start;
  if(fcount > 0) cur_pos = bp->cur_pos_start + sizeof(double)*bp->ext_temp_length * fcount;  
  if( cur_pos > bp->cur_pos_end) printf("ERROR: \tfcount(%d) is too large !! \n", fcount),exit(0);
  
  tempo=(double *)(malloc(bp->ext_temp_length*sizeof(double)));
  
  if((fp=fopen(cp->fn_extinp, "rb")) == 0) printf("ERROR: \tcannot open file: %s!! \n", cp->fn_extinp), exit (0);
  
  fseek(fp, cur_pos, SEEK_SET);
  
  fread(tempo,sizeof(double),bp->ext_temp_length,fp);
  
  printf("tempo_New[0] = %f \n", tempo[0]);
  
  index = 0;

  //send the data to bp->ext_temp_new
  for(k = 0; k < bp->ext_nc[2]; k++){
    for(j = 0; j < bp->ext_nc[1]; j++){
      for(i = 0; i < bp->ext_nc[0]; i++){
        if(bp->ext_status[i][j][k] == 1) {
	  bp->ext_temp_new[i][j][k] = tempo[index];
	  index ++;
	}else bp->ext_temp_new[i][j][k] = -274;
      }
    }
  }

  fprintf(stderr, "EXT TEMP: Macro timestep: %d, time: %f \n", bp->ext_count, bp->ext_times[bp->ext_count]);
  
 
//  printf("ext_temp_new[12][5][59] = %f \n", bp->ext_temp_new[12][5][59]);
  
  fclose(fp);
  free(tempo);
  return 1;
  
}

int ext_dataexchange(BB_struct *bp){
  
  int i, j, k;

  for(k = 0; k < bp->ext_nc[2]; k++){
    for(j = 0; j < bp->ext_nc[1]; j++){
      for(i = 0; i < bp->ext_nc[0]; i++){
	bp->ext_temp_old[i][j][k] = bp->ext_temp_new[i][j][k];
      }
    }
  }
  

  return 1;
}

int ext_set_cells (BB_struct *bp, int sbnum){
  
  int i, j, k;
  CA_FLOAT *c_fs, *c_sol_alloy;
  int *gr;

  gr = bp->sb[sbnum]->gr;
  c_fs = bp->sb[sbnum]->c_fs;
  c_sol_alloy = bp->sb[sbnum]->c_sol_alloy;


  for(k = 0; k < bp->ext_nc[2]; k++){
    for(j = 0; j < bp->ext_nc[1]; j++){
      for(i = 0; i < bp->ext_nc[0]; i++){
        if(bp->ext_status[i][j][k] == 0) {
	  *gr = NOT_CASTING;
	  *c_fs = NOT_CASTING;
          if(bp->ctrl->diffuse_alloy == 1) c_sol_alloy = NOT_CASTING;	  
	} 
	gr ++;
	c_fs ++;
	if(bp->ctrl->diffuse_alloy == 1) c_sol_alloy++;
      }
    }
  }
  return 1;
}

int ext_temp_interp(BB_struct *bp, CA_FLOAT timenow, int fcount){
  
  int i, j, k;
  CA_FLOAT dtime;

  dtime = (timenow - bp->ext_times[fcount-1])/ (bp->ext_times[fcount] - bp->ext_times[fcount-1]);

  for(k = 0; k < bp->ext_nc[2]; k++){
    for(j = 0; j < bp->ext_nc[1]; j++){
      for(i = 0; i < bp->ext_nc[0]; i++){
	bp->ext_temp[i][j][k] = bp->ext_temp_old[i][j][k]+ dtime*(bp->ext_temp_new[i][j][k]-bp->ext_temp_old[i][j][k]);
      }
    }
  }


  return 1;
}


