/**-----------------------------------------------------------------------**/
/*            Main Head file for  Fluid Flow Code   by lyuan   01/2008   
 *              *             						*/
/**-----------------------------------------------------------------------**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "machine.h"
#include "blocks.h"
#include "ff_memory.h"

#define GAMMA 0			// 0 CENTRAL DIFFERENCE; 1 UPWIND
#define OMEGA 1.7			//Relaxation parameter for SOR iteration
#define ITERMAX 300					//itermax: maximal number of pressure iterations in one time step
#define EPS 0.00001				//eps : stopping tolerance for pressure iteration
#define TOTALITER 200000

#define BCCELL -5
#define FFCELL -2
#define INLETCELL -3
#define OUTLETCELL -4

#define MAX(A,B) ( (A) > (B) ? (A) : (B))

//#define LYUAN_LEFTIN

#define LYUAN_DOWNIN   //periodic bcs for left and right walls
				      

//#define IMAX 50 //80  //
//#define JMAX 50 //60  //
//#define KMAX 1

//#define DELTX  0.02 // 1.97522e-3 // 1.11e-3  //
//#define DELTY  0.02 
//#define DELTZ  1 

//#define DELTT 0.0001  // time step

/*
#define GX 0.0
#define GY 1000  // 9.8  //
#define GZ 0.0
#define CCCONST 0  //Carman-Cozeny  premeability

#define BETA  0.01 //5.8e-5 //  0.00341 // //thermal expansion coeffiecient
#define TEMP_REF 0.5 //301.3 // 2 // 
#define LATENTHEAT 5 //7.982e4
#define SPECIFICHEAT  1 //378.5 //
#define THERMCOND 0.001 //32   // W/mK 
*/
//#define INIIVELOCITY 0.0001
#define INITFL 1

/*
//#define INITTEMP 0.5 //301.3 // 2 //
#define INITTEMPHIGH 0.5 //311 //  12 //
#define INITTEMPCOLD  -0.5 // 

#define TEMPMELT 0.05 //302.78  //liquidus temp
#define TEMPSOLID -0.05 //301.7  //solidus temp


#define MDENSITY  1 //5907   // kg/m3  1.19 // 1.19  //
#define MVISCOSITY 1 //2.04e-3  //kg/ms  1.8e-5 //
*/

/*
CA_FLOAT ***realmemalloc(int nxl,int nxh,int nyl,int nyh,int nzl, int nzh);
void freerealmem(CA_FLOAT*** m,int nxl,int nxh,int nyl,int nyh,int nzl, int nzh);
int ***intmemalloc(int nxl,int nxh,int nyl,int nyh,int nzl, int nzh);
void freeintmem(int*** m,int nxl,int nxh,int nyl,int nyh,int nzl, int nzh);
*/
				      
int ff_alloc_bb(BB_struct *bp);
int ff_free_bb(BB_struct *bp);

/*-----------------------------------------------------------------*/
/*	subroutines for calculating Fluid flow  		   */
/*-----------------------------------------------------------------*/

void initvelocity(BB_struct *bp);
int ff_timestep(BB_struct *bp);
void boundary (BB_struct *bp);
void boundary_cyc (BB_struct *bp);

void calc_fgh(BB_struct *bp);
void poisson_rhs(BB_struct *bp);
int ppe_sor(BB_struct *bp);
void newvelocity(BB_struct *bp);
int PPE_ICCG(BB_struct *bp,CA_FLOAT ***pe,CA_FLOAT ***pw,CA_FLOAT ***pn,CA_FLOAT ***ps,CA_FLOAT ***pt,CA_FLOAT ***pb,CA_FLOAT ***pp, CA_FLOAT ***rhs, CA_FLOAT ***sol);

void pltout(BB_struct * bp, int num);

void calc_temp(BB_struct *bp);
void calc_velop2(BB_struct *bp);     /* Implicit way to calculate velocity field*/
int calc_midv(BB_struct *bp);
void newvelocityp2(BB_struct *bp);
void poisson_rhsp2(BB_struct *bp);
void newpresp2(BB_struct *bp);
int ppe_iccgp2(BB_struct *bp);
int ppe_iccgtest(BB_struct *bp);
void calc_fgh_imptest(BB_struct *bp);

/*Energy equation based on Enthalpy function */
CA_FLOAT HtoT(BB_struct *bp, CA_FLOAT enthalpy, CA_FLOAT liq_f);       /*Transfer Enthalpy(H) to Temperature(T)*/
void calc_temp_enthalpy(BB_struct *bp);
