/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008      
			Computation of new velocity field 
*/
/*----------------------------------------------------------------------*/

#include "ff_mpflow.h"


void newvelocity(BB_struct *bp){

	int i,j,k;
	int ***cflag;
	CA_FLOAT delttime, sizex, sizey, sizez;
//	CA_FLOAT ***ca_cell_fl;
	CA_FLOAT ***ca_cell_p, ***ca_cell_ftry, ***ca_cell_delp;
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w;
	CA_FLOAT ***cell_f, ***cell_g, ***cell_h;
	CA_FLOAT resnorm, tempres;
	CA_FLOAT ftrytemp;
	int IMAX, JMAX, KMAX;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
				

	cflag = bp->cflag;
//	ca_cell_fl = bp->ca_cell_fl;
	ca_cell_ftry = bp->ca_cell_ftry;
	ca_cell_p = bp->ca_cell_p;
	ca_cell_delp = bp->ca_cell_delp;
	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
	cell_f = bp->cell_f;
	cell_g = bp->cell_g;
	cell_h = bp->cell_h;
	ftrytemp = 0.0;
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	delttime = bp->delt;
					

// && ca_cell_fl[i][j][k] != 0 && ca_cell_ftry[i][j][k] != 0

	for (i=1; i<=IMAX-1; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i+1][j][k] == FFCELL) {
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])/2 ;
		ca_cell_u[i][j][k] = cell_f[i][j][k]-ftrytemp*delttime*(ca_cell_p[i+1][j][k]-ca_cell_p[i][j][k])/sizex;
	      }
//	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0) //|| ca_cell_ftry[i][j][k] == 0
//	        ca_cell_u[i][j][k] = 0.0;
	    }
	  }
	}

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX-1; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j+1][k] == FFCELL ) {
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2 ;
		ca_cell_v[i][j][k] = cell_g[i][j][k]-ftrytemp*delttime*(ca_cell_p[i][j+1][k]-ca_cell_p[i][j][k])/sizey;			     }
//	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
//		ca_cell_v[i][j][k] = 0.0;
	    }
	  }
	}

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX-1; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j][k+1] == FFCELL ){
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2 ;
		ca_cell_w[i][j][k] = cell_h[i][j][k]-ftrytemp*delttime*(ca_cell_p[i][j][k+1]-ca_cell_p[i][j][k])/sizez;			     }
//	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
//		ca_cell_w[i][j][k] = 0.0;
	    }
	  }
	}
/*
	for (i=1; i<=IMAX-1; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i+1][j][k] == FFCELL && ca_cell_ftry[i][j][k] != 0) {
	        ca_cell_u[i][j][k] = cell_f[i][j][k]/ca_cell_fl[i][j][k]-delttime*(ca_cell_p[i+1][j][k]-ca_cell_p[i][j][k])/sizex;
	      }
	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0) //|| ca_cell_ftry[i][j][k] == 0
	        ca_cell_u[i][j][k] = 0.0;
	    }
	  }
	}

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX-1; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j+1][k] == FFCELL && ca_cell_ftry[i][j][k] != 0) {
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2 ;
		ca_cell_v[i][j][k] = cell_g[i][j][k]/ca_cell_fl[i][j][k]-ftrytemp*delttime*(ca_cell_p[i][j+1][k]-ca_cell_p[i][j][k])/sizey;			     }
	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
		ca_cell_v[i][j][k] = 0.0;
	    }
	  }
	}

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX-1; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j][k+1] == FFCELL && ca_cell_ftry[i][j][k] != 0){
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2 ;
		ca_cell_w[i][j][k] = cell_h[i][j][k]/ca_cell_fl[i][j][k]-ftrytemp*delttime*(ca_cell_p[i][j][k+1]-ca_cell_p[i][j][k])/sizez;			     }
     	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
	        ca_cell_w[i][j][k] = 0.0;
	    }
	  }
	}
*/

	resnorm = tempres = 0.0;
	for (k=1; k<=KMAX-1; k++) {
	  for (j=1; j<=JMAX-1; j++)	{
	    for (i=1; i<=IMAX-1; i++)	{
	      tempres = (ca_cell_u[i+1][j][k]-ca_cell_u[i][j][k])/sizex + 
		(ca_cell_v[i+1][j][k]-ca_cell_v[i][j][k])/sizey +
		(ca_cell_w[i+1][j][k]-ca_cell_w[i][j][k])/sizez;
	      resnorm += tempres* tempres ; 
	    }
	  }
	}

	resnorm = sqrtf(resnorm / bp->totalffcnum);

	fprintf(stderr,  "res of Mass concervation : %f \n", resnorm);

}


void newvelocityp2(BB_struct *bp){
	
	int i,j,k;
	int ***cflag;
	CA_FLOAT delttime, sizex, sizey, sizez;
//	CA_FLOAT ***ca_cell_fl;
	CA_FLOAT ***ca_cell_p, ***ca_cell_ftry, ***ca_cell_delp;
	CA_FLOAT ***ca_cell_u, ***ca_cell_v, ***ca_cell_w;
//	CA_FLOAT ***ca_cell_uold, ***ca_cell_vold, ***ca_cell_wold;
	CA_FLOAT ***cell_f, ***cell_g, ***cell_h;
	CA_FLOAT ftrytemp;
	int IMAX, JMAX, KMAX;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	
	cflag = bp->cflag;
//	ca_cell_fl = bp->ca_cell_fl;
	ca_cell_ftry = bp->ca_cell_ftry;
	ca_cell_p = bp->ca_cell_p;
	ca_cell_delp = bp->ca_cell_delp;
	ca_cell_u = bp->ca_cell_u;
	ca_cell_v = bp->ca_cell_v;
	ca_cell_w = bp->ca_cell_w;
//	ca_cell_uold = bp->ca_cell_uold;
//	ca_cell_vold = bp->ca_cell_vold;
//	ca_cell_wold = bp->ca_cell_wold;
	cell_f = bp->cell_f;
	cell_g = bp->cell_g;
	cell_h = bp->cell_h;
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	delttime = bp->delt;
	ftrytemp = 0;
	

// u(n+1)=u(n)-delt*delp and force u(n+1)=0;
/*
	for (i=1; i<=IMAX-1; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i+1][j][k] == FFCELL && ca_cell_fl[i][j][k] != 0 && ca_cell_ftry[i][j][k] >= 0.5)
		ca_cell_u[i][j][k] = cell_f[i][j][k]/ca_cell_fl[i][j][k]-delttime*(ca_cell_delp[i+1][j][k]-ca_cell_delp[i][j][k])/sizex;
	      else if (ca_cell_fl[i][j][k] == 0  || ca_cell_ftry[i][j][k] <= 0.5) 
		ca_cell_u[i][j][k] = 0.0;
	    }
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX-1; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j+1][k] == FFCELL && ca_cell_fl[i][j][k] != 0 && ca_cell_ftry[i][j][k] >= 0.5)
		ca_cell_v[i][j][k] = cell_g[i][j][k]/ca_cell_fl[i][j][k]-delttime*(ca_cell_delp[i][j+1][k]-ca_cell_delp[i][j][k])/sizey;	
	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] <= 0.5)
		ca_cell_v[i][j][k] = 0.0;
	    }
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX-1; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j][k+1] == FFCELL && ca_cell_fl[i][j][k] != 0 && ca_cell_ftry[i][j][k] >= 0.5)
		ca_cell_w[i][j][k] = cell_h[i][j][k]/ca_cell_fl[i][j][k]-delttime*(ca_cell_delp[i][j][k+1]-ca_cell_delp[i][j][k])/sizez;			     
	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] <= 0.5)
		ca_cell_w[i][j][k] = 0.0;
	    }
	  }
	}

*/

// u(n+1)=u(n)-delt*f*delp;

	for (i=1; i<=IMAX-1; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i+1][j][k] == FFCELL) {
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])/2 ;
		ca_cell_u[i][j][k] = cell_f[i][j][k]-ftrytemp*delttime*(ca_cell_delp[i+1][j][k]-ca_cell_delp[i][j][k])/sizex;
	      }
// 	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0) //|| ca_cell_ftry[i][j][k] == 0
//		ca_cell_u[i][j][k] = 0.0;
	    }
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX-1; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j+1][k] == FFCELL ) {
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2 ;
	        ca_cell_v[i][j][k] = cell_g[i][j][k]-ftrytemp*delttime*(ca_cell_delp[i][j+1][k]-ca_cell_delp[i][j][k])/sizey;		     }
// 	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
//	        ca_cell_v[i][j][k] = 0.0;
	    }
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX-1; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j][k+1] == FFCELL ){
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2 ;
		ca_cell_w[i][j][k] = cell_h[i][j][k]-ftrytemp*delttime*(ca_cell_delp[i][j][k+1]-ca_cell_delp[i][j][k])/sizez;		     }
//	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
//		ca_cell_w[i][j][k] = 0.0;
	    }
	  }
	}

	
/*	
	
// u(n+1)=f*(u(n)-delt*delp);
	
	for (i=1; i<=IMAX-1; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i+1][j][k] == FFCELL) {
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i+1][j][k])/2 ;
		ca_cell_u[i][j][k] = ftrytemp* (cell_f[i][j][k]/ca_cell_fl[i][j][k]-delttime*(ca_cell_delp[i+1][j][k]-ca_cell_delp[i][j][k])/sizex);
	      }
//  	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0) //|| ca_cell_ftry[i][j][k] == 0
//    		ca_cell_u[i][j][k] = 0.0;
            }
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX-1; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j+1][k] == FFCELL ) {
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j+1][k])/2 ;
		ca_cell_v[i][j][k] = ftrytemp*(cell_g[i][j][k]/ca_cell_fl[i][j][k]-delttime*(ca_cell_delp[i][j+1][k]-ca_cell_delp[i][j][k])/sizey);		     }
//            else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
//		ca_cell_v[i][j][k] = 0.0;
   	    }
	  }
	}
	
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX-1; k++){
	      if (cflag[i][j][k] == FFCELL && cflag[i][j][k+1] == FFCELL ){
		ftrytemp = (ca_cell_ftry[i][j][k]+ca_cell_ftry[i][j][k+1])/2 ;
		ca_cell_w[i][j][k] = ftrytemp* (cell_h[i][j][k]/ca_cell_fl[i][j][k]-delttime*(ca_cell_delp[i][j][k+1]-ca_cell_delp[i][j][k])/sizez);		     }
// 	      else if (ca_cell_fl[i][j][k] == 0 || ca_cell_ftry[i][j][k] == 0)
// 		ca_cell_w[i][j][k] = 0.0;
 	    }
	  }
	}
*/	
}

