/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008      
			Solution of Pressure by solving PPE using SOR
*/
/*----------------------------------------------------------------------*/

#include "ff_mpflow.h"


int ppe_sor(BB_struct *bp){

	int i,j,k;
	int iter, ffnum;
	CA_FLOAT ***ca_cell_p, ***ppe_rhs;
	int ***cflag;
	int iterflag;

	CA_FLOAT sizex,sizey,sizez;
	CA_FLOAT rev_dx2, rev_dy2, rev_dz2;
	CA_FLOAT rev_dxyz;
	CA_FLOAT ab_residual, rel_residual, temp_res;
	CA_FLOAT initp;
	int IMAX, JMAX, KMAX;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
				

	ca_cell_p = bp->ca_cell_p;
	ppe_rhs = bp->ppe_rhs;
	cflag = bp->cflag;
	ffnum = bp->totalffcnum;
        sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
			
	rev_dx2 = 1.0/sizex/sizex;
	rev_dy2 = 1.0/sizey/sizey;
	rev_dz2 = 1.0/sizez/sizez;
	rev_dxyz = OMEGA/(2.0 * (rev_dx2 + rev_dy2 + rev_dz2));

	initp = 0.0;
	iterflag = 0;
	iter = 0;

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if(cflag[i][j][k] == FFCELL) initp +=ca_cell_p[i][j][k]*ca_cell_p[i][j][k];
	    }
	  }
	}
			
	initp = sqrt(initp/ffnum);

/*-------------Boundary conditions for pressure-------------*/
/*	for (i=1; i<=IMAX; i++){
	  for (k=1; k<=KMAX; k++){
  	    ca_cell_p[i][0][k] = ca_cell_p[i][1][k];
	    ca_cell_p[i][JMAX+1][k] = ca_cell_p[i][JMAX][k];
	  }
	}

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    ca_cell_p[i][j][0] = ca_cell_p[i][j][1];
	    ca_cell_p[i][j][KMAX+1] = ca_cell_p[i][j][KMAX];
	  }
	}

	for (j=1; j<=JMAX; j++){
	  for (k=1; k<=KMAX; k++){
	    ca_cell_p[0][j][k] = ca_cell_p[1][j][k];
	    ca_cell_p[IMAX+1][j][k] = ca_cell_p[IMAX][j][k];
	  }
	}

	if (initp < 0.0001) initp = 1.0;
*/
/*---------------------SOR-iteration------------------------*/

	for (iter=0; iter<=ITERMAX; iter++){
	  iterflag = 0;
	
/*-------------Boundary conditions for pressure-------------*/

	  for (i=1; i<=IMAX; i++){
	    for (k=1; k<=KMAX; k++){
	      ca_cell_p[i][0][k] = ca_cell_p[i][1][k];
	      ca_cell_p[i][JMAX+1][k] = ca_cell_p[i][JMAX][k];
   	    }
	  }

	  for (i=1; i<=IMAX; i++){
	    for (j=1; j<=JMAX; j++){
	      ca_cell_p[i][j][0] = ca_cell_p[i][j][1];
	      ca_cell_p[i][j][KMAX+1] = ca_cell_p[i][j][KMAX];
	    }
	  }

	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      ca_cell_p[0][j][k] = ca_cell_p[1][j][k];
	      ca_cell_p[IMAX+1][j][k] = ca_cell_p[IMAX][j][k];
	  }
	 }

/*----------------------  SOR  -----------------------*/

	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
  	      if (cflag[i][j][k] != FFCELL) continue;

	      ca_cell_p[i][j][k] = (1.0-OMEGA)*ca_cell_p[i][j][k]+ 
		rev_dxyz*((ca_cell_p[i+1][j][k]+ca_cell_p[i-1][j][k])*rev_dx2+
		(ca_cell_p[i][j+1][k]+ca_cell_p[i][j-1][k])*rev_dy2 + 
		(ca_cell_p[i][j][k+1]+ca_cell_p[i][j][k-1])*rev_dz2 -
		ppe_rhs[i][j][k]);
					
	    } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/

/*------------- computation of residual --------------*/

	ab_residual = 0.0;
	rel_residual =0.0;
	temp_res = 0.0;

		
	for (i=1; i<=IMAX; i++){
	  for (j=1; j<=JMAX; j++){
	    for (k=1; k<=KMAX; k++){
	      if (cflag[i][j][k] != FFCELL) continue;
					
	      temp_res = (ca_cell_p[i+1][j][k]+ca_cell_p[i-1][j][k]-2.0*ca_cell_p[i][j][k])*rev_dx2+
		(ca_cell_p[i][j+1][k]+ca_cell_p[i][j-1][k]-2.0*ca_cell_p[i][j][k])*rev_dy2 +
		(ca_cell_p[i][j][k+1]+ca_cell_p[i][j][k-1]-2.0*ca_cell_p[i][j][k])*rev_dz2 -
		ppe_rhs[i][j][k];
	      temp_res = fabs(temp_res);

	      if (ab_residual <= temp_res) ab_residual = temp_res;

	      rel_residual += temp_res*temp_res;
					
	    } /* end of k loop*/
	  } /* end of j loop*/
	} /* end of i loop*/

	rel_residual = sqrtf(rel_residual/ffnum)/initp;

/*	if (rel_residual < EPS)	{
	  fprintf(stderr, "\t Relative tolerance is %f \n", rel_residual);
	  return iter;
	} 
*/
	if (ab_residual < EPS){
	  fprintf(stderr, "\t Absolute tolerance is %f \n", ab_residual);
	  return iter;
	}
      } 

      fprintf(stderr, "\t Iteration exceeded......\n");
      fprintf(stderr, "\t inter_iter = %i  absolute_res = %f   relative_res = %f\n", iter, ab_residual, rel_residual);

      return iter;
               

}

