/*----------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008      
						 Time step checking
*/
/*--------------------------------------------------------------------*/

#include "ff_mpflow.h"

int ff_timestep(BB_struct *bp){
	
	CA_FLOAT m_density, m_viscosity, delttime;
	CA_FLOAT tempt;
	CA_FLOAT sizex, sizey, sizez;
	CA_FLOAT Reynolds, therm_dif, fourier;
	int IMAX, JMAX, KMAX;
	CA_FLOAT INITVELO;

	IMAX = bp->tnc[0];
	JMAX = bp->tnc[1];
	KMAX = bp->tnc[2];
	INITVELO = MAX(fabs(bp->initvelo[0]),fabs(bp->initvelo[1]));
					
	sizex = bp->size_c[0];
	sizey = bp->size_c[1];
	sizez = bp->size_c[2];
	delttime = bp->delt;
	m_density = bp->mprops.rho;
	m_viscosity = bp->mprops.viscosity;
	therm_dif = bp->mprops.thermcond/bp->mprops.rhocp;

	tempt = 1/(1/(sizex*sizex)+1/(sizey*sizey)+1/(sizez*sizez));
	tempt = (m_density/m_viscosity)*tempt/3;

	fprintf(stderr, "\t FF: The time step should be less than : %e \n" , tempt);

//	if (delttime > tempt || delttime > (sizex/(INITVELO+EPS)))  return 1;

	Reynolds = INITVELO * (sizex * IMAX) / m_viscosity * m_density;

	fourier = 3* therm_dif * delttime / sizex / sizex;
	
	fprintf(stderr, "\t Reynolds number is : %f\n \t Fourier number is : %f \n" , Reynolds, fourier);
	
	fprintf(stderr, "\t FOURIER: The time step should be less than : %f \n" , sizex*sizex/therm_dif/6);

//	if (fourier >= 0.4) 	   return 1;

	return 0;
}

