#include <stdio.h>
#include "machine.h"
#include <math.h>
/**  \todo  figure out how to completely eliminate the need for this subroutine -- general - maybe done already?*/

int getxyz (int cellnum, int *nc, int *Cell)
{
/* cellnum = cell index to find the x,y,z for */
/* nc = array[3] of number of cells in x,y,z of block */
/* Cell = array[3] to put the calculated cell x,y,z into */

  int errors = 0;
  int cellx, celly, cellz;
  int nxny, nxnynz, ncx, ncy;

  /* double or else round-off is too big for 1/3 */
  double tmp1, tmp2, tmp3;

  ncx = *nc++;
  ncy = *nc++;
  nxny = ncx * ncy;
  nxnynz = nxny * (*nc);

  if (cellnum > nxnynz) {
    errors++;
  } else {
    tmp1 = (double) cellnum / (double) nxny;
    cellz = (int) (floor (tmp1));
    tmp2 = (double) (cellnum - cellz * nxny);
    tmp3 = tmp2 / (double) ncx;
    celly = (int) (floor (tmp3));
    cellx = cellnum - cellz * nxny - celly * ncx;

    *Cell++ = cellx;
    *Cell++ = celly;
    *Cell = cellz;
  }
  return (errors);
}

#ifdef TESTXYZ
void main ()
{
  int nc[3], Cell[3];
  int i;
  int cellnum, testnum;
  FILE *output;
  int errors;

  printf ("input system size:\n");
  for (i = 0; i < 3; i++) {
    scanf ("%i", &(nc[i]));
  }
  printf ("system size %i %i %i\n", nc[0], nc[1], nc[2]);

  while (1) {
    printf ("INput a cell number:");
    scanf ("%i", &cellnum);
    errors = getxyz (cellnum, nc, Cell);
    if (errors) {
      printf ("Error: cell %i out of range.\n", cellnum);
      break;
    } else {
      for (i = 0; i < 3; i++) {
        printf ("%i ", Cell[i]);
      }
      printf ("\n");
    }
  }
  output = fopen ("Cell.csv", "w");
  for (cellnum = 0; cellnum < nc[0] * nc[1] * nc[2]; cellnum++) {
    errors = getxyz (cellnum, nc, Cell);
    testnum = Cell[0] + Cell[1] * nc[0] + Cell[2] * nc[0] * nc[1];
    if (testnum != cellnum) {
      fprintf (output, "%i,", cellnum);
      for (i = 0; i < 3; i++) {
        fprintf (output, "%i,", Cell[i]);
      }
      fprintf (output, "\n");
    }
  }
  fclose (output);
}

#endif /*TESTXYZ*/
/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_getxyz_c ()
{
  static char const rcsid[] = "$Id: getxyz.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_subroutine */
