#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "machine.h"
#include "blocks.h"
#include "read_sb.h"
#include "interp.h"
#include "SurCellRoutines.h"
#include "ca_phy_calc.h"

#ifdef JUNK
/* functions not used JUNK */
/* functions used from sb_temp_calc.c */
extern int sb_temp_calc (BB_struct * bp, int sbnum);

/* subroutines later in the file ... */
extern int init_c_elm (BB_struct *, int);
extern int init_c_elm_solo (BB_struct *, int);
#endif
extern int init_nuc_thresh (BB_struct * bp, int sbnum);
extern int pore_setup (BB_struct * bp, int sbnum);
extern int sb_nuc (BB_struct * bp, int sbnum);
extern int alloc_sb (BB_struct * bp, int sbnum);

/* from user_rtns.c -- only used in procast mode */
extern void procast_sb_set_cells (BB_struct * bp, int sbnum);

extern void phy_temp_calc(BB_struct * bp);


int open_sb (BB_struct * bp, int sbnum)
{
  int errors = 0;
  int i, nc;
  int oldstep;
  SB_struct *sp;

  sp = bp->sb[sbnum];
  nc = bp->ncsb;

  if (sp->open == SB_OPEN) {    /*check if already open */
    fprintf (stderr, "ERROR: open_sb: SB %i already open.\n", sbnum);
    errors++;
    return (errors);
  }
  if (sp->open == SB_CLOSED) {  /*check if already closed */
    fprintf (stderr, "ERROR: open_sb: SB %i already used.\n", sbnum);
    errors++;
    return (errors);
  }

  sp->open = SB_OPEN;
  bp->sb_mask[sbnum] = TRUE;

      /********************************************/
      /** call the routine to allocate the memory */
      /** and cross link the pointers             */
      /** for this subblock                       */
      /********************************************/
  init_SurCell (&(sp->surface));
  errors += alloc_sb (bp, sbnum);

  sp->nmould = 0;
  if (bp->ctrl->input) {
#        ifndef ALLSLICE        /*copy single slice to all slices for pseudo 2d */
    read_bin_sb_slice (bp, sbnum);      /*copy image to all slices of sb for now */
#        else
    read_bin_sb (bp, sbnum);
#        endif /*ALL/SINGLESLICE */
    errors += fix_grains (bp, sbnum);
  }

  if (bp->ctrl->procast) {
    procast_sb_set_cells (bp, sbnum);
  }
  /* I have not considered the problems of inputting a partially complete slice at this point */
  /* so issue some warnings. Maybe it works anyways? -- Robert                                */
  if (bp->ctrl->input && bp->ctrl->procast && bp->ctrl->physica && bp->ctrl->ffheattran) {
    fprintf (stderr, "WARNING: open_sb: Input, procast and physica flags are active.\n");
    fprintf (stderr, "WARNING: open_sb: This behaviour has not been fully implemented.\n");
    fprintf (stderr, "WARNING: open_sb: Continuing anyways but there may be problems.\n");
  }

  /* EXTERNAL INPUT SET CELL STATUS*/
  if(bp->ctrl->extinput == 1) {
    ext_set_cells (bp, sbnum);
  } 

  /*allocate nuc threshold array */

/*THUINET 05/05*/

/*      if ((bp->ctrl->block_nuc == TRUE )) { *//*nuc threshold array*/

  if ((bp->ctrl->block_nuc == TRUE )&&(bp->ctrl->diffuse_alloy_poly == FALSE)) {
  /* set up the nucleation for this block*/
    if (! init_nuc_thresh(bp,sbnum) == 0 ){
      #ifndef ALWAYS_NUC
      fprintf(stderr,"... but in open_sb: ALWAYS_NUC is not defined so exiting due to init_nuc_thresh failure.\n");
      exit(1);
      #endif /*ALWAYS_NUC*/
    }

  }

  if ((bp->ctrl->block_nuc == TRUE )&&(bp->ctrl->diffuse_alloy_poly == TRUE)) { /*nuc threshold array*/
  /* set up the nucleation for this block*/
    if (! init_nuc_thresh_poly(bp,sbnum) == 0 ){
      #ifndef ALWAYS_NUC 
      fprintf(stderr,"... but in open_sb: ALWAYS_NUC is not defined so exiting due to init_nuc_thresh failure.\n");
      exit(1);
      #endif /*ALWAYS_NUC*/
    }
  }

  /*end allocate nuc threshold array */

#  ifdef USE_ELM
      /************************************************/
  /* Set the elm # if reading CAP CA file...      */
  /* or for testing, or reading input ......      */
      /************************************************/
  if (bp->ctrl->cap) {          /* Read elm # for all cells */
    init_c_elm (bp, sbnum);
  } else if (bp->ctrl->solo) {
    init_c_elm_solo (bp, sbnum);        /* set c_elm to cell # for test purposes */
#  else
  if (bp->ctrl->solo) {

#  endif /*USE_ELM */
    /* set initial Thermal Values... */
  }
      /***************************************************************/
  if (bp->ctrl->pore == TRUE) {
    errors += pore_setup (bp, sbnum);
  }
      /*************************************/
  /* pre-create the nuclei if FIXED... */
      /*************************************/
  if (bp->ctrl->fixed_nuc) {
    oldstep = bp->step;
    bp->step = INIT;
    sb_nuc (bp, sbnum);
    bp->step = oldstep;
  }
  if (bp->ctrl->fgrid_input) {
    wfact_r_calc (bp->fg, sp->nnd, bp, sbnum);
    wfact_z_calc (bp->fg, sp->nnd, bp, sbnum);
    wfact_r_calc (bp->fg_next, sp->nnd_next, bp, sbnum);
    wfact_z_calc (bp->fg_next, sp->nnd_next, bp, sbnum);
    sb_temp_setup (bp, sbnum);
  }

/*  if (bp->ctrl->physica) {
    phy_temp_calc(bp);
    sp->c_temp=bp->ca_cell_Tar;	  
  }
*/  
  sp->t_addsol = 0;
  return (errors);
}                               /*end of open_sb subroutine */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file */
char const *rcs_id_open_sb_c ()
{
  static char const rcsid[] = "$Id: open_sb.c 1491 2010-07-30 00:32:44Z  $";

  return (rcsid);
}

/* end of rcs_id_subroutine */

/*
RCS Log: $Log$
RCS Log: Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log: Merging polycomponent and gas with meltback
RCS Log:
RCS Log: Revision 10.3.2.2  2006/02/20 14:51:23  rcatwood
RCS Log: Correced evil log message
RCS Log:
RCS Log: Revision 10.3.2.1  2006/02/20 12:00:13  lthuinet
RCS Log: A lot of modifications : add an option to treat correctly diffusion in the case the secondary eutectic phase is stoechiometric AND add a pointer to distinguish the nature of the cell and the nature of the grain
RCS Log:
RCS Log: Revision 10.3  2005/12/01 14:38:01  rcatwood
RCS Log: Merged xly_05 changes into the main trunk
RCS Log: Primarily involving melt-back
RCS Log:
RCS Log: Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log: Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log: Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log: New version number -- using mould_src as base
RCS Log:
RCS Log: Revision 8.2.8.2  2005/11/02 11:55:05  rcatwood
RCS Log: Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log: Revision 9.2.4.2  2004/01/06 15:49:37  rcatwood
RCS Log: Fixed surface nucleation to work wtih Procast - moved transfer of NOT_CASTING information into open_sb
RCS Log:
RCS Log: Revision 9.2.4.1  2003/12/11 16:04:03  rcatwood
RCS Log: Branch for developing the mould solute source function
RCS Log:
RCS Log: Revision 9.2  2003/11/18 13:22:40  rcatwood
RCS Log: Added routines to find and store the interface cells between the casting and the mould.
RCS Log: Added the surface cell storage structure to the subblock.
RCS Log: Improved mould source and nucleation  routines to use the surface cell structure
RCS Log:
RCS Log: Revision 9.1  2003/08/14 14:38:37  rcatwood
RCS Log: Working merge with decentered/porosity/procast, also including
RCS Log: Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log: Revision 8.2.2.4  2003/08/14 14:18:03  rcatwood
RCS Log: Working ca_procast new version, on linux
RCS Log: Added surface nucleation
RCS Log: Added mould source term
RCS Log: Changed printout headers
RCS Log: Temperature output image
RCS Log:
RCS Log: Revision 8.2.2.3  2003/06/30 16:32:54  rcatwood
RCS Log: Flux from not-casting boundary
RCS Log:
RCS Log: Revision 8.2.2.2  2003/02/27 23:04:38  rcatwood
RCS Log: Removed use of old temperature routines , all temperatures shoudl
RCS Log: be determined by checking the array c_temp in teh subblock, if the
RCS Log: subblock is open
RCS Log:
RCS Log: Revision 8.2.2.1  2003/01/22 16:53:20  rcatwood
RCS Log: :
RCS Log:
RCS Log: Revision 8.2  2003/01/09 17:04:57  rcatwood
RCS Log: No changes for ca_procast (hopefully)
RCS Log:
RCS Log: Revision 8.1.6.1  2002/11/06 17:27:47  rcatwood
RCS Log: NOT WORKING check-in of first stage merge with ca_procast
RCS Log:
RCS Log: Revision 8.1  2002/10/17 17:01:02  rcatwood
RCS Log: New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log: Revision 7.4  2002/10/17 16:52:37  rcatwood
RCS Log: Merge from branch: combined Robert (porosity) and Wei (decentered octahedron) versions
RCS Log:
RCS Log: Revision 7.3.10.3  2002/09/13 11:02:17  rcatwood
RCS Log: added file position pointer for each subblock data location
RCS Log: de-linted the program a bit
RCS Log:
RCS Log: Revision 7.3.10.2  2002/08/30 19:18:25  rcatwood
RCS Log: split bigblock and subblock allocation into seperate subroutines
RCS Log: from bigblock.c and open_sb.c: added alloc_bb.c and alloc_sb.c
RCS Log:
RCS Log: Open an inactive subblock, allocate data storage etc.
RCS Log: ----------------------------
RCS Log: revision 7.3.10.1
RCS Log: date: 2002/08/22 15:13:43;  author: ww1;  state: Exp;  lines: +45 -3
RCS Log: Merge of Wei Wang's decentered octahedron/square method
RCS Log: ----------------------------
RCS Log: revision 7.3.8.1
RCS Log: date: 2002/07/05 12:04:30;  author: ww1;  state: Exp;  lines: +217 -164
RCS Log: 
RCS Log: Wei Wang version including decentered square algorithm
RCS Log: ----------------------------
RCS Log: revision 7.3.4.1
RCS Log: date: 2002/08/27 14:18:17;  author: chirazi;  state: Exp;  lines: +121 -8
RCS Log: adding files for multi-component-Procast version of CA
RCS Log: ----------------------------
RCS Log: revision 7.3.2.3
RCS Log: date: 2002/07/09 14:30:27;  author: rcatwood;  state: Exp;  lines: +8 -3
RCS Log: Changed subblock open flag to 3 values: new, open,and closed. This is to aviod re-opening blocks that are already processed.
RCS Log: COmpiles and runs without seg fault.
RCS Log: ----------------------------
RCS Log: revision 7.3.2.2
RCS Log: date: 2002/07/09 09:40:40;  author: rcatwood;  state: Exp;  lines: +12 -65
RCS Log: Split the initialization of the subblock into two parts, allocate and set up values
RCS Log: to avoid resetting values upon reading in a stored block file
RCS Log: ----------------------------
RCS Log: revision 7.3.2.1
RCS Log: date: 2002/05/29 14:24:50;  author: rcatwood;  state: Exp;  lines: +2 -1
RCS Log: Working up to subblock header & array data
RCS Log: =============================================================================
RCS Log: revision 7.3
RCS Log: date: 2002/05/23 17:28:01;  author: rcatwood;  state: Exp;  lines: +3 -3
RCS Log: branches:  7.3.2;  7.3.4;  7.3.8;  7.3.10;
RCS Log: Used dbmalloc to eliminate all memory leaks!
RCS Log: Started close-sb routine to improve multiblock
RCS Log: ----------------------------
RCS Log: revision 7.2
RCS Log: date: 2000/12/06 21:10:40;  author: rcatwood;  state: Exp;  lines: +4 -2
RCS Log: fixed up heatfolw, tctrace
RCS Log: ----------------------------
RCS Log: revision 7.1
RCS Log: date: 2000/11/07 19:33:49;  author: rcatwood;  state: Exp;  lines: +8 -0
RCS Log: Altered T_lists and pore_max_fs
RCS Log: ----------------------------
RCS Log: revision 7.0
RCS Log: date: 2000/11/07 15:53:28;  author: rcatwood;  state: Exp;  lines: +0 -0
RCS Log: Multi Cell Pores added
RCS Log: ----------------------------
RCS Log: revision 6.2
RCS Log: date: 2000/10/24 14:53:57;  author: rcatwood;  state: Exp;  lines: +4 -3
RCS Log: Changed grain nuc to include block_nuc method
RCS Log: ----------------------------
RCS Log: revision 6.1
RCS Log: date: 2000/10/16 10:37:22;  author: rcatwood;  state: Exp;  lines: +136 -108
RCS Log: Changed grain nuc to include block_nuc method
RCS Log: ----------------------------
RCS Log: revision 6.0
RCS Log: date: 2000/09/25 18:03:36;  author: rcatwood;  state: Exp;  lines: +1 -0
RCS Log: After PORE_00 and NLM
RCS Log: ----------------------------
RCS Log: revision 5.90
RCS Log: date: 2000/09/25 17:11:24;  author: rcatwood;  state: Exp;  lines: +0 -0
RCS Log: Particle version before synchronisationESS
RCS Log: ----------------------------
RCS Log: revision 5.2
RCS Log: date: 2000/03/24 19:19:47;  author: rcatwood;  state: Exp;  lines: +1 -1
RCS Log: Particle dependant growth fixed.
RCS Log: ----------------------------
RCS Log: revision 5.1
RCS Log: date: 2000/03/02 16:10:16;  author: rcatwood;  state: Exp;  lines: +4 -1
RCS Log: Merged xxu and rca versions
RCS Log: ----------------------------
RCS Log: revision 5.0
RCS Log: date: 2000/02/22 19:06:28;  author: rcatwood;  state: Exp;
RCS Log: branches:  5.0.1;  5.0.2;
RCS Log: Created in this version.
RCS Log: ----------------------------
RCS Log: revision 5.0.2.1
RCS Log: date: 2000/03/01 15:54:30;  author: rcatwood;  state: Exp;  lines: +4 -1
RCS Log: merged VAR and Multiblock updates. Not tested
RCS Log: ----------------------------
RCS Log: revision 5.0.1.2
RCS Log: date: 2000/02/29 18:00:25;  author: rcatwood;  state: Exp;  lines: +4 -1
RCS Log: Bug fixed when growing into new block
RCS Log: ----------------------------
RCS Log: revision 5.0.1.1
RCS Log: date: 2000/02/22 19:07:42;  author: rcatwood;  state: Exp;  lines: +0 -0
RCS Log: Improve multiblock by adding open when activated routine
*/
