/****************************************************************/
/*      Copyright (c) 1998 Dept. of Materials, ICSTM            */
/*      All Rights Reserved                                     */
/*      THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM    */
/*      The copyright notice above does not evidence any        */
/*      actual or intended publication of such source code,     */
/*      and is an unpublished work by Dept. of Materials, ICSTM.*/
/*      This material contains CONFIDENTIAL INFORMATION that    */
/*      is the property of Imperial College. Any use,           */
/*      duplication or disclosure not specifically authorized   */
/*      by Imperial College is strictly prohibited.             */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/****************************************************************/
/*      p_growth.c                                              */
/*  Subroutine to calculate growth rate depending upon 		*/
/*  undercooling and particle concentration.       		*/
/****************************************************************/
/* Written by Peter D. Lee Robert C. Atwood and Yehia Youssef   */
/*  Imperial College                                            */
/****************************************************************/

/*RCS Id:$Id: p_growth.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <math.h>
#include "machine.h"

CA_FLOAT particle_growth (CA_FLOAT pg_const_a, CA_FLOAT pg_const_b, CA_FLOAT dt, CA_FLOAT Tunder, CA_FLOAT p_conc)
{

  if (pg_const_a == 0) {
    return (dt * FLAT_GROWTH);
  } else {
    return (dt * pg_const_a * Tunder * Tunder * EXP (-pg_const_b * p_conc));
  }
}

/* Include the rcs-id string in a small subroutine to put it in the object code */
char const *rcs_id_p_growth_c ()
{
  static char const rcsid[] = "$Id: p_growth.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* RCS log messages
 RCS Log -- $Log$
 RCS Log -- Revision 11.1  2006/03/01 18:20:40  rcatwood
 RCS Log -- Merging polycomponent and gas with meltback
 RCS Log --
 RCS Log -- Revision 10.3  2005/12/01 14:38:01  rcatwood
 RCS Log -- Merged xly_05 changes into the main trunk
 RCS Log -- Primarily involving melt-back
 RCS Log --
 RCS Log -- Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
 RCS Log -- Result of merging mould_source and xly meltback+curvature 2d versions
 RCS Log --
 RCS Log -- Revision 10.1  2005/11/03 11:56:47  rcatwood
 RCS Log -- New version number -- using mould_src as base
 RCS Log --
 RCS Log -- Revision 8.1.12.2  2005/11/02 11:55:05  rcatwood
 RCS Log -- Fixing up the revision nubmer after loss of repository
 RCS Log --
 RCS Log -- Revision 9.1  2003/08/14 14:38:38  rcatwood
 RCS Log -- Working merge with decentered/porosity/procast, also including
 RCS Log -- Ali Chirazi's multicomponent (not tested in this version)
 RCS Log --
 RCS Log -- Revision 8.1.6.1  2003/01/22 16:53:45  rcatwood
 RCS Log -- Almost working read_fg version
 RCS Log --
 RCS Log -- Revision 8.1  2002/10/17 17:01:02  rcatwood
 RCS Log -- New version number! for decentered/porosity merge! Alpha Version!
 RCS Log --
 RCS Log -- Revision 7.0  2000/11/07 15:53:28  rcatwood
 RCS Log -- Multi Cell Pores added
 RCS Log --
 RCS Log -- Revision 6.0  2000/09/25 18:03:36  rcatwood
 RCS Log -- After PORE_00 and NLM
 RCS Log --
 RCS Log -- Revision 2.0  2000/08/02 10:21:56  rcatwood
 RCS Log -- Version used for pore paper runs
 RCS Log --
 RCS Log -- Revision 1.1  2000/05/22 12:29:24  rcatwood
 RCS Log -- Fixed fs finish. Casolid to C from  W file. Global option
 RCS Log --
 RCS Log -- Revision 5.6  2000/03/28 13:53:33  rcatwood
 RCS Log -- Yehia changed growth law and fixed.
 RCS Log --
 RCS Log -- Revision 5.6  2000/03/28 12:22:25  yehia
 RCS Log -- Particle dependant growth - factor in EXP term
 RCS Log --
 RCS Log -- Revision 5.5  2000/03/28 12:01:42  yehia
 RCS Log -- Particle dependant growth - factor in EXP term
 RCS Log --
 RCS Log -- Revision 5.4  2000/03/27 17:06:26  rcatwood
 RCS Log -- Particle dependant growth - neg. phi
 RCS Log --
 RCS Log -- Revision 1.3  2000/03/27 11:21:22  rcatwood
 RCS Log -- Checkin prior to modifications for particle version
 RCS Log --
 RCS Log -- Revision 5.3  2000/03/27 11:21:17  rcatwood
 RCS Log -- Particle dependant growth - neg. phi
 RCS Log --
 RCS Log -- Revision 1.2  2000/03/24 19:34:34  rcatwood
 RCS Log -- Checkin prior to modifications for particle version
 RCS Log --
 RCS Log -- Revision 5.2  2000/03/24 19:19:47  rcatwood
 RCS Log -- Particle dependant growth fixed.
 RCS Log --
 RCS Log -- Revision 1.1  2000/03/23 19:00:16  rcatwood
 RCS Log -- Checkin prior to modifications for particle version
 RCS Log --
 RCS Log -- Revision 5.1  2000/03/23 18:38:55  rcatwood
 RCS Log -- Initial revision.
 RCS Log --
 RCS Log -- Revision 1.1  2000/03/23 18:38:14  rcatwood
 RCS Log -- Initial revision
 RCS Log --
*/
