/*---------------------------------------------------------------------*/
/*             Fluid Flow Code   by LY   01/2008     
							allocate memory and free memory
*/
/*---------------------------------------------------------------------*/

#include "phy_ca_tran.h"
#include "ff_memory.h"

int phy_alloc_bb(BB_struct *bp)
{

  int IMAX, JMAX, KMAX;

  IMAX = bp->tnc[0];
  JMAX = bp->tnc[1];
  KMAX = bp->tnc[2];
	 
  bp->phy_u = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_v = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_w = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_T = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_fl = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_r = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_a = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_z = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);

 
  bp->phy_uold = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_vold = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_wold = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_Told = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  bp->phy_flold = realmemalloc(0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);

  bp->ca_r = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  bp->ca_a = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  bp->ca_z = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  bp->ca_T = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  bp->ca_Told = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  bp->ca_Tnow = realmemalloc(0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

  fprintf(stderr, "CA_PHY_TRAN: Memory allocated!!!\n");
  return 0;

}


int phy_free_bb(BB_struct *bp)
{
  int IMAX, JMAX, KMAX;

  IMAX = bp->tnc[0];
  JMAX = bp->tnc[1];
  KMAX = bp->tnc[2];
	   
	
  freerealmem(bp->phy_u, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_v, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_w, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_T, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_fl, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_r, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_a, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_z, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);

  freerealmem(bp->phy_uold, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_vold, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_wold, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_Told, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);
  freerealmem(bp->phy_flold, 0, RMAX+1, 0, ZMAX+1, 0, AMAX+1);

  freerealmem(bp->ca_r, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  freerealmem(bp->ca_a, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  freerealmem(bp->ca_z, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  freerealmem(bp->ca_T, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  freerealmem(bp->ca_Told, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  freerealmem(bp->ca_Tnow, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);

  fprintf(stderr, "CA_PHY_TRAN: Memory free!!!\n");
  return 0;

}
