/*$Id: safeopen.c 1037 2007-07-16 15:07:50Z  $*/
/* safeopen file opener */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
int safeclose (FILE * fp)
{
  int ret = 0;

#ifdef VERBOSE_FILE
  int fno = 0;                  /* the file descriptor number */

  fno = fileno (fp);
  fprintf (stderr, "SAFECLOSE: closing,%i\n", fno);
#endif /*VERBOSE_FILE */

  ret = fclose (fp);
  return (ret);
}

FILE *safeopen (const char *fname, const char *type)
{
  FILE *fp;
  int myerror;

#ifdef VERBOSE_FILE
  int fno = 0;                  /* the file descriptor number */
#endif /*VERBOSE_FILE */
  errno=0;
  myerror=0;
  fp = fopen (fname, type);
  myerror=errno; /* because errno may be changed by fprintf */
  /* exit if the file did not open */
  if (fp == NULL) {
    fprintf (stderr, "ERROR: safeopen: could not open file named [%s]\n", fname);
    fprintf (stderr, "       safeopen: Check for the following problems:\n");
    fprintf (stderr, "       safeopen: (1) The file may not exist,\n");
    fprintf (stderr, "       safeopen: (2) The file may be locked,\n");
    fprintf (stderr, "       safeopen: (3) The file may not have the correct permissions.\n");
    fprintf (stderr, "       safeopen: (4) The file name may be invalid (spaces, linefeeds included, etc.\n");
    fprintf (stderr, "       safeopen: The attempt was made to open the file with mode: \"%s\".\n", type);
    fprintf (stderr, "\nERROR message: %s\n",strerror(myerror));
    fprintf (stderr, "Exiting...\n");
    exit (17);
  }
#ifdef VERBOSE_FILE
  fno = fileno (fp);
  fprintf (stderr, "SAFEOPEN: %s,%i\n", fname, fno);
#endif /*VERBOSE_FILE */
  return (fp);
}

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *safeopen_c ()
{
  static char const rcsid[] = "$Id: safeopen.c 1037 2007-07-16 15:07:50Z  $";

  return (rcsid);
}
