/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/

/*RCS Id:$Id: sb_boundary.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "blocks.h"
#include "machine.h"
#include "sb_diffuse.h"
#include "ca_matrix.h"

int sb_boundary (BB_struct * bp, int sbnum)
{
  int errflg = 0, fileflag = 0, errors = 0;
  int nx, ny, nz, tsteps;
  int *oni, *onip, *onend;
  SB_struct *sp;
  int t, i, j, k, l;
  CA_FLOAT partcoef;
  char *np, *ngr;
  int *op, *ogr;
  CA_FLOAT rs, rl;
  FILE *fp;

/* set up local neighbourhood */
/* use 6cell only for now     */
  oni = bp->nbhd.onq;           /*padded */
  onip = oni;
  onend = oni + 6;
/* set up local values and pointers */
  sp = bp->sb[sbnum];
  /*don't do it if sb doesn't exist */
  if (sp->open == FALSE)
    return (0);

  bp->cubeptr.curr = sbnum;
  nx = bp->nc[0];
  ny = bp->nc[1];
  nz = bp->nc[2];

  op = ogr = bp->itmp_one;
  np = ngr = (char *) calloc (bp->ncsb, sizeof (char));

  /* make a copy of the grain array */

  errflg += icopy_matrix (PAD, ogr, sp->gr, bp, bp->gr_array, sbnum);   /* (flag, to, from, bp) */

  op = ogr + bp->cubeptr.flist[0][START];       /*rewind */
/*  LOOP                               */
/* Run through all cells updating as needed.    */
/************************************************/
  for (k = 0; k < nz; k++) {    /* loop cells in z direction */
    for (j = 0; j < ny; j++) {  /* loop cells in y direction */
      for (i = 0; i < nx; i++) {        /* loop cells in x direction */

        /*loop neighbours */
        for (onip = oni; onip < onend; onip++) {
          if (*(op + *onip) != *op) {
            *np = (char) 255;
            break;
          }
        }
        np++;
        op++;
      }                         /*x */
      op += 2;
    }                           /*y */
    op += 2 * (nx + 2);
  }                             /*z */

  fp = fopen ("sb_bdy.bin", "w");
  fwrite (ngr, sizeof (char), bp->ncsb, fp);
  fclose (fp);
  free (ngr);

  return (errflg);
}                               /* end of */

/* Little subroutine to get rcs id into the object code */
/* so you can use ident on the compiled program  */
/* also you can call this to print out or include the rcs id in a file*/
char const *rcs_id_sb_boundary_c ()
{
  static char const rcsid[] = "$Id: sb_boundary.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}

/* end of rcs_id_sb_boundary_c subroutine */
/*
RCS Log:$Log$
RCS Log:Revision 11.1  2006/03/01 18:20:40  rcatwood
RCS Log:Merging polycomponent and gas with meltback
RCS Log:
RCS Log:Revision 10.3  2005/12/01 14:38:02  rcatwood
RCS Log:Merged xly_05 changes into the main trunk
RCS Log:Primarily involving melt-back
RCS Log:
RCS Log:Revision 10.1.2.2  2005/11/23 18:18:53  rcatwood
RCS Log:Result of merging mould_source and xly meltback+curvature 2d versions
RCS Log:
RCS Log:Revision 10.1  2005/11/03 11:56:47  rcatwood
RCS Log:New version number -- using mould_src as base
RCS Log:
RCS Log:Revision 8.1.12.2  2005/11/02 11:55:06  rcatwood
RCS Log:Fixing up the revision nubmer after loss of repository
RCS Log:
RCS Log:Revision 9.1  2003/08/14 14:38:39  rcatwood
RCS Log:Working merge with decentered/porosity/procast, also including
RCS Log:Ali Chirazi's multicomponent (not tested in this version)
RCS Log:
RCS Log:Revision 8.1.6.1  2003/01/22 16:53:46  rcatwood
RCS Log:Almost working read_fg version
RCS Log:
RCS Log:Revision 8.1  2002/10/17 17:01:03  rcatwood
RCS Log:New version number! for decentered/porosity merge! Alpha Version!
RCS Log:
RCS Log:Revision 7.0  2000/11/07 15:53:28  rcatwood
RCS Log:Multi Cell Pores added
RCS Log:
RCS Log:Revision 6.0  2000/09/25 18:03:35  rcatwood
RCS Log:After PORE_00 and NLM
RCS Log:
RCS Log:Revision 2.0  2000/08/02 10:21:56  rcatwood
RCS Log:Version used for pore paper runs
RCS Log:
RCS Log:Revision 1.2  2000/07/11 16:33:44  rcatwood
RCS Log:Changed pore output.
RCS Log:
RCS Log:Revision 1.1  2000/05/22 12:29:24  rcatwood
RCS Log:Fixed fs finish. Casolid to C from  W file. Global option
RCS Log:
RCS Log:Revision 5.2  2000/03/15 16:47:00  rcatwood
RCS Log:fixed seg fault from sb not open.
RCS Log:
RCS Log:Revision 5.1  2000/03/02 16:11:10  rcatwood
RCS Log:Merged xxu and rca versions
RCS Log:
RCS Log:Revision 5.0.2.1  2000/03/01 15:54:30  rcatwood
RCS Log:merged VAR and Multiblock updates. Not tested
RCS Log:
RCS Log:Revision 5.0.1.1  2000/02/22 19:04:27  rcatwood
RCS Log:Not yet tested
RCS Log:
RCS Log:Revision 4.2  1999/12/23 18:12:24  rcatwood
RCS Log:Version used for Mcwasp runs
RCS Log:
RCS Log:Revision 4.1  1999/12/16 13:33:44  rcatwood
RCS Log:Finalised improved use of RCS in all files.
RCS Log:
RCS Log:Revision 4.0.2.2  1999/12/16 12:31:32  rcatwood
RCS Log:Improving rcs id for all files, this may require several checkins to test.
RCS Log:
*/
