/****************************************************************/
/*   Copyright (c) 1998 Dept. of Materials, ICSTM               */
/*   All Rights Reserved                                        */
/*   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ICSTM       */
/*   The copyright notice above does not evidence any           */
/*   actual or intended publication of such source code,        */
/*   and is an unpublished work by Dept. of Materials, ICSTM.   */
/*   This material contains CONFIDENTIAL INFORMATION that       */
/*   is the property of Imperial College. Any use,              */
/*   duplication or disclosure not specifically authorized      */
/*   by Imperial College is strictly prohibited.                */
/****************************************************************/
/* This code is part of the umats routines developed at in the  */
/* Materials Processing Group, Dept. of Materials, ICSTM.       */
/*      email p.d.lee or r.atwood @ic.ac.uk for details         */
/****************************************************************/
/* sb_diffuse_alloy_decentred.c                                 */
/* added by Wei WANG on 15-07-02                                */
/* Moddified by Lang YUAN on 01-10-2007                         */
/****************************************************************/

/*RCS Id:$Id: sb_diffuse_alloy_decentred.c 1479 2009-11-12 12:08:32Z  $*/
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "blocks.h"
#include "machine.h"
#include "ca_matrix.h"
#include "sb_diffuse.h"
#include "mould_sources.h"
#include "ff_mpflow.h"
#include "datatrans.h"

extern void sb_mould_src (BB_struct * bp, Solute_props * sp, int sbnum, CA_FLOAT * osol);

extern CA_FLOAT get_dl (CA_FLOAT temp);
extern CA_FLOAT get_ds (CA_FLOAT temp);
extern CA_FLOAT getav_d (CA_FLOAT dl, CA_FLOAT ds, CA_FLOAT fs);
extern CA_FLOAT cell_temp_calc_cc (BB_struct * bp, int sbnum, int x, int y);

int sb_diffuse_alloy_decentred (BB_struct * bp, int sbnum)
{

  int errflg = 0, fileflag = 0, errors = 0;
  int nx, ny, nz, skip;
  static int wmess = 0, emess = 0, courant_messg = 0;
  int *oni, *onip, *onend;
  SB_struct *sp;
  int i, j, k, n;
  CA_FLOAT **sol_alloy_values;
  CA_FLOAT *ofs, *ocl, *oce, *nfs, *ncl, *nce;
  CA_FLOAT dtx, r, rs, rl, rsrl;
  CA_FLOAT fstot, nbfs, fs_av, conc, nbconc, nbsum;


  /*************************************************/
  
  /*Other way to calculate *nce  by LY*/
  
  CA_FLOAT fsnb[6];
  CA_FLOAT clnb[6];
  CA_FLOAT unb[6];
  CA_FLOAT vnb[6];
  CA_FLOAT wnb[6];
  
  int num;
  CA_FLOAT confs;
  CA_FLOAT consta;
  CA_FLOAT constb;
  CA_FLOAT clterm = 0.0;
  CA_FLOAT clfsterm = 0.0;
  CA_FLOAT mp_k0;
  CA_FLOAT mp_ds0;
  CA_FLOAT mp_dl;

  /*Parameters for Convection included*/
  CA_FLOAT *ophyu, *ophyv, *ophyw;
  CA_FLOAT *nphyu, *nphyv, *nphyw;
  CA_FLOAT dcll, dclr, dclf, dclb, dclu, dcld;
  CA_FLOAT sgu, sgv, sgw;
  CA_FLOAT dcldx, dcldy, dcldz;
				
  CA_FLOAT vterm = 0.0;
  CA_FLOAT vclterm = 0.0;
  CA_FLOAT vfsterm = 0.0;
  CA_FLOAT consu, consv, consw;
  CA_FLOAT dtxx;
  CA_FLOAT vtoce;          /* Ce changes on v*/
  int IMAX, JMAX, KMAX;
  
  IMAX = bp->tnc[0];
  JMAX = bp->tnc[1];
  KMAX = bp->tnc[2];
 
  consu=consv=consw=0;
  vtoce=0;
  
  /**********************************************/



/* set up local neighbourhood */
/* use 6cell only for now     */
  fstot = 0;
  oni = bp->nbhd.onq;           /*padded */
  onip = oni;
  onend = oni + 6;

  nx = bp->nc[0];
  ny = bp->nc[1];
  nz = bp->nc[2];
  skip = 2 * (nx + 2);

/* set up local values and pointers */
  sp = bp->sb[sbnum];
  bp->cubeptr.curr = sbnum;

  nfs = sp->c_fs;
  ncl = sp->c_sol_alloy;
  nce = sp->c_eqv_alloy;

  ofs = bp->ftmp_one;
  ocl = bp->ftmp_four;
  oce = bp->ftmp_five;

  /********************************************/
  /*  CA_PHY Convection included and Fluidflow 
   *  model included
   *                         lyuan 03/08*/
 
  if(bp->ctrl->fluidflow || bp->phy_convection){

  /*----------Fluid flow mode...-----------*/
  /*     transfer the [][][] data to []  */

	  /* size [nc]*[nc]*[nc]*/
  vectorout(bp->ca_cell_u, bp->ca_cell_uar, 1, IMAX, 1, JMAX, 1, KMAX);
  vectorout(bp->ca_cell_v, bp->ca_cell_var, 1, IMAX, 1, JMAX, 1, KMAX);
  vectorout(bp->ca_cell_w, bp->ca_cell_war, 1, IMAX, 1, JMAX, 1, KMAX);

          /* size [nc+2]*[nc+2]*[nc+2]*/
  vectorout(bp->ca_cell_u, bp->ftmp_u, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  vectorout(bp->ca_cell_v, bp->ftmp_v, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  vectorout(bp->ca_cell_w, bp->ftmp_w, 0, IMAX+1, 0, JMAX+1, 0, KMAX+1);
  /*---------------------------------------*/
      
  
  nphyu = bp->ca_cell_uar;
  nphyv = bp->ca_cell_var;
  nphyw = bp->ca_cell_war;
      
  ophyu = bp->ftmp_u;
  ophyv = bp->ftmp_v;
  ophyw = bp->ftmp_w;

  if(bp->phy_convection){ 
    fcopy_matrix (PAD, ophyu, nphyu, bp, NULL, sbnum);
    fcopy_matrix (PAD, ophyv, nphyv, bp, NULL, sbnum);
    fcopy_matrix (PAD, ophyw, nphyw, bp, NULL, sbnum);
  }

  ophyu += bp->cubeptr.flist[0][START];
  ophyv += bp->cubeptr.flist[0][START];
  ophyw += bp->cubeptr.flist[0][START];
  }
  /********************************************/

  /* copy C_L, C_E to temporary buffers */
  fcopy_matrix (PAD, ocl, ncl, bp, NULL, sbnum);        /*not work for multi-blocks */
  fcopy_matrix (PAD, oce, nce, bp, NULL, sbnum);

  /* add the source amount to the interface cells */
  if (bp->ctrl->mould_src) {
    sb_mould_src (bp, &(bp->mprops.alloyprops[0]), sbnum, ocl);
  }

  ofs += bp->cubeptr.flist[0][START];
  ocl += bp->cubeptr.flist[0][START];
/*set up parameter values*/

  dtx = bp->delt / (bp->size_c[0] * bp->size_c[0]);     /* dt /dx^2 */
  rs = (bp->mprops.alloyprops[0].Dsol[0] * dtx);      /* D_S * dt /dx^2 */
  rl = (bp->mprops.alloyprops[0].Dliq * dtx);      /* D_L * dt /dx^2 */
  rsrl = rs * rl;               /* precalc to save time in loop */

  /**********************************************************************/
  /*Parameter by LY*/
  mp_k0 = bp->mprops.alloyprops[0].part_coef[0];
  mp_dl = bp->mprops.alloyprops[0].Dliq;
  mp_ds0 = bp->mprops.alloyprops[0].Dsol[0];
  dtxx = bp->delt / bp->size_c[0];     /* dt /dx */
  
  /*First try to rearrange the velocity*/

/*  if(bp->phy_convection){
     for(i = 0; i < bp->total_ca_number; i++){
        if( ofs[i] > 0.99 ) {
	   unb[i] = 0.0;
	   vnb[i] = 0.0;
	   wnb[i] = 0.0;
	}
     }
  }
  
*/  
  /*******************************************************************************/
  

  
  
/* check courant stability*/
  if (rs > COURANT_LIMIT || rl > COURANT_LIMIT) {
    if (courant_messg < MAX_WARN_MSG)
      fprintf (stderr, "SB_DIFFUSE_ALLOY: WARNING: Possible instability by Courant criterion!\n Solid: , %1.2e, Liquid: %1.2e\n", rs,
               rl);
    courant_messg++;
#ifdef ERROR_EXIT
    if (courant_messg > WARN_EXIT_LIMIT) {
      fprintf (stderr, "SB_DIFFUSE_ALLOY: ERROR_EXIT: Courant Stability warning limit exceeded. %i warnings.\n", courant_messg);
      exit (courant_messg);
    }
#endif /*ERROR_EXIT */
  }

      /************************************************/
  /* now calculate the finite difference */
      /************************************************/
  /* DIFFUSION LOOP                               */
      /************************************************/
  /* Run through all cells updating as needed.    */
      /************************************************/
  for (k = 0; k < nz; k++) {    /* loop cells in z direction */
    for (j = 0; j < ny; j++) {  /* loop cells in y direction */
      for (i = 0; i < nx; i++) {        /* loop cells in x direction */
        /* skip cells that are not in the casting */
        if (*ofs == NOT_CASTING) {
        } else {
		
	  num = 0;
          nbsum = 0;
          conc = *ocl;

//#define DIFF_LY
	  
#ifndef DIFF_LY	  
	  
          for (onip = oni; onip < onend; onip++) {
            nbfs = *(ofs + *onip);
            /* skip nb cells that are not in the casting */
              if (nbfs == NOT_CASTING)
                continue;
              /* averaged frac solid */
              fs_av = 0.5 * (*ofs + nbfs);
            /* Linear Averaged diff coeff */
            r = rs * fs_av + rl * (1 - fs_av);
            nbconc = *(ocl + *onip);
            nbsum += r * (nbconc - conc);
          }                     /* end of neighbour sum loop */

#else	  
	  /*Modified by LY cooresponding to the diffusion equaiton*/

	  confs = *ofs;
	                 
          if(bp->ctrl->fluidflow){
	     consu = *ophyu;
	     consv = *ophyv;
	     consw = *ophyw;
	  } else if(bp->phy_convection){
	     consu = (*ophyu)/bp->phy_velofactor;
	     consv = (*ophyv)/bp->phy_velofactor;
	     consw = (*ophyw)/bp->phy_velofactor;
	  } 
	  
			 
		  
	  for (onip = oni ; onip < onend; onip++){
	     fsnb[num] = *(ofs + *onip);
	     clnb[num] = *(ocl + *onip);
	     
	     if(bp->ctrl->fluidflow){
	          unb[num]= *(ophyu + *onip);
	          vnb[num]= *(ophyv + *onip);
	          wnb[num]= *(ophyw + *onip);
	     } else if(bp->phy_convection){
	          unb[num]= (*(ophyu + *onip)) / bp->phy_velofactor;
		  vnb[num]= (*(ophyv + *onip)) / bp->phy_velofactor;
		  wnb[num]= (*(ophyw + *onip)) / bp->phy_velofactor;
             }
			      
	   
	     num++;
	  }

	  consta = (mp_dl * (1-confs) + mp_ds0 * mp_k0 * confs)*dtx;
	  constb = (mp_ds0 * mp_k0 - mp_dl)*dtx;

	//  consta = consta * dtx;
	//  constb = constb * dtx;

	  clterm = clnb[0]+clnb[1]+clnb[2]+clnb[3]+clnb[4]+clnb[5] - 6 * conc;
	  clfsterm = ((clnb[1]-clnb[0])*(fsnb[1]-fsnb[0])+(clnb[3]-clnb[2])*(fsnb[3]-fsnb[2])+(clnb[5]-clnb[4])*(fsnb[5]-fsnb[4]))/4;

//	  clfsterm =(clnb[1]-conc)*(fsnb[1]-confs)+(clnb[3]-conc)*(fsnb[3]-confs)+(clnb[5]-conc)*(fsnb[5]-confs);
		  
	  nbsum = consta * clterm + constb * clfsterm;

	  
	  if(bp->ctrl->fluidflow || bp->ctrl->flowdiffusion || bp->phy_convection ){

	     dcll = (conc - clnb[0])/ bp->size_c[0];
	     dclr = (clnb[1] - conc)/ bp->size_c[0];
	     sgu = (consu >=0 ? 1.0 : -1.0);
	     dcldx = (dcll + dclr + GAMMA*sgu*(dcll-dclr))/2;

	     dclb = (conc - clnb[2])/ bp->size_c[1];
	     dclf = (clnb[3] - conc)/ bp->size_c[1];
	     sgv = (consv >=0 ? 1.0 : -1.0);
	     dcldy = (dclf + dclb + GAMMA*sgv*(dclb-dclf))/2;

	     dcld = (conc - clnb[4])/ bp->size_c[2];
	     dclu = (clnb[5] - conc)/ bp->size_c[2];
	     sgw = (consw >=0 ? 1.0 : -1.0);
	     dcldz = (dcld + dclu + GAMMA*sgw*(dcld-dclu))/2;

//	     vtoce = (1-(confs+fsnb[1])/2)*consu*dcldx + (1-(confs+fsnb[3])/2)*consv*dcldy + (1-(confs+fsnb[5])/2)*consw*dcldz ;
	     vtoce = consu*dcldx + consv*dcldy + consw*dcldz ;
	     
	     vtoce = vtoce * bp->delt;
						    
						    
		  
/*		
	     vterm = (unb[1]-unb[0])+(unb[3]-unb[2])+(unb[5]-unb[4]);
	     vclterm = consu * (clnb[1]-clnb[0]) + consv * (clnb[3]-clnb[2]) + consw * (clnb[5]-clnb[4]);
	     vfsterm = consu * (fsnb[1]-fsnb[0]) + consv * (fsnb[3]-fsnb[2]) + consw * (fsnb[5]-fsnb[4]);
	  
	     vterm = (vterm * dtxx)/2;
	     vclterm = (vclterm * dtxx)/2;
	     vfsterm = (vfsterm * dtxx)/2;

	     vtoce = (1-confs)* conc * vterm + (1-confs)*vclterm - conc * vfsterm;
*/	     
	  }
	  
	  
	  if(bp->ctrl->fluidflow || bp->ctrl->flowdiffusion || bp->phy_convection) nbsum = nbsum - vtoce;

	  
	  /*End of LY's diffusion*/

#endif	  
          *nce += nbsum;        /* increment of equivalent cocentration */
        
	  if (*nce < 0.) {
            if (emess < MAX_ERR_MSG) {
              fprintf (stderr, "ERROR:sb_diffuse_alloy_decentred:Instability C_E=%g I=%d J=%d K=%d\n", *nce, i, j, k);
            }
            emess++;
          }
          fstot += *ofs;
        }                       /* end of NOT_CASTING test */
        ofs++;
        ocl++;
        nce++;
	ophyu++;
	ophyv++;
	ophyw++;
      }                         /*x */
      ofs += 2;
      ocl += 2;
      ophyu += 2;
      ophyv += 2;
      ophyw += 2;
    }                           /*y */
    ofs += skip;
    ocl += skip;
    ophyu += skip;
    ophyv += skip;
    ophyw += skip;
	 
  }                             /*z */

  sp->Tvals.fsavg = fstot / bp->ncsb;   /*fix up fraction solid */
  return (errflg);
}                               /* end of sb_diffuse */

/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *sb_diffuse_alloy_decentred_c ()
{
  static char const rcsid[] = "$Id: sb_diffuse_alloy_decentred.c 1479 2009-11-12 12:08:32Z  $";

  return (rcsid);
}
