/*$Id: write_pprop_values.c 887 2006-03-01 18:21:01Z rcatwood $*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "machine.h"
#include "blocks.h"
#include "pore.h"

void write_pprop_values (FILE * fp, P_str * pp)
{

  fprintf (fp, "\n\nPORE PROP STRUCTURE VALUES\n");
  fprintf (fp, "P_nmeth, %i\n", pp->P_nmeth);   /*GAUSS or STEP */
  fprintf (fp, "Binsize, %.10g\n", pp->Binsize);        /* size of temp. bins to use */
  fprintf (fp, "P_nmax, %.10g\n", pp->P_nmax);  /* nmax for the pore distrib. */
  fprintf (fp, "P_tn, %.10g\n", pp->P_tn);      /* center of gauss. dis. for pores */
  fprintf (fp, "P_tsig, %.10g\n", pp->P_tsig);  /*spread of pore distrib */
  fprintf (fp, "P_par1, %.10g\n", pp->P_par1);  /*user defined parameter */
  fprintf (fp, "P_par2, %.10g\n", pp->P_par2);  /*user defined parameter */
  /* for making the list of radius at steps of temperature */
  fprintf (fp, "P_ntrad, %i\n", pp->P_ntrad);
  fprintf (fp, "P_trad_max, %.10g\n", pp->P_trad_max);
  fprintf (fp, "P_trad_min, %.10g\n", pp->P_trad_min);
  fprintf (fp, "P_trad_step, %.10g\n", pp->P_trad_step);
  fprintf (fp, "P_limrad_perturb, %.10g\n", pp->P_limrad_perturb);
}

 /**/
/***************************************************/
/* rcs id routine to include rcs id in the program */
/* generated by make_rcs_sub.sh script             */
/***************************************************/
char const *write_pprop_values_c ()
{
  static char const rcsid[] = "$Id: write_pprop_values.c 887 2006-03-01 18:21:01Z rcatwood $";

  return (rcsid);
}
