% This program simulates motor learning in Null Field (NF), Velocity-Dependent 
% Field (VF) or Divergent Field (DF). 
%==========================================================================
%   by Keng Peng Tee (kptee@i2r.a-star.edu.sg) and Etienne Burdet (e.burdet@imperial.ac.uk)
%
% For details, refer to supplemental material for: 
%   Franklin et al, "CNS learns Stable, Accurate and Efficient Movements
%   using a Simple Algorithm", Journal of Neuroscience, 28(44):1116511173, 2008.
% available at www.jneurosci.org.
%==========================================================================

global FIELD
FIELD=0;
while (FIELD~=1)&&(FIELD~=2)&&(FIELD~=3)
    FIELD=input('(1)DF   (2)VF   (3)NF  ? \n');	
end;

randn('state',sum(5*clock));
param;              %sets the parameters of the model
learn_NF = false;

if ~exist('submov_num','var')
     load exptdataNF;   %loads the position data of 50 NF trials 
     [qd qvd qad xd xvd xad] = plankin(dataPoolx,dataPooly);   %computes the planned kinematics
     [PLAN PFMdynmod] = plandyn(qd,qvd,qad,xvd,xad);  %computes the planned dynamics.
     if learn_NF
        MUSCLE_INV = invdynmuscle(PLAN,PFMdynmod);  %computes the inverse dynamics. 
     end
     [MJ submov_num]=submov;   %computes the basis functions to smooth the muscle forces later
end   

if learn_NF
    FFm(:,:,1)=MUSCLE_INV;  %initializes the feedforward muscle forces to those computed from the inverse dynamics
else
    load FFmdat; %loads a saved instance of the feedforward muscle forces learnt in the NF
    FFm(:,:,1)=FFmdat;  %initializes the feedforward muscle forces to those learnt in the NF
end

plotcircle;  %plots the target circle
wait=waitbar(0); 

for trial=1:trial_num
    muscNOISE(:,:,trial)=noise;  %noise generator 
    [x2 elambL MUSCLE(:,:,trial) Kxmid(:,:,trial) AbsE(trial) SgnE(trial)] = motion(qd,qvd,xd,muscNOISE(:,:,trial),FFm(:,:,trial)); %computes the motion trajectories
    if trial>trial_num-10
        plot(x2(1,:),x2(2,:));  %plots the last 10 trials
    elseif trial<=10
        plot(x2(1,:),x2(2,:),'r'); %plots the first 10 trials
    end;   
    FFm(:,:,trial+1)=learning(elambL,MJ,submov_num,FFm(:,:,trial));  %updates the feedforward muscle force  
    ffm(:,trial)=mean(FFm(:,50:trEnd,trial),2);
    fbm(:,trial)=mean(MUSCLE(:,50:trEnd,trial)-FFm(:,50:trEnd,trial),2);
    waitbar(trial/trial_num,wait);
end;

close(wait);
kxplot(Kxmid(:,:,1),Kxmid(:,:,trial_num)); %plots the stiffness ellipses of the first and last trials
muscleplot(ffm,fbm); %plots the muscle forces (feedforward + feedback)
handpatherror(AbsE,SgnE); %evolution of hand path error
