function muscleplot(ffm,fbm)

%==========================================================================
% This program plots the evolution of muscle forces (feedforward + feedback) 
% that are averaged over the duration of movement. 
%==========================================================================

load NFstart % loads a saved instance of baseline muscle forces in the NF
muscle=[nfstart ffm+fbm];

trial_num=min(size(ffm,2),size(ffm,2));

musclelabel={'shoulder flexor','shoulder extensor','elbow flexor','elbow extensor','biarticular flexor','biarticular extensor'};

figure
for i=1:2 
    subplot(3,2,i);
    plot(-20:1:trial_num,muscle(i,:),'r');
    hold on;
    vm(i,:)=axis;
    xlabel('trial no.')
    ylabel('muscle force [N]')
    title(musclelabel{i})
end
for i=3:4 
    subplot(3,2,i+2);
    plot(-20:1:trial_num,muscle(i,:),'r');
    hold on;
    vm(i,:)=axis;
    xlabel('trial no.')
    ylabel('muscle force [N]')
    title(musclelabel{i})
end
for i=5:6 
    subplot(3,2,i-2);
    plot(-20:1:trial_num,muscle(i,:),'r');
    hold on;
    vm(i,:)=axis;
    xlabel('trial no.')
    ylabel('muscle force [N]')
    title(musclelabel{i})
end

vmmax=max(vm,[],1);

for i=1:6
    subplot(3,2,i);
    axis([-20 vm(1,2) 0 vmmax(4)]);
end;


