function [PLAN PFMdynmod]=plandyn(qd,qvd,qad,xvd,xad)
%==========================================================================
% This program computes the planned dynamics. 
%==========================================================================

global N m l cl I PFMmass PFMdamp statfric

PLAN=zeros(2,N);

for i=1:N
    H= mass(m,l,cl,I,qd(:,i));	
    C= coriolis(m,l,cl,qd(:,i),qvd(:,i)); 
    PLAN(:,i)=H*qad(:,i) + C;
    Ja=jacobian(l,qd(:,i));
    PLANx(:,i)=Ja'\PLAN(:,i);
    PFMdynXmod(:,i)=PFMmass*xad(:,i)+PFMdamp*xvd(:,i)+tanh(diag(xvd(:,i))*200)*statfric;
    PFMdynmod(:,i)=Ja'*PFMdynXmod(:,i);
end;





