%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%Main GUI for calculation of averaged photolysed fraction of an ensemble of
%randomly oriented molecules.
%Depending on the relative orientation between the polarisation of the
%laser pulse and the transition dipole moment of the molecule, there are 
%different probabilities for a molecule to be excited. Perfectly alinged
%molecules have maximum probability (i.e. at x=1 or x=-1), and perpendicularly
%aligned ones have zero probatility (i.e. at x=0).
%Higher power densities increase the photolysed fraction, but saturation is
%only reached with infinite power density.
%A second pulse can interact with the population that is un-photolysed,
%and the fraction that has already returned to the ground state when the
%second pulse arrives. The user needs to estimate/calculate how large this
%fraction is to estimate 
%Configuration window
clear all
close all

startWindow=figure('Name','Averaged photolysed fraction calculation','NumberTitle','off','MenuBar','none',...
    'Units','normalized','Position',[0.01 0.2 0.96 0.75]);

%Input paramaters pulse1 panel
pulse1_panel=uipanel('Title','Input parameters Pulse 1','FontSize',10,...
    'Position',[.01 .55 .30 .4]);
uicontrol('Parent',pulse1_panel,'Style','Text','String','Wavelength (nm):','units','normalized',...
    'Position',[ 0.01 0.82 .39 .1],'HorizontalAlignment','left');
pulse1_wave=uicontrol('Parent',pulse1_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.4 0.82 .12 .12],'HorizontalAlignment','left','Tag','pulse1_wave_box','TooltipString','Excitation wavelength in nanometers of first pulse.');
uicontrol('Parent',pulse1_panel,'Style','Text','String','Power (microJoule):','units','normalized',...
    'Position',[ 0.01 0.66 .39 .1],'HorizontalAlignment','left');
pulse1_power=uicontrol('Parent',pulse1_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.4 0.66 .12 .12],'HorizontalAlignment','left','Tag','pulse1_power_box','TooltipString','Excitation power in microJoules of first pulse.');
uicontrol('Parent',pulse1_panel,'Style','Text','String','Beam diameter (micrometer):','units','normalized',...
    'Position',[ 0.01 0.5 .39 .1],'HorizontalAlignment','left');
pulse1_size=uicontrol('Parent',pulse1_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.4 0.5 .12 .12],'HorizontalAlignment','left','Tag','pulse1_size_box','TooltipString','Beam diameter of first pulse (in micrometer, square pulse profile), or full width half maximum for Gaussian profile.');
pulse1_shape=uicontrol('Parent',pulse1_panel,'Style','Checkbox','units','normalized','String','Gaussian beam profile',...
    'Position',[ 0.55 0.5 .33 .12],'HorizontalAlignment','left','Tag','pulse1_shape_box','TooltipString','Tick box for Gaussian beam profile. Otherwise the shape is square, i.e. the intensity is maximum everywhere and drops suddenly to zero at the edge.');
uicontrol('Parent',pulse1_panel,'Style','Text','String','Quantum Yield (0-1):','units','normalized',...
    'Position',[ 0.01 0.34 .39 .1],'HorizontalAlignment','left');
pulse1_QY=uicontrol('Parent',pulse1_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.40 0.34 .12 .12],'HorizontalAlignment','left','Tag','pulse1_QY_box','TooltipString','Quantum Yield for photoreaction (from 0-1).');
uicontrol('Parent',pulse1_panel,'Style','Text','String','Cross section (cm^2/molecule):','units','normalized',...
    'Position',[ 0.01 0.18 .39 .1],'HorizontalAlignment','left');
pulse1_cross_sec=uicontrol('Parent',pulse1_panel,'Style','Edit','units','normalized',...
    'Position', [ 0.40 0.18 .17 .12],'HorizontalAlignment','left','Tag','pulse1_cross_sec_box','TooltipString','Cross section at excitation wavelength (in cm^2/molecule).');
uicontrol('Parent',pulse1_panel,'Style','Text','String','pH:','units','normalized',...
    'Position',[ 0.01 0.02 .39 .1] ,'HorizontalAlignment','left');
pulse1_pH=uicontrol('Parent',pulse1_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.40 0.02 .12 .12],'HorizontalAlignment','left','Tag','pulse1_pH_box','TooltipString','[Your reference only] pH value for current cross section. NB. This value is not used in any calculation.');
pulse1_frac_button=uicontrol('Parent',pulse1_panel,'Style','Pushbutton','String','Calculate single pulse fraction','units','normalized','Callback','single_pulse1_frac',...
    'Position',[ 0.58 0.02 .4 .11],'Tag','pulse1_frac_button','TooltipString','Calculate single pulse average photolysed fraction based on input parameters of Pulse1.');

%Input paramaters pulse2 panel
pulse2_panel=uipanel('Title','Input parameters Pulse 2','FontSize',10,...
    'Position',[.34 .55 .30 .4]);
uicontrol('Parent',pulse2_panel,'Style','Text','String','Wavelength (nm):','units','normalized',...
    'Position',[ 0.01 0.82 .39 .1],'HorizontalAlignment','left');
pulse2_wave=uicontrol('Parent',pulse2_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.4 0.82 .12 .12],'HorizontalAlignment','left','Tag','pulse2_wave_box','TooltipString','Excitation wavelength in nanometers of second pulse.');
uicontrol('Parent',pulse2_panel,'Style','Text','String','Power (microJoule):','units','normalized',...
    'Position',[ 0.01 0.66 .39 .1],'HorizontalAlignment','left');
pulse2_power=uicontrol('Parent',pulse2_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.4 0.66 .12 .12],'HorizontalAlignment','left','Tag','pulse2_power_box','TooltipString','Excitation power in microJoules of second pulse.');
uicontrol('Parent',pulse2_panel,'Style','Text','String','Beam diameter (micrometer):','units','normalized',...
    'Position',[ 0.01 0.5 .39 .1],'HorizontalAlignment','left');
pulse2_size=uicontrol('Parent',pulse2_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.4 0.5 .12 .12],'HorizontalAlignment','left','Tag','pulse2_size_box','TooltipString','Beam diameter of second pulse (in micrometer, square pulse profile), or full width half maximum for Gaussian profile.');
pulse2_shape=uicontrol('Parent',pulse2_panel,'Style','Checkbox','units','normalized','String','Gaussian beam profile',...
    'Position',[ 0.55 0.5 .33 .12],'HorizontalAlignment','left','Tag','pulse2_shape_box','TooltipString','Tick box for Gaussian beam profile. Otherwise the shape is square, i.e. the intensity is maximum everywhere and drops suddenly to zero at the edge.');
uicontrol('Parent',pulse2_panel,'Style','Text','String','Quantum Yield (0-1):','units','normalized',...
    'Position',[ 0.01 0.34 .39 .1],'HorizontalAlignment','left');
pulse2_QY=uicontrol('Parent',pulse2_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.40 0.34 .12 .12],'HorizontalAlignment','left','Tag','pulse2_QY_box','TooltipString','Quantum Yield for photoreaction (from 0-1).');
uicontrol('Parent',pulse2_panel,'Style','Text','String','Cross section (cm^2/molecule):','units','normalized',...
    'Position',[ 0.01 0.18 .39 .1],'HorizontalAlignment','left');
pulse2_cross_sec=uicontrol('Parent',pulse2_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.40 0.18 .17 .12],'HorizontalAlignment','left','Tag','pulse2_cross_sec_box','TooltipString','Cross section at excitation wavelength (in cm^2/molecule).');
pulse2_frac_button=uicontrol('Parent',pulse2_panel,'Style','Pushbutton','String','Calculate single pulse fraction','units','normalized','Callback','single_pulse2_frac',...
    'Position',[ 0.59 0.18 .4 .11],'Tag','pulse2_frac_button','TooltipString','Calculate single pulse average photolysed fraction based on input parameters of Pulse2.');
pulse1_pulse2_frac_button=uicontrol('Parent',pulse2_panel,'Style','Pushbutton','String','Calculate two-pulse fractions','units','normalized','Callback','two_pulse_frac',...
    'Position',[ 0.59 0.02 .4 .11],'Tag','pulse1_pulse2_frac_button','TooltipString','Calculate average photolysed fractions of both pulses, based on input parameters of Pulse1 and Pulse2, and on the ground state recovery fraction.');

%Calculation options panel
calc_opt_panel=uipanel('Title','Calculation options','FontSize',10,...
    'Position',[.67 0.55 .32 .4]);
calc_opt_panel_order=0.05:0.16:0.85;
calc_opt_panel_order(2,:)=calc_opt_panel_order(1,:)-0.02;
uicontrol('Parent',calc_opt_panel,'Style','Text','String','Taylor series cut-off pulse 1 (valid for single/multipulse):','units','normalized',...
    'Position',[ 0.01 calc_opt_panel_order(2,6)-0.01 .35 .16],'HorizontalAlignment','left');
pulse1_Taylor_opt=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','25',...
    'Position',[ 0.4 calc_opt_panel_order(1,6) .06 .10],'HorizontalAlignment','left','Tag','pulse1_Taylor_opt_box','TooltipString','[25=default] Select (n-1) order of polynomial approximation used for Taylor Series calculations. Higher values increase accuracy, but also its calculation time.');
uicontrol('Parent',calc_opt_panel,'Style','Text','String','Taylor series cut-off pulse 2 (valid for single/multipulse):','units','normalized',...
    'Position',[ 0.01 calc_opt_panel_order(2,5)-0.01 .35 .16],'HorizontalAlignment','left');
pulse2_Taylor_opt=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','25',...
    'Position',[ 0.4 calc_opt_panel_order(1,5) .06 .10],'HorizontalAlignment','left','Tag','pulse2_Taylor_opt_box','TooltipString','[25=default] Select (n-1) order of polynomial approximation used for Taylor Series calculations. Higher values increase accuracy, but also its calculation time.');
uicontrol('Parent',calc_opt_panel,'Style','Text','String','Spacing for inner product x:','units','normalized',...
    'Position',[ 0.01 calc_opt_panel_order(2,4) .50 .11],'HorizontalAlignment','left');
orientation_x_spacing=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','0.1',...
    'Position',[ 0.4 calc_opt_panel_order(1,4) .08 .10],'HorizontalAlignment','left','Tag','orientation_x_spacing_box','TooltipString','[0.1=default] The inner product x= ranges from -1 to 1. Give spacing between points in that range (0.1 means 21 points to calculate).');
uicontrol('Parent',calc_opt_panel,'Style','Text','String','Power factors to calculate:','units','normalized',...
    'Position',[ 0.01 calc_opt_panel_order(2,3) .50 .11],'HorizontalAlignment','left');
plot_power_factor_orient=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','1 10 50 100',...
    'Position',[ 0.4 calc_opt_panel_order(1,3) .58 .10],'HorizontalAlignment','left','Tag','plot_power_factor_orient_box','TooltipString','[1 10 50 100=default] Select which power-multiplication factors to plot. These values represent the amount of lines to plot in the photolysed fraction vs. orientation plot.');
uicontrol('Parent',calc_opt_panel,'Style','Text','String','Power densities to calculate (start-spacing-end):','units','normalized',...
    'Position',[ 0.01 calc_opt_panel_order(2,2)-0.01 .50 .16],'HorizontalAlignment','left');
plot_power_factor_integr_start=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','0.1',...
    'Position',[ 0.4 calc_opt_panel_order(1,2) .08 .10],'HorizontalAlignment','left','Tag','plot_power_factor_integr_start_box','TooltipString','[0.1=default] Lowest power density factor (multiplied by excitation power) to calculate for integrated population vs power density plot..');
plot_power_factor_integr_spacing=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','0.1',...
    'Position',[ 0.5 calc_opt_panel_order(1,2) .08 .10],'HorizontalAlignment','left','Tag','plot_power_factor_integr_spacing_box','TooltipString','[0.1=default] Select spacing between power factors (multiplied by excitation power) to calculate for integrated population vs power density plot.');
plot_power_factor_integr_end=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','3',...
    'Position',[ 0.6 calc_opt_panel_order(1,2) .08 .10],'HorizontalAlignment','left','Tag','plot_power_factor_integr_end_box','TooltipString','[3=default] Highest power density factor (multiplied by excitation power) to calculate for integrated population vs power density plot.');
uicontrol('Parent',calc_opt_panel,'Style','Text','String','Beam diameters to calculate (start-spacing-end):','units','normalized',...
    'Position',[ 0.01 calc_opt_panel_order(2,1)-0.01 .50 .16],'HorizontalAlignment','left');
plot_beam_factor_start=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','0.2',...
    'Position',[ 0.4 calc_opt_panel_order(1,1) .08 .10],'HorizontalAlignment','left','Tag','plot_beam_factor_start_box','TooltipString','[0.2=default] Smallest beam diameter factor (multiplied by beam diameter) to calculate for averaged photolysed fraction vs beam diameter plot.');
plot_beam_factor_spacing=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','0.25',...
    'Position',[ 0.5 calc_opt_panel_order(1,1) .08 .10],'HorizontalAlignment','left','Tag','plot_beam_factor_spacing_box','TooltipString','[0.25=default] Spacing between beam diameter factors (multiplied by beam diameter) to calculate for averaged photolysed fraction vs beam diameter plot.');
plot_beam_factor_end=uicontrol('Parent',calc_opt_panel,'Style','Edit','units','normalized','String','2',...
    'Position',[ 0.6 calc_opt_panel_order(1,1) .08 .10],'HorizontalAlignment','left','Tag','plot_beam_factor_end_box','TooltipString','[2=default] Largest beam diameter factor (multiplied by beam diameter) to calculate for averaged photolysed fraction vs beam diameter plot.');

%Single pulse 1 ouput panel
pulse1_output_panel=uipanel('Title','Output parameters single pulse 1','FontSize',10,...
    'Position',[.01 .36 .30 .17]);
uicontrol('Parent',pulse1_output_panel,'Style','Text','String','Average photolysed fraction (analytical solution):','units','normalized',...
    'Position',[ 0.01 0.58 .70 .25],'HorizontalAlignment','left');
pulse1_ana_output=uicontrol('Parent',pulse1_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.63 0.55 .16 .35],'HorizontalAlignment','left','Tag','pulse1_ana_output_box','TooltipString','[0-1] Analytical solution for single pulse input parameters.');
uicontrol('Parent',pulse1_output_panel,'Style','Text','String','Average photolysed fraction (numerical solution):','units','normalized',...
    'Position',[ 0.01 0.08 .70 .25],'HorizontalAlignment','left');
pulse1_num_output=uicontrol('Parent',pulse1_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.63 0.05 .16 .35],'HorizontalAlignment','left','Tag','pulse1_num_output_box','TooltipString','[0-1] Numerical solution for single pulse input parameters via Taylor series approximation.');

%Single pulse 2 ouput panel
pulse2_output_panel=uipanel('Title','Output parameters single pulse 2','FontSize',10,...
    'Position',[.34 .36 .30 .17]);
uicontrol('Parent',pulse2_output_panel,'Style','Text','String','Average photolysed fraction (analytical solution):','units','normalized',...
    'Position',[ 0.01 0.58 .70 .25],'HorizontalAlignment','left');
pulse2_ana_output=uicontrol('Parent',pulse2_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.63 0.55 .16 .35],'HorizontalAlignment','left','Tag','pulse2_ana_output_box','TooltipString','[0-1] Analytical solution for single pulse input parameters.');
uicontrol('Parent',pulse2_output_panel,'Style','Text','String','Average photolysed fraction (numerical solution):','units','normalized',...
    'Position',[ 0.01 0.08 .70 .25],'HorizontalAlignment','left');
pulse2_num_output=uicontrol('Parent',pulse2_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.63 0.05 .16 .35],'HorizontalAlignment','left','Tag','pulse2_num_output_box','TooltipString','[0-1] Numerical solution for single pulse input parameters via Taylor series approximation.');

%Time difference between two pulses panel
delay_panel=uipanel('Title','Input time delay between pulse 1 and 2','FontSize',10,...
    'Position',[.01 0.12 .30 .20]);
uicontrol('Parent',delay_panel,'Style','Text','String','Ground state recovery fractions to plot (0-1):','units','normalized',...
'Position',[ 0.01 0.56 .30 .3],'HorizontalAlignment','left');
pulses_recovery=uicontrol('Parent',delay_panel,'Style','Edit','units','normalized','String','0 0.1 0.2 0.5 0.75 1',...
'Position',[ 0.33 0.60 .5 .25],'HorizontalAlignment','left','Tag','pulses_recovery_box','TooltipString','[0 0.1 0.2 0.5 0.75 1=default] Set which fractions have recovered to ground state according to your model (for instance via concentration profiles generated with global analysis program).');
uicontrol('Parent',delay_panel,'Style','Text','String','Time delay between 1st and 2nd pulse:','units','normalized',...
'Position',[ 0.01 0.07 .30 .3],'HorizontalAlignment','left');
pulses_delay=uicontrol('Parent',delay_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.33 0.10 .5 .25],'HorizontalAlignment','left','Tag','pulses_delay_box','TooltipString','[Plotting parameter] Time delay between first and second pulse (a.u.). Depends on used model. Values only used for plotting of ground state recovering populations.');


% %Two pulse ouput panel
pulse12_output_panel=uipanel('Title','Output parameters two-pulse experiment','FontSize',10,...
    'Position',[.34 .02 .30 .3]);
uicontrol('Parent',pulse12_output_panel,'Style','Text','String','n1 (Photolysed fraction pulse 1; analytical):','units','normalized',...
    'Position',[ 0.01 0.86 .55 .1],'HorizontalAlignment','left');
pulse1_2pulses_ana_output=uicontrol('Parent',pulse12_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.56 0.85 .12 .15],'HorizontalAlignment','left','Tag','pulse1_2pulses_ana_output_box','TooltipString','Photolysed fraction pulse 1 only, analytical solution.');
uicontrol('Parent',pulse12_output_panel,'Style','Text','String','n1 (Photolysed fraction pulse 1; numerical):','units','normalized',...
    'Position',[ 0.01 0.65 .55 .1],'HorizontalAlignment','left');
pulse1_2pulses_num_output=uicontrol('Parent',pulse12_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.56 0.64 .12 .15],'HorizontalAlignment','left','Tag','pulse1_2pulses_num_output_box','TooltipString','Photolysed fraction pulse 1 only, numerical approximation (Check Taylor pulse 1 cut-off order if it does not match analytical solution).');
uicontrol('Parent',pulse12_output_panel,'Style','Text','String','n2 (Photolysed fraction pulse 2; analytical):','units','normalized',...
    'Position',[ 0.01 0.44 .55 .1],'HorizontalAlignment','left');
pulse2_2pulses_ana_output=uicontrol('Parent',pulse12_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.56 0.43 .43 .15],'HorizontalAlignment','left','Tag','pulse2_2pulses_ana_output_box','TooltipString','Photolysed fraction pulse 2 on partially recovered ground state (i.e. using the fraction(s) given in Delay between pulses panel), analytical solution.');
uicontrol('Parent',pulse12_output_panel,'Style','Text','String','n2 (Photolysed fraction pulse 2; numerical):','units','normalized',...
    'Position',[ 0.01 0.24 .55 .1],'HorizontalAlignment','left');
pulse2_2pulses_num_output=uicontrol('Parent',pulse12_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.56 0.22 .43 .15],'HorizontalAlignment','left','Tag','pulse2_2pulses_num_output_box','TooltipString','Photolysed fraction pulse 2 on partially recovered ground state (i.e. using the fraction(s) given in Delay between pulses panel), numerical approximation (Check Taylor pulse 2 cut-off order if it does not match analytical solution; NB this is generally higher than pulse 1 cut-off).');
uicontrol('Parent',pulse12_output_panel,'Style','Text','String','n1 x Beta = f(delay) [analytical]:','units','normalized',...
    'Position',[ 0.01 0.02 .5 .1],'HorizontalAlignment','left');
n_1_beta_time_course_output=uicontrol('Parent',pulse12_output_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.56 0.02 .43 .15],'HorizontalAlignment','left','Tag','n_1_beta_time_course_output_box','TooltipString','Time course of ground state recovered photolysed fraction of pulse 1; 1-Beta represents the ground state recovery fraction.');
