%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%Globe_toolbox_v1_00.m

function Globe_toolbox_v1_00
%Main user interface for global analysis toolbox.
%It defines its layout, which consists of multiple panels, and its 
%callbacks (the functions that are called by the gui).
%
%This gui calls other functions, and defined variables are passed directly 
%to other functions by using them as input, or, if they are needed by 
%multiple functions, are declared 'global' so that all have acces to them.
%
%Quick start guide to fitting
%Loading your dataset first (press 'Load data'), define rate constants 
%(start with one or two), and press 'Fit'!
%
%A bit more elaborately:
%(Note that the data file has the '.dat' extension, and is in ASCII format)
%The data file (containing columns of each observable, with each row 
%representing (increasing) time. The first columns should contain the time 
%points. The identity of the observables (for instance wavlength), can be 
%set by calibrating it. That file is loaded separately, and should consist 
%of a row of wavelengths, q vector, pH, etc. After loading, graphs appear 
%that let you explore the data in 3D, and each time trace and the signal at
%each time point by clicking in the surface plot.
%
%A common problem is the determination of time zero. To circomvent this,
%fix time zero at 0 to start with. Do this by activating the constraints in
%the 'Fitting parameters' panel, and tick the box next to 'Time zero'. If
%your time zero is different, have a look at the data first, and set it
%manually.
%
%Check also the supplied help files, by pressing the Help button

%Configuration window figure
startWindow=figure('Name','Globe_Toolbox v1.00','NumberTitle','off','MenuBar','none',...
    'Units','normalized','Position',[0.01 0.05 0.8 0.9]);

%Setting up GUI components, grouped in panels
load_data_button=uicontrol('Style','Pushbutton','String','Load data','units','normalized','Position',[ 0.01 0.93 .085 0.05],...
    'Callback','load_data','TooltipString','Load and visualise data file. Required format: Absorption spectra in rows, increasing with time; corresponding timepoints in first column, no calibration (check ''Calibrate'' button help).');
fit_button=uicontrol('Style','Pushbutton','String','Fit','units','normalized','Position',[ 0.11 0.93 .045 0.05],...
    'Callback','fit_data','TooltipString','Start globally optimising data. Load data and model first. Wavelength calibration possible, check ''Calibrate'' button help.');
close_figs_button=uicontrol('Style','Pushbutton','String','Close figures','units','normalized','Position',[ 0.17 0.955 .09 0.025],...
     'Callback','close_figs','TooltipString','Close all visible figures except main interface.');
replot_figs_button=uicontrol('Style','Pushbutton','String','Replot fit','units','normalized','Position',[ 0.17 0.93 .09 0.025],...
     'Callback','plot_figs','TooltipString','Replot generated graphs from latest fit session. Note that you can also open saved figures with the ''Open figs'' button.');
save_figs_data_button=uicontrol('Style','Pushbutton','String','Save figures and data','units','normalized','Position',[ 0.275 0.955 .15 0.025],...
     'Callback','save_figs_data','TooltipString','Save all visible graphs and export data.');
export_figs_button=uicontrol('Style','Pushbutton','String','Export figs','units','normalized','Position',[ 0.275 0.93 .09 0.025],...
     'Callback','export_figs2jpg','TooltipString','Export all open figures to jpg format.');
open_figs_button=uicontrol('Style','Pushbutton','String','Open figs','units','normalized','Position',[ 0.365 0.93 .06 0.025],...
     'Callback','open_figs','TooltipString','Visualise previously generated  figures.');
save_button=uicontrol('Style','Pushbutton','String','Save settings','units','normalized','Position',[ 0.44 0.955 .105 0.025],...
       'Callback','save_settings','TooltipString','Save parameter setting to input file that can be loaded with the ''Recall settings'' button.');
recall_button=uicontrol('Style','Pushbutton','String','Recall settings','units','normalized','Position',[ 0.44 0.93 .105 0.025],...
      'Callback','recall_settings','TooltipString','Load saved parameter file.');
help_Globe_Toolbox_button=uicontrol('Style','Pushbutton','String','Help','units','normalized','Position',[ 0.56 0.93 .08 0.05],...
    'Callback','Help_Globe_Toolbox','TooltipString','Show documentation.');

%*****PANEL 1: Information panel*****
info_panel=uipanel('Title','Loaded data, model, calibration and dispersion files','FontSize',10,...
    'Position',[.01 .79 .63 .12]);
load_data_text=uicontrol('Parent',info_panel,'Style','Text','Visible','off','units','normalized',...
    'Position',[ 0.02 0.77 .9 .25],'HorizontalAlignment','left','Tag','load_data_text','ButtonDownFcn', 'set(gcbo, ''Selected'', ''on'')');
load_model_text=uicontrol('Parent',info_panel,'Style','Text','Visible','off','units','normalized',...
    'Position',[ 0.02 0.51 .9 .25],'HorizontalAlignment','left','Tag','load_model_text');
calibfilename_text=uicontrol('Parent',info_panel,'Style','Text','units','normalized','Visible','off',...
    'Position',[ 0.02 0.26 .95 .25],'HorizontalAlignment','left','Tag','calibfilename_text');
dispersion_filename_text=uicontrol('Parent',info_panel,'Style','Text','units','normalized','Visible','off',...
    'Position',[ 0.02 0.01 .95 .25],'HorizontalAlignment','left','Tag','dispersion_filename_text');

%*****PANEL 2: Model selection*****
model_sel_panel=uibuttongroup('Title','Model selection','FontSize',10,...
    'Position',[.01 .56 .37 .2],'Tag','model_sel_panel','SelectionChangeFcn',@fix_model3,'SelectedObject',[]);
model1 = uicontrol('Style','Radio','String','Parallel','units','normalized','pos',[ 0.1 0.70 .3 .2],'parent',model_sel_panel,'Tag','model1');
model2= uicontrol('Style','Radio','String','Sequential','units','normalized','pos',[ 0.1 0.4 .3 .2],'parent',model_sel_panel,'Tag','model2');
model3= uicontrol('Style','Radio','String','Target model','units','normalized','pos',[ 0.1 0.1 .4 .2],'parent',model_sel_panel,'Tag','model3');

model3_fix_toggle=uicontrol('Parent',model_sel_panel,'Style','checkbox','String','Keep curently selected target model','units','normalized','Tag','model3_fix_toggle',...
    'Position',[ 0.35 0.13 .5 .15],'visible','off','TooltipString','Keep currently defined target model. If not selected, it will ask for a new target model file to be loaded every time a new fit is started.');

%*****PANEL 3: Data selection*****
data_sel_panel=uibuttongroup('Title','Data selection','FontSize',10,'Position',[.39 .56 .25 .2]);
data_1 = uicontrol('Style','Radio','String','All data','units','normalized','pos',[ 0.1 0.70 .25 .2],'parent',data_sel_panel);
data_2 = uicontrol('Style','Radio','String','SVD','units','normalized','pos',[ 0.1 0.45 .2 .2],'parent',data_sel_panel);%,'Callback','load_SVD_specs');
set(data_sel_panel,'SelectionChangeFcn',@load_SVD_specs,'visible','on','Tag','data_sel_panel');

%Create GUI components if SVD is selected
nr_SVD_comps_text_box=uicontrol('Parent',data_sel_panel,'Style','Text','String','Nr components','units','normalized','Tag','nr_SVD_comps_text_box',...
    'Position',[ 0.18 0.16 .5 .2],'HorizontalAlignment','center','Visible','off');
nr_SVD_comps_box=uicontrol('Style','Edit','Parent',data_sel_panel,'String',0,'units','normalized','Tag','nr_SVD_comps_box',...
    'Position',[ 0.1 0.24 .05 .2],'HorizontalAlignment','center','Visible','off','TooltipString','Choose number of most significant Singular Values determined by Singular Value Decomposition that are to be fitted');
SVD_contrib_toggle=uicontrol('Parent',data_sel_panel,'Style','checkbox','String','SVD contribution per component','units','normalized','Tag','SVD_contrib_toggle',...
    'Position',[ 0.1 0.03 .9 .2],'Visible','off','TooltipString','Calculation of ''Left Singular Values x S'' of most significant singular values S; It uses the same number of components as given by nr. SVD components. Faster than SVD due to weighting.');

data_props_button=uicontrol('Parent',data_sel_panel,'Style','pushbutton','String','Data properties','units','normalized','Tag','data_props_button','Callback','data_props',...
    'Position',[ 0.6 0.7 .35 .2],'Visible','on','TooltipString','Show information about datafile (size and minima/maxima).');

%*****PANEL 4: Fitting parameters*****
fit_pars_panel=uipanel('Title','Fitting parameters','FontSize',10,...
    'Position',[.01 .22 .37 .31]);
grab_rates_button=uicontrol('Parent',fit_pars_panel,'Style','Pushbutton','String','Grab rates','units','normalized','Callback','grab_rates',...
    'Position',[ 0.72 0.905 .265 .11],'Tag','grab_rates_button','TooltipString','Use fitted rate constants as new starting values.');
order_rates_button=uicontrol('Parent',fit_pars_panel,'Style','Pushbutton','String','Order','units','normalized','Callback','order_rates',...
    'Position',[ 0.6 0.905 .12 .11],'Tag','order_rates_button','TooltipString','Organise rate constants in decending order.');
uicontrol('Parent',fit_pars_panel,'Style','Text','String','Rate constants:','units','normalized',...
    'Position',[ 0.01 0.77 .3 .12]);
time_choice_box=uicontrol('Parent',fit_pars_panel,'Style','Edit','units','normalized',...
    'Position',[ 0.31 0.78 .67 .12],'HorizontalAlignment','left','Tag','time_choice_box','TooltipString','Give rate constants, separated by spaces (should match number of compartments in your model minus 1 for parallel and sequential models; can be different for models with reversible reactions).');

%GUI components for advanced algorithm options
fit_opts_panel=uibuttongroup('Parent',fit_pars_panel,'Position',[.01 .02 .97 .70],'Tag','fit_opts_panel');
fit_pars_1 = uicontrol('Style','Radio','String','Fit parameters','units','normalized','pos',[ 0.02 0.85 .24 .12],'parent',fit_opts_panel,'Tag','fit_pars_1');
fit_pars_2 = uicontrol('Style','Radio','String','Advanced','units','normalized','pos',[ 0.28 0.85 .2 .12],'parent',fit_opts_panel,'Tag','fit_pars_2');
set(fit_opts_panel,'SelectionChangeFcn',@load_fit_opts,'visible','on','Tag','fit_opts_panel');

Alg_choice_toggle=uicontrol('Parent',fit_opts_panel,'Style','checkbox','String','Pattern search','units','normalized','Tag','Alg_choice_toggle',...
    'Position',[ 0.1 0.55 .3 .12],'Visible','off','TooltipString','Use patternsearch to look for global minima in stead of non-linear fitting. Takes much longer, but helps identifying global in stead of local minima. Does not work with error in non-linear parameters.');
Alg_accuracy_toggle=uicontrol('Parent',fit_opts_panel,'Style','checkbox','String','Better accuracy','units','normalized','Tag','Alg_accuracy_toggle',...
    'Position',[ 0.1 0.36 .3 .12],'Visible','off','TooltipString','Algorithm option: increase convergence tolerance from 1e-6 to 1e-12 when selected.');
Alg_interpol_text=uicontrol('Parent',fit_opts_panel,'Style','text','String','Interpolation method','units','normalized','Tag','Alg_interpol_text',...
    'Position',[ 0.145 0.15 .3 .12],'Visible','off','HorizontalAlignment','left');
Alg_interpol_box=uicontrol('Parent',fit_opts_panel,'Style','edit','String',1,'units','normalized','Tag','Alg_interpol_box',...
    'Position',[ 0.1 0.12 .04 .15],'Visible','off','TooltipString','[1 = Default] Choose interpolation method: 1=Linear, 2=Zero-order hold, 3=cubic, 4=spline. Linear is the best option, but it cannot extrapolate. If extrapolation error occurs, choose other method and use optimised values again with the linear option.');

time_zero_text=uicontrol('Parent',fit_opts_panel,'Style','Text','String','Time zero: ','units','normalized','HorizontalAlignment','center',...
    'Position',[ 0.01 0.48 .28 .12],'Tag','time_zero_text');
time_zero_box=uicontrol('Parent',fit_opts_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.30 0.45 .20 .18],'HorizontalAlignment','center','Tag','time_zero_box','TooltipString','Time offset; must be smaller or equal to 0.');
OD_offset_text=uicontrol('Parent',fit_opts_panel,'Style','Text','String','OD offset: ','units','normalized','HorizontalAlignment','center',...
    'Position',[ 0.01 0.29 .28 .12],'Tag','OD_offset_text');
OD_offset_box=uicontrol('Parent',fit_opts_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.30 0.26 .20 .18],'HorizontalAlignment','center','Tag','OD_offset_box','TooltipString','OD offset');
IRF_text=uicontrol('Parent',fit_opts_panel,'Style','Text','String','IRF (FWHM, t0): ','units','normalized','HorizontalAlignment','center',...
    'Position',[ 0.01 0.1 .28 .12],'Tag','IRF_text');
IRF_box=uicontrol('Parent',fit_opts_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.30 0.07 .20 .18],'HorizontalAlignment','center','Tag','IRF_box','TooltipString','Give full-width-half-maximum and time zero (t0) of Gaussian instrument response function. If FWHM AND mu0 are 0, then no IRF is used. Note that mu0 is also used for the dispersion estimation (under ''Advanced'').');

Disp_panel=uipanel('Parent',fit_opts_panel,'Title','Dispersion parameters','units','normalized','Tag','Disp_panel',...
    'Position',[ 0.48 0.02 .51 .72],'Visible','off');
Dispers_text=uicontrol('Parent',Disp_panel,'Style','Text','String','mu=f(n,mu0,lc,m(n)): ','units','normalized','HorizontalAlignment','left',...
    'Position',[ 0.02 0.77 .51 .22],'Tag','Dispers_text','Visible','off');
Dispers_box=uicontrol('Parent',Disp_panel,'Style','Edit','String',0,'units','normalized','Visible','off',...
    'Position',[ 0.55 0.77 .44 .22],'HorizontalAlignment','center','Tag','Dispers_box','TooltipString','[0] = Default. Useage: [n mu0 lc m(n)] = dispersion function parameters. Give dispersion function order (n), time zero (muo), central wavelength (lc), and m(n) for the dispersion function (for instance: m(2) requires 2 additional parameters, making 5 in total). If 0, then the dispersion is not estimated.');
Par_fix_disp_toggle=uicontrol('Parent',Disp_panel,'Style','checkbox','String','fix','units','normalized','Tag','Par_fix_disp_toggle',...
    'Position',[ 0.55 0.52 .44 .22],'Visible','off','TooltipString','Fix all dispersion parameters when selected.');
dispersion_correction_toggle=uicontrol('Parent',Disp_panel,'Style','checkbox','String','Apply?','units','normalized','Tag','dispersion_correction_toggle',...
    'Position',[ 0.55 0.27 .44 .22],'Visible','off','TooltipString','Select if dispersion correction needs to be applied to data.');
Disp_fitting_button=uicontrol('Parent',Disp_panel,'Style','Pushbutton','String','Fit dispersion','units','normalized','Callback','dispersion_IRF_calc',...
    'Position',[ 0.55 0.02 .44 .22],'Visible','off','Tag','Disp_fitting_button','TooltipString','Estimate dispersion by calculating the cross-correlation between a Gaussian and every pixel (i.e. wavelength), based on dispersion parameters. It is possible to select a range of wavelengths/times to fit.');
Load_Disp_button=uicontrol('Parent',Disp_panel,'Style','Pushbutton','String','Load dispersion','units','normalized','Callback','load_dispersion',...
    'Position',[ 0.04 0.02 .44 .22],'Visible','off','Tag','Load_Disp_button','TooltipString','Load previously determined calibration file (single column with delay in time for every wavelength (defined delay time in file should correspond to any of the actual timepoints).');

%GUI components for activating constraints
par_fix_switch_toggle=uicontrol('Parent',fit_opts_panel,'Style','checkbox','String','Activate constraints','units','normalized','Callback','par_fix_constraints','Tag','par_fix_switch_toggle',...
    'Position',[ 0.02 0.7 .35 .12],'visible','on','TooltipString','Activate constraints below when selected. Otherwise NO constraints are actually used.');

Par_fix_time_zero_toggle=uicontrol('Parent',fit_opts_panel,'Style','checkbox','String','fix','units','normalized','Tag','Par_fix_time_zero_toggle',...
    'Position',[ 0.51 0.49 .1 .12],'Visible','off','TooltipString','Fix time zero when selected.');
Par_fix_OD_offset_toggle=uicontrol('Parent',fit_opts_panel,'Style','checkbox','String','fix','units','normalized','Tag','Par_fix_OD_offset_toggle',...
    'Position',[ 0.51 0.29 .1 .12],'Visible','off','TooltipString','Fix OD offset when selected.');
Par_fix_IRF_toggle=uicontrol('Parent',fit_opts_panel,'Style','checkbox','String','fix','units','normalized','Tag','Par_fix_IRF_toggle',...
    'Position',[ 0.51 0.09 .1 .12],'Visible','off','TooltipString','Fix both IRF parameters when selected.');
Par_fix_time_text=uicontrol('Parent',fit_opts_panel,'Style','Text','String','Fix rate constants','units','normalized',...
    'Position',[ 0.75 0.66 .24 .12],'Visible','off','Tag','Par_fix_time_text');
Par_fix_time_box=uicontrol('Parent',fit_opts_panel,'Style','Edit','String',0,'units','normalized','Tag','Par_fix_time_box',...
    'Position',[ 0.75 0.48 .2 .15],'Visible','off','TooltipString','Indices of time constant(s) to fix, separated by spaces.');
Par_fix_spectra_matrix_text=uicontrol('Parent',fit_opts_panel,'Style','Text','String','Fix spectral pairs','units','normalized',...
    'Position',[ 0.75 0.33 .24 .12],'Visible','off','Tag','Par_fix_spectra_matrix_text');
Par_fix_spectra_matrix_box=uicontrol('Parent',fit_opts_panel,'Style','Edit','String',0,'units','normalized','Tag','Par_fix_spectra_matrix_box',...
    'Position',[ 0.75 0.15 .2 .15],'Visible','off','TooltipString','State here which spectra (in pairs) are forced equal (f.i. ''3 2; 2 1'' or ''2 1''). Start with highest number,; Add more rows (indicated by ;) for more equalities. 0 for no equalities.');

%*****PANEL 5: Data manipulation*****
data_manip_panel=uipanel('Title','Data manipulation','FontSize',10,...
    'Position',[.39 .22 .25 .31]);

uicontrol('Parent',data_manip_panel,'Style','Text','String','Time shift: ','units','normalized',...
    'Position',[ 0.01 0.89 .65 .09]);
time_shift_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.92 .15 .09],'HorizontalAlignment','center','Tag','time_shift_box','TooltipString','[Absolute value] Shift time axis with specified amount. Remember that only POSITIVE times are fitted. Should not be equal (but smaller) than actual time point.');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Wavelength shift: ','units','normalized',...
    'Position',[ 0.01 0.79 .64 .09]);
wave_shift_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.82 .15 .09],'HorizontalAlignment','center','Tag','wave_shift_box','TooltipString','[Absolute value] Shift wavelength axis with specified amount.');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Time limits: ','units','normalized',...
    'Position',[ 0.01 0.69 .64 .09],'FontAngle','italic');
time_lim_box1=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.71 .15 .09],'HorizontalAlignment','center','Tag','time_lim_box1','TooltipString','[Index] Left time point boundary. 0 and 0 for all time points.');
time_lim_box2=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.83 0.71 .15 .09],'HorizontalAlignment','center','Tag','time_lim_box2','TooltipString','[Index] Right time point boundary. 0 and 0 for all time points.');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Wavelength limits: ','units','normalized',...
    'Position',[ 0.01 0.60 .64 .09],'FontAngle','italic');
wave_lim_box1=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.62 .15 .09],'HorizontalAlignment','center','Tag','wave_lim_box1','TooltipString','[Index] Left boundary for wavelength limits. 0 and 0 for whole spectrum.');
wave_lim_box2=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.83 0.62 .15 .09],'HorizontalAlignment','center','Tag','wave_lim_box2','TooltipString','[Index] Right boundary for wavelength limits. 0 and 0 for whole spectrum.');

uicontrol('Parent',data_manip_panel,'Style','Text','String','Time divider: ','units','normalized',...
    'Position',[ 0.01 0.49 .64 .09]);
time_divider_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.51 .15 .09],'HorizontalAlignment','center','Tag','time_divider_box','TooltipString','Stepsize of index for time points (''>1'' for less time points).');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Wavelength divider: ','units','normalized',...
    'Position',[ 0.01 0.40 .64 .09]);
wave_divider_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.42 .15 .09],'HorizontalAlignment','center','Tag','wave_divider_box','TooltipString','Stepsize of index for wavelengths (''>1'' for less wavelengths).');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Time subtraction: ','units','normalized',...
    'Position',[ 0.01 0.28 .64 .09],'FontAngle','italic');
time_subtract_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.30 .15 .09],'HorizontalAlignment','center','Tag','time_subtract_box','TooltipString','[index]/[index1 index2] Give index, or range of indices of time points that will be averaged to subtract from dataset, relative to specified time limits. 0 for no subtraction.');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Wavelength subtraction: ','units','normalized',...
    'Position',[ 0.01 0.19 .64 .09],'FontAngle','italic');
wave_subtract_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.21 .15 .09],'HorizontalAlignment','center','Tag','wave_subtract_box','TooltipString','[index]/[index1 index2] Give index, or range of indices of wavelengths that will be averaged to subtract from dataset, relative to wave_limits. 0 for no subtraction.');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Time weight: ','units','normalized',...
    'Position',[ 0.01 0.09 .64 .09]);
time_weight_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.10 .33 .09],'HorizontalAlignment','center','Tag','time_weight_box','TooltipString','[Index, 0 = Default] Weight for selected time range (applied to the residual). Usage: [weight start end] to give weight to time range from start to end. 0 means no weighting, add semicolon for multiple ranges (f.i. ''0.1 1 10; 0.001 200 202'').');
uicontrol('Parent',data_manip_panel,'Style','Text','String','Wavelength weight: ','units','normalized',...
    'Position',[ 0.01 0.00 .64 .09]);
wave_weight_box=uicontrol('Parent',data_manip_panel,'Style','Edit','String',0,'units','normalized',...
    'Position',[ 0.65 0.01 .33 .09],'HorizontalAlignment','center','Tag','wave_weight_box','TooltipString','[Index, 0 = Default] Weight for selected wavelength range (applied to the residual). Usage: [weight start end] to give weight to wavelength range from start to end. 0 means no weighting, add semicolon for multiple ranges (f.i. ''0.1 1 500; 0.1 700 702''.');

%*****PANEL 6: Plotting options*****
plot_options_panel=uipanel('Title','Plotting options','FontSize',10,...
    'Position',[.01 .01 .37 .18]);

axis_switch_toggle=uicontrol('Parent',plot_options_panel,'Style','checkbox','String','Reverse wavelength axis','units','normalized','Tag','axis_switch_toggle',...
    'Position',[ 0.1 0.69 .5 .2],'Visible','on','TooltipString','Reverse when selected, only for plotting.');
plot_residuals_toggle=uicontrol('Parent',plot_options_panel,'Style','checkbox','String','Residuals','units','normalized','Tag','plot_residuals_toggle',...
    'Position',[ 0.1 0.49 .5 .2],'Visible','on','TooltipString','Plot sum of residuals of all traces when selected.');
plot_fit_prog_live_toggle=uicontrol('Parent',plot_options_panel,'Style','checkbox','String','Show fit progress','units','normalized','Tag','plot_fit_prog_live_toggle',...
    'Position',[ 0.1 0.29 .5 .2],'Visible','on','TooltipString','Show how optimisation proceeds by plotting the parameter values (all but OD offset) for each iteration.');
uicontrol('Parent',plot_options_panel,'Style','Text','String','Title decimals','units','normalized','HorizontalAlignment','left',...
    'Position',[ 0.15 0.04 .25 .2],'Visible','on','TooltipString','Set number of decimals of the title (representing the wavelength).');
wave_digits_box=uicontrol('Parent',plot_options_panel,'Style','Edit','String',0,'units','normalized','Tag','wave_digits_box','HorizontalAlignment','center',...
    'Position',[ 0.1 0.05 .04 .2],'Visible','on','TooltipString','Set number of decimals of the title (representing the wavelength).');

calib_button=uicontrol('Parent',plot_options_panel,'Style','pushbutton','String','Calibrate','units','normalized','Tag','calib_button','Callback','load_calibration',...
    'Position',[ 0.6 0.74 .3 .2],'Visible','on','TooltipString','Choose calibration file containing a row of wavelengths (matching your datafile). If nothing is selected it uses column index. Clear a loaded calibration by pressing ''Calibrate'', and not selecting a file. Calibration is ignored if ''SVD'' is chosen.');
lin_log_toggle=uicontrol('Parent',plot_options_panel,'Style','checkbox','String','Linear scale','units','normalized','Tag','lin_log_toggle',...
    'Position',[ 0.6 0.49 .3 .2],'Visible','on','TooltipString','Plots all time axes on linear scales in stead of logarithmic.');
uicontrol('Parent',plot_options_panel,'Style','Text','String','Wavelength divider','units','normalized','HorizontalAlignment','left',...
    'Position',[ 0.65 0.24 .25 .2],'Visible','on','TooltipString','Show every n-th plot. A maximum of 240 individual traces is plotted. If the dataset contains more, f.i. 1024, set divider to 5 to show every 5th wavelength. Note. This value is only used for plotting purposes.');
plot_wave_divider_box=uicontrol('Parent',plot_options_panel,'Style','Edit','String',0,'units','normalized','Tag','plot_wave_divider_box','HorizontalAlignment','center',...
    'Position',[ 0.6 0.25 .04 .2],'Visible','on','TooltipString','Show every n-th plot. A maximum of 240 individual traces is plotted. If the dataset contains more, f.i. 1024, set divider to 5 to show every 5th wavelength. Note. This value is only used for plotting purposes.');

%*****PANEL 7: Error estimation*****
error_estim_panel=uipanel('Title','Error estimation','FontSize',10,...
    'Position',[.39 .01 .25 .18]);

Error_switch_nonlin_toggle=uicontrol('Parent',error_estim_panel,'Style','checkbox','String','Decay times and offsets','units','normalized','Tag','Error_switch_nonlin_toggle',...
    'Position',[ 0.1 0.6 .9 .3],'Visible','on','TooltipString','Error estimation for non linear parameters (decay times and time/OD-offset) when selected.');
Error_switch_lin_spectra_toggle=uicontrol('Parent',error_estim_panel,'Style','checkbox','String','Spectra','units','normalized','Tag','Error_switch_lin_spectra_toggle',...
    'Position',[ 0.1 0.2 .9 .3],'Visible','on','TooltipString','Error estimation for linear parameters (spectra); Check if solution is identical to solution when this is not selected.');

%*****PANEL 8: Logo*****
logo_panel=uipanel('Position',[.65 .85 .35 .15],'BorderWidth',0,'BackgroundColor','none');
axes('parent',logo_panel)
imshow(imread('ICL_logo.jpg'))

%*****PANEL 9: General info*****
copyright_text=uicontrol('Style','Text','units','normalized','Position',[ 0.65 0.06 .34 0.02],...
    'String','Copyright (c) 2010 LJGW van Wilderen');
stop_fitting_text=uicontrol('Style','Text','units','normalized','Position',[ 0.65 0.01 .34 0.05],...
    'String','Note: Fitting can be interrupted by pressing Ctrl+C simultaneously with Command Window selected.');
