%Copyright (c) 2010, Luuk J.G.W. van Wilderen
%
%data_explorer_plot.m

function data_explorer_plot
%Permits the interaction with the raw data figure by clicking in it. One
%click to activate the cross-hair, a second one to select a data point.

global filename;
global wave_raw;
global xdata_raw;
global ydata_raw;

%Time axis toggle. If not switched on, all time axes are logarithmic.
lin_log=get(findobj('Tag','lin_log_toggle'),'Value');
%Disable 'negative timepoints' warning if logarithmic time axis used. Is
%switched back on at end of this file
warning('off','MATLAB:Axes:NegativeDataInLogAxis')

%Interactively select datapoint in surface plot, with the action of the
%mouse click invoking an update of two figures, showing its spectrum and
%time trace.

[trace_plot,wave_plot]=ginput(1); %Get mouse position when clicked inside 
%surface plot. NB. get(gca,'CurrentPoint') does not do the job as it is not in
%the correct units.

%Trick to get datapoint closest to mouse position
[~,wave_plot_ind]=min(abs(wave_plot-wave_raw)); 
[~,trace_plot_ind]=min(abs(trace_plot-xdata_raw));

%------Plotting-------
%Raw data surface plot
subplot(3,3,[1:2,4:5])
cla;
pcolor(xdata_raw,wave_raw,ydata_raw(:,:)')
colorbar
shading interp
title({'Click in surface plot to activate cross-hair, click again for slice selection',['Datafile: ' filename]},'Interpreter','None');    %The TEX Interpreter is switched off to prevent error message due to possible interpretation of forward slashes
xlabel('Time');
ylabel('Pixel');
hold on
%Plot lines where mouse is clicked
plot(xdata_raw,wave_raw(wave_plot_ind)*(ones(size(xdata_raw))),'k')
plot(xdata_raw(trace_plot_ind)*(ones(size(wave_raw))),wave_raw,'k')
if lin_log==0
    set(gca,'XScale','log');
end
set(gca,'YDir','reverse');
drawnow

%Time trace plot
subplot(3,3,7:8)
plot(xdata_raw,ydata_raw(:,wave_plot_ind),'k')
if lin_log==0
    set(gca,'XScale','log');
end
xlabel(['Time trace at pixel ',num2str(wave_raw(wave_plot_ind))]);
clear wave_plot_ind
axis tight
grid on
drawnow %Invokes immediate update of plot

%Spectrum plot
subplot(3,3,[3,6])
plot(wave_raw,ydata_raw(trace_plot_ind,:),'k')
xlabel(['Pixel spectrum at timepoint ',num2str(xdata_raw(trace_plot_ind))]);
clear trace_plot_ind
axis tight
grid on
drawnow

%Turn warning about negative timepoints back on again (see above)
warning('on','MATLAB:Axes:NegativeDataInLogAxis')